// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.config.provisioning;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of flavors
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 * Configuration of the node repository
 */
public final class FlavorsConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "202d6269cc20a496bd6b65695ade5586";
  public final static String CONFIG_DEF_NAME = "flavors";
  public final static String CONFIG_DEF_NAMESPACE = "config.provisioning";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=config.provisioning",
    "flavor[].name string",
    "flavor[].cost int default=0",
    "flavor[].environment string default=\"undefined\"",
    "flavor[].minCpuCores double default=0.0",
    "flavor[].cpuSpeedup double default=1.0",
    "flavor[].minMainMemoryAvailableGb double default=0.0",
    "flavor[].minDiskAvailableGb double default=0.0",
    "flavor[].fastDisk bool default=true",
    "flavor[].remoteStorage bool default=true",
    "flavor[].bandwidth double default=0.0",
    "flavor[].architecture string default=\"x86_64\"",
    "flavor[].gpuType string default=\"T4\"",
    "flavor[].gpuCount int default=0",
    "flavor[].gpuMemoryGb double default=0.0"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public List<Flavor.Builder> flavor = new ArrayList<>();

    public Builder() { }

    public Builder(FlavorsConfig config) {
      for (Flavor f : config.flavor()) {
        flavor(new Flavor.Builder(f));
      }
    }

    private Builder override(Builder __superior) {
      if (!__superior.flavor.isEmpty())
        flavor.addAll(__superior.flavor);
      return this;
    }

    /**
     * Add the given builder to this builder's list of Flavor builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder flavor(Flavor.Builder __builder) {
      flavor.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder flavor(java.util.function.Consumer<Flavor.Builder> __func) {
      Flavor.Builder __inner = new Flavor.Builder();
      __func.accept(__inner);
      flavor.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Flavor builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder flavor(List<Flavor.Builder> __builders) {
      flavor = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public FlavorsConfig build() {
      return new FlavorsConfig(this);
    }

  }

  private final InnerNodeVector<Flavor> flavor;

  public FlavorsConfig(Builder builder) {
    this(builder, true);
  }

  private FlavorsConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "flavors must be initialized: " + builder.__uninitialized);

    flavor = Flavor.createVector(builder.flavor);
  }

  /**
   * @return flavors.flavor[]
   */
  public List<Flavor> flavor() {
    return flavor;
  }

  /**
   * @param i the index of the value to return
   * @return flavors.flavor[]
   */
  public Flavor flavor(int i) {
    return flavor.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(FlavorsConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("flavors");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents flavors.flavor[]
   */
  public final static class Flavor extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "name"
        ));

      private String name = null;
      private Integer cost = null;
      private String environment = null;
      private Double minCpuCores = null;
      private Double cpuSpeedup = null;
      private Double minMainMemoryAvailableGb = null;
      private Double minDiskAvailableGb = null;
      private Boolean fastDisk = null;
      private Boolean remoteStorage = null;
      private Double bandwidth = null;
      private String architecture = null;
      private String gpuType = null;
      private Integer gpuCount = null;
      private Double gpuMemoryGb = null;

      public Builder() { }

      public Builder(Flavor config) {
        name(config.name());
        cost(config.cost());
        environment(config.environment());
        minCpuCores(config.minCpuCores());
        cpuSpeedup(config.cpuSpeedup());
        minMainMemoryAvailableGb(config.minMainMemoryAvailableGb());
        minDiskAvailableGb(config.minDiskAvailableGb());
        fastDisk(config.fastDisk());
        remoteStorage(config.remoteStorage());
        bandwidth(config.bandwidth());
        architecture(config.architecture());
        gpuType(config.gpuType());
        gpuCount(config.gpuCount());
        gpuMemoryGb(config.gpuMemoryGb());
      }

      private Builder override(Builder __superior) {
        if (__superior.name != null)
          name(__superior.name);
        if (__superior.cost != null)
          cost(__superior.cost);
        if (__superior.environment != null)
          environment(__superior.environment);
        if (__superior.minCpuCores != null)
          minCpuCores(__superior.minCpuCores);
        if (__superior.cpuSpeedup != null)
          cpuSpeedup(__superior.cpuSpeedup);
        if (__superior.minMainMemoryAvailableGb != null)
          minMainMemoryAvailableGb(__superior.minMainMemoryAvailableGb);
        if (__superior.minDiskAvailableGb != null)
          minDiskAvailableGb(__superior.minDiskAvailableGb);
        if (__superior.fastDisk != null)
          fastDisk(__superior.fastDisk);
        if (__superior.remoteStorage != null)
          remoteStorage(__superior.remoteStorage);
        if (__superior.bandwidth != null)
          bandwidth(__superior.bandwidth);
        if (__superior.architecture != null)
          architecture(__superior.architecture);
        if (__superior.gpuType != null)
          gpuType(__superior.gpuType);
        if (__superior.gpuCount != null)
          gpuCount(__superior.gpuCount);
        if (__superior.gpuMemoryGb != null)
          gpuMemoryGb(__superior.gpuMemoryGb);
        return this;
      }

      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        __uninitialized.remove("name");
        return this;
      }


      public Builder cost(int __value) {
        cost = __value;
        return this;
      }

      private Builder cost(String __value) {
        return cost(Integer.valueOf(__value));
      }

      public Builder environment(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        environment = __value;
        return this;
      }


      public Builder minCpuCores(double __value) {
        minCpuCores = __value;
        return this;
      }

      private Builder minCpuCores(String __value) {
        return minCpuCores(Double.valueOf(__value));
      }

      public Builder cpuSpeedup(double __value) {
        cpuSpeedup = __value;
        return this;
      }

      private Builder cpuSpeedup(String __value) {
        return cpuSpeedup(Double.valueOf(__value));
      }

      public Builder minMainMemoryAvailableGb(double __value) {
        minMainMemoryAvailableGb = __value;
        return this;
      }

      private Builder minMainMemoryAvailableGb(String __value) {
        return minMainMemoryAvailableGb(Double.valueOf(__value));
      }

      public Builder minDiskAvailableGb(double __value) {
        minDiskAvailableGb = __value;
        return this;
      }

      private Builder minDiskAvailableGb(String __value) {
        return minDiskAvailableGb(Double.valueOf(__value));
      }

      public Builder fastDisk(boolean __value) {
        fastDisk = __value;
        return this;
      }

      private Builder fastDisk(String __value) {
        return fastDisk(Boolean.valueOf(__value));
      }

      public Builder remoteStorage(boolean __value) {
        remoteStorage = __value;
        return this;
      }

      private Builder remoteStorage(String __value) {
        return remoteStorage(Boolean.valueOf(__value));
      }

      public Builder bandwidth(double __value) {
        bandwidth = __value;
        return this;
      }

      private Builder bandwidth(String __value) {
        return bandwidth(Double.valueOf(__value));
      }

      public Builder architecture(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        architecture = __value;
        return this;
      }


      public Builder gpuType(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        gpuType = __value;
        return this;
      }


      public Builder gpuCount(int __value) {
        gpuCount = __value;
        return this;
      }

      private Builder gpuCount(String __value) {
        return gpuCount(Integer.valueOf(__value));
      }

      public Builder gpuMemoryGb(double __value) {
        gpuMemoryGb = __value;
        return this;
      }

      private Builder gpuMemoryGb(String __value) {
        return gpuMemoryGb(Double.valueOf(__value));
      }

      public Flavor build() {
        return new Flavor(this);
      }

    }

    // A node flavor which (may) be available in this zone.
    // This is to allow configuration per flavor.
    // If a certain flavor has no config it is not necessary to list it here to use it.
    private final StringNode name;
    // The monthly Total Cost of Ownership (TCO) in USD. Typically calculated as TCO divided by
    // the expected lifetime of the node (usually three years).
    private final IntegerNode cost;
    // The type of node: BARE_METAL, VIRTUAL_MACHINE or DOCKER_CONTAINER
    private final StringNode environment;
    // The minimum number of CPU cores available.
    private final DoubleNode minCpuCores;
    // The speedup factor per cpu core compared to an historical baseline for a particular cpu generation
    // The vcpu resources available on the node will be minCpuCores * cpuCoreSpeedup
    private final DoubleNode cpuSpeedup;
    // The minimum amount of main memory available.
    private final DoubleNode minMainMemoryAvailableGb;
    // The minimum amount of disk available.
    private final DoubleNode minDiskAvailableGb;
    // Whether the disk is fast (typically SSD) or slow (typically spinning HDD).
    private final BooleanNode fastDisk;
    // Whether the storage is remote (network) or local.
    private final BooleanNode remoteStorage;
    // Expected network interface bandwidth available for this flavor, in Mbit/s.
    private final DoubleNode bandwidth;
    // The architecture for this flavor
    private final StringNode architecture;
    // The GPU count and GPU memory (per GPU) of this flavor
    private final StringNode gpuType;
    private final IntegerNode gpuCount;
    private final DoubleNode gpuMemoryGb;

    public Flavor(Builder builder) {
      this(builder, true);
    }

    private Flavor(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "flavors.flavor[] must be initialized: " + builder.__uninitialized);

      name = (builder.name == null) ?
          new StringNode() : new StringNode(builder.name);
      cost = (builder.cost == null) ?
          new IntegerNode(0) : new IntegerNode(builder.cost);
      environment = (builder.environment == null) ?
          new StringNode("undefined") : new StringNode(builder.environment);
      minCpuCores = (builder.minCpuCores == null) ?
          new DoubleNode(0.0D) : new DoubleNode(builder.minCpuCores);
      cpuSpeedup = (builder.cpuSpeedup == null) ?
          new DoubleNode(1.0D) : new DoubleNode(builder.cpuSpeedup);
      minMainMemoryAvailableGb = (builder.minMainMemoryAvailableGb == null) ?
          new DoubleNode(0.0D) : new DoubleNode(builder.minMainMemoryAvailableGb);
      minDiskAvailableGb = (builder.minDiskAvailableGb == null) ?
          new DoubleNode(0.0D) : new DoubleNode(builder.minDiskAvailableGb);
      fastDisk = (builder.fastDisk == null) ?
          new BooleanNode(true) : new BooleanNode(builder.fastDisk);
      remoteStorage = (builder.remoteStorage == null) ?
          new BooleanNode(true) : new BooleanNode(builder.remoteStorage);
      bandwidth = (builder.bandwidth == null) ?
          new DoubleNode(0.0D) : new DoubleNode(builder.bandwidth);
      architecture = (builder.architecture == null) ?
          new StringNode("x86_64") : new StringNode(builder.architecture);
      gpuType = (builder.gpuType == null) ?
          new StringNode("T4") : new StringNode(builder.gpuType);
      gpuCount = (builder.gpuCount == null) ?
          new IntegerNode(0) : new IntegerNode(builder.gpuCount);
      gpuMemoryGb = (builder.gpuMemoryGb == null) ?
          new DoubleNode(0.0D) : new DoubleNode(builder.gpuMemoryGb);
    }

    /**
     * @return flavors.flavor[].name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return flavors.flavor[].cost
     */
    public int cost() {
      return cost.value();
    }

    /**
     * @return flavors.flavor[].environment
     */
    public String environment() {
      return environment.value();
    }

    /**
     * @return flavors.flavor[].minCpuCores
     */
    public double minCpuCores() {
      return minCpuCores.value();
    }

    /**
     * @return flavors.flavor[].cpuSpeedup
     */
    public double cpuSpeedup() {
      return cpuSpeedup.value();
    }

    /**
     * @return flavors.flavor[].minMainMemoryAvailableGb
     */
    public double minMainMemoryAvailableGb() {
      return minMainMemoryAvailableGb.value();
    }

    /**
     * @return flavors.flavor[].minDiskAvailableGb
     */
    public double minDiskAvailableGb() {
      return minDiskAvailableGb.value();
    }

    /**
     * @return flavors.flavor[].fastDisk
     */
    public boolean fastDisk() {
      return fastDisk.value();
    }

    /**
     * @return flavors.flavor[].remoteStorage
     */
    public boolean remoteStorage() {
      return remoteStorage.value();
    }

    /**
     * @return flavors.flavor[].bandwidth
     */
    public double bandwidth() {
      return bandwidth.value();
    }

    /**
     * @return flavors.flavor[].architecture
     */
    public String architecture() {
      return architecture.value();
    }

    /**
     * @return flavors.flavor[].gpuType
     */
    public String gpuType() {
      return gpuType.value();
    }

    /**
     * @return flavors.flavor[].gpuCount
     */
    public int gpuCount() {
      return gpuCount.value();
    }

    /**
     * @return flavors.flavor[].gpuMemoryGb
     */
    public double gpuMemoryGb() {
      return gpuMemoryGb.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Flavor newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("flavor");
      return changes;
    }

    private static InnerNodeVector<Flavor> createVector(List<Builder> builders) {
        List<Flavor> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Flavor(b));
        }
        return new InnerNodeVector<Flavor>(elems);
    }
  }

}
