// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.config.provisioning;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of cloud
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 *  
 * Configures the features supported by a cloud service.
 */
public final class CloudConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "cb7e019e7cc67b558c16290947efed1e";
  public final static String CONFIG_DEF_NAME = "cloud";
  public final static String CONFIG_DEF_NAMESPACE = "config.provisioning";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=config.provisioning",
    "dynamicProvisioning bool default=false",
    "allowHostSharing bool default=true",
    "requireAccessControl bool default=false",
    "account string default=\"\"",
    "region string default=\"\"",
    "snapshotPrivateKeySecretName string default=\"\""
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Boolean dynamicProvisioning = null;
    private Boolean allowHostSharing = null;
    private Boolean requireAccessControl = null;
    private String account = null;
    private String region = null;
    private String snapshotPrivateKeySecretName = null;

    public Builder() { }

    public Builder(CloudConfig config) {
      dynamicProvisioning(config.dynamicProvisioning());
      allowHostSharing(config.allowHostSharing());
      requireAccessControl(config.requireAccessControl());
      account(config.account());
      region(config.region());
      snapshotPrivateKeySecretName(config.snapshotPrivateKeySecretName());
    }

    private Builder override(Builder __superior) {
      if (__superior.dynamicProvisioning != null)
        dynamicProvisioning(__superior.dynamicProvisioning);
      if (__superior.allowHostSharing != null)
        allowHostSharing(__superior.allowHostSharing);
      if (__superior.requireAccessControl != null)
        requireAccessControl(__superior.requireAccessControl);
      if (__superior.account != null)
        account(__superior.account);
      if (__superior.region != null)
        region(__superior.region);
      if (__superior.snapshotPrivateKeySecretName != null)
        snapshotPrivateKeySecretName(__superior.snapshotPrivateKeySecretName);
      return this;
    }

    public Builder dynamicProvisioning(boolean __value) {
      dynamicProvisioning = __value;
      return this;
    }

    private Builder dynamicProvisioning(String __value) {
      return dynamicProvisioning(Boolean.valueOf(__value));
    }

    public Builder allowHostSharing(boolean __value) {
      allowHostSharing = __value;
      return this;
    }

    private Builder allowHostSharing(String __value) {
      return allowHostSharing(Boolean.valueOf(__value));
    }

    public Builder requireAccessControl(boolean __value) {
      requireAccessControl = __value;
      return this;
    }

    private Builder requireAccessControl(String __value) {
      return requireAccessControl(Boolean.valueOf(__value));
    }

    public Builder account(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      account = __value;
      return this;
    }


    public Builder region(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      region = __value;
      return this;
    }


    public Builder snapshotPrivateKeySecretName(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      snapshotPrivateKeySecretName = __value;
      return this;
    }


    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public CloudConfig build() {
      return new CloudConfig(this);
    }

  }

  // Are hosts provisioned dynamically on-demand?
  private final BooleanNode dynamicProvisioning;
  // Can nodes belonging to different applications be placed on the same host?
  private final BooleanNode allowHostSharing;
  // Should clusters in this cloud always require access control for both read and write operations?
  private final BooleanNode requireAccessControl;
  // The default account used to provision hosts and load balancers in this zone.
  private final StringNode account;
  // The cloud-specific region for this zone (as opposed to the Vespa region).
  private final StringNode region;
  // Name of private key secret used for sealing snapshot encryption keys.
  private final StringNode snapshotPrivateKeySecretName;

  public CloudConfig(Builder builder) {
    this(builder, true);
  }

  private CloudConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "cloud must be initialized: " + builder.__uninitialized);

    dynamicProvisioning = (builder.dynamicProvisioning == null) ?
        new BooleanNode(false) : new BooleanNode(builder.dynamicProvisioning);
    allowHostSharing = (builder.allowHostSharing == null) ?
        new BooleanNode(true) : new BooleanNode(builder.allowHostSharing);
    requireAccessControl = (builder.requireAccessControl == null) ?
        new BooleanNode(false) : new BooleanNode(builder.requireAccessControl);
    account = (builder.account == null) ?
        new StringNode("") : new StringNode(builder.account);
    region = (builder.region == null) ?
        new StringNode("") : new StringNode(builder.region);
    snapshotPrivateKeySecretName = (builder.snapshotPrivateKeySecretName == null) ?
        new StringNode("") : new StringNode(builder.snapshotPrivateKeySecretName);
  }

  /**
   * @return cloud.dynamicProvisioning
   */
  public boolean dynamicProvisioning() {
    return dynamicProvisioning.value();
  }

  /**
   * @return cloud.allowHostSharing
   */
  public boolean allowHostSharing() {
    return allowHostSharing.value();
  }

  /**
   * @return cloud.requireAccessControl
   */
  public boolean requireAccessControl() {
    return requireAccessControl.value();
  }

  /**
   * @return cloud.account
   */
  public String account() {
    return account.value();
  }

  /**
   * @return cloud.region
   */
  public String region() {
    return region.value();
  }

  /**
   * @return cloud.snapshotPrivateKeySecretName
   */
  public String snapshotPrivateKeySecretName() {
    return snapshotPrivateKeySecretName.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(CloudConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("cloud");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
