/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.yahoo.config.provision.CloudAccount;
import com.yahoo.config.provision.CloudName;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class Cloud {
    private final CloudName name;
    private final boolean dynamicProvisioning;
    private final boolean allowHostSharing;
    private final boolean allowEnclave;
    private final boolean requireAccessControl;
    private final CloudAccount account;
    private final Optional<String> snapshotPrivateKeySecretName;

    private Cloud(CloudName name, boolean dynamicProvisioning, boolean allowHostSharing, boolean allowEnclave, boolean requireAccessControl, CloudAccount account, Optional<String> snapshotPrivateKeySecretName) {
        this.name = Objects.requireNonNull(name);
        this.dynamicProvisioning = dynamicProvisioning;
        this.allowHostSharing = allowHostSharing;
        this.allowEnclave = allowEnclave;
        this.requireAccessControl = requireAccessControl;
        this.account = Objects.requireNonNull(account);
        this.snapshotPrivateKeySecretName = Objects.requireNonNull(snapshotPrivateKeySecretName);
        if (allowEnclave && account.isUnspecified()) {
            throw new IllegalArgumentException("Account must be non-empty in '" + String.valueOf((Object)name) + "'");
        }
    }

    public CloudName name() {
        return this.name;
    }

    public boolean dynamicProvisioning() {
        return this.dynamicProvisioning;
    }

    public boolean allowHostSharing() {
        return this.allowHostSharing;
    }

    public boolean allowEnclave() {
        return this.allowEnclave;
    }

    public boolean requireAccessControl() {
        return this.requireAccessControl;
    }

    public boolean supportsPrivateEndpoints() {
        return Set.of(CloudName.AWS, CloudName.GCP).contains((Object)this.name);
    }

    public CloudAccount account() {
        return this.account;
    }

    public boolean useProxyProtocol() {
        return !this.name.equals((Object)CloudName.AZURE);
    }

    public Optional<String> snapshotPrivateKeySecretName() {
        return this.snapshotPrivateKeySecretName;
    }

    public static Cloud defaultCloud() {
        return new Builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "cloud " + String.valueOf((Object)this.name);
    }

    public static class Builder {
        private CloudName name = CloudName.DEFAULT;
        private boolean dynamicProvisioning = false;
        private boolean allowHostSharing = true;
        private boolean allowEnclave = false;
        private boolean requireAccessControl = false;
        private CloudAccount account = CloudAccount.empty;
        private Optional<String> snapshotPrivateKeySecretName = Optional.empty();

        public Builder name(CloudName name) {
            this.name = name;
            return this;
        }

        public Builder dynamicProvisioning(boolean dynamicProvisioning) {
            this.dynamicProvisioning = dynamicProvisioning;
            return this;
        }

        public Builder allowHostSharing(boolean allowHostSharing) {
            this.allowHostSharing = allowHostSharing;
            return this;
        }

        public Builder allowEnclave(boolean allowEnclave) {
            this.allowEnclave = allowEnclave;
            return this;
        }

        public Builder requireAccessControl(boolean requireAccessControl) {
            this.requireAccessControl = requireAccessControl;
            return this;
        }

        public Builder account(CloudAccount account) {
            this.account = account;
            return this;
        }

        public Builder snapshotPrivateKeySecretName(String snapshotPrivateKeySecretName) {
            this.snapshotPrivateKeySecretName = Optional.of(snapshotPrivateKeySecretName).filter(s -> !s.isEmpty());
            return this;
        }

        public Cloud build() {
            return new Cloud(this.name, this.dynamicProvisioning, this.allowHostSharing, this.allowEnclave, this.requireAccessControl, this.account, this.snapshotPrivateKeySecretName);
        }
    }
}

