/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision.security;

import com.yahoo.config.provision.security.NodeIdentity;
import java.security.Principal;
import java.util.Objects;

public class NodePrincipal
implements Principal {
    private final NodeIdentity identity;

    public NodePrincipal(NodeIdentity identity) {
        this.identity = identity;
    }

    public NodeIdentity getIdentity() {
        return this.identity;
    }

    @Override
    public String getName() {
        StringBuilder builder = new StringBuilder(this.identity.nodeType().name());
        this.identity.hostname().ifPresent(hostname -> builder.append('/').append(hostname.value()));
        this.identity.applicationId().ifPresent(applicationId -> builder.append('/').append(applicationId.toShortString()));
        return builder.toString();
    }

    @Override
    public String toString() {
        return "NodePrincipal{identity=" + String.valueOf(this.identity) + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodePrincipal that = (NodePrincipal)o;
        return Objects.equals(this.identity, that.identity);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.identity);
    }
}

