/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision.serialization;

import com.yahoo.component.Version;
import com.yahoo.config.provision.AllocatedHosts;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.config.provision.HostSpec;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.config.provision.ZoneEndpoint;
import com.yahoo.config.provision.serialization.NetworkPortsSerializer;
import com.yahoo.config.provision.zone.AuthMethod;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Optional;

public class AllocatedHostsSerializer {
    private static final String mappingKey = "mapping";
    private static final String hostSpecKey = "hostSpec";
    private static final String hostSpecHostNameKey = "hostName";
    private static final String hostSpecMembershipKey = "membership";
    private static final String loadBalancerSettingsKey = "zoneEndpoint";
    private static final String publicField = "public";
    private static final String privateField = "private";
    private static final String authMethodsField = "authMethods";
    private static final String allowedUrnsField = "allowedUrns";
    private static final String accessTypeField = "type";
    private static final String urnField = "urn";
    private static final String realResourcesKey = "realResources";
    private static final String advertisedResourcesKey = "advertisedResources";
    private static final String requestedResourcesKey = "requestedResources";
    private static final String vcpuKey = "vcpu";
    private static final String memoryKey = "memory";
    private static final String diskKey = "disk";
    private static final String bandwidthKey = "bandwidth";
    private static final String diskSpeedKey = "diskSpeed";
    private static final String storageTypeKey = "storageType";
    private static final String architectureKey = "architecture";
    private static final String gpuKey = "gpu";
    private static final String gpuTypeKey = "gpuType";
    private static final String gpuCountKey = "gpuCount";
    private static final String gpuMemoryKey = "gpuMemory";
    private static final String hostSpecVespaVersionKey = "vespaVersion";
    private static final String hostSpecDockerImageRepoKey = "dockerImageRepo";
    private static final String hostSpecCurrentVespaVersionKey = "currentVespaVersion";
    private static final String hostSpecNetworkPortsKey = "ports";

    public static byte[] toJson(AllocatedHosts allocatedHosts) throws IOException {
        Slime slime = new Slime();
        AllocatedHostsSerializer.toSlime(allocatedHosts, slime.setObject());
        return SlimeUtils.toJsonBytes((Slime)slime);
    }

    public static void toSlime(AllocatedHosts allocatedHosts, Cursor cursor) {
        Cursor array = cursor.setArray(mappingKey);
        for (HostSpec host : allocatedHosts.getHosts()) {
            AllocatedHostsSerializer.toSlime(host, array.addObject().setObject(hostSpecKey));
        }
    }

    private static void toSlime(HostSpec host, Cursor object) {
        object.setString(hostSpecHostNameKey, host.hostname());
        host.membership().ifPresent(membership -> {
            object.setString(hostSpecMembershipKey, membership.stringValue());
            object.setString(hostSpecVespaVersionKey, membership.cluster().vespaVersion().toFullString());
            if (!membership.cluster().zoneEndpoint().isDefault()) {
                AllocatedHostsSerializer.toSlime(object.setObject(loadBalancerSettingsKey), membership.cluster().zoneEndpoint());
            }
            membership.cluster().dockerImageRepo().ifPresent(repo -> object.setString(hostSpecDockerImageRepoKey, repo.untagged()));
        });
        AllocatedHostsSerializer.toSlime(host.realResources(), object.setObject(realResourcesKey));
        AllocatedHostsSerializer.toSlime(host.advertisedResources(), object.setObject(advertisedResourcesKey));
        host.requestedResources().ifPresent(resources -> AllocatedHostsSerializer.toSlime(resources, object.setObject(requestedResourcesKey)));
        host.version().ifPresent(version -> object.setString(hostSpecCurrentVespaVersionKey, version.toFullString()));
        host.networkPorts().ifPresent(ports -> NetworkPortsSerializer.toSlime(ports, object.setArray(hostSpecNetworkPortsKey)));
    }

    private static void toSlime(NodeResources resources, Cursor resourcesObject) {
        resourcesObject.setDouble(vcpuKey, resources.vcpu());
        resourcesObject.setDouble(memoryKey, resources.memoryGiB());
        resourcesObject.setDouble(diskKey, resources.diskGb());
        resourcesObject.setDouble(bandwidthKey, resources.bandwidthGbps());
        resourcesObject.setString(diskSpeedKey, AllocatedHostsSerializer.diskSpeedToString(resources.diskSpeed()));
        resourcesObject.setString(storageTypeKey, AllocatedHostsSerializer.storageTypeToString(resources.storageType()));
        resourcesObject.setString(architectureKey, AllocatedHostsSerializer.architectureToString(resources.architecture()));
        if (!resources.gpuResources().isDefault()) {
            Cursor gpuObject = resourcesObject.setObject(gpuKey);
            gpuObject.setString(gpuTypeKey, resources.gpuResources().type().toString());
            gpuObject.setLong(gpuCountKey, (long)resources.gpuResources().count());
            gpuObject.setDouble(gpuMemoryKey, resources.gpuResources().memoryGiB());
        }
    }

    public static AllocatedHosts fromJson(byte[] json) {
        return AllocatedHostsSerializer.fromSlime((Inspector)SlimeUtils.jsonToSlime((byte[])json).get());
    }

    public static AllocatedHosts fromSlime(Inspector inspector) {
        Inspector array = inspector.field(mappingKey);
        LinkedHashSet<HostSpec> hosts = new LinkedHashSet<HostSpec>();
        array.traverse((i, host) -> hosts.add(AllocatedHostsSerializer.hostFromSlime(host.field(hostSpecKey))));
        return AllocatedHosts.withHosts(hosts);
    }

    private static HostSpec hostFromSlime(Inspector object) {
        if (object.field(hostSpecMembershipKey).valid()) {
            return new HostSpec(object.field(hostSpecHostNameKey).asString(), AllocatedHostsSerializer.nodeResourcesFromSlime(object.field(realResourcesKey)), AllocatedHostsSerializer.nodeResourcesFromSlime(object.field(advertisedResourcesKey)), AllocatedHostsSerializer.optionalNodeResourcesFromSlime(object.field(requestedResourcesKey)), AllocatedHostsSerializer.membershipFromSlime(object), AllocatedHostsSerializer.optionalString(object.field(hostSpecCurrentVespaVersionKey)).map(Version::new), NetworkPortsSerializer.fromSlime(object.field(hostSpecNetworkPortsKey)), AllocatedHostsSerializer.optionalDockerImage(object.field(hostSpecDockerImageRepoKey)));
        }
        return new HostSpec(object.field(hostSpecHostNameKey).asString(), NetworkPortsSerializer.fromSlime(object.field(hostSpecNetworkPortsKey)));
    }

    private static NodeResources nodeResourcesFromSlime(Inspector resources) {
        return new NodeResources(resources.field(vcpuKey).asDouble(), resources.field(memoryKey).asDouble(), resources.field(diskKey).asDouble(), resources.field(bandwidthKey).asDouble(), AllocatedHostsSerializer.diskSpeedFromSlime(resources.field(diskSpeedKey)), AllocatedHostsSerializer.storageTypeFromSlime(resources.field(storageTypeKey)), AllocatedHostsSerializer.architectureFromSlime(resources.field(architectureKey)), AllocatedHostsSerializer.gpuResourcesFromSlime(resources.field(gpuKey)));
    }

    private static NodeResources.GpuResources gpuResourcesFromSlime(Inspector gpu) {
        if (!gpu.valid()) {
            return NodeResources.GpuResources.getDefault();
        }
        return new NodeResources.GpuResources(gpu.field(gpuTypeKey).asString(), (int)gpu.field(gpuCountKey).asLong(), gpu.field(gpuMemoryKey).asDouble());
    }

    private static NodeResources optionalNodeResourcesFromSlime(Inspector resources) {
        if (!resources.valid()) {
            return NodeResources.unspecified();
        }
        return AllocatedHostsSerializer.nodeResourcesFromSlime(resources);
    }

    private static NodeResources.DiskSpeed diskSpeedFromSlime(Inspector diskSpeed) {
        return switch (diskSpeed.asString()) {
            case "fast" -> NodeResources.DiskSpeed.fast;
            case "slow" -> NodeResources.DiskSpeed.slow;
            case "any" -> NodeResources.DiskSpeed.any;
            default -> throw new IllegalStateException("Illegal disk-speed value '" + diskSpeed.asString() + "'");
        };
    }

    private static String diskSpeedToString(NodeResources.DiskSpeed diskSpeed) {
        return switch (diskSpeed) {
            default -> throw new IncompatibleClassChangeError();
            case NodeResources.DiskSpeed.fast -> "fast";
            case NodeResources.DiskSpeed.slow -> "slow";
            case NodeResources.DiskSpeed.any -> "any";
        };
    }

    private static NodeResources.StorageType storageTypeFromSlime(Inspector storageType) {
        return switch (storageType.asString()) {
            case "remote" -> NodeResources.StorageType.remote;
            case "local" -> NodeResources.StorageType.local;
            case "any" -> NodeResources.StorageType.any;
            default -> throw new IllegalStateException("Illegal storage-type value '" + storageType.asString() + "'");
        };
    }

    private static String storageTypeToString(NodeResources.StorageType storageType) {
        return switch (storageType) {
            default -> throw new IncompatibleClassChangeError();
            case NodeResources.StorageType.remote -> "remote";
            case NodeResources.StorageType.local -> "local";
            case NodeResources.StorageType.any -> "any";
        };
    }

    private static NodeResources.Architecture architectureFromSlime(Inspector architecture) {
        if (!architecture.valid()) {
            return NodeResources.Architecture.x86_64;
        }
        return switch (architecture.asString()) {
            case "x86_64" -> NodeResources.Architecture.x86_64;
            case "arm64" -> NodeResources.Architecture.arm64;
            case "any" -> NodeResources.Architecture.any;
            default -> throw new IllegalStateException("Illegal architecture value '" + architecture.asString() + "'");
        };
    }

    private static String architectureToString(NodeResources.Architecture architecture) {
        return switch (architecture) {
            default -> throw new IncompatibleClassChangeError();
            case NodeResources.Architecture.x86_64 -> "x86_64";
            case NodeResources.Architecture.arm64 -> "arm64";
            case NodeResources.Architecture.any -> "any";
        };
    }

    private static ClusterMembership membershipFromSlime(Inspector object) {
        return ClusterMembership.from(object.field(hostSpecMembershipKey).asString(), Version.fromString((String)object.field(hostSpecVespaVersionKey).asString()), object.field(hostSpecDockerImageRepoKey).valid() ? Optional.of(DockerImage.fromString(object.field(hostSpecDockerImageRepoKey).asString())) : Optional.empty(), AllocatedHostsSerializer.zoneEndpoint(object.field(loadBalancerSettingsKey)));
    }

    private static void toSlime(Cursor settingsObject, ZoneEndpoint settings) {
        settingsObject.setBool(publicField, settings.isPublicEndpoint());
        settingsObject.setBool(privateField, settings.isPrivateEndpoint());
        Cursor authMethods = settingsObject.setArray(authMethodsField);
        for (AuthMethod method : settings.authMethods()) {
            authMethods.addString(method.name());
        }
        if (settings.isPrivateEndpoint()) {
            Cursor allowedUrnsArray = settingsObject.setArray(allowedUrnsField);
            for (ZoneEndpoint.AllowedUrn urn : settings.allowedUrns()) {
                Cursor urnObject = allowedUrnsArray.addObject();
                urnObject.setString(urnField, urn.urn());
                urnObject.setString(accessTypeField, switch (urn.type()) {
                    default -> throw new IncompatibleClassChangeError();
                    case ZoneEndpoint.AccessType.awsPrivateLink -> "awsPrivateLink";
                    case ZoneEndpoint.AccessType.gcpServiceConnect -> "gcpServiceConnect";
                });
            }
        }
    }

    private static ZoneEndpoint zoneEndpoint(Inspector settingsObject) {
        if (!settingsObject.valid()) {
            return ZoneEndpoint.defaultEndpoint;
        }
        return new ZoneEndpoint(settingsObject.field(publicField).asBool(), settingsObject.field(privateField).asBool(), SlimeUtils.entriesStream((Inspector)settingsObject.field(authMethodsField)).map(value -> AuthMethod.valueOf(value.asString())).toList(), SlimeUtils.entriesStream((Inspector)settingsObject.field(allowedUrnsField)).map(urnObject -> new ZoneEndpoint.AllowedUrn(switch (urnObject.field(accessTypeField).asString()) {
            case "awsPrivateLink" -> ZoneEndpoint.AccessType.awsPrivateLink;
            case "gcpServiceConnect" -> ZoneEndpoint.AccessType.gcpServiceConnect;
            default -> throw new IllegalArgumentException("unknown service access type in '" + String.valueOf(urnObject) + "'");
        }, urnObject.field(urnField).asString())).toList());
    }

    private static Optional<String> optionalString(Inspector inspector) {
        if (!inspector.valid()) {
            return Optional.empty();
        }
        return Optional.of(inspector.asString());
    }

    private static Optional<DockerImage> optionalDockerImage(Inspector inspector) {
        if (!inspector.valid()) {
            return Optional.empty();
        }
        return Optional.of(DockerImage.fromString(inspector.asString()));
    }
}

