/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content;

import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.vespa.config.content.core.StorDistributormanagerConfig;
import com.yahoo.vespa.config.content.core.StorServerConfig;
import com.yahoo.vespa.model.content.ContentNode;
import com.yahoo.vespa.model.content.DistributorCluster;
import com.yahoo.vespa.model.content.StorageNode;
import com.yahoo.vespa.model.content.engines.PersistenceEngine;
import com.yahoo.vespa.model.utils.ResourceUtils;
import java.util.Optional;

public class Distributor
extends ContentNode
implements StorDistributormanagerConfig.Producer {
    PersistenceEngine provider;

    public Distributor(ModelContext.Properties properties, DistributorCluster parent, int distributionKey, PersistenceEngine provider) {
        super(properties.featureFlags(), parent, parent.getClusterName(), StorageNode.rootFolder + parent.getClusterName() + "/distributor/" + distributionKey, distributionKey);
        this.provider = provider;
        this.setMallocImpl(properties.mallocImpl(Optional.of(ClusterSpec.Type.content)));
    }

    private int tuneNumDistributorStripes() {
        return this.maybeRealNodeResources().map(res -> {
            int cores = (int)res.vcpu();
            if (cores <= 16) {
                return 1;
            }
            if (cores <= 64) {
                return 2;
            }
            return 4;
        }).orElse(0);
    }

    @Override
    public void getConfig(StorServerConfig.Builder builder) {
        super.getConfig(builder);
        this.provider.getConfig(builder);
    }

    public void getConfig(StorDistributormanagerConfig.Builder builder) {
        builder.num_distributor_stripes(this.tuneNumDistributorStripes());
        this.maybeRealNodeResources().ifPresent(res -> {
            builder.hwinfo.cpu.cores((int)Math.ceil(res.vcpu()));
            builder.hwinfo.memory.size((long)(ResourceUtils.usableMemoryGb(res) * 1.073741824E9));
            builder.hwinfo.disk.size((long)(res.diskGb() * 1.0E9));
        });
    }

    @Override
    public Optional<String> getStartupCommand() {
        return Optional.of("exec sbin/vespa-distributord -c $VESPA_CONFIG_ID");
    }

    protected Optional<NodeResources> maybeRealNodeResources() {
        if (this.getHostResource() == null || this.getHostResource().realResources().isUnspecified()) {
            return Optional.empty();
        }
        return Optional.of(this.getHostResource().realResources());
    }
}

