/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.content.ResourceLimits;
import com.yahoo.vespa.model.content.cluster.DomResourceLimitsBuilder;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.logging.Level;

public class ClusterResourceLimits {
    private final ResourceLimits clusterControllerLimits;
    private final ResourceLimits contentNodeLimits;

    private ClusterResourceLimits(Builder builder) {
        this.clusterControllerLimits = builder.ctrlBuilder.build();
        this.contentNodeLimits = builder.nodeBuilder.build();
    }

    public ResourceLimits getClusterControllerLimits() {
        return this.clusterControllerLimits;
    }

    public ResourceLimits getContentNodeLimits() {
        return this.contentNodeLimits;
    }

    public static class Builder {
        private final boolean hostedVespa;
        private final double resourceLimitDisk;
        private final double resourceLimitMemory;
        private final double resourceLimitLowAddressSpace;
        private final DeployLogger deployLogger;
        private ResourceLimits.Builder ctrlBuilder = new ResourceLimits.Builder();
        private ResourceLimits.Builder nodeBuilder = new ResourceLimits.Builder();

        public Builder(boolean hostedVespa, double resourceLimitDisk, double resourceLimitMemory, double resourceLimitLowAddressSpace, DeployLogger deployLogger) {
            this.hostedVespa = hostedVespa;
            this.resourceLimitDisk = resourceLimitDisk;
            this.resourceLimitMemory = resourceLimitMemory;
            this.resourceLimitLowAddressSpace = resourceLimitLowAddressSpace;
            this.deployLogger = deployLogger;
            this.verifyLimits(resourceLimitDisk, resourceLimitMemory, resourceLimitLowAddressSpace);
        }

        public ClusterResourceLimits build(ModelElement clusterElem) {
            this.ctrlBuilder = this.createBuilder(clusterElem.childByPath("tuning"));
            this.nodeBuilder = this.createBuilder(clusterElem.childByPath("engine.proton"));
            if (this.nodeBuilder.getDiskLimit().isPresent() || this.nodeBuilder.getMemoryLimit().isPresent()) {
                this.deployLogger.logApplicationPackage(Level.WARNING, "Setting proton resource limits in <engine><proton> should not be done directly. Set limits for cluster as described in https://docs.vespa.ai/en/reference/services/content.html#resource-limits instead.");
            }
            this.deriveLimits();
            return new ClusterResourceLimits(this);
        }

        private ResourceLimits.Builder createBuilder(ModelElement element) {
            return element == null ? new ResourceLimits.Builder() : DomResourceLimitsBuilder.createBuilder(element, this.hostedVespa);
        }

        public void setClusterControllerBuilder(ResourceLimits.Builder builder) {
            this.ctrlBuilder = builder;
        }

        public void setContentNodeBuilder(ResourceLimits.Builder builder) {
            this.nodeBuilder = builder;
        }

        public ClusterResourceLimits build() {
            this.deriveLimits();
            return new ClusterResourceLimits(this);
        }

        private void deriveLimits() {
            this.considerSettingDefaultClusterControllerLimit(this.ctrlBuilder.getDiskLimit(), this.nodeBuilder.getDiskLimit(), this.ctrlBuilder::setDiskLimit, this.resourceLimitDisk);
            this.considerSettingDefaultClusterControllerLimit(this.ctrlBuilder.getMemoryLimit(), this.nodeBuilder.getMemoryLimit(), this.ctrlBuilder::setMemoryLimit, this.resourceLimitMemory);
            this.considerSettingDefaultClusterControllerLimit(this.ctrlBuilder.getAddressSpaceLimit(), this.nodeBuilder.getAddressSpaceLimit(), this.ctrlBuilder::setAddressSpaceLimit, this.resourceLimitLowAddressSpace);
            this.deriveClusterControllerLimit(this.ctrlBuilder.getDiskLimit(), this.nodeBuilder.getDiskLimit(), this.ctrlBuilder::setDiskLimit);
            this.deriveClusterControllerLimit(this.ctrlBuilder.getMemoryLimit(), this.nodeBuilder.getMemoryLimit(), this.ctrlBuilder::setMemoryLimit);
            this.deriveClusterControllerLimit(this.ctrlBuilder.getAddressSpaceLimit(), this.nodeBuilder.getAddressSpaceLimit(), this.ctrlBuilder::setAddressSpaceLimit);
            this.deriveContentNodeLimit(this.nodeBuilder.getDiskLimit(), this.ctrlBuilder.getDiskLimit(), 0.6, this.nodeBuilder::setDiskLimit);
            this.deriveContentNodeLimit(this.nodeBuilder.getMemoryLimit(), this.ctrlBuilder.getMemoryLimit(), 0.5, this.nodeBuilder::setMemoryLimit);
            this.deriveContentNodeLimit(this.nodeBuilder.getAddressSpaceLimit(), this.ctrlBuilder.getAddressSpaceLimit(), 0.5, this.nodeBuilder::setAddressSpaceLimit);
        }

        private void considerSettingDefaultClusterControllerLimit(Optional<Double> clusterControllerLimit, Optional<Double> contentNodeLimit, Consumer<Double> setter, double resourceLimit) {
            if (clusterControllerLimit.isEmpty() && contentNodeLimit.isEmpty()) {
                setter.accept(resourceLimit);
            }
        }

        private void deriveClusterControllerLimit(Optional<Double> clusterControllerLimit, Optional<Double> contentNodeLimit, Consumer<Double> setter) {
            if (clusterControllerLimit.isEmpty()) {
                contentNodeLimit.ifPresent(limit -> setter.accept(Double.max(0.0, limit - 0.01)));
            }
        }

        private void deriveContentNodeLimit(Optional<Double> contentNodeLimit, Optional<Double> clusterControllerLimit, double scaleFactor, Consumer<Double> setter) {
            if (contentNodeLimit.isEmpty()) {
                clusterControllerLimit.ifPresent(limit -> setter.accept(this.calcContentNodeLimit((double)limit, scaleFactor)));
            }
        }

        private double calcContentNodeLimit(double clusterControllerLimit, double scaleFactor) {
            return clusterControllerLimit + (1.0 - clusterControllerLimit) * scaleFactor;
        }

        private void verifyLimits(double resourceLimitDisk, double resourceLimitMemory, double resourceLimitAddressSpace) {
            this.verifyLimitInRange(resourceLimitDisk, "disk");
            this.verifyLimitInRange(resourceLimitMemory, "memory");
            this.verifyLimitInRange(resourceLimitAddressSpace, "address space");
        }

        private void verifyLimitInRange(double limit, String type) {
            String message = "Resource limit for " + type + " is set to illegal value " + limit + ", but must be in the range [0.0, 1.0]";
            if (limit < 0.0) {
                throw new IllegalArgumentException(message);
            }
            if (limit > 1.0) {
                throw new IllegalArgumentException(message);
            }
        }
    }
}

