/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.xml;

import com.yahoo.config.model.builder.xml.XmlHelper;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.vespa.model.container.ContainerThreadpool;
import java.util.logging.Level;
import org.w3c.dom.Element;

public class ContainerThreadpoolOptionsBuilder {
    public static ContainerThreadpool.UserOptions build(DeployState ds, Element parent) {
        boolean isRelative;
        ContainerThreadpool.UserOptions options = new ContainerThreadpool.UserOptions(null, null, null, false);
        Element threadpoolElem = XmlHelper.getOptionalChild(parent, "threadpool").orElse(null);
        if (threadpoolElem == null) {
            return options;
        }
        Double max = null;
        Double min = null;
        Double queue = null;
        Element threadsElem = XmlHelper.getOptionalChild(threadpoolElem, "threads").orElse(null);
        Element queueElem = XmlHelper.getOptionalChild(threadpoolElem, "queue").orElse(null);
        if (threadsElem != null || queueElem != null) {
            if (threadsElem != null) {
                min = Double.parseDouble(threadsElem.getTextContent());
                String maxAttribute = XmlHelper.getOptionalAttribute(threadsElem, "max").orElse(null);
                String boostAttribute = XmlHelper.getOptionalAttribute(threadsElem, "boost").orElse(null);
                if (maxAttribute != null && boostAttribute != null) {
                    throw new IllegalArgumentException("For <threads>: both 'max' and 'boost' cannot be specified at the same time. Please use 'max' only.");
                }
                if (maxAttribute != null) {
                    max = Double.parseDouble(maxAttribute);
                } else if (boostAttribute != null) {
                    ds.getDeployLogger().logApplicationPackage(Level.WARNING, "For <threads>: the 'boost' attribute is deprecated, use 'max' instead.");
                    max = Double.parseDouble(boostAttribute);
                } else {
                    max = min;
                }
            }
            if (queueElem != null) {
                queue = Double.parseDouble(queueElem.getTextContent());
            }
            isRelative = true;
        } else {
            Element queueSizeElem;
            Element maxElem;
            Element minElem = XmlHelper.getOptionalChild(threadpoolElem, "min-threads").orElse(null);
            if (minElem != null) {
                ds.getDeployLogger().logApplicationPackage(Level.WARNING, "For <threadpool>: <min-threads> is deprecated, use <threads> instead");
            }
            if ((maxElem = (Element)XmlHelper.getOptionalChild(threadpoolElem, "max-threads").orElse(null)) != null) {
                ds.getDeployLogger().logApplicationPackage(Level.WARNING, "For <threadpool>: <max-threads> is deprecated, use <threads> with 'max' instead");
            }
            if (minElem != null) {
                min = Double.parseDouble(minElem.getTextContent());
            }
            if (maxElem != null) {
                max = Double.parseDouble(maxElem.getTextContent());
            }
            if ((queueSizeElem = (Element)XmlHelper.getOptionalChild(threadpoolElem, "queue-size").orElse(null)) != null) {
                ds.getDeployLogger().logApplicationPackage(Level.WARNING, "For <threadpool>: <queue-size> is deprecated, use <queue> instead");
            }
            if (queueSizeElem != null) {
                queue = Double.parseDouble(queueSizeElem.getTextContent());
            }
            isRelative = false;
        }
        if (min != null && min < 0.0) {
            throw new IllegalArgumentException("For <threadpool>: <threads> must be positive.");
        }
        if (max != null && max <= 0.0) {
            throw new IllegalArgumentException("For <threadpool>: 'max' on <threads> must be positive.");
        }
        if (queue != null && queue < 0.0) {
            throw new IllegalArgumentException("For <threadpool>: <queue> must be positive.");
        }
        if (min != null && max != null && min > max) {
            throw new IllegalArgumentException("For <threadpool>: 'max' on <threads> must be greater than <threads>.");
        }
        options = new ContainerThreadpool.UserOptions(max, min, queue, isRelative);
        return options;
    }
}

