/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.search;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.search.query.profile.BackedOverridableQueryProfile;
import com.yahoo.search.query.profile.QueryProfile;
import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.search.query.profile.SubstituteString;
import com.yahoo.search.query.profile.config.QueryProfilesConfig;
import com.yahoo.search.query.profile.types.FieldDescription;
import com.yahoo.search.query.profile.types.QueryProfileType;
import com.yahoo.tensor.TensorType;
import com.yahoo.vespa.model.container.search.DeclaredQueryProfileVariants;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class QueryProfiles
implements Serializable,
QueryProfilesConfig.Producer {
    private final QueryProfileRegistry registry;

    public QueryProfiles(QueryProfileRegistry registry, DeployLogger logger) {
        this.registry = registry;
        this.validate(registry, logger);
    }

    public QueryProfiles() {
        this.registry = new QueryProfileRegistry();
    }

    public QueryProfileRegistry getRegistry() {
        return this.registry;
    }

    private void validate(QueryProfileRegistry registry, DeployLogger logger) {
        HashSet<String> tensorFields = new HashSet<String>();
        for (QueryProfileType type : registry.getTypeRegistry().allComponents()) {
            for (Map.Entry fieldEntry : type.fields().entrySet()) {
                this.validateTensorField((String)fieldEntry.getKey(), ((FieldDescription)fieldEntry.getValue()).getType().asTensorType());
                if (((FieldDescription)fieldEntry.getValue()).getType().asTensorType().rank() <= 0) continue;
                tensorFields.add((String)fieldEntry.getKey());
            }
        }
        if (registry.getTypeRegistry().hasApplicationTypes() && registry.allComponents().isEmpty()) {
            logger.logApplicationPackage(Level.WARNING, "This application define query profile types, but has no query profiles referencing them so they have no effect. " + (String)(tensorFields.isEmpty() ? "" : "In particular, the tensors (" + String.join((CharSequence)", ", tensorFields) + ") will be interpreted as strings, not tensors if sent in requests. ") + "See https://docs.vespa.ai/en/querying/query-profiles.html");
        }
    }

    private void validateTensorField(String fieldName, TensorType type) {
        if (type.dimensions().stream().anyMatch(d -> d.isIndexed() && d.size().isEmpty())) {
            throw new IllegalArgumentException("Illegal type in field " + fieldName + " type " + String.valueOf(type) + ": Dense tensor dimensions must have a size");
        }
    }

    public void getConfig(QueryProfilesConfig.Builder builder) {
        for (QueryProfile profile : this.registry.allComponents()) {
            builder.queryprofile(this.createConfig(profile));
        }
        for (QueryProfileType profileType : this.registry.getTypeRegistry().allComponents()) {
            if (profileType.isBuiltin()) continue;
            builder.queryprofiletype(this.createConfig(profileType));
        }
    }

    private QueryProfilesConfig.Queryprofile.Builder createConfig(QueryProfile profile) {
        QueryProfilesConfig.Queryprofile.Builder qB = new QueryProfilesConfig.Queryprofile.Builder();
        qB.id(profile.getId().stringValue());
        if (profile.getType() != null) {
            qB.type(profile.getType().getId().stringValue());
        }
        for (QueryProfile inherited : profile.inherited()) {
            qB.inherit(inherited.getId().stringValue());
        }
        if (profile.getVariants() != null) {
            for (String dimension : profile.getVariants().getDimensions()) {
                qB.dimensions(dimension);
            }
        }
        this.addFieldChildren(qB, profile, "");
        this.addVariants(qB, profile);
        return qB;
    }

    private void addFieldChildren(QueryProfilesConfig.Queryprofile.Builder qpB, QueryProfile profile, String namePrefix) {
        ArrayList content = new ArrayList(profile.declaredContent().entrySet());
        content.sort(new MapEntryKeyComparator());
        if (profile.getValue() != null) {
            QueryProfilesConfig.Queryprofile.Property.Builder propB = new QueryProfilesConfig.Queryprofile.Property.Builder();
            String string = namePrefix.substring(0, namePrefix.length() - 1);
            Object value = profile.getValue();
            if (value instanceof SubstituteString) {
                value = value.toString();
            }
            propB.name(string);
            if (value != null) {
                propB.value(value.toString());
            }
            qpB.property(propB);
        }
        for (Map.Entry entry : content) {
            this.addField(qpB, profile, entry, namePrefix);
        }
    }

    private void addVariantFieldChildren(QueryProfilesConfig.Queryprofile.Queryprofilevariant.Builder qpB, QueryProfile profile, String namePrefix) {
        ArrayList content = new ArrayList(profile.declaredContent().entrySet());
        content.sort(new MapEntryKeyComparator());
        if (profile.getValue() != null) {
            QueryProfilesConfig.Queryprofile.Queryprofilevariant.Property.Builder propB = new QueryProfilesConfig.Queryprofile.Queryprofilevariant.Property.Builder();
            String string = namePrefix.substring(0, namePrefix.length() - 1);
            Object value = profile.getValue();
            if (value instanceof SubstituteString) {
                value = value.toString();
            }
            propB.name(string);
            if (value != null) {
                propB.value(value.toString());
            }
            qpB.property(propB);
        }
        for (Map.Entry entry : content) {
            this.addVariantField(qpB, entry, profile.isDeclaredOverridable((String)entry.getKey(), Map.of()), namePrefix);
        }
    }

    private void addField(QueryProfilesConfig.Queryprofile.Builder qpB, QueryProfile profile, Map.Entry<String, Object> field, String namePrefix) {
        String fullName = namePrefix + field.getKey();
        Object object = field.getValue();
        if (object instanceof QueryProfile) {
            QueryProfile subProfile = (QueryProfile)object;
            if (!subProfile.isExplicit()) {
                this.addFieldChildren(qpB, subProfile, fullName + ".");
            } else {
                QueryProfilesConfig.Queryprofile.Reference.Builder refB = new QueryProfilesConfig.Queryprofile.Reference.Builder();
                this.createReferenceFieldConfig(refB, profile, fullName, field.getKey(), ((BackedOverridableQueryProfile)subProfile).getBacking().getId().stringValue());
                qpB.reference(refB);
                this.addFieldChildren(qpB, subProfile, fullName + ".");
            }
        } else {
            qpB.property(this.createPropertyFieldConfig(profile, fullName, field.getKey(), field.getValue()));
        }
    }

    private void addVariantField(QueryProfilesConfig.Queryprofile.Queryprofilevariant.Builder qpB, Map.Entry<String, Object> field, Boolean overridable, String namePrefix) {
        String fullName = namePrefix + field.getKey();
        Object object = field.getValue();
        if (object instanceof QueryProfile) {
            QueryProfile subProfile = (QueryProfile)object;
            if (!subProfile.isExplicit()) {
                this.addVariantFieldChildren(qpB, subProfile, fullName + ".");
            } else {
                QueryProfilesConfig.Queryprofile.Queryprofilevariant.Reference.Builder refB = new QueryProfilesConfig.Queryprofile.Queryprofilevariant.Reference.Builder();
                this.createVariantReferenceFieldConfig(refB, fullName, ((BackedOverridableQueryProfile)subProfile).getBacking().getId().stringValue());
                qpB.reference(refB);
                this.addVariantFieldChildren(qpB, subProfile, fullName + ".");
            }
        } else {
            qpB.property(this.createVariantPropertyFieldConfig(fullName, field.getValue(), overridable));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addVariants(QueryProfilesConfig.Queryprofile.Builder qB, QueryProfile profile) {
        if (profile.getVariants() == null) {
            return;
        }
        DeclaredQueryProfileVariants declaredVariants = new DeclaredQueryProfileVariants(profile);
        for (DeclaredQueryProfileVariants.VariantQueryProfile variant : declaredVariants.getVariantQueryProfiles().values()) {
            void var9_12;
            QueryProfilesConfig.Queryprofile.Queryprofilevariant.Builder varB = new QueryProfilesConfig.Queryprofile.Queryprofilevariant.Builder();
            String[] stringArray = variant.getDimensionValues();
            int n = stringArray.length;
            boolean bl = false;
            while (var9_12 < n) {
                String dimensionValue = stringArray[var9_12];
                if (dimensionValue == null) {
                    dimensionValue = "*";
                }
                varB.fordimensionvalues(dimensionValue);
                ++var9_12;
            }
            for (QueryProfile inherited : variant.inherited()) {
                varB.inherit(inherited.getId().stringValue());
            }
            ArrayList<Map.Entry<String, Object>> content = new ArrayList<Map.Entry<String, Object>>(variant.getValues().entrySet());
            content.sort(new MapEntryKeyComparator());
            for (Map.Entry entry : content) {
                this.addVariantField(varB, entry, variant.getOverriable().get(entry.getKey()), "");
            }
            qB.queryprofilevariant(varB);
        }
    }

    private void createReferenceFieldConfig(QueryProfilesConfig.Queryprofile.Reference.Builder refB, QueryProfile profile, String fullName, String localName, String stringValue) {
        refB.name(fullName);
        if (stringValue != null) {
            refB.value(stringValue);
        }
        Boolean overridable = null;
        if (profile != null) {
            overridable = profile.isDeclaredOverridable(localName, null);
        }
        if (overridable != null) {
            refB.overridable("" + overridable);
        }
    }

    private void createVariantReferenceFieldConfig(QueryProfilesConfig.Queryprofile.Queryprofilevariant.Reference.Builder refB, String fullName, String stringValue) {
        refB.name(fullName);
        if (stringValue != null) {
            refB.value(stringValue);
        }
    }

    private QueryProfilesConfig.Queryprofile.Property.Builder createPropertyFieldConfig(QueryProfile profile, String fullName, String localName, Object value) {
        QueryProfilesConfig.Queryprofile.Property.Builder propB = new QueryProfilesConfig.Queryprofile.Property.Builder();
        Boolean overridable = null;
        if (value instanceof SubstituteString) {
            value = value.toString();
        }
        propB.name(fullName);
        if (value != null) {
            propB.value(value.toString());
        }
        if (profile != null) {
            overridable = profile.isDeclaredOverridable(localName, null);
        }
        if (overridable != null) {
            propB.overridable("" + overridable);
        }
        return propB;
    }

    private QueryProfilesConfig.Queryprofile.Queryprofilevariant.Property.Builder createVariantPropertyFieldConfig(String fullName, Object value, Boolean overridable) {
        QueryProfilesConfig.Queryprofile.Queryprofilevariant.Property.Builder propB = new QueryProfilesConfig.Queryprofile.Queryprofilevariant.Property.Builder();
        if (value instanceof SubstituteString) {
            value = value.toString();
        }
        propB.name(fullName);
        if (value != null) {
            propB.value(value.toString());
        }
        if (overridable != null) {
            propB.overridable(overridable.toString());
        }
        return propB;
    }

    private QueryProfilesConfig.Queryprofiletype.Builder createConfig(QueryProfileType profileType) {
        QueryProfilesConfig.Queryprofiletype.Builder qtB = new QueryProfilesConfig.Queryprofiletype.Builder();
        qtB.id(profileType.getId().stringValue());
        if (profileType.isDeclaredStrict()) {
            qtB.strict(true);
        }
        if (profileType.getDeclaredMatchAsPath()) {
            qtB.matchaspath(true);
        }
        for (QueryProfileType inherited : profileType.inherited()) {
            qtB.inherit(inherited.getId().stringValue());
        }
        ArrayList fields = new ArrayList(profileType.declaredFields().values());
        Collections.sort(fields);
        for (FieldDescription field : fields) {
            qtB.field(this.createConfig(field));
        }
        return qtB;
    }

    private QueryProfilesConfig.Queryprofiletype.Field.Builder createConfig(FieldDescription field) {
        String aliases;
        QueryProfilesConfig.Queryprofiletype.Field.Builder fB = new QueryProfilesConfig.Queryprofiletype.Field.Builder();
        fB.name(field.getName()).type(field.getType().stringValue());
        if (!field.isOverridable()) {
            fB.overridable(false);
        }
        if (field.isMandatory()) {
            fB.mandatory(true);
        }
        if (!(aliases = this.toSpaceSeparatedString(field.getAliases())).isEmpty()) {
            fB.alias(aliases);
        }
        return fB;
    }

    private String toSpaceSeparatedString(List<String> list) {
        StringBuilder b = new StringBuilder();
        Iterator<String> i = list.iterator();
        while (i.hasNext()) {
            b.append(i.next());
            if (!i.hasNext()) continue;
            b.append(" ");
        }
        return b.toString();
    }

    public QueryProfilesConfig getConfig() {
        QueryProfilesConfig.Builder qB = new QueryProfilesConfig.Builder();
        this.getConfig(qB);
        return new QueryProfilesConfig(qB);
    }

    private static class MapEntryKeyComparator
    implements Comparator<Map.Entry<String, Object>> {
        private MapEntryKeyComparator() {
        }

        @Override
        public int compare(Map.Entry<String, Object> e1, Map.Entry<String, Object> e2) {
            return e1.getKey().compareTo(e2.getKey());
        }
    }
}

