/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.component;

import ai.vespa.embedding.config.VoyageAiEmbedderConfig;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.component.TypedComponent;
import org.w3c.dom.Element;

public class VoyageAIEmbedder
extends TypedComponent
implements VoyageAiEmbedderConfig.Producer {
    private final String apiKeySecretRef;
    private final String endpoint;
    private final String model;
    private final Integer timeout;
    private final Integer maxRetries;
    private final String defaultInputType;
    private final Boolean autoDetectInputType;
    private final Boolean truncate;
    private final Integer maxIdleConnections;
    private final Boolean normalize;

    public VoyageAIEmbedder(ApplicationContainerCluster cluster, Element xml, DeployState state) {
        super("ai.vespa.embedding.VoyageAIEmbedder", "model-integration", xml);
        this.apiKeySecretRef = (String)XML.getChildValue((Element)xml, (String)"api-key-secret-ref").orElseThrow(() -> new IllegalArgumentException("VoyageAI embedder requires <api-key-secret-ref> element. Please specify the reference to the secret in Vespa's secret store."));
        this.model = (String)XML.getChildValue((Element)xml, (String)"model").orElseThrow(() -> new IllegalArgumentException("VoyageAI embedder requires <model> element. Please specify the VoyageAI model name (e.g., voyage-3, voyage-3.5, voyage-code-3)."));
        this.endpoint = XML.getChildValue((Element)xml, (String)"endpoint").orElse(null);
        this.timeout = XML.getChildValue((Element)xml, (String)"timeout").map(Integer::parseInt).orElse(null);
        this.maxRetries = XML.getChildValue((Element)xml, (String)"max-retries").map(Integer::parseInt).orElse(null);
        this.defaultInputType = XML.getChildValue((Element)xml, (String)"default-input-type").orElse(null);
        this.autoDetectInputType = XML.getChildValue((Element)xml, (String)"auto-detect-input-type").map(Boolean::parseBoolean).orElse(null);
        this.truncate = XML.getChildValue((Element)xml, (String)"truncate").map(Boolean::parseBoolean).orElse(null);
        this.maxIdleConnections = XML.getChildValue((Element)xml, (String)"max-idle-connections").map(Integer::parseInt).orElse(null);
        this.normalize = XML.getChildValue((Element)xml, (String)"normalize").map(Boolean::parseBoolean).orElse(null);
        this.validate();
    }

    @Override
    public void validate() {
        String type;
        if (this.timeout != null && this.timeout < 1000) {
            throw new IllegalArgumentException("timeout must be at least 1000ms, got: " + this.timeout);
        }
        if (this.maxRetries != null && (this.maxRetries < 0 || this.maxRetries > 100)) {
            throw new IllegalArgumentException("max-retries must be between 0 and 100, got: " + this.maxRetries);
        }
        if (this.maxIdleConnections != null && (this.maxIdleConnections < 0 || this.maxIdleConnections > 100)) {
            throw new IllegalArgumentException("max-idle-connections must be between 0 and 100, got: " + this.maxIdleConnections);
        }
        if (this.defaultInputType != null && !(type = this.defaultInputType.toLowerCase()).equals("query") && !type.equals("document")) {
            throw new IllegalArgumentException("default-input-type must be 'query' or 'document', got: " + this.defaultInputType);
        }
        if (this.model != null && !this.model.startsWith("voyage")) {
            throw new IllegalArgumentException("Invalid VoyageAI model name: " + this.model + ". Model name should start with 'voyage' (e.g., voyage-3, voyage-code-3).");
        }
    }

    public void getConfig(VoyageAiEmbedderConfig.Builder builder) {
        builder.apiKeySecretRef(this.apiKeySecretRef);
        builder.model(this.model);
        if (this.endpoint != null) {
            builder.endpoint(this.endpoint);
        }
        if (this.timeout != null) {
            builder.timeout(this.timeout.intValue());
        }
        if (this.maxRetries != null) {
            builder.maxRetries(this.maxRetries.intValue());
        }
        if (this.defaultInputType != null) {
            builder.defaultInputType(VoyageAiEmbedderConfig.DefaultInputType.Enum.valueOf((String)this.defaultInputType.toLowerCase()));
        }
        if (this.autoDetectInputType != null) {
            builder.autoDetectInputType(this.autoDetectInputType.booleanValue());
        }
        if (this.truncate != null) {
            builder.truncate(this.truncate.booleanValue());
        }
        if (this.maxIdleConnections != null) {
            builder.maxIdleConnections(this.maxIdleConnections.intValue());
        }
        if (this.normalize != null) {
            builder.normalize(this.normalize.booleanValue());
        }
    }
}

