/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.component;

import com.yahoo.config.ModelReference;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.embedding.SpladeEmbedderConfig;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.component.Model;
import com.yahoo.vespa.model.container.component.OnnxEmbedder;
import java.util.Set;
import org.w3c.dom.Element;

public class SpladeEmbedder
extends OnnxEmbedder
implements SpladeEmbedderConfig.Producer {
    private final ModelReference modelRef;
    private final ModelReference vocabRef;
    private final Integer maxTokens;
    private final String transformerInputIds;
    private final String transformerAttentionMask;
    private final String transformerTokenTypeIds;
    private final String transformerOutput;
    private final Double termScoreThreshold;

    public SpladeEmbedder(ApplicationContainerCluster cluster, Element xml, DeployState state) {
        super("ai.vespa.embedding.SpladeEmbedder", "model-integration", xml, state);
        Model model = Model.fromXml(state, xml, "transformer-model", Set.of("onnx-model")).orElseThrow();
        this.modelRef = model.modelReference();
        this.vocabRef = Model.fromXmlOrImplicitlyFromOnnxModel(state, xml, model, "tokenizer-model", Set.of("huggingface-tokenizer")).modelReference();
        this.maxTokens = XML.getChildValue((Element)xml, (String)"max-tokens").map(Integer::parseInt).orElse(null);
        this.transformerInputIds = XML.getChildValue((Element)xml, (String)"transformer-input-ids").orElse(null);
        this.transformerAttentionMask = XML.getChildValue((Element)xml, (String)"transformer-attention-mask").orElse(null);
        this.transformerTokenTypeIds = XML.getChildValue((Element)xml, (String)"transformer-token-type-ids").orElse(null);
        this.transformerOutput = XML.getChildValue((Element)xml, (String)"transformer-output").orElse(null);
        this.termScoreThreshold = XML.getChildValue((Element)xml, (String)"term-score-threshold").map(Double::parseDouble).orElse(null);
        model.registerOnnxModelCost(cluster, this.onnxModelOptions);
    }

    public void getConfig(SpladeEmbedderConfig.Builder b) {
        b.transformerModel(this.modelRef).tokenizerPath(this.vocabRef);
        if (this.maxTokens != null) {
            b.transformerMaxTokens(this.maxTokens.intValue());
        }
        if (this.transformerInputIds != null) {
            b.transformerInputIds(this.transformerInputIds);
        }
        if (this.transformerAttentionMask != null) {
            b.transformerAttentionMask(this.transformerAttentionMask);
        }
        if (this.transformerTokenTypeIds != null) {
            b.transformerTokenTypeIds(this.transformerTokenTypeIds);
        }
        if (this.transformerOutput != null) {
            b.transformerOutput(this.transformerOutput);
        }
        if (this.termScoreThreshold != null) {
            b.termScoreThreshold(this.termScoreThreshold.doubleValue());
        }
    }
}

