/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change;

import com.yahoo.config.model.api.ServiceInfo;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.Validation;
import com.yahoo.vespa.model.application.validation.change.ChangeValidator;
import com.yahoo.vespa.model.application.validation.change.VespaRestartAction;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.DataplaneProxy;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DataplaneProxyChangeValidator
implements ChangeValidator {
    @Override
    public void validate(Validation.ChangeContext context) {
        String message;
        ApplicationContainerCluster cluster;
        Map<ClusterSpec.Id, ApplicationContainerCluster> previousClustersWithProxy = DataplaneProxyChangeValidator.findClustersWithDataplaneProxy(context.previousModel());
        Map<ClusterSpec.Id, ApplicationContainerCluster> nextClustersWithProxy = DataplaneProxyChangeValidator.findClustersWithDataplaneProxy(context.model());
        for (Map.Entry<ClusterSpec.Id, ApplicationContainerCluster> entry : nextClustersWithProxy.entrySet()) {
            if (previousClustersWithProxy.containsKey(entry.getKey())) continue;
            cluster = entry.getValue();
            cluster.setDeferChangesUntilRestart(true);
            message = "Token endpoint was enabled for cluster '%s', services require restart".formatted(entry.getKey());
            context.require(DataplaneProxyChangeValidator.createRestartAction(cluster, message));
        }
        for (ClusterSpec.Id clusterId : previousClustersWithProxy.keySet()) {
            if (nextClustersWithProxy.containsKey(clusterId)) continue;
            cluster = previousClustersWithProxy.get(clusterId);
            cluster.setDeferChangesUntilRestart(true);
            message = "Token endpoint was disabled for cluster '%s', services require restart".formatted(clusterId);
            context.require(DataplaneProxyChangeValidator.createRestartAction(cluster, message));
        }
    }

    private static Map<ClusterSpec.Id, ApplicationContainerCluster> findClustersWithDataplaneProxy(VespaModel model) {
        return model.getContainerClusters().values().stream().filter(cluster -> cluster.getAllComponents().stream().anyMatch(component -> component.getClassId().getName().equals(DataplaneProxy.COMPONENT_CLASS))).collect(Collectors.toMap(ContainerCluster::id, cluster -> cluster));
    }

    private static VespaRestartAction createRestartAction(ApplicationContainerCluster cluster, String message) {
        List<ServiceInfo> services = cluster.getContainers().stream().map(AbstractService::getServiceInfo).toList();
        return new VespaRestartAction(cluster.id(), message, services);
    }
}

