/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.DataType;
import com.yahoo.document.NumericDataType;
import com.yahoo.document.TensorDataType;
import com.yahoo.documentmodel.NewDocumentReferenceDataType;
import com.yahoo.schema.Schema;
import com.yahoo.schema.derived.DerivedConfiguration;
import com.yahoo.schema.derived.SchemaInfo;
import com.yahoo.schema.document.Attribute;
import com.yahoo.schema.document.ImmutableSDField;
import com.yahoo.schema.document.MatchType;
import com.yahoo.vespa.model.application.validation.Validation;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.search.SearchCluster;
import java.util.List;
import java.util.logging.Level;

public class StreamingValidator
implements Validator {
    @Override
    public void validate(Validation.Context context) {
        List<SearchCluster> searchClusters = context.model().getSearchClusters();
        DeployLogger deployLogger = context.deployState().getDeployLogger();
        for (SearchCluster cluster : searchClusters) {
            for (SchemaInfo schemaInfo : cluster.schemas().values()) {
                if (schemaInfo.getIndexMode() != SchemaInfo.IndexMode.STREAMING) continue;
                StreamingValidator.warnStreamingAttributes(cluster.getClusterName(), schemaInfo.fullSchema(), deployLogger);
                StreamingValidator.warnStreamingIndexFields(cluster.getClusterName(), schemaInfo.fullSchema(), deployLogger);
                StreamingValidator.warnStreamingGramMatching(cluster.getClusterName(), schemaInfo.fullSchema(), deployLogger);
                StreamingValidator.failStreamingDocumentReferences(cluster.getClusterName(), cluster.getDocumentDB(schemaInfo.name()).getDerivedConfiguration(), context);
            }
            if (!cluster.hasStreaming() || !cluster.hasIndexed()) continue;
            deployLogger.logApplicationPackage(Level.WARNING, "For search cluster '" + String.valueOf(cluster) + "': Using document types with both streaming and indexed mode is discouraged, see https://docs.vespa.ai/en/performance/streaming-search.html.");
        }
    }

    private static void logWarning(String cluster, Schema schema, ImmutableSDField sd, DeployLogger logger, String message) {
        logger.logApplicationPackage(Level.WARNING, "For search cluster '" + cluster + "', streaming schema '" + schema.getName() + "', schema field '" + sd.getName() + "': " + message);
    }

    private static void warnStreamingGramMatching(String cluster, Schema schema, DeployLogger logger) {
        for (ImmutableSDField immutableSDField : schema.allConcreteFields()) {
            if (immutableSDField.getMatching().getType() != MatchType.GRAM) continue;
            StreamingValidator.logWarning(cluster, schema, immutableSDField, logger, "n-gram matching is not supported for streaming search.");
        }
    }

    private static void warnStreamingAttributes(String cluster, Schema schema, DeployLogger logger) {
        for (ImmutableSDField immutableSDField : schema.allConcreteFields()) {
            if (!immutableSDField.doesAttributing()) continue;
            StreamingValidator.warnStreamingAttribute(cluster, schema, immutableSDField, logger);
        }
    }

    private static void warnStreamingAttribute(String cluster, Schema schema, ImmutableSDField sd, DeployLogger logger) {
        if (sd.getDataType() instanceof NumericDataType) {
            return;
        }
        if (sd.getDataType() instanceof TensorDataType) {
            for (Attribute fieldAttribute : sd.getAttributes().values()) {
                if (!fieldAttribute.hnswIndexParams().isPresent()) continue;
                StreamingValidator.logWarning(cluster, schema, sd, logger, "hnsw index is not relevant and not supported, ignoring setting");
            }
            return;
        }
        if (sd.getDataType() == DataType.PREDICATE) {
            StreamingValidator.logWarning(cluster, schema, sd, logger, "field type predicate is not supported for streaming search");
        }
    }

    private static void failStreamingDocumentReferences(String cluster, DerivedConfiguration derived, Validation.Context context) {
        for (Attribute attribute : derived.getAttributeFields().attributes()) {
            DataType dataType = attribute.getDataType();
            if (!(dataType instanceof NewDocumentReferenceDataType)) continue;
            String errorMessage = String.format("For search cluster '%s', streaming schema '%s': Attribute '%s' has type '%s'. Document references and imported fields are not allowed in streaming search.", cluster, derived.getSchema().getName(), attribute.getName(), dataType.getName());
            context.illegal(errorMessage);
        }
    }

    private static void warnStreamingIndexFields(String cluster, Schema schema, DeployLogger logger) {
        for (ImmutableSDField immutableSDField : schema.allConcreteFields()) {
            if (!immutableSDField.doesIndexing()) continue;
            StreamingValidator.warnStreamingIndexField(cluster, schema, immutableSDField, logger);
        }
    }

    private static void warnStreamingIndexField(String cluster, Schema schema, ImmutableSDField sd, DeployLogger logger) {
        if (sd.getDataType() == DataType.URI) {
            StreamingValidator.logWarning(cluster, schema, sd, logger, "field type uri is not supported for streaming search, it will be handled as a string field");
        }
    }
}

