/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.io.IOUtils;
import com.yahoo.io.reader.NamedReader;
import com.yahoo.path.Path;
import com.yahoo.security.X509CertificateUtils;
import com.yahoo.vespa.model.application.validation.Validation;
import com.yahoo.vespa.model.application.validation.Validator;
import java.io.Reader;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class CloudDataPlaneFilterValidator
implements Validator {
    private static final Logger log = Logger.getLogger(CloudDataPlaneFilterValidator.class.getName());

    @Override
    public void validate(Validation.Context context) {
        if (!context.deployState().isHosted()) {
            return;
        }
        if (!context.deployState().zone().system().isPublicCloudLike()) {
            return;
        }
        this.validateUniqueCertificates(context);
    }

    private void validateUniqueCertificates(Validation.Context context) {
        List certFiles = context.deployState().getApplicationPackage().getFiles(ApplicationPackage.SECURITY_DIR, ".pem");
        Map<String, List> configuredCertificates = certFiles.stream().collect(Collectors.toMap(NamedReader::getName, reader -> CloudDataPlaneFilterValidator.readCertificates(context, reader)));
        HashSet<X509Certificate> duplicates = new HashSet<X509Certificate>();
        HashSet globalUniqueCerts = new HashSet();
        for (Map.Entry<String, List> certificateFile : configuredCertificates.entrySet()) {
            List<X509Certificate> duplicatesInFile = certificateFile.getValue().stream().filter(i -> !globalUniqueCerts.add(i)).toList();
            duplicates.addAll(duplicatesInFile);
        }
        if (!duplicates.isEmpty()) {
            List<String> filesWithDuplicates = configuredCertificates.entrySet().stream().filter(entry -> ((List)entry.getValue()).stream().anyMatch(duplicates::contains)).map(Map.Entry::getKey).map(Path::fromString).map(Path::getName).map(p -> ApplicationPackage.SECURITY_DIR.append(p).getRelative()).sorted().toList();
            context.illegal("Duplicate certificate(s) detected in files: %s. Certificate subject of duplicates: %s".formatted(filesWithDuplicates.toString(), duplicates.stream().map(cert -> cert.getSubjectX500Principal().getName()).toList().toString()));
        }
    }

    private static List<X509Certificate> readCertificates(Validation.Context context, NamedReader reader) {
        try {
            return X509CertificateUtils.certificateListFromPem((String)IOUtils.readAll((Reader)reader));
        }
        catch (Exception e) {
            log.warning("Exception reading certificate list from application package. File: %s, exception message: %s".formatted(reader.getName(), e.getMessage()));
            context.illegal("Error reading certificates from application package", e);
            return List.of();
        }
    }
}

