/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.vespa.model.application.validation.AbstractBundleValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.w3c.dom.Document;

public class BundleValidator
extends AbstractBundleValidator {
    @Override
    protected void validateManifest(AbstractBundleValidator.JarContext reporter, JarFile jar, Manifest mf) {
        Attributes attributes = mf.getMainAttributes();
        HashSet<String> mfAttributes = new HashSet<String>();
        for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
            mfAttributes.add(entry.getKey().toString());
        }
        List<String> requiredOSGIHeaders = List.of("Bundle-ManifestVersion", "Bundle-Name", "Bundle-SymbolicName", "Bundle-Version");
        for (String header : requiredOSGIHeaders) {
            if (mfAttributes.contains(header)) continue;
            reporter.illegal("Required OSGI header '" + header + "' was not found in manifest in '" + this.filename(jar) + "'");
        }
        if (attributes.getValue("Bundle-Version").endsWith(".SNAPSHOT")) {
            this.log(reporter.deployState(), Level.WARNING, "Deploying snapshot bundle " + this.filename(jar) + ".\nTo use this bundle, you must include the qualifier 'SNAPSHOT' in the version specification in services.xml.", new Object[0]);
        }
        if (attributes.getValue("Import-Package") != null) {
            this.validateImportedPackages(reporter.deployState(), jar, mf);
        }
    }

    @Override
    protected void validatePomXml(AbstractBundleValidator.JarContext reporter, JarFile jar, Document pom) {
    }

    private void validateImportedPackages(DeployState state, JarFile jar, Manifest manifest) {
        HashMap<DeprecatedProvidedBundle, List> deprecatedPackagesInUse = new HashMap<DeprecatedProvidedBundle, List>();
        this.forEachImportPackage(manifest, packageName -> {
            for (DeprecatedProvidedBundle deprecatedBundle : DeprecatedProvidedBundle.values()) {
                for (Predicate<String> matcher : deprecatedBundle.javaPackageMatchers) {
                    if (!matcher.test((String)packageName)) continue;
                    deprecatedPackagesInUse.computeIfAbsent(deprecatedBundle, __ -> new ArrayList()).add(packageName);
                }
            }
        });
        deprecatedPackagesInUse.forEach((artifact, packagesInUse) -> this.log(state, Level.WARNING, "JAR file '%s' imports the packages %s from '%s'. \n%s", this.filename(jar), packagesInUse, artifact.name, artifact.description));
    }

    private static enum DeprecatedProvidedBundle {
        ORG_JSON("org.json:json", "This bundle is no longer provided on Vespa 8 - see https://docs.vespa.ai/en/reference/release-notes/vespa8.html#container-runtime.", Set.of("org\\.json")),
        JETTY("jetty", "The Jetty bundles are no longer provided on Vespa 8 - see https://docs.vespa.ai/en/reference/release-notes/vespa8.html#container-runtime.", Set.of("org\\.eclipse\\.jetty.*"));

        final String name;
        final Collection<Predicate<String>> javaPackageMatchers;
        final String description;

        private DeprecatedProvidedBundle(String name, String description, Collection<String> javaPackagePatterns) {
            this.name = name;
            this.javaPackageMatchers = javaPackagePatterns.stream().map(s -> Pattern.compile(s).asMatchPredicate()).toList();
            this.description = description;
        }
    }
}

