/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin.clustercontroller;

import com.yahoo.config.model.api.Reindexing;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.search.config.QrStartConfig;
import com.yahoo.vespa.model.admin.clustercontroller.ClusterControllerContainer;
import com.yahoo.vespa.model.admin.clustercontroller.ReindexingContext;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.PlatformBundles;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;

public class ClusterControllerContainerCluster
extends ContainerCluster<ClusterControllerContainer> {
    private static final Set<Path> UNNECESSARY_BUNDLES = Set.copyOf(PlatformBundles.VESPA_SECURITY_BUNDLES);
    private final ReindexingContext reindexingContext;
    private int totalNumberOfContentNodes = 0;

    public ClusterControllerContainerCluster(TreeConfigProducer<?> parent, String subId, String name, DeployState deployState) {
        super(parent, subId, name, deployState, false);
        this.addDefaultHandlersWithVip();
        this.reindexingContext = ClusterControllerContainerCluster.createReindexingContext(deployState);
        this.setJvmGCOptions(deployState.getProperties().jvmGCOptions(Optional.of(ClusterSpec.Type.admin), Optional.of(ClusterSpec.Id.from((String)name))));
        if (this.isHostedVespa()) {
            this.addAccessLog("controller");
        }
    }

    @Override
    protected Set<Path> unnecessaryPlatformBundles() {
        return UNNECESSARY_BUNDLES;
    }

    @Override
    protected boolean messageBusEnabled() {
        return false;
    }

    @Override
    public void getConfig(QrStartConfig.Builder builder) {
        super.getConfig(builder);
        builder.jvm.heapsize(this.calculateHeapSize());
    }

    public void updateNodeCount(int nodes) {
        this.totalNumberOfContentNodes += nodes;
    }

    private int calculateHeapSize() {
        int baseValue = 128;
        if (!this.isHostedVespa) {
            return baseValue;
        }
        return Math.min(baseValue + this.calculateJvmHeapAdjustment(), 400);
    }

    private int calculateJvmHeapAdjustment() {
        int step = this.totalNumberOfContentNodes / 50;
        double adjustmentFactor = 0.75;
        int adjustment = (int)((double)step * adjustmentFactor * 50.0);
        if ((double)adjustment > 0.0) {
            log.log(Level.INFO, "Increased cluster controller max heap size memory with " + adjustment + " MiB due to having many content nodes(" + this.totalNumberOfContentNodes + ")");
        }
        return adjustment;
    }

    public ReindexingContext reindexingContext() {
        return this.reindexingContext;
    }

    private static ReindexingContext createReindexingContext(DeployState deployState) {
        return new ReindexingContext(deployState.reindexing().orElse(Reindexing.DISABLED_INSTANCE));
    }
}

