/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.TensorDataType;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.FieldSet;
import com.yahoo.schema.document.ImmutableSDField;
import com.yahoo.schema.document.Matching;
import com.yahoo.schema.document.NormalizeLevel;
import com.yahoo.schema.document.Stemming;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;

public class FieldSetSettings
extends Processor {
    private static final String fieldSetDocUrl = "https://docs.vespa.ai/en/reference/schemas/schemas.html#fieldset";

    public FieldSetSettings(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        for (FieldSet fieldSet : this.schema.fieldSets().userFieldSets().values()) {
            if (validate) {
                this.checkFieldNames(this.schema, fieldSet);
            }
            this.checkMatching(this.schema, fieldSet);
            this.checkNormalization(this.schema, fieldSet);
            this.checkStemming(this.schema, fieldSet);
            this.checkTypes(this.schema, fieldSet);
        }
    }

    private void checkFieldNames(Schema schema, FieldSet fieldSet) {
        List<String> invalidFieldNames = fieldSet.getFieldNames().stream().filter(f -> schema.getField((String)f) == null).map(f -> "'" + f + "'").toList();
        if (invalidFieldNames.isEmpty()) {
            return;
        }
        String message = "For " + String.valueOf(schema) + ": ";
        message = invalidFieldNames.size() == 1 ? message + "Field " + invalidFieldNames.get(0) + " in " + String.valueOf(fieldSet) + " does not exist." : message + "Fields " + String.join((CharSequence)",", invalidFieldNames) + " in " + String.valueOf(fieldSet) + " do not exist.";
        throw new IllegalArgumentException(message);
    }

    private void checkMatching(Schema schema, FieldSet fieldSet) {
        Matching matching = fieldSet.getMatching();
        for (String fieldName : fieldSet.getFieldNames()) {
            ImmutableSDField field = schema.getField(fieldName);
            Matching fieldMatching = field.getMatching();
            if (matching == null) {
                matching = fieldMatching;
                continue;
            }
            if (matching.equals(fieldMatching)) continue;
            StringBuilder buf = new StringBuilder();
            buf.append("For schema '").append(schema.getName()).append("': ");
            buf.append("The matching settings in ").append(fieldSet);
            buf.append(" are inconsistent (explicitly or because of field type). ");
            buf.append("This may lead to recall and ranking issues. ");
            Matching original = fieldSet.getMatching();
            if (original == null) {
                buf.append("The fieldset will use matching TEXT. ");
            } else {
                buf.append("The fieldset will use matching ").append((Object)original.getType()).append(". ");
            }
            List<String> list = fieldSet.getFieldNames().stream().map(name -> schema.getField((String)name)).filter(f -> f != null).filter(f -> f.getMatching() != null).map(f -> " Field '" + f.asField().getName() + "' has matching " + String.valueOf((Object)f.getMatching().getType())).toList();
            buf.append(list);
            buf.append(" See ").append(fieldSetDocUrl);
            this.deployLogger.logApplicationPackage(Level.WARNING, buf.toString());
            return;
        }
        fieldSet.setMatching(matching);
    }

    private void checkNormalization(Schema schema, FieldSet fieldSet) {
        NormalizeLevel.Level normalizing = null;
        for (String fieldName : fieldSet.getFieldNames()) {
            ImmutableSDField field = schema.getField(fieldName);
            NormalizeLevel.Level fieldNorm = field.getNormalizing().getLevel();
            if (normalizing == null) {
                normalizing = fieldNorm;
                continue;
            }
            if (normalizing.equals((Object)fieldNorm)) continue;
            this.warn(schema, field.asField(), "The normalization settings for the fields in " + String.valueOf(fieldSet) + " are inconsistent (explicitly or because of field type). This may lead to recall and ranking issues. See https://docs.vespa.ai/en/reference/schemas/schemas.html#fieldset");
        }
    }

    private void checkStemming(Schema schema, FieldSet fieldSet) {
        Stemming stemming = null;
        for (String fieldName : fieldSet.getFieldNames()) {
            ImmutableSDField field = schema.getField(fieldName);
            Stemming fieldStemming = field.getStemming();
            if (stemming == null) {
                stemming = fieldStemming;
                continue;
            }
            if (stemming.equals((Object)fieldStemming)) continue;
            this.warn(schema, field.asField(), "The stemming settings for the fields in the fieldset '" + fieldSet.getName() + "' are inconsistent (explicitly or because of field type). This may lead to recall and ranking issues. See https://docs.vespa.ai/en/reference/schemas/schemas.html#fieldset");
        }
    }

    private void checkTypes(Schema schema, FieldSet fieldSet) {
        LinkedList<String> tensorFields = new LinkedList<String>();
        LinkedList<String> nonTensorFields = new LinkedList<String>();
        for (String fieldName : fieldSet.getFieldNames()) {
            ImmutableSDField field = schema.getField(fieldName);
            if (field.getDataType() instanceof TensorDataType) {
                tensorFields.add(field.getName());
                continue;
            }
            nonTensorFields.add(field.getName());
        }
        if (!tensorFields.isEmpty() && !nonTensorFields.isEmpty()) {
            throw new IllegalArgumentException("For schema '" + schema.getName() + "', fieldset '" + fieldSet.getName() + "': Illegal mixing of tensor fields ['" + String.join((CharSequence)"','", tensorFields) + "'] and non-tensor fields ['" + String.join((CharSequence)"','", nonTensorFields) + "']");
        }
    }
}

