/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema;

import com.yahoo.schema.DocumentReference;
import com.yahoo.schema.document.SDDocumentType;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;

public class DocumentGraphValidator {
    public void validateDocumentGraph(List<SDDocumentType> documents) {
        for (SDDocumentType document : documents) {
            DocumentGraphValidator.validateRoot(document);
        }
    }

    private static void validateRoot(SDDocumentType root) {
        DocumentGraphValidator.validateChildren(root, root);
    }

    private static void validateChildren(SDDocumentType root, SDDocumentType currentDocument) {
        try {
            currentDocument.getDocumentReferences().get().forEach(entry -> {
                SDDocumentType referencedDocument = ((DocumentReference)entry.getValue()).targetSearch().getDocument();
                DocumentGraphValidator.validateDocument(root, referencedDocument);
            });
            currentDocument.getInheritedTypes().forEach(inheritedDocument -> {
                if (!DocumentGraphValidator.isRootDocument(inheritedDocument)) {
                    DocumentGraphValidator.validateDocument(root, inheritedDocument);
                }
            });
        }
        catch (DocumentGraphException e) {
            e.addParentDocument(currentDocument);
            throw e;
        }
    }

    private static void validateDocument(SDDocumentType root, SDDocumentType currentDocument) {
        if (root.equals(currentDocument)) {
            throw new DocumentGraphException(currentDocument);
        }
        DocumentGraphValidator.validateChildren(root, currentDocument);
    }

    private static boolean isRootDocument(SDDocumentType doc) {
        return doc.getName().equals("document");
    }

    public static class DocumentGraphException
    extends IllegalArgumentException {
        private final Deque<SDDocumentType> deque = new ArrayDeque<SDDocumentType>();

        public DocumentGraphException(SDDocumentType document) {
            this.deque.addLast(document);
        }

        public void addParentDocument(SDDocumentType document) {
            this.deque.addFirst(document);
        }

        @Override
        public String getMessage() {
            return this.deque.stream().map(SDDocumentType::getName).collect(Collectors.joining("->", "Document dependency cycle detected: ", "."));
        }
    }
}

