/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.xml;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.container.docproc.ContainerDocproc;
import java.util.Set;
import java.util.logging.Level;
import org.w3c.dom.Element;

public class DocprocOptionsBuilder {
    public static ContainerDocproc.Options build(Element spec, DeployLogger deployLogger) {
        DocprocOptionsBuilder.checkForDeprecatedAttributes(spec, Set.of("maxqueuebytesize", "numnodesperclient", "preferlocalnode"), deployLogger);
        return new ContainerDocproc.Options(DocprocOptionsBuilder.getMaxMessagesInQueue(spec), DocprocOptionsBuilder.getTime(spec.getAttribute("maxqueuewait")), DocprocOptionsBuilder.getFactor(spec.getAttribute("maxconcurrentfactor")), DocprocOptionsBuilder.getFactor(spec.getAttribute("documentexpansionfactor")), DocprocOptionsBuilder.getInt(spec.getAttribute("containercorememory")), XML.getChild((Element)spec, (String)"threadpool"));
    }

    private static Integer getInt(String integer) {
        return integer == null || integer.trim().isEmpty() ? null : Integer.valueOf(Integer.parseInt(integer));
    }

    private static Double getFactor(String factor) {
        return factor == null || factor.trim().isEmpty() ? null : Double.valueOf(Double.parseDouble(factor));
    }

    private static Integer getMaxMessagesInQueue(Element spec) {
        Integer maxMessagesInQueue = null;
        if (spec.hasAttribute("maxmessagesinqueue")) {
            maxMessagesInQueue = Integer.valueOf(spec.getAttribute("maxmessagesinqueue"));
        }
        return maxMessagesInQueue;
    }

    private static Integer getTime(String intStr) {
        if (intStr == null) {
            return null;
        }
        if ((intStr = intStr.trim()).isEmpty()) {
            return null;
        }
        return 1000 * (int)Double.parseDouble(intStr);
    }

    private static void checkForDeprecatedAttributes(Element spec, Set<String> names, DeployLogger deployLogger) {
        names.forEach(n -> {
            if (!spec.getAttribute((String)n).isEmpty()) {
                deployLogger.logApplicationPackage(Level.WARNING, "'" + n + "' is ignored, deprecated and will be removed in Vespa 9.");
            }
        });
    }
}

