/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.component;

import com.yahoo.config.ModelReference;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.embedding.huggingface.HuggingFaceEmbedderConfig;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.component.Model;
import com.yahoo.vespa.model.container.component.OnnxEmbedder;
import java.util.Set;
import org.w3c.dom.Element;

public class HuggingFaceEmbedder
extends OnnxEmbedder
implements HuggingFaceEmbedderConfig.Producer {
    private final ModelReference modelRef;
    private final ModelReference vocabRef;
    private final Integer maxTokens;
    private final String transformerInputIds;
    private final String transformerAttentionMask;
    private final String transformerTokenTypeIds;
    private final String transformerOutput;
    private final Boolean normalize;
    private final String poolingStrategy;
    private String prependQuery;
    private String prependDocument;

    public HuggingFaceEmbedder(ApplicationContainerCluster cluster, Element xml, DeployState state) {
        super("ai.vespa.embedding.HuggingFaceEmbedder", "model-integration", xml, state);
        Model model = Model.fromXml(state, xml, "transformer-model", Set.of("onnx-model")).orElseThrow();
        this.modelRef = model.modelReference();
        this.vocabRef = Model.fromXmlOrImplicitlyFromOnnxModel(state, xml, model, "tokenizer-model", Set.of("huggingface-tokenizer")).modelReference();
        this.maxTokens = XML.getChildValue((Element)xml, (String)"max-tokens").map(Integer::parseInt).orElse(null);
        this.transformerInputIds = XML.getChildValue((Element)xml, (String)"transformer-input-ids").orElse(null);
        this.transformerAttentionMask = XML.getChildValue((Element)xml, (String)"transformer-attention-mask").orElse(null);
        this.transformerTokenTypeIds = XML.getChildValue((Element)xml, (String)"transformer-token-type-ids").orElse(null);
        this.transformerOutput = XML.getChildValue((Element)xml, (String)"transformer-output").orElse(null);
        this.normalize = XML.getChildValue((Element)xml, (String)"normalize").map(Boolean::parseBoolean).orElse(null);
        this.poolingStrategy = XML.getChildValue((Element)xml, (String)"pooling-strategy").orElse(null);
        Element prepend = XML.getChild((Element)xml, (String)"prepend");
        if (prepend != null) {
            this.prependQuery = XML.getChildValue((Element)prepend, (String)"query").orElse(null);
            this.prependDocument = XML.getChildValue((Element)prepend, (String)"document").orElse(null);
        }
        model.registerOnnxModelCost(cluster, this.onnxModelOptions);
    }

    public void getConfig(HuggingFaceEmbedderConfig.Builder b) {
        b.transformerModel(this.modelRef).tokenizerPath(this.vocabRef);
        if (this.maxTokens != null) {
            b.transformerMaxTokens(this.maxTokens.intValue());
        }
        if (this.transformerInputIds != null) {
            b.transformerInputIds(this.transformerInputIds);
        }
        if (this.transformerAttentionMask != null) {
            b.transformerAttentionMask(this.transformerAttentionMask);
        }
        if (this.transformerTokenTypeIds != null) {
            b.transformerTokenTypeIds(this.transformerTokenTypeIds);
        }
        if (this.transformerOutput != null) {
            b.transformerOutput(this.transformerOutput);
        }
        if (this.normalize != null) {
            b.normalize(this.normalize.booleanValue());
        }
        if (this.poolingStrategy != null) {
            b.poolingStrategy(HuggingFaceEmbedderConfig.PoolingStrategy.Enum.valueOf((String)this.poolingStrategy));
        }
        if (this.prependQuery != null) {
            b.prependQuery(this.prependQuery);
        }
        if (this.prependDocument != null) {
            b.prependDocument(this.prependDocument);
        }
    }
}

