/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin.clustercontroller;

import com.yahoo.component.ComponentSpecification;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.config.content.FleetcontrollerConfig;
import com.yahoo.vespa.config.content.StorDistributionConfig;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import com.yahoo.vespa.model.content.cluster.ContentCluster;

public class ClusterControllerConfigurer
extends SimpleComponent
implements StorDistributionConfig.Producer,
FleetcontrollerConfig.Producer {
    private final ContentCluster cluster;
    private final int clusterControllerIndex;
    private final int nodeCount;

    public ClusterControllerConfigurer(ContentCluster cluster, int clusterControllerIndex, int nodeCount) {
        super(new ComponentModel(new BundleInstantiationSpecification(new ComponentSpecification("clustercontroller-" + cluster.getName() + "-configurer"), new ComponentSpecification("com.yahoo.vespa.clustercontroller.apps.clustercontroller.ClusterControllerClusterConfigurer"), new ComponentSpecification("clustercontroller-apps"))));
        this.cluster = cluster;
        this.clusterControllerIndex = clusterControllerIndex;
        this.nodeCount = nodeCount;
    }

    public void getConfig(StorDistributionConfig.Builder builder) {
        this.cluster.getConfig(builder);
    }

    public void getConfig(FleetcontrollerConfig.Builder builder) {
        this.cluster.getConfig(builder);
        this.cluster.getClusterControllerConfig().getConfig(builder);
        builder.index(this.clusterControllerIndex);
        builder.fleet_controller_count(this.nodeCount);
        builder.http_port(0);
        builder.rpc_port(0);
    }
}

