/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.Attribute;
import com.yahoo.schema.document.SDField;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class SingleValueOnlyAttributeValidator
extends Processor {
    public SingleValueOnlyAttributeValidator(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        for (SDField field : this.schema.allConcreteFields()) {
            Attribute attribute = field.getAttribute();
            if (attribute == null || !attribute.getType().equals((Object)Attribute.Type.BOOL) && !attribute.getType().equals((Object)Attribute.Type.RAW) || attribute.getCollectionType().equals((Object)Attribute.CollectionType.SINGLE)) continue;
            this.fail(this.schema, field, "Only single value " + attribute.getType().getName() + " attribute fields are supported");
        }
    }
}

