/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.SDDocumentType;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.HashSet;
import java.util.Set;

public class ReservedDocumentNames
extends Processor {
    private static final Set<String> RESERVED_NAMES = new HashSet<String>();

    public ReservedDocumentNames(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        if (!validate) {
            return;
        }
        String docName = this.schema.getDocument().getName();
        if (RESERVED_NAMES.contains(docName)) {
            throw new IllegalArgumentException("For " + String.valueOf(this.schema) + ": Document name '" + docName + "' is reserved.");
        }
    }

    static {
        for (SDDocumentType dataType : SDDocumentType.VESPA_DOCUMENT.getTypes()) {
            RESERVED_NAMES.add(dataType.getName());
        }
    }
}

