/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.derived.validation;

import com.yahoo.schema.Schema;
import com.yahoo.schema.derived.DerivedConfiguration;
import com.yahoo.schema.derived.IndexingScript;
import com.yahoo.schema.derived.validation.Validator;
import com.yahoo.schema.document.SDDocumentType;
import com.yahoo.vespa.indexinglanguage.ExpressionVisitor;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.OutputExpression;

public class IndexStructureValidator
extends Validator {
    public IndexStructureValidator(DerivedConfiguration config, Schema schema) {
        super(config, schema);
    }

    @Override
    public void validate() {
        IndexingScript script = this.config.getIndexingScript();
        for (Expression exp : script.expressions()) {
            new OutputVisitor(this.schema.getDocument(), exp).visit(exp);
        }
    }

    private static class OutputVisitor
    extends ExpressionVisitor {
        final SDDocumentType docType;
        final Expression exp;

        public OutputVisitor(SDDocumentType docType, Expression exp) {
            this.docType = docType;
            this.exp = exp;
        }

        protected void doVisit(Expression exp) {
            if (!(exp instanceof OutputExpression)) {
                return;
            }
            String fieldName = ((OutputExpression)exp).getFieldName();
            if (this.docType.getField(fieldName) != null) {
                return;
            }
            throw new IllegalArgumentException("Indexing expression '" + String.valueOf(this.exp) + "' refers to field '" + fieldName + "' which does not exist in the index structure.");
        }
    }
}

