/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.config.application.api.ValidationId;
import com.yahoo.config.application.api.ValidationOverrides;
import com.yahoo.config.model.api.ConfigChangeAction;
import com.yahoo.config.model.api.ValidationParameters;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.AccessControlFilterExcludeValidator;
import com.yahoo.vespa.model.application.validation.AccessControlFilterValidator;
import com.yahoo.vespa.model.application.validation.BundleValidator;
import com.yahoo.vespa.model.application.validation.CloudClientsValidator;
import com.yahoo.vespa.model.application.validation.CloudDataPlaneFilterValidator;
import com.yahoo.vespa.model.application.validation.CloudHttpConnectorValidator;
import com.yahoo.vespa.model.application.validation.CloudUserFilterValidator;
import com.yahoo.vespa.model.application.validation.ComplexFieldsWithStructFieldAttributesValidator;
import com.yahoo.vespa.model.application.validation.ComplexFieldsWithStructFieldIndexesValidator;
import com.yahoo.vespa.model.application.validation.ConstantValidator;
import com.yahoo.vespa.model.application.validation.ContainerInCloudValidator;
import com.yahoo.vespa.model.application.validation.DeploymentSpecValidator;
import com.yahoo.vespa.model.application.validation.EmbedExpressionValidator;
import com.yahoo.vespa.model.application.validation.EndpointCertificateSecretsValidator;
import com.yahoo.vespa.model.application.validation.HnswValidator;
import com.yahoo.vespa.model.application.validation.InfrastructureDeploymentValidator;
import com.yahoo.vespa.model.application.validation.JvmHeapSizeValidator;
import com.yahoo.vespa.model.application.validation.NoPrefixForIndexes;
import com.yahoo.vespa.model.application.validation.PagedAttributesRemoteStorageValidator;
import com.yahoo.vespa.model.application.validation.PublicApiBundleValidator;
import com.yahoo.vespa.model.application.validation.QuotaValidator;
import com.yahoo.vespa.model.application.validation.RankSetupValidator;
import com.yahoo.vespa.model.application.validation.RoutingValidator;
import com.yahoo.vespa.model.application.validation.SchemasDirValidator;
import com.yahoo.vespa.model.application.validation.SearchDataTypeValidator;
import com.yahoo.vespa.model.application.validation.SecretStoreValidator;
import com.yahoo.vespa.model.application.validation.StreamingValidator;
import com.yahoo.vespa.model.application.validation.TenantSecretValidator;
import com.yahoo.vespa.model.application.validation.UriBindingsValidator;
import com.yahoo.vespa.model.application.validation.UrlConfigValidator;
import com.yahoo.vespa.model.application.validation.ValidationOverridesValidator;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.application.validation.change.CertificateRemovalChangeValidator;
import com.yahoo.vespa.model.application.validation.change.ConfigValueChangeValidator;
import com.yahoo.vespa.model.application.validation.change.ContainerRestartValidator;
import com.yahoo.vespa.model.application.validation.change.ContentClusterRemovalValidator;
import com.yahoo.vespa.model.application.validation.change.ContentTypeRemovalValidator;
import com.yahoo.vespa.model.application.validation.change.DataplaneTokenRemovalValidator;
import com.yahoo.vespa.model.application.validation.change.GlobalDocumentChangeValidator;
import com.yahoo.vespa.model.application.validation.change.IndexedSearchClusterChangeValidator;
import com.yahoo.vespa.model.application.validation.change.IndexingModeChangeValidator;
import com.yahoo.vespa.model.application.validation.change.NodeResourceChangeValidator;
import com.yahoo.vespa.model.application.validation.change.ResourcesReductionValidator;
import com.yahoo.vespa.model.application.validation.change.RestartOnDeployForLocalLLMValidator;
import com.yahoo.vespa.model.application.validation.change.RestartOnDeployForOnnxModelChangesValidator;
import com.yahoo.vespa.model.application.validation.change.StartupCommandChangeValidator;
import com.yahoo.vespa.model.application.validation.change.StreamingSearchClusterChangeValidator;
import com.yahoo.vespa.model.application.validation.change.VespaRestartAction;
import com.yahoo.vespa.model.application.validation.first.RedundancyValidator;
import com.yahoo.yolean.Exceptions;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;

public class Validation {
    private final List<Validator> additionalValidators;

    public Validation() {
        this(List.of());
    }

    public Validation(List<Validator> additionalValidators) {
        this.additionalValidators = additionalValidators;
    }

    public List<ConfigChangeAction> validate(VespaModel model, ValidationParameters validationParameters, DeployState deployState) {
        Execution execution = new Execution(model, deployState);
        if (validationParameters.checkRouting()) {
            Validation.validateRouting(execution);
        }
        Validation.validateModel(validationParameters, execution);
        for (Validator validator : this.additionalValidators) {
            validator.validate(execution);
        }
        if (deployState.getProperties().isFirstTimeDeployment()) {
            Validation.validateFirstTimeDeployment(execution);
        } else if (deployState.getPreviousModel().isPresent() && deployState.getPreviousModel().get() instanceof VespaModel) {
            Validation.validateChanges(execution);
        }
        execution.throwIfFailed();
        return execution.actions;
    }

    private static void validateRouting(Execution execution) {
        new RoutingValidator().validate(execution);
    }

    private static void validateModel(ValidationParameters validationParameters, Execution execution) {
        new SchemasDirValidator().validate(execution);
        new BundleValidator().validate(execution);
        new PublicApiBundleValidator().validate(execution);
        new SearchDataTypeValidator().validate(execution);
        new ComplexFieldsWithStructFieldAttributesValidator().validate(execution);
        new ComplexFieldsWithStructFieldIndexesValidator().validate(execution);
        new StreamingValidator().validate(execution);
        new RankSetupValidator(validationParameters.ignoreValidationErrors()).validate(execution);
        new NoPrefixForIndexes().validate(execution);
        new ContainerInCloudValidator().validate(execution);
        new DeploymentSpecValidator().validate(execution);
        new ValidationOverridesValidator().validate(execution);
        new ConstantValidator().validate(execution);
        new SecretStoreValidator().validate(execution);
        new AccessControlFilterValidator().validate(execution);
        new QuotaValidator().validate(execution);
        new UriBindingsValidator().validate(execution);
        new CloudDataPlaneFilterValidator().validate(execution);
        new AccessControlFilterExcludeValidator().validate(execution);
        new CloudUserFilterValidator().validate(execution);
        new CloudHttpConnectorValidator().validate(execution);
        new UrlConfigValidator().validate(execution);
        new JvmHeapSizeValidator().validate(execution);
        new InfrastructureDeploymentValidator().validate(execution);
        new EndpointCertificateSecretsValidator().validate(execution);
        new CloudClientsValidator().validate(execution);
        new PagedAttributesRemoteStorageValidator().validate(execution);
        new TenantSecretValidator().validate(execution);
        new HnswValidator().validate(execution);
        new EmbedExpressionValidator().validate(execution);
    }

    private static void validateFirstTimeDeployment(Execution execution) {
        new RedundancyValidator().validate((Context)execution);
    }

    private static void validateChanges(Execution execution) {
        new IndexingModeChangeValidator().validate(execution);
        new GlobalDocumentChangeValidator().validate(execution);
        new IndexedSearchClusterChangeValidator().validate(execution);
        new StreamingSearchClusterChangeValidator().validate(execution);
        new ConfigValueChangeValidator().validate(execution);
        new StartupCommandChangeValidator().validate(execution);
        new ContentTypeRemovalValidator().validate(execution);
        new ContentClusterRemovalValidator().validate(execution);
        new ResourcesReductionValidator().validate(execution);
        new ContainerRestartValidator().validate(execution);
        new NodeResourceChangeValidator().validate(execution);
        new CertificateRemovalChangeValidator().validate(execution);
        new RedundancyValidator().validate(execution);
        new RestartOnDeployForOnnxModelChangesValidator().validate(execution);
        new RestartOnDeployForLocalLLMValidator().validate(execution);
        new DataplaneTokenRemovalValidator().validate(execution);
    }

    static class Execution
    implements ChangeContext {
        private final List<String> errors = new ArrayList<String>();
        private final Map<ValidationId, List<String>> failures = new LinkedHashMap<ValidationId, List<String>>();
        private final VespaModel model;
        private final DeployState deployState;
        private final List<ConfigChangeAction> actions = new ArrayList<ConfigChangeAction>();

        Execution(VespaModel model, DeployState deployState) {
            this.model = model;
            this.deployState = deployState;
        }

        void throwIfFailed() {
            Optional<ValidationOverrides.ValidationException> invalidException = this.deployState.validationOverrides().invalidException(this.failures, this.deployState.now());
            if (invalidException.isPresent() && this.deployState.isHosted() && this.deployState.zone().environment().isManuallyDeployed()) {
                this.deployState.getDeployLogger().logApplicationPackage(Level.WARNING, "Auto-overriding validation which would be disallowed in production: " + Exceptions.toMessageString((Throwable)((Throwable)invalidException.get())));
                invalidException = Optional.empty();
            }
            if (!this.errors.isEmpty()) {
                Object illegalMessage;
                Object object = illegalMessage = this.errors.size() == 1 ? this.errors.get(0) : "multiple errors:\n\t" + String.join((CharSequence)"\n\t", this.errors);
                if (invalidException.isPresent()) {
                    illegalMessage = (String)illegalMessage + "\n" + ((ValidationOverrides.ValidationException)invalidException.get()).getMessage();
                }
                throw new IllegalArgumentException((String)illegalMessage);
            }
            invalidException.ifPresent(e -> {
                throw e;
            });
        }

        List<ConfigChangeAction> actions() {
            return this.actions;
        }

        List<String> errors() {
            return this.errors;
        }

        @Override
        public DeployState deployState() {
            return this.deployState;
        }

        @Override
        public VespaModel model() {
            return this.model;
        }

        @Override
        public VespaModel previousModel() {
            return (VespaModel)this.deployState.getPreviousModel().get();
        }

        @Override
        public void require(ConfigChangeAction action) {
            if (action instanceof VespaRestartAction && action.getServices().isEmpty()) {
                throw new IllegalStateException("restart actions must have services specified");
            }
            this.actions.add(action);
            action.validationId().ifPresent(id -> this.invalid((ValidationId)id, action.getMessage()));
        }

        @Override
        public void illegal(String message, Throwable cause) {
            if (cause != null) {
                message = (String)message + ": " + Exceptions.toMessageString((Throwable)cause);
            }
            this.errors.add((String)message);
        }

        @Override
        public void invalid(ValidationId id, String message) {
            this.failures.computeIfAbsent(id, __ -> new ArrayList()).add(message);
        }
    }

    public static interface Context {
        public DeployState deployState();

        public VespaModel model();

        default public void illegal(String message) {
            this.illegal(message, null);
        }

        public void illegal(String var1, Throwable var2);

        public void invalid(ValidationId var1, String var2);
    }

    public static interface ChangeContext
    extends Context {
        public VespaModel previousModel();

        public void require(ConfigChangeAction var1);
    }
}

