/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.component;

import com.yahoo.config.ModelReference;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.language.huggingface.config.HuggingFaceTokenizerConfig;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.container.component.Model;
import com.yahoo.vespa.model.container.component.TypedComponent;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.w3c.dom.Element;

public class HuggingFaceTokenizer
extends TypedComponent
implements HuggingFaceTokenizerConfig.Producer {
    private final Map<String, ModelReference> langToModel = new TreeMap<String, ModelReference>();

    public HuggingFaceTokenizer(Element xml, DeployState state) {
        super("com.yahoo.language.huggingface.HuggingFaceTokenizer", "linguistics-components", xml);
        for (Element element : XML.getChildren((Element)xml, (String)"model")) {
            String lang = element.hasAttribute("language") ? element.getAttribute("language") : "unknown";
            this.langToModel.put(lang, Model.fromXml(state, element, Set.of("huggingface-tokenizer")).modelReference());
        }
    }

    public void getConfig(HuggingFaceTokenizerConfig.Builder builder) {
        this.langToModel.forEach((lang, vocab) -> builder.model.add(new HuggingFaceTokenizerConfig.Model.Builder().language(lang).path(vocab)));
        builder.truncation(HuggingFaceTokenizerConfig.Truncation.Enum.OFF).padding(HuggingFaceTokenizerConfig.Padding.Enum.OFF).addSpecialTokens(false);
    }
}

