/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model;

import com.yahoo.vespa.defaults.Defaults;

public class MallocImplResolver {
    public static String resolvePath(Impl impl) {
        return switch (impl) {
            default -> throw new IncompatibleClassChangeError();
            case Impl.vespamalloc -> MallocImplResolver.resolveVespaMallocPath();
            case Impl.mimalloc -> MallocImplResolver.resolveMimallocPath();
        };
    }

    private static String resolveMimallocPath() {
        return "/opt/vespa-deps/lib64/libmimalloc.so";
    }

    private static String resolveVespaMallocPath() {
        return Defaults.getDefaults().underVespaHome("lib64/vespa/malloc/libvespamalloc.so");
    }

    public static enum Impl {
        vespamalloc,
        mimalloc;

    }
}

