/* SchemaParser.java */
/* Generated by: ParserGeneratorCC: Do not edit this line. SchemaParser.java */
package com.yahoo.schema.parser;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.language.Linguistics;
import com.yahoo.language.process.Chunker;
import com.yahoo.language.process.Embedder;
import com.yahoo.language.process.FieldGenerator;
import com.yahoo.language.simple.SimpleLinguistics;
import com.yahoo.search.query.ranking.Diversity;
import com.yahoo.schema.DistributableResource;
import com.yahoo.schema.ElementGap;
import com.yahoo.schema.OnnxModel;
import com.yahoo.schema.RankProfile.DiversitySettings;
import com.yahoo.schema.RankProfile.MatchPhaseSettings;
import com.yahoo.schema.RankProfile;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.Case;
import com.yahoo.schema.document.MatchType;
import com.yahoo.schema.document.MatchAlgorithm;
import com.yahoo.schema.document.HnswIndexParams;
import com.yahoo.schema.document.Sorting;
import com.yahoo.schema.document.Stemming;
import com.yahoo.searchlib.ranking.features.FeatureNames;
import com.yahoo.schema.fieldoperation.IndexingOperation;
import com.yahoo.search.schema.RankProfile.InputType;
import com.yahoo.searchlib.rankingexpression.FeatureList;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.IndexedTensor;
import com.yahoo.tensor.MixedTensor;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.TensorAddress;

import java.util.Optional;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import java.util.logging.Level;

/**
 * The schema parser
 *
 * NOTE: When this grammar is changed, also change integration/intellij/src/main/bnf/ai/vespa/intellij/schema/parser/sd.bnf
 *
 * @author bratseth
 */
public class SchemaParser implements SchemaParserConstants {

    private DeployLogger deployLogger;
    private ModelContext.Properties properties;

    /** Creates a parser. */
    public SchemaParser(SimpleCharStream stream, DeployLogger deployLogger) {
        this(stream);
        this.deployLogger = deployLogger;
        this.properties = properties;
    }

    /**
     * Consumes an indexing language script which will use the simple linguistics implementation
     * for testing, by taking input from the current input stream.
     *
     * @param multiline Whether or not to allow multi-line expressions.
     */
    @SuppressWarnings("deprecation")
    private IndexingOperation newIndexingOperation(boolean multiline) throws ParseException {
        return newIndexingOperation(multiline, new SimpleLinguistics(), Chunker.throwsOnUse.asMap(), Embedder.throwsOnUse.asMap(), FieldGenerator.throwsOnUse.asMap());
    }

    /**
     * Consumes an indexing language script from the current input stream.
     *
     * @param multiline whether to allow multi-line expressions
     * @param linguistics what to use for tokenizing
     */
    private IndexingOperation newIndexingOperation(boolean multiline, Linguistics linguistics, Map<String, Chunker> chunkers, Map<String, Embedder> embedders, Map<String, FieldGenerator> generators) throws ParseException {
        SimpleCharStream input = (SimpleCharStream)token_source.input_stream;
        if (token.next != null) {
            input.backup(token.next.image.length());
        }
        try {
            return IndexingOperation.fromStream(input, multiline, linguistics, chunkers, embedders, generators);
        } finally {
            token.next = null;
            jj_ntk = -1;
        }
    }

    /**
     * Parses the given token image as a ranking expression feature list.
     *
     * @param image The token image to parse.
     * @return The consumed feature list.
     * @throws ParseException Thrown if the image could not be parsed.
     */
    private FeatureList getFeatureList(String image) throws ParseException {
        try {
            return new FeatureList(image);
        }
        catch (com.yahoo.searchlib.rankingexpression.parser.ParseException e) {
            throw (ParseException) new ParseException("Could not parse feature list '" + image + "' at line " +
                                                      token_source.input_stream.getBeginLine() + ", column " +
                                                      token_source.input_stream.getBeginColumn() + ".").initCause(e);
        }
    }

// --------------------------------------------------------------------------------
//
// Production rules.
//
// --------------------------------------------------------------------------------

/**
 * The rule consumes any schema and returns the corresponding object. This is the only production that should
 * ever consume leading newlines.
 *
 * @return the schema object
 */
  final public ParsedSchema schema() throws ParseException {ParsedSchema schema;
    label_1:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NL:{
        break;
        }
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      jj_consume_token(NL);
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case SCHEMA:
    case SEARCH:{
      schema = rootSchema();
      break;
      }
    case 0:
    case DOCUMENT:{
      schema = rootDocument();
      break;
      }
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return schema;}
    throw new IllegalStateException ("Missing return statement in function");
}

/**
 * This rule consumes a proper schema block. This and rootDocument() are the only rules that should ever consume
 * trailing newline tokens.
 *
 * @return the schema definition object.
 */
  final public ParsedSchema rootSchema() throws ParseException {String name;
    String inherited = null;
    ParsedSchema schema;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case SCHEMA:{
      jj_consume_token(SCHEMA);
      break;
      }
    case SEARCH:{
      jj_consume_token(SEARCH);
      break;
      }
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    name = identifier();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case INHERITS:{
      jj_consume_token(INHERITS);
      inherited = identifier();
      break;
      }
    default:
      jj_la1[3] = jj_gen;
      ;
    }
schema = new ParsedSchema(name);
        if (inherited != null) schema.inherit(inherited);
    lbrace();
    label_2:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ANNOTATION:
      case DOCUMENT:
      case STRUCT:
      case FIELD:
      case FIELDSET:
      case IMPORT:
      case DOCUMENT_SUMMARY:
      case INDEX:
      case CONSTANT:
      case ONNX_MODEL:
      case MODEL:
      case RANK_PROFILE:
      case RAW_AS_BASE64_IN_SUMMARY:
      case STEMMING:{
        break;
        }
      default:
        jj_la1[4] = jj_gen;
        break label_2;
      }
      rootSchemaItem(schema);
      label_3:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NL:{
          break;
          }
        default:
          jj_la1[5] = jj_gen;
          break label_3;
        }
        jj_consume_token(NL);
      }
    }
    jj_consume_token(RBRACE);
    label_4:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NL:{
        break;
        }
      default:
        jj_la1[6] = jj_gen;
        break label_4;
      }
      jj_consume_token(NL);
    }
    jj_consume_token(0);
{if ("" != null) return schema;}
    throw new IllegalStateException ("Missing return statement in function");
}

/**
 * Consumes an element of a schema block. This and rootSearch() are the only rules that should ever consume
 * trailing newline tokens.
 *
 * @param schema the schema object to modify.
 */
  final public void rootSchemaItem(ParsedSchema schema) throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DOCUMENT:{
      document(schema);
      break;
      }
    case RAW_AS_BASE64_IN_SUMMARY:{
      rawAsBase64(schema);
      break;
      }
    case STEMMING:{
      searchStemming(schema);
      break;
      }
    case IMPORT:{
      importField(schema);
      break;
      }
    case CONSTANT:{
      rankingConstant(schema);
      break;
      }
    case MODEL:
    case RANK_PROFILE:{
      rankProfile(schema);
      break;
      }
    case DOCUMENT_SUMMARY:{
      documentSummary(schema);
      break;
      }
    case FIELD:{
      fieldOutsideDoc(schema);
      break;
      }
    case INDEX:{
      indexOutsideDoc(schema);
      break;
      }
    case STRUCT:{
      structOutside(schema);
      break;
      }
    case ANNOTATION:{
      annotationOutside(schema);
      break;
      }
    case FIELDSET:{
      fieldSet(schema);
      break;
      }
    case ONNX_MODEL:{
      onnxModelInSchema(schema);
      break;
      }
    default:
      jj_la1[7] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

/**
 * Consumes a schema definition that contains only documents to be used for inheritance, etc.
 *
 * @return the schema definition object.
 */
  final public ParsedSchema rootDocument() throws ParseException {ParsedSchema schema = null;
    label_5:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DOCUMENT:{
        break;
        }
      default:
        jj_la1[8] = jj_gen;
        break label_5;
      }
      schema = rootDocumentItem(schema);
      label_6:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NL:{
          break;
          }
        default:
          jj_la1[9] = jj_gen;
          break label_6;
        }
        jj_consume_token(NL);
      }
    }
    jj_consume_token(0);
{if ("" != null) return schema;}
    throw new IllegalStateException ("Missing return statement in function");
}

/**
 * Consumes a single item from within a root document node.
 *
 * @param schema the schema object to modify.
 */
  final public ParsedSchema rootDocumentItem(ParsedSchema schema) throws ParseException {ParsedDocument doc = null;
    doc = namedDocument();
if (schema == null) schema = new ParsedSchema(doc.name());
        schema.addDocument(doc);
        schema.setDocumentWithoutSchema();
        {if ("" != null) return schema;}
    throw new IllegalStateException ("Missing return statement in function");
}

/**
 * Consumes a document element. The name defaults to the schema's name, but may be set.
 *
 * @param schema the schema object to add content to.
 */
  final public void document(ParsedSchema schema) throws ParseException {String name = schema.name();
    ParsedDocument document;
    jj_consume_token(DOCUMENT);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ANNOTATION:
    case ANNOTATIONREFERENCE:
    case SCHEMA:
    case SEARCH:
    case DIVERSITY:
    case LOOSE:
    case STRICT:
    case DOCUMENT:
    case OPERATION:
    case STRUCT:
    case INHERITS:
    case FIELD:
    case FIELDS:
    case FIELDSET:
    case IMPORT:
    case AS:
    case INDEXING:
    case INFINITY:
    case WEIGHT:
    case TYPE:
    case INDEX:
    case INPUTS:
    case MTOKEN:
    case TEXT:
    case WORD:
    case GRAM:
    case PREFIX:
    case SUBSTRING:
    case SUFFIX:
    case CONSTANT:
    case SIGNIFICANCE:
    case WEAKAND:
    case PARALLEL:
    case SEQUENTIAL:
    case MODEL:
    case MUTATE:
    case QUERY:
    case SUMMARY:
    case FULL:
    case STATIC:
    case DYNAMIC:
    case TOKENS:
    case SSCONTEXTUAL:
    case SSOVERRIDE:
    case SSTITLE:
    case SSURL:
    case PROPERTIES:
    case ATTRIBUTE:
    case SORTING:
    case DICTIONARY:
    case ASCENDING:
    case DESCENDING:
    case UCA:
    case RAW:
    case LOWERCASE:
    case FUNCTION:
    case LOCALE:
    case STRENGTH:
    case PRIMARY:
    case SECONDARY:
    case TERTIARY:
    case QUATERNARY:
    case IDENTICAL:
    case STEMMING:
    case NORMALIZING:
    case HASH:
    case BTREE:
    case CASED:
    case UNCASED:
    case BOLDING:
    case NONE:
    case ON:
    case OFF:
    case TRUE:
    case FALSE:
    case SYMMETRIC:
    case ALIAS:
    case MATCH:
    case RANK:
    case LITERAL:
    case EXACT:
    case FILTER:
    case NORMAL:
    case ID:
    case SOURCE:
    case TO:
    case DIRECT:
    case ALWAYS:
    case NEVER:
    case MUTABLE:
    case PAGED:
    case ARRAY:
    case WEIGHTEDSET:
    case MAP:
    case REFERENCE:
    case ORDER:
    case MACRO:
    case INLINE:
    case ARITY:
    case HNSW:
    case DOUBLE_KEYWORD:
    case FLOAT_KEYWORD:
    case LONG_KEYWORD:
    case STRING_KEYWORD:
    case CONSTANTS:
    case FILE:
    case URI:
    case IDENTIFIER:
    case CONTEXT:
    case INTEGER:
    case LONG:
    case STRING:
    case VARIABLE:{
      name = identifier();
      break;
      }
    default:
      jj_la1[10] = jj_gen;
      ;
    }
    label_7:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NL:{
        break;
        }
      default:
        jj_la1[11] = jj_gen;
        break label_7;
      }
      jj_consume_token(NL);
    }
document = new ParsedDocument(name);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case INHERITS:{
      inheritsDocument(document);
      label_8:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NL:{
          break;
          }
        default:
          jj_la1[12] = jj_gen;
          break label_8;
        }
        jj_consume_token(NL);
      }
      break;
      }
    default:
      jj_la1[13] = jj_gen;
      ;
    }
    jj_consume_token(LBRACE);
    label_9:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NL:{
        break;
        }
      default:
        jj_la1[14] = jj_gen;
        break label_9;
      }
      jj_consume_token(NL);
    }
    label_10:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ANNOTATION:
      case STRUCT:
      case FIELD:{
        break;
        }
      default:
        jj_la1[15] = jj_gen;
        break label_10;
      }
      documentBody(document);
      label_11:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NL:{
          break;
          }
        default:
          jj_la1[16] = jj_gen;
          break label_11;
        }
        jj_consume_token(NL);
      }
    }
    jj_consume_token(RBRACE);
schema.addDocument(document);
}

/**
 * Consumes a document element, explicitly named
 */
  final public ParsedDocument namedDocument() throws ParseException {String name;
    ParsedDocument document;
    jj_consume_token(DOCUMENT);
    name = identifier();
    label_12:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NL:{
        break;
        }
      default:
        jj_la1[17] = jj_gen;
        break label_12;
      }
      jj_consume_token(NL);
    }
document = new ParsedDocument(name);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case INHERITS:{
      inheritsDocument(document);
      label_13:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NL:{
          break;
          }
        default:
          jj_la1[18] = jj_gen;
          break label_13;
        }
        jj_consume_token(NL);
      }
      break;
      }
    default:
      jj_la1[19] = jj_gen;
      ;
    }
    jj_consume_token(LBRACE);
    label_14:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NL:{
        break;
        }
      default:
        jj_la1[20] = jj_gen;
        break label_14;
      }
      jj_consume_token(NL);
    }
    label_15:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ANNOTATION:
      case STRUCT:
      case FIELD:{
        break;
        }
      default:
        jj_la1[21] = jj_gen;
        break label_15;
      }
      documentBody(document);
      label_16:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NL:{
          break;
          }
        default:
          jj_la1[22] = jj_gen;
          break label_16;
        }
        jj_consume_token(NL);
      }
    }
    jj_consume_token(RBRACE);
{if ("" != null) return document;}
    throw new IllegalStateException ("Missing return statement in function");
}

/**
 * Consumes a document body block
 *
 * @param document the document type to modify.
 */
  final public void documentBody(ParsedDocument document) throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ANNOTATION:{
      annotation(document);
      break;
      }
    case STRUCT:{
      structInside(document);
      break;
      }
    case FIELD:{
      fieldInsideDoc(document);
      break;
      }
    default:
      jj_la1[23] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void rawAsBase64(ParsedSchema schema) throws ParseException {boolean enabled = false;
    jj_consume_token(RAW_AS_BASE64_IN_SUMMARY);
enabled = true;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case TRUE:{
        jj_consume_token(TRUE);
        break;
        }
      case FALSE:{
        jj_consume_token(FALSE);
enabled = false;
        break;
        }
      default:
        jj_la1[24] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[25] = jj_gen;
      ;
    }
schema.enableRawAsBase64(enabled);
}

/**
 * Consumes struct inheritance
 *
 * @param struct The struct type to modify.
 */
  final public void inheritsStruct(ParsedStruct struct) throws ParseException {String name;
    jj_consume_token(INHERITS);
    name = identifier();
struct.inherit(name);
    label_17:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[26] = jj_gen;
        break label_17;
      }
      jj_consume_token(COMMA);
      name = identifier();
struct.inherit(name);
    }
}

/**
 * Consumes a document inheritance statement.
 *
 * @param document The document type to modify.
 */
  final public void inheritsDocument(ParsedDocument document) throws ParseException {String name;
    jj_consume_token(INHERITS);
    name = identifier();
document.inherit(name);
    label_18:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[27] = jj_gen;
        break label_18;
      }
      jj_consume_token(COMMA);
      name = identifier();
document.inherit(name);
    }
}

/**
 * Consumes a field block from within a document element.
 *
 * @param document the document type to modify
 */
  final public void fieldInsideDoc(ParsedDocument document) throws ParseException {ParsedField field;
    field = field();
document.addField(field);
}

/**
 * Consumes a field block from outside a document element.
 *
 * @param schema the schema to modify
 */
  final public void fieldOutsideDoc(ParsedSchema schema) throws ParseException {ParsedField field;
    field = field();
schema.addField(field);
}

/**
 * Consumes a field block
 */
  final public ParsedField field() throws ParseException {String name;
    ParsedField field;
    ParsedType type;
    jj_consume_token(FIELD);
    name = identifier();
    jj_consume_token(TYPE);
    type = dataType();
if (name != null && Schema.isReservedName(name.toLowerCase())) {
            throw new IllegalArgumentException("Reserved name '" + name + "' can not be used as a field name.");
        }
        field = new ParsedField(name, type);
    lbrace();
    label_19:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case STRUCT_FIELD:
      case INDEXING:
      case SUMMARY_TO:
      case RANK_TYPE:
      case WEIGHT:
      case INDEX:
      case SUMMARY:
      case ATTRIBUTE:
      case SORTING:
      case DICTIONARY:
      case STEMMING:
      case NORMALIZING:
      case BOLDING:
      case QUERY_COMMAND:
      case ALIAS:
      case MATCH:
      case RANK:
      case ID:
      case WEIGHTEDSET:{
        break;
        }
      default:
        jj_la1[28] = jj_gen;
        break label_19;
      }
      fieldBody(field);
      label_20:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NL:{
          break;
          }
        default:
          jj_la1[29] = jj_gen;
          break label_20;
        }
        jj_consume_token(NL);
      }
    }
    jj_consume_token(RBRACE);
{if ("" != null) return field;}
    throw new IllegalStateException ("Missing return statement in function");
}

/** Consumes a fieldset block */
  final public void fieldSet(ParsedSchema schema) throws ParseException {String name;
  String queryCommand;
  ParsedMatchSettings matchInfo;
  ParsedFieldSet fieldSet;
    jj_consume_token(FIELDSET);
    name = identifier();
    lbrace();
fieldSet = new ParsedFieldSet(name);
    label_21:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case FIELDS:{
        jj_consume_token(FIELDS);
        jj_consume_token(COLON);
        name = identifier();
fieldSet.addField(name);
        label_22:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case COMMA:{
            break;
            }
          default:
            jj_la1[30] = jj_gen;
            break label_22;
          }
          jj_consume_token(COMMA);
          name = identifier();
fieldSet.addField(name);
        }
        break;
        }
      case QUERY_COMMAND:{
        jj_consume_token(QUERY_COMMAND);
        jj_consume_token(COLON);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ANNOTATION:
        case ANNOTATIONREFERENCE:
        case SCHEMA:
        case SEARCH:
        case DIVERSITY:
        case MIN_GROUPS:
        case CUTOFF_FACTOR:
        case CUTOFF_STRATEGY:
        case LOOSE:
        case STRICT:
        case DOCUMENT:
        case OPERATION:
        case ON_MATCH:
        case ON_FIRST_PHASE:
        case ON_SECOND_PHASE:
        case ON_SUMMARY:
        case STRUCT:
        case INHERITS:
        case FIELD:
        case FIELDS:
        case FIELDSET:
        case STRUCT_FIELD:
        case IMPORT:
        case AS:
        case INDEXING:
        case SUMMARY_TO:
        case DOCUMENT_SUMMARY:
        case ELEMENT_GAP:
        case INFINITY:
        case RANK_TYPE:
        case WEIGHT:
        case TYPE:
        case INDEX:
        case INPUTS:
        case MTOKEN:
        case TEXT:
        case WORD:
        case GRAM:
        case GRAM_SIZE:
        case MAX_LENGTH:
        case PREFIX:
        case SUBSTRING:
        case SUFFIX:
        case CONSTANT:
        case ONNX_MODEL:
        case SIGNIFICANCE:
        case USE_MODEL:
        case WEAKAND:
        case STOPWORD_LIMIT:
        case ALLOW_DROP_ALL:
        case ADJUST_TARGET:
        case FILTER_THRESHOLD:
        case INTRAOP_THREADS:
        case INTEROP_THREADS:
        case GPU_DEVICE:
        case EXECUTION_MODE:
        case PARALLEL:
        case SEQUENTIAL:
        case MODEL:
        case MUTATE:
        case QUERY:
        case RANK_PROFILE:
        case RAW_AS_BASE64_IN_SUMMARY:
        case SUMMARY:
        case FULL:
        case STATIC:
        case DYNAMIC:
        case TOKENS:
        case MATCHED_ELEMENTS_ONLY:
        case SSCONTEXTUAL:
        case SSOVERRIDE:
        case SSTITLE:
        case SSURL:
        case PROPERTIES:
        case ATTRIBUTE:
        case SORTING:
        case DICTIONARY:
        case ASCENDING:
        case DESCENDING:
        case UCA:
        case RAW:
        case LOWERCASE:
        case FUNCTION:
        case LOCALE:
        case STRENGTH:
        case PRIMARY:
        case SECONDARY:
        case TERTIARY:
        case QUATERNARY:
        case IDENTICAL:
        case STEMMING:
        case NORMALIZING:
        case HASH:
        case BTREE:
        case CASED:
        case UNCASED:
        case BOLDING:
        case NONE:
        case ON:
        case OFF:
        case TRUE:
        case FALSE:
        case SYMMETRIC:
        case QUERY_COMMAND:
        case ALIAS:
        case MATCH:
        case RANK:
        case LITERAL:
        case EXACT:
        case FILTER:
        case NORMAL:
        case EXACT_TERMINATOR:
        case IGNORE_DEFAULT_RANK_FEATURES:
        case ID:
        case SOURCE:
        case TO:
        case DIRECT:
        case FROM_DISK:
        case OMIT_SUMMARY_FEATURES:
        case ALWAYS:
        case ON_DEMAND:
        case NEVER:
        case ENABLE_BIT_VECTORS:
        case ENABLE_ONLY_BIT_VECTOR:
        case FAST_ACCESS:
        case MUTABLE:
        case PAGED:
        case FAST_RANK:
        case FAST_SEARCH:
        case ARRAY:
        case WEIGHTEDSET:
        case MAP:
        case REFERENCE:
        case CREATE_IF_NONEXISTENT:
        case REMOVE_IF_ZERO:
        case MATCH_PHASE:
        case EVALUATION_POINT:
        case PRE_POST_FILTER_TIPPING_POINT:
        case ORDER:
        case MAX_FILTER_COVERAGE:
        case MAX_HITS:
        case FIRST_PHASE:
        case SECOND_PHASE:
        case GLOBAL_PHASE:
        case MACRO:
        case INLINE:
        case ARITY:
        case LOWER_BOUND:
        case UPPER_BOUND:
        case DENSE_POSTING_LIST_THRESHOLD:
        case ENABLE_BM25:
        case HNSW:
        case MAX_LINKS_PER_NODE:
        case DOUBLE_KEYWORD:
        case FLOAT_KEYWORD:
        case LONG_KEYWORD:
        case STRING_KEYWORD:
        case DISTANCE_METRIC:
        case NEIGHBORS_TO_EXPLORE_AT_INSERT:
        case MULTI_THREADED_INDEXING:
        case RANK_PROPERTIES:
        case RERANK_COUNT:
        case NUM_THREADS_PER_SEARCH:
        case MIN_HITS_PER_THREAD:
        case NUM_SEARCH_PARTITIONS:
        case TERMWISE_LIMIT:
        case POST_FILTER_THRESHOLD:
        case APPROXIMATE_THRESHOLD:
        case FILTER_FIRST_THRESHOLD:
        case FILTER_FIRST_EXPLORATION:
        case EXPLORATION_SLACK:
        case TARGET_HITS_MAX_ADJUSTMENT_FACTOR:
        case KEEP_RANK_COUNT:
        case RANK_SCORE_DROP_LIMIT:
        case CONSTANTS:
        case FILE:
        case URI:
        case IDENTIFIER:
        case IDENTIFIER_WITH_DASH:
        case CONTEXT:
        case INTEGER:
        case LONG:
        case STRING:
        case VARIABLE:{
          queryCommand = identifierWithDash();
          break;
          }
        case DOUBLEQUOTEDSTRING:
        case SINGLEQUOTEDSTRING:{
          queryCommand = quotedString();
          break;
          }
        default:
          jj_la1[31] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
fieldSet.addQueryCommand(queryCommand);
        break;
        }
      case MATCH:{
        matchSettings(fieldSet.matchSettings());
        break;
        }
      default:
        jj_la1[32] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_23:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NL:{
          break;
          }
        default:
          jj_la1[33] = jj_gen;
          break label_23;
        }
        jj_consume_token(NL);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case FIELDS:
      case QUERY_COMMAND:
      case MATCH:{
        break;
        }
      default:
        jj_la1[34] = jj_gen;
        break label_21;
      }
    }
    jj_consume_token(RBRACE);
schema.addFieldSet(fieldSet);
}

/**
 * This rule consumes a annotation block from within a schema element.
 *
 * @param schema the schema object to add content to
 */
  final public void annotationOutside(ParsedSchema schema) throws ParseException {String name;
    ParsedAnnotation type;
    jj_consume_token(ANNOTATION);
    name = identifier();
type = new ParsedAnnotation(name);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case INHERITS:{
      inheritsAnnotation(type);
      label_24:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NL:{
          break;
          }
        default:
          jj_la1[35] = jj_gen;
          break label_24;
        }
        jj_consume_token(NL);
      }
      break;
      }
    default:
      jj_la1[36] = jj_gen;
      ;
    }
    lbrace();
    annotationBody(type);
    jj_consume_token(RBRACE);
schema.addAnnotation(type);
}

/**
 * Consumes an annotation block from within a document element
 *
 * @param document the document object to add content to
 */
  final public void annotation(ParsedDocument document) throws ParseException {String name;
    ParsedAnnotation type;
    jj_consume_token(ANNOTATION);
    name = identifier();
type = new ParsedAnnotation(name);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case INHERITS:{
      inheritsAnnotation(type);
      label_25:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NL:{
          break;
          }
        default:
          jj_la1[37] = jj_gen;
          break label_25;
        }
        jj_consume_token(NL);
      }
      break;
      }
    default:
      jj_la1[38] = jj_gen;
      ;
    }
    lbrace();
    annotationBody(type);
    jj_consume_token(RBRACE);
document.addAnnotation(type);
}

/**
 * Consumes a single element of an annotation body block.
 */
  final public void annotationBody(ParsedAnnotation type) throws ParseException {ParsedStruct struct = new ParsedStruct("annotation." + type.name());
    boolean seenField = false;
    label_26:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case FIELD:{
        break;
        }
      default:
        jj_la1[39] = jj_gen;
        break label_26;
      }
      structFieldDefinition(struct);
seenField = true;
      label_27:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NL:{
          break;
          }
        default:
          jj_la1[40] = jj_gen;
          break label_27;
        }
        jj_consume_token(NL);
      }
    }
if (seenField) type.setStruct(struct);
}

  final public void inheritsAnnotation(ParsedAnnotation annotation) throws ParseException {String name;
    jj_consume_token(INHERITS);
    name = identifier();
annotation.inherit(name);
}

/**
 * This rule consumes a struct block from within a document element.
 * @param document the document object to add content to
 */
  final public void structInside(ParsedDocument document) throws ParseException {ParsedStruct struct;
    struct = structDefinition();
document.addStruct(struct);
}

/**
 * This rule consumes a struct block from within a schema element.
 * @param schema the schema object to add content to
 */
  final public void structOutside(ParsedSchema schema) throws ParseException {ParsedStruct struct;
    struct = structDefinition();
schema.addStruct(struct);
}

/**
 * This rule consumes a struct declaration block
 */
  final public ParsedStruct structDefinition() throws ParseException {String name;
    String inherited;
    ParsedStruct struct;
    jj_consume_token(STRUCT);
    name = identifier();
    label_28:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NL:{
        break;
        }
      default:
        jj_la1[41] = jj_gen;
        break label_28;
      }
      jj_consume_token(NL);
    }
struct = new ParsedStruct(name);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case INHERITS:{
      inheritsStruct(struct);
      label_29:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NL:{
          break;
          }
        default:
          jj_la1[42] = jj_gen;
          break label_29;
        }
        jj_consume_token(NL);
      }
      break;
      }
    default:
      jj_la1[43] = jj_gen;
      ;
    }
    lbrace();
    label_30:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case FIELD:{
        break;
        }
      default:
        jj_la1[44] = jj_gen;
        break label_30;
      }
      structFieldDefinition(struct);
      label_31:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NL:{
          break;
          }
        default:
          jj_la1[45] = jj_gen;
          break label_31;
        }
        jj_consume_token(NL);
      }
    }
    jj_consume_token(RBRACE);
{if ("" != null) return struct;}
    throw new IllegalStateException ("Missing return statement in function");
}

/**
 * This rule consumes a data type block from within a field element.
 *
 * @return the consumed data type
 */
  final public ParsedType dataType() throws ParseException {String typeName = null;
    boolean isArrayOldStyle = false;
    ParsedType mapType = null;
    ParsedType arrayType = null;
    ParsedType wsetType = null;
    TensorType tensorType;
    ParsedType referenceType;
    if (jj_2_1(2147483647)) {
      jj_consume_token(ARRAY);
      jj_consume_token(LESSTHAN);
      arrayType = dataType();
      jj_consume_token(GREATERTHAN);
{if ("" != null) return ParsedType.arrayOf(arrayType);}
    } else if (jj_2_2(2147483647)) {
      jj_consume_token(WEIGHTEDSET);
      jj_consume_token(LESSTHAN);
      wsetType = dataType();
      jj_consume_token(GREATERTHAN);
{if ("" != null) return ParsedType.wsetOf(wsetType);}
    } else if (jj_2_3(2147483647)) {
      mapType = mapDataType();
{if ("" != null) return mapType;}
    } else if (jj_2_4(2147483647)) {
      mapType = annotationRefDataType();
{if ("" != null) return mapType;}
    } else if (jj_2_5(2147483647)) {
      tensorType = tensorType("Field type");
{if ("" != null) return ParsedType.tensorType(tensorType);}
    } else if (jj_2_6(2147483647)) {
      jj_consume_token(REFERENCE);
      jj_consume_token(LESSTHAN);
      referenceType = referenceType();
      jj_consume_token(GREATERTHAN);
{if ("" != null) return ParsedType.documentRef(referenceType);}
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ANNOTATION:
      case ANNOTATIONREFERENCE:
      case SCHEMA:
      case SEARCH:
      case DIVERSITY:
      case LOOSE:
      case STRICT:
      case DOCUMENT:
      case OPERATION:
      case STRUCT:
      case INHERITS:
      case FIELD:
      case FIELDS:
      case FIELDSET:
      case IMPORT:
      case AS:
      case INDEXING:
      case INFINITY:
      case WEIGHT:
      case TYPE:
      case INDEX:
      case INPUTS:
      case MTOKEN:
      case TEXT:
      case WORD:
      case GRAM:
      case PREFIX:
      case SUBSTRING:
      case SUFFIX:
      case CONSTANT:
      case SIGNIFICANCE:
      case WEAKAND:
      case PARALLEL:
      case SEQUENTIAL:
      case MODEL:
      case MUTATE:
      case QUERY:
      case SUMMARY:
      case FULL:
      case STATIC:
      case DYNAMIC:
      case TOKENS:
      case SSCONTEXTUAL:
      case SSOVERRIDE:
      case SSTITLE:
      case SSURL:
      case PROPERTIES:
      case ATTRIBUTE:
      case SORTING:
      case DICTIONARY:
      case ASCENDING:
      case DESCENDING:
      case UCA:
      case RAW:
      case LOWERCASE:
      case FUNCTION:
      case LOCALE:
      case STRENGTH:
      case PRIMARY:
      case SECONDARY:
      case TERTIARY:
      case QUATERNARY:
      case IDENTICAL:
      case STEMMING:
      case NORMALIZING:
      case HASH:
      case BTREE:
      case CASED:
      case UNCASED:
      case BOLDING:
      case NONE:
      case ON:
      case OFF:
      case TRUE:
      case FALSE:
      case SYMMETRIC:
      case ALIAS:
      case MATCH:
      case RANK:
      case LITERAL:
      case EXACT:
      case FILTER:
      case NORMAL:
      case ID:
      case SOURCE:
      case TO:
      case DIRECT:
      case ALWAYS:
      case NEVER:
      case MUTABLE:
      case PAGED:
      case ARRAY:
      case WEIGHTEDSET:
      case MAP:
      case REFERENCE:
      case ORDER:
      case MACRO:
      case INLINE:
      case ARITY:
      case HNSW:
      case DOUBLE_KEYWORD:
      case FLOAT_KEYWORD:
      case LONG_KEYWORD:
      case STRING_KEYWORD:
      case CONSTANTS:
      case FILE:
      case URI:
      case IDENTIFIER:
      case CONTEXT:
      case INTEGER:
      case LONG:
      case STRING:
      case VARIABLE:{
        typeName = identifier();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case 232:{
          jj_consume_token(232);
isArrayOldStyle = true;
          break;
          }
        default:
          jj_la1[46] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[47] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
ParsedType type = ParsedType.fromName(typeName);
        if (isArrayOldStyle) {
            deployLogger.logApplicationPackage(Level.WARNING, "Data type syntax '" + typeName + "[]' is deprecated, use 'array<" + typeName + ">' instead.");
            type = ParsedType.arrayOf(type);
        }
        {if ("" != null) return type;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ParsedType referenceType() throws ParseException {String documentName;
    documentName = identifier();
{if ("" != null) return ParsedType.documentType(documentName);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ParsedType annotationRefDataType() throws ParseException {ParsedType dataType;
    String targetName;
    jj_consume_token(ANNOTATIONREFERENCE);
    jj_consume_token(LESSTHAN);
    targetName = identifier();
    jj_consume_token(GREATERTHAN);
{if ("" != null) return ParsedType.annotationRef(targetName);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ParsedType mapDataType() throws ParseException {ParsedType keyType;
    ParsedType valType;
    jj_consume_token(MAP);
    jj_consume_token(LESSTHAN);
    keyType = dataType();
    jj_consume_token(COMMA);
    valType = dataType();
    jj_consume_token(GREATERTHAN);
{if ("" != null) return ParsedType.mapType(keyType, valType);}
    throw new IllegalStateException ("Missing return statement in function");
}

/**
 * This rule consumes a field block of a struct body.
 *
 * @param struct The struct to modify.
 */
  final public void structFieldDefinition(ParsedStruct struct) throws ParseException {String name;
    ParsedType type;
    ParsedField field;
    int fieldId;
    jj_consume_token(FIELD);
    name = identifier();
    jj_consume_token(TYPE);
    type = dataType();
if (name != null && Schema.isReservedName(name.toLowerCase())) {
            throw new IllegalArgumentException("Reserved name '" + name + "' can not be used as a field name.");
        }
        field = new ParsedField(name, type);
    lbrace();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ID:{
      id(field);
      label_32:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NL:{
          break;
          }
        default:
          jj_la1[48] = jj_gen;
          break label_32;
        }
        jj_consume_token(NL);
      }
      break;
      }
    default:
      jj_la1[49] = jj_gen;
      ;
    }
    label_33:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MATCH:{
        break;
        }
      default:
        jj_la1[50] = jj_gen;
        break label_33;
      }
      matchSettings(field.matchSettings());
      label_34:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NL:{
          break;
          }
        default:
          jj_la1[51] = jj_gen;
          break label_34;
        }
        jj_consume_token(NL);
      }
    }
    jj_consume_token(RBRACE);
struct.addField(field);
}

/**
 * This rule consumes a struct subfield from a document field body. This is not to be confused with a document
 * struct's fields, but rather this is a subfield of a document field of type struct.
 *
 * @param field    the field to modify
 */
  final public void structField(ParsedField field) throws ParseException {String name;
    ParsedField structField;
    jj_consume_token(STRUCT_FIELD);
    name = identifier();
if (name != null && Schema.isReservedName(name.toLowerCase())) {
            throw new IllegalArgumentException("Reserved name '" + name + "' can not be used as a field name.");
        }
        structField = new ParsedField(name, null);
    lbrace();
    label_35:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case STRUCT_FIELD:
      case INDEXING:
      case SUMMARY_TO:
      case SUMMARY:
      case ATTRIBUTE:
      case QUERY_COMMAND:
      case MATCH:
      case RANK:{
        break;
        }
      default:
        jj_la1[52] = jj_gen;
        break label_35;
      }
      structFieldBody(structField);
      label_36:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NL:{
          break;
          }
        default:
          jj_la1[53] = jj_gen;
          break label_36;
        }
        jj_consume_token(NL);
      }
    }
    jj_consume_token(RBRACE);
field.addStructField(structField);
}

/**
 * This rule consumes a single element of a field body block.
 *
 * @param field    the field being built
 */
  final public void fieldBody(ParsedField field) throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ALIAS:{
      alias(field);
      break;
      }
    case ATTRIBUTE:{
      attribute(field);
      break;
      }
    case BOLDING:{
      bolding(field);
      break;
      }
    case DICTIONARY:{
      dictionary(field);
      break;
      }
    case STEMMING:{
      fieldStemming(field);
      break;
      }
    case ID:{
      id(field);
      break;
      }
    case SUMMARY:{
      summaryInField(field);
      break;
      }
    case INDEX:{
      indexInsideField(field);
      break;
      }
    case INDEXING:{
      indexing(field);
      break;
      }
    case MATCH:{
      matchSettings(field.matchSettings());
      break;
      }
    case NORMALIZING:{
      normalizing(field);
      break;
      }
    case QUERY_COMMAND:{
      queryCommand(field);
      break;
      }
    case RANK:{
      rank(field);
      break;
      }
    case RANK_TYPE:{
      rankType(field);
      break;
      }
    case SORTING:{
      fieldSorting(field);
      break;
      }
    case STRUCT_FIELD:{
      structField(field);
      break;
      }
    case SUMMARY_TO:{
      summaryTo(field);
      break;
      }
    case WEIGHT:{
      weight(field);
      break;
      }
    case WEIGHTEDSET:{
      weightedset(field.getType());
      break;
      }
    default:
      jj_la1[54] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

/**
 * This rule consumes a single element of a struct subfield body block.
 * Only elements that are supported in streaming schema and indexed schema (with complex attributes) are allowed.
 *
 * @param field    the field being built
 */
  final public void structFieldBody(ParsedField field) throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case SUMMARY:{
      summaryInField(field);
      break;
      }
    case INDEXING:{
      indexing(field);
      break;
      }
    case ATTRIBUTE:{
      attribute(field);
      break;
      }
    case MATCH:{
      matchSettings(field.matchSettings());
      break;
      }
    case QUERY_COMMAND:{
      queryCommand(field);
      break;
      }
    case RANK:{
      rank(field);
      break;
      }
    case STRUCT_FIELD:{
      structField(field);
      break;
      }
    case SUMMARY_TO:{
      summaryTo(field);
      break;
      }
    default:
      jj_la1[55] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

/**
 * This rule consumes an indexing block of a field element.
 *
 * @param field The field to modify.
 */
  final public void indexing(ParsedField field) throws ParseException {
    jj_consume_token(INDEXING);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
      indexingOperation(field, false);
      break;
      }
    default:
      jj_la1[56] = jj_gen;
      indexingOperation(field, true);
    }
}

/**
 * This rule consumes an IL script block. This is expected to consume trailing newlines.
 *
 * @param field The field to modify.
 */
  final public void indexingOperation(ParsedField field, boolean multiLine) throws ParseException {
IndexingOperation oldOp = newIndexingOperation(multiLine);
        ParsedIndexingOp newOp = new ParsedIndexingOp(oldOp.getScript());
        field.setIndexingOperation(newOp);
}

/**
 * This rule consumes a summary-to statement of a field element.
 *
 * @param field The field to modify.
 */
  final public void summaryTo(ParsedField field) throws ParseException {String name = field.name();
    String destination;
    ParsedSummaryField psf;
    jj_consume_token(SUMMARY_TO);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ANNOTATION:
    case ANNOTATIONREFERENCE:
    case SCHEMA:
    case SEARCH:
    case DIVERSITY:
    case LOOSE:
    case STRICT:
    case DOCUMENT:
    case OPERATION:
    case STRUCT:
    case INHERITS:
    case FIELD:
    case FIELDS:
    case FIELDSET:
    case IMPORT:
    case AS:
    case INDEXING:
    case INFINITY:
    case WEIGHT:
    case TYPE:
    case INDEX:
    case INPUTS:
    case MTOKEN:
    case TEXT:
    case WORD:
    case GRAM:
    case PREFIX:
    case SUBSTRING:
    case SUFFIX:
    case CONSTANT:
    case SIGNIFICANCE:
    case WEAKAND:
    case PARALLEL:
    case SEQUENTIAL:
    case MODEL:
    case MUTATE:
    case QUERY:
    case SUMMARY:
    case FULL:
    case STATIC:
    case DYNAMIC:
    case TOKENS:
    case SSCONTEXTUAL:
    case SSOVERRIDE:
    case SSTITLE:
    case SSURL:
    case PROPERTIES:
    case ATTRIBUTE:
    case SORTING:
    case DICTIONARY:
    case ASCENDING:
    case DESCENDING:
    case UCA:
    case RAW:
    case LOWERCASE:
    case FUNCTION:
    case LOCALE:
    case STRENGTH:
    case PRIMARY:
    case SECONDARY:
    case TERTIARY:
    case QUATERNARY:
    case IDENTICAL:
    case STEMMING:
    case NORMALIZING:
    case HASH:
    case BTREE:
    case CASED:
    case UNCASED:
    case BOLDING:
    case NONE:
    case ON:
    case OFF:
    case TRUE:
    case FALSE:
    case SYMMETRIC:
    case ALIAS:
    case MATCH:
    case RANK:
    case LITERAL:
    case EXACT:
    case FILTER:
    case NORMAL:
    case ID:
    case SOURCE:
    case TO:
    case DIRECT:
    case ALWAYS:
    case NEVER:
    case MUTABLE:
    case PAGED:
    case ARRAY:
    case WEIGHTEDSET:
    case MAP:
    case REFERENCE:
    case ORDER:
    case MACRO:
    case INLINE:
    case ARITY:
    case HNSW:
    case DOUBLE_KEYWORD:
    case FLOAT_KEYWORD:
    case LONG_KEYWORD:
    case STRING_KEYWORD:
    case CONSTANTS:
    case FILE:
    case URI:
    case IDENTIFIER:
    case CONTEXT:
    case INTEGER:
    case LONG:
    case STRING:
    case VARIABLE:{
      name = identifier();
      break;
      }
    default:
      jj_la1[57] = jj_gen;
      ;
    }
    jj_consume_token(COLON);
    destination = identifier();
psf = field.summaryFieldFor(name);
        psf.addDestination(destination);
    label_37:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[58] = jj_gen;
        break label_37;
      }
      jj_consume_token(COMMA);
      destination = identifier();
psf.addDestination(destination);
    }
}

/**
 * This rule consumes a weight statement of a field element.
 *
 * @param field The field to modify.
 */
  final public void weight(ParsedField field) throws ParseException {int num;
    jj_consume_token(WEIGHT);
    jj_consume_token(COLON);
    num = integer();
field.setWeight(num);
}

/**
 * This rule consumes a weighted set statement of a field element.
 *
 * @param fieldType The field type to modify.
 */
  final public void weightedset(ParsedType fieldType) throws ParseException {
    jj_consume_token(WEIGHTEDSET);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
      weightedsetBody(fieldType);
      break;
      }
    case NL:
    case LBRACE:{
      lbrace();
      label_38:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case CREATE_IF_NONEXISTENT:
        case REMOVE_IF_ZERO:{
          break;
          }
        default:
          jj_la1[59] = jj_gen;
          break label_38;
        }
        weightedsetBody(fieldType);
        label_39:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case NL:{
            break;
            }
          default:
            jj_la1[60] = jj_gen;
            break label_39;
          }
          jj_consume_token(NL);
        }
      }
      jj_consume_token(RBRACE);
      break;
      }
    default:
      jj_la1[61] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

/**
 * This rule consumes one body item of a weighted set block.
 *
 * @param type The field type to modify.
 */
  final public void weightedsetBody(ParsedType type) throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case CREATE_IF_NONEXISTENT:{
      jj_consume_token(CREATE_IF_NONEXISTENT);
type.setCreateIfNonExistent(true);
      break;
      }
    case REMOVE_IF_ZERO:{
      jj_consume_token(REMOVE_IF_ZERO);
type.setRemoveIfZero(true);
      break;
      }
    default:
      jj_la1[62] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

/**
 * This rule consumes a rank-type statement of a field element.
 *
 * @param field The field to modify.
 */
  final public void rankType(ParsedField field) throws ParseException {String typeName;
    String indexName = "";
    jj_consume_token(RANK_TYPE);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ANNOTATION:
    case ANNOTATIONREFERENCE:
    case SCHEMA:
    case SEARCH:
    case DIVERSITY:
    case LOOSE:
    case STRICT:
    case DOCUMENT:
    case OPERATION:
    case STRUCT:
    case INHERITS:
    case FIELD:
    case FIELDS:
    case FIELDSET:
    case IMPORT:
    case AS:
    case INDEXING:
    case INFINITY:
    case WEIGHT:
    case TYPE:
    case INDEX:
    case INPUTS:
    case MTOKEN:
    case TEXT:
    case WORD:
    case GRAM:
    case PREFIX:
    case SUBSTRING:
    case SUFFIX:
    case CONSTANT:
    case SIGNIFICANCE:
    case WEAKAND:
    case PARALLEL:
    case SEQUENTIAL:
    case MODEL:
    case MUTATE:
    case QUERY:
    case SUMMARY:
    case FULL:
    case STATIC:
    case DYNAMIC:
    case TOKENS:
    case SSCONTEXTUAL:
    case SSOVERRIDE:
    case SSTITLE:
    case SSURL:
    case PROPERTIES:
    case ATTRIBUTE:
    case SORTING:
    case DICTIONARY:
    case ASCENDING:
    case DESCENDING:
    case UCA:
    case RAW:
    case LOWERCASE:
    case FUNCTION:
    case LOCALE:
    case STRENGTH:
    case PRIMARY:
    case SECONDARY:
    case TERTIARY:
    case QUATERNARY:
    case IDENTICAL:
    case STEMMING:
    case NORMALIZING:
    case HASH:
    case BTREE:
    case CASED:
    case UNCASED:
    case BOLDING:
    case NONE:
    case ON:
    case OFF:
    case TRUE:
    case FALSE:
    case SYMMETRIC:
    case ALIAS:
    case MATCH:
    case RANK:
    case LITERAL:
    case EXACT:
    case FILTER:
    case NORMAL:
    case ID:
    case SOURCE:
    case TO:
    case DIRECT:
    case ALWAYS:
    case NEVER:
    case MUTABLE:
    case PAGED:
    case ARRAY:
    case WEIGHTEDSET:
    case MAP:
    case REFERENCE:
    case ORDER:
    case MACRO:
    case INLINE:
    case ARITY:
    case HNSW:
    case DOUBLE_KEYWORD:
    case FLOAT_KEYWORD:
    case LONG_KEYWORD:
    case STRING_KEYWORD:
    case CONSTANTS:
    case FILE:
    case URI:
    case IDENTIFIER:
    case CONTEXT:
    case INTEGER:
    case LONG:
    case STRING:
    case VARIABLE:{
      indexName = identifier();
      break;
      }
    default:
      jj_la1[63] = jj_gen;
      ;
    }
    jj_consume_token(COLON);
    typeName = identifier();
field.addRankType(indexName, typeName);
}

/**
 * This rule consumes an attribute statement of a field element.
 *
 * @param field The field to modify.
 */
  final public void attribute(ParsedField field) throws ParseException {String name = field.name();
    jj_consume_token(ATTRIBUTE);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ANNOTATION:
    case ANNOTATIONREFERENCE:
    case SCHEMA:
    case SEARCH:
    case DIVERSITY:
    case LOOSE:
    case STRICT:
    case DOCUMENT:
    case OPERATION:
    case STRUCT:
    case INHERITS:
    case FIELD:
    case FIELDS:
    case FIELDSET:
    case IMPORT:
    case AS:
    case INDEXING:
    case INFINITY:
    case WEIGHT:
    case TYPE:
    case INDEX:
    case INPUTS:
    case MTOKEN:
    case TEXT:
    case WORD:
    case GRAM:
    case PREFIX:
    case SUBSTRING:
    case SUFFIX:
    case CONSTANT:
    case SIGNIFICANCE:
    case WEAKAND:
    case PARALLEL:
    case SEQUENTIAL:
    case MODEL:
    case MUTATE:
    case QUERY:
    case SUMMARY:
    case FULL:
    case STATIC:
    case DYNAMIC:
    case TOKENS:
    case SSCONTEXTUAL:
    case SSOVERRIDE:
    case SSTITLE:
    case SSURL:
    case PROPERTIES:
    case ATTRIBUTE:
    case SORTING:
    case DICTIONARY:
    case ASCENDING:
    case DESCENDING:
    case UCA:
    case RAW:
    case LOWERCASE:
    case FUNCTION:
    case LOCALE:
    case STRENGTH:
    case PRIMARY:
    case SECONDARY:
    case TERTIARY:
    case QUATERNARY:
    case IDENTICAL:
    case STEMMING:
    case NORMALIZING:
    case HASH:
    case BTREE:
    case CASED:
    case UNCASED:
    case BOLDING:
    case NONE:
    case ON:
    case OFF:
    case TRUE:
    case FALSE:
    case SYMMETRIC:
    case ALIAS:
    case MATCH:
    case RANK:
    case LITERAL:
    case EXACT:
    case FILTER:
    case NORMAL:
    case ID:
    case SOURCE:
    case TO:
    case DIRECT:
    case ALWAYS:
    case NEVER:
    case MUTABLE:
    case PAGED:
    case ARRAY:
    case WEIGHTEDSET:
    case MAP:
    case REFERENCE:
    case ORDER:
    case MACRO:
    case INLINE:
    case ARITY:
    case HNSW:
    case DOUBLE_KEYWORD:
    case FLOAT_KEYWORD:
    case LONG_KEYWORD:
    case STRING_KEYWORD:
    case CONSTANTS:
    case FILE:
    case URI:
    case IDENTIFIER:
    case CONTEXT:
    case INTEGER:
    case LONG:
    case STRING:
    case VARIABLE:{
      name = identifier();
      break;
      }
    default:
      jj_la1[64] = jj_gen;
      ;
    }
// TODO: Remove support for attribute with different name than field name in Vespa 9
        if ( ! name.equals(field.name()))
                deployLogger.logApplicationPackage(Level.WARNING, "Creating an attribute for field '" + field.name() +
                "' with a different name '" + name + "' than the field name" +
                " is deprecated, and support will be removed in Vespa 9. Define a field with the wanted name outside the document instead.");
        ParsedAttribute attr = field.attributeFor(name);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
      attributeSetting(attr);
      break;
      }
    case NL:
    case LBRACE:{
      lbrace();
      label_40:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case SORTING:
        case ALIAS:
        case ENABLE_BIT_VECTORS:
        case ENABLE_ONLY_BIT_VECTOR:
        case FAST_ACCESS:
        case MUTABLE:
        case PAGED:
        case FAST_RANK:
        case FAST_SEARCH:
        case DISTANCE_METRIC:{
          break;
          }
        default:
          jj_la1[65] = jj_gen;
          break label_40;
        }
        attributeSetting(attr);
        label_41:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case NL:{
            break;
            }
          default:
            jj_la1[66] = jj_gen;
            break label_41;
          }
          jj_consume_token(NL);
        }
      }
      jj_consume_token(RBRACE);
      break;
      }
    default:
      jj_la1[67] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

/* pick up sorting in field block */
  final public void fieldSorting(ParsedField field) throws ParseException {
    sorting(field.sortInfo());
}

/* pick up sorting in field block */
  final public void attributeSorting(ParsedAttribute attribute) throws ParseException {
    sorting(attribute.sortInfo());
}

  final public void sorting(ParsedSorting sort) throws ParseException {
    jj_consume_token(SORTING);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
      sortingSetting(sort);
      break;
      }
    case NL:
    case LBRACE:{
      lbrace();
      label_42:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ASCENDING:
        case DESCENDING:
        case FUNCTION:
        case LOCALE:
        case STRENGTH:{
          break;
          }
        default:
          jj_la1[68] = jj_gen;
          break label_42;
        }
        sortingSetting(sort);
        label_43:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case NL:{
            break;
            }
          default:
            jj_la1[69] = jj_gen;
            break label_43;
          }
          jj_consume_token(NL);
        }
      }
      jj_consume_token(RBRACE);
      break;
      }
    default:
      jj_la1[70] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void sortingSetting(ParsedSorting sorting) throws ParseException {String locale;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ASCENDING:{
      jj_consume_token(ASCENDING);
sorting.setAscending();
      break;
      }
    case DESCENDING:{
      jj_consume_token(DESCENDING);
sorting.setDescending();
      break;
      }
    case FUNCTION:{
      jj_consume_token(FUNCTION);
      jj_consume_token(COLON);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case UCA:{
        jj_consume_token(UCA);
sorting.setFunction(Sorting.Function.UCA);
        break;
        }
      case RAW:{
        jj_consume_token(RAW);
sorting.setFunction(Sorting.Function.RAW);
        break;
        }
      case LOWERCASE:{
        jj_consume_token(LOWERCASE);
sorting.setFunction(Sorting.Function.LOWERCASE);
        break;
        }
      default:
        jj_la1[71] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case STRENGTH:{
      jj_consume_token(STRENGTH);
      jj_consume_token(COLON);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PRIMARY:{
        jj_consume_token(PRIMARY);
sorting.setStrength(Sorting.Strength.PRIMARY);
        break;
        }
      case SECONDARY:{
        jj_consume_token(SECONDARY);
sorting.setStrength(Sorting.Strength.SECONDARY);
        break;
        }
      case TERTIARY:{
        jj_consume_token(TERTIARY);
sorting.setStrength(Sorting.Strength.TERTIARY);
        break;
        }
      case QUATERNARY:{
        jj_consume_token(QUATERNARY);
sorting.setStrength(Sorting.Strength.QUATERNARY);
        break;
        }
      case IDENTICAL:{
        jj_consume_token(IDENTICAL);
sorting.setStrength(Sorting.Strength.IDENTICAL);
        break;
        }
      default:
        jj_la1[72] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case LOCALE:{
      jj_consume_token(LOCALE);
      jj_consume_token(COLON);
      locale = identifierWithDash();
sorting.setLocale(locale);
      break;
      }
    default:
      jj_la1[73] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

/**
 * This rule consumes a single attribute setting statement of an attribute element.
 *
 * @param attribute The attribute to change.
 */
  final public void attributeSetting(ParsedAttribute attribute) throws ParseException {String str;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case FAST_RANK:{
      jj_consume_token(FAST_RANK);
attribute.setFastRank(true);
      break;
      }
    case FAST_SEARCH:{
      jj_consume_token(FAST_SEARCH);
attribute.setFastSearch(true);
      break;
      }
    case FAST_ACCESS:{
      jj_consume_token(FAST_ACCESS);
attribute.setFastAccess(true);
      break;
      }
    case MUTABLE:{
      jj_consume_token(MUTABLE);
attribute.setMutable(true);
      break;
      }
    case PAGED:{
      jj_consume_token(PAGED);
attribute.setPaged(true);
      break;
      }
    case ENABLE_BIT_VECTORS:{
      jj_consume_token(ENABLE_BIT_VECTORS);
deployLogger.logApplicationPackage(Level.WARNING, "'enable-bit-vectors' is deprecated and void -> remove it. Will be removed in vespa-9");
      break;
      }
    case ENABLE_ONLY_BIT_VECTOR:{
      jj_consume_token(ENABLE_ONLY_BIT_VECTOR);
attribute.setEnableOnlyBitVector(true);
      break;
      }
    case SORTING:{
      attributeSorting(attribute);
      break;
      }
    case ALIAS:{
      jj_consume_token(ALIAS);
String alias; String aliasedName=attribute.name();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ANNOTATION:
      case ANNOTATIONREFERENCE:
      case SCHEMA:
      case SEARCH:
      case DIVERSITY:
      case LOOSE:
      case STRICT:
      case DOCUMENT:
      case OPERATION:
      case STRUCT:
      case INHERITS:
      case FIELD:
      case FIELDS:
      case FIELDSET:
      case IMPORT:
      case AS:
      case INDEXING:
      case INFINITY:
      case WEIGHT:
      case TYPE:
      case INDEX:
      case INPUTS:
      case MTOKEN:
      case TEXT:
      case WORD:
      case GRAM:
      case PREFIX:
      case SUBSTRING:
      case SUFFIX:
      case CONSTANT:
      case SIGNIFICANCE:
      case WEAKAND:
      case PARALLEL:
      case SEQUENTIAL:
      case MODEL:
      case MUTATE:
      case QUERY:
      case SUMMARY:
      case FULL:
      case STATIC:
      case DYNAMIC:
      case TOKENS:
      case SSCONTEXTUAL:
      case SSOVERRIDE:
      case SSTITLE:
      case SSURL:
      case PROPERTIES:
      case ATTRIBUTE:
      case SORTING:
      case DICTIONARY:
      case ASCENDING:
      case DESCENDING:
      case UCA:
      case RAW:
      case LOWERCASE:
      case FUNCTION:
      case LOCALE:
      case STRENGTH:
      case PRIMARY:
      case SECONDARY:
      case TERTIARY:
      case QUATERNARY:
      case IDENTICAL:
      case STEMMING:
      case NORMALIZING:
      case HASH:
      case BTREE:
      case CASED:
      case UNCASED:
      case BOLDING:
      case NONE:
      case ON:
      case OFF:
      case TRUE:
      case FALSE:
      case SYMMETRIC:
      case ALIAS:
      case MATCH:
      case RANK:
      case LITERAL:
      case EXACT:
      case FILTER:
      case NORMAL:
      case ID:
      case SOURCE:
      case TO:
      case DIRECT:
      case ALWAYS:
      case NEVER:
      case MUTABLE:
      case PAGED:
      case ARRAY:
      case WEIGHTEDSET:
      case MAP:
      case REFERENCE:
      case ORDER:
      case MACRO:
      case INLINE:
      case ARITY:
      case HNSW:
      case DOUBLE_KEYWORD:
      case FLOAT_KEYWORD:
      case LONG_KEYWORD:
      case STRING_KEYWORD:
      case CONSTANTS:
      case FILE:
      case URI:
      case IDENTIFIER:
      case CONTEXT:
      case INTEGER:
      case LONG:
      case STRING:
      case VARIABLE:{
        aliasedName = identifier();
        break;
        }
      default:
        jj_la1[74] = jj_gen;
        ;
      }
      jj_consume_token(COLON);
      alias = identifierWithDash();
attribute.addAlias(aliasedName, alias);
      break;
      }
    case DISTANCE_METRIC:{
      jj_consume_token(DISTANCE_METRIC);
      jj_consume_token(COLON);
      str = identifierWithDash();
attribute.setDistanceMetric(str);
      break;
      }
    default:
      jj_la1[75] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

/**
 * This rule consumes a summary statement defined inside a document-summary block.
 *
 * @param docsum The document summary to modify.
 */
  final public void summaryInDocument(ParsedDocumentSummary docsum) throws ParseException {String name;
    ParsedType type = null;
    ParsedSummaryField psf;
    jj_consume_token(SUMMARY);
    name = identifierWithDash();

    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case TYPE:{
      jj_consume_token(TYPE);
      type = dataType();
      break;
      }
    default:
      jj_la1[76] = jj_gen;
      ;
    }
    lbrace();
psf = new ParsedSummaryField(name, type);
 if (type != null) {
     psf.setHasExplicitType();
 }
    label_44:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case FULL:
      case STATIC:
      case DYNAMIC:
      case TOKENS:
      case MATCHED_ELEMENTS_ONLY:
      case BOLDING:
      case SOURCE:
      case TO:
      case SELECT_ELEMENTS_BY_SL:{
        break;
        }
      default:
        jj_la1[77] = jj_gen;
        break label_44;
      }
      summaryItem(psf);
      label_45:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NL:{
          break;
          }
        default:
          jj_la1[78] = jj_gen;
          break label_45;
        }
        jj_consume_token(NL);
      }
    }
    jj_consume_token(RBRACE);
var old = docsum.addField(psf);
        if (old != null) {
            deployLogger.logApplicationPackage(Level.WARNING, "Summary field '" + psf.name()
                                               + "' is defined twice in document-summary '"
                                               + docsum.name() + "'");
        }
}

/**
 * The rule consumes a summary statement defined inside a field.
 *
 * @param field The field to modify.
 */
  final public void summaryInField(ParsedField field) throws ParseException {
    jj_consume_token(SUMMARY);
    if (jj_2_7(2)) {
      summaryInFieldShort(field);
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NL:
      case ANNOTATION:
      case ANNOTATIONREFERENCE:
      case SCHEMA:
      case SEARCH:
      case DIVERSITY:
      case LOOSE:
      case STRICT:
      case DOCUMENT:
      case OPERATION:
      case STRUCT:
      case INHERITS:
      case FIELD:
      case FIELDS:
      case FIELDSET:
      case IMPORT:
      case AS:
      case INDEXING:
      case INFINITY:
      case WEIGHT:
      case TYPE:
      case INDEX:
      case INPUTS:
      case MTOKEN:
      case TEXT:
      case WORD:
      case GRAM:
      case PREFIX:
      case SUBSTRING:
      case SUFFIX:
      case CONSTANT:
      case SIGNIFICANCE:
      case WEAKAND:
      case PARALLEL:
      case SEQUENTIAL:
      case MODEL:
      case MUTATE:
      case QUERY:
      case SUMMARY:
      case FULL:
      case STATIC:
      case DYNAMIC:
      case TOKENS:
      case SSCONTEXTUAL:
      case SSOVERRIDE:
      case SSTITLE:
      case SSURL:
      case PROPERTIES:
      case ATTRIBUTE:
      case SORTING:
      case DICTIONARY:
      case ASCENDING:
      case DESCENDING:
      case UCA:
      case RAW:
      case LOWERCASE:
      case FUNCTION:
      case LOCALE:
      case STRENGTH:
      case PRIMARY:
      case SECONDARY:
      case TERTIARY:
      case QUATERNARY:
      case IDENTICAL:
      case STEMMING:
      case NORMALIZING:
      case HASH:
      case BTREE:
      case CASED:
      case UNCASED:
      case BOLDING:
      case NONE:
      case ON:
      case OFF:
      case TRUE:
      case FALSE:
      case SYMMETRIC:
      case ALIAS:
      case MATCH:
      case RANK:
      case LITERAL:
      case EXACT:
      case FILTER:
      case NORMAL:
      case ID:
      case SOURCE:
      case TO:
      case DIRECT:
      case ALWAYS:
      case NEVER:
      case MUTABLE:
      case PAGED:
      case LBRACE:
      case ARRAY:
      case WEIGHTEDSET:
      case MAP:
      case REFERENCE:
      case ORDER:
      case MACRO:
      case INLINE:
      case ARITY:
      case HNSW:
      case DOUBLE_KEYWORD:
      case FLOAT_KEYWORD:
      case LONG_KEYWORD:
      case STRING_KEYWORD:
      case CONSTANTS:
      case FILE:
      case URI:
      case IDENTIFIER:
      case CONTEXT:
      case INTEGER:
      case LONG:
      case STRING:
      case VARIABLE:{
        summaryInFieldLong(field);
        break;
        }
      default:
        jj_la1[79] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
}

/**
 * This rule consumes a single-line summary field.
 */
  final public void summaryInFieldShort(ParsedField field) throws ParseException {String name = field.name();
    ParsedSummaryField psf;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ANNOTATION:
    case ANNOTATIONREFERENCE:
    case SCHEMA:
    case SEARCH:
    case DIVERSITY:
    case LOOSE:
    case STRICT:
    case DOCUMENT:
    case OPERATION:
    case STRUCT:
    case INHERITS:
    case FIELD:
    case FIELDS:
    case FIELDSET:
    case IMPORT:
    case AS:
    case INDEXING:
    case INFINITY:
    case WEIGHT:
    case TYPE:
    case INDEX:
    case INPUTS:
    case MTOKEN:
    case TEXT:
    case WORD:
    case GRAM:
    case PREFIX:
    case SUBSTRING:
    case SUFFIX:
    case CONSTANT:
    case SIGNIFICANCE:
    case WEAKAND:
    case PARALLEL:
    case SEQUENTIAL:
    case MODEL:
    case MUTATE:
    case QUERY:
    case SUMMARY:
    case FULL:
    case STATIC:
    case DYNAMIC:
    case TOKENS:
    case SSCONTEXTUAL:
    case SSOVERRIDE:
    case SSTITLE:
    case SSURL:
    case PROPERTIES:
    case ATTRIBUTE:
    case SORTING:
    case DICTIONARY:
    case ASCENDING:
    case DESCENDING:
    case UCA:
    case RAW:
    case LOWERCASE:
    case FUNCTION:
    case LOCALE:
    case STRENGTH:
    case PRIMARY:
    case SECONDARY:
    case TERTIARY:
    case QUATERNARY:
    case IDENTICAL:
    case STEMMING:
    case NORMALIZING:
    case HASH:
    case BTREE:
    case CASED:
    case UNCASED:
    case BOLDING:
    case NONE:
    case ON:
    case OFF:
    case TRUE:
    case FALSE:
    case SYMMETRIC:
    case ALIAS:
    case MATCH:
    case RANK:
    case LITERAL:
    case EXACT:
    case FILTER:
    case NORMAL:
    case ID:
    case SOURCE:
    case TO:
    case DIRECT:
    case ALWAYS:
    case NEVER:
    case MUTABLE:
    case PAGED:
    case ARRAY:
    case WEIGHTEDSET:
    case MAP:
    case REFERENCE:
    case ORDER:
    case MACRO:
    case INLINE:
    case ARITY:
    case HNSW:
    case DOUBLE_KEYWORD:
    case FLOAT_KEYWORD:
    case LONG_KEYWORD:
    case STRING_KEYWORD:
    case CONSTANTS:
    case FILE:
    case URI:
    case IDENTIFIER:
    case CONTEXT:
    case INTEGER:
    case LONG:
    case STRING:
    case VARIABLE:{
      name = identifier();
      break;
      }
    default:
      jj_la1[80] = jj_gen;
      ;
    }
psf = field.summaryFieldFor(name);
    jj_consume_token(COLON);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DYNAMIC:{
      jj_consume_token(DYNAMIC);
psf.setDynamic();
      break;
      }
    case MATCHED_ELEMENTS_ONLY:{
      jj_consume_token(MATCHED_ELEMENTS_ONLY);
psf.setMatchedElementsOnly();
      break;
      }
    case FULL:
    case STATIC:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case FULL:{
        jj_consume_token(FULL);
        break;
        }
      case STATIC:{
        jj_consume_token(STATIC);
        break;
        }
      default:
        jj_la1[81] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
psf.setFull();
      break;
      }
    case TOKENS:{
      jj_consume_token(TOKENS);
psf.setTokens();
      break;
      }
    default:
      jj_la1[82] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

/**
 * This rule consumes a multi-line summary field.
 */
  final public void summaryInFieldLong(ParsedField field) throws ParseException {String name = field.name();
    ParsedType type = field.getType();
    boolean explicitType = false;
    ParsedSummaryField psf;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ANNOTATION:
    case ANNOTATIONREFERENCE:
    case SCHEMA:
    case SEARCH:
    case DIVERSITY:
    case LOOSE:
    case STRICT:
    case DOCUMENT:
    case OPERATION:
    case STRUCT:
    case INHERITS:
    case FIELD:
    case FIELDS:
    case FIELDSET:
    case IMPORT:
    case AS:
    case INDEXING:
    case INFINITY:
    case WEIGHT:
    case TYPE:
    case INDEX:
    case INPUTS:
    case MTOKEN:
    case TEXT:
    case WORD:
    case GRAM:
    case PREFIX:
    case SUBSTRING:
    case SUFFIX:
    case CONSTANT:
    case SIGNIFICANCE:
    case WEAKAND:
    case PARALLEL:
    case SEQUENTIAL:
    case MODEL:
    case MUTATE:
    case QUERY:
    case SUMMARY:
    case FULL:
    case STATIC:
    case DYNAMIC:
    case TOKENS:
    case SSCONTEXTUAL:
    case SSOVERRIDE:
    case SSTITLE:
    case SSURL:
    case PROPERTIES:
    case ATTRIBUTE:
    case SORTING:
    case DICTIONARY:
    case ASCENDING:
    case DESCENDING:
    case UCA:
    case RAW:
    case LOWERCASE:
    case FUNCTION:
    case LOCALE:
    case STRENGTH:
    case PRIMARY:
    case SECONDARY:
    case TERTIARY:
    case QUATERNARY:
    case IDENTICAL:
    case STEMMING:
    case NORMALIZING:
    case HASH:
    case BTREE:
    case CASED:
    case UNCASED:
    case BOLDING:
    case NONE:
    case ON:
    case OFF:
    case TRUE:
    case FALSE:
    case SYMMETRIC:
    case ALIAS:
    case MATCH:
    case RANK:
    case LITERAL:
    case EXACT:
    case FILTER:
    case NORMAL:
    case ID:
    case SOURCE:
    case TO:
    case DIRECT:
    case ALWAYS:
    case NEVER:
    case MUTABLE:
    case PAGED:
    case ARRAY:
    case WEIGHTEDSET:
    case MAP:
    case REFERENCE:
    case ORDER:
    case MACRO:
    case INLINE:
    case ARITY:
    case HNSW:
    case DOUBLE_KEYWORD:
    case FLOAT_KEYWORD:
    case LONG_KEYWORD:
    case STRING_KEYWORD:
    case CONSTANTS:
    case FILE:
    case URI:
    case IDENTIFIER:
    case CONTEXT:
    case INTEGER:
    case LONG:
    case STRING:
    case VARIABLE:{
      name = identifier();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case TYPE:{
        jj_consume_token(TYPE);
type = dataType(); explicitType = true;
        break;
        }
      default:
        jj_la1[83] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[84] = jj_gen;
      ;
    }
    lbrace();
psf = field.summaryFieldFor(name, type);
   if (explicitType) {
              psf.setHasExplicitType();
          }
    label_46:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case FULL:
      case STATIC:
      case DYNAMIC:
      case TOKENS:
      case MATCHED_ELEMENTS_ONLY:
      case BOLDING:
      case SOURCE:
      case TO:
      case SELECT_ELEMENTS_BY_SL:{
        break;
        }
      default:
        jj_la1[85] = jj_gen;
        break label_46;
      }
      summaryItem(psf);
      label_47:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NL:{
          break;
          }
        default:
          jj_la1[86] = jj_gen;
          break label_47;
        }
        jj_consume_token(NL);
      }
    }
    jj_consume_token(RBRACE);
}

/**
 * This rule consumes an item of a summary field block.
 *
 * @param field The field to modify.
 */
  final public void summaryItem(ParsedSummaryField field) throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case FULL:
    case STATIC:
    case DYNAMIC:
    case TOKENS:{
      summaryTransform(field);
      break;
      }
    case MATCHED_ELEMENTS_ONLY:
    case SELECT_ELEMENTS_BY_SL:{
      summaryElementsSelection(field);
      break;
      }
    case BOLDING:{
      summaryBolding(field);
      break;
      }
    case SOURCE:{
      summarySourceList(field);
      break;
      }
    case TO:{
      summaryDestinationList(field);
      break;
      }
    default:
      jj_la1[87] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

/**
 * This rule consumes a transform statement for a summary field element.
 *
 * @param field            The field to modify.
 */
  final public void summaryTransform(ParsedSummaryField field) throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DYNAMIC:{
      jj_consume_token(DYNAMIC);
field.setDynamic();
      break;
      }
    case FULL:
    case STATIC:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case FULL:{
        jj_consume_token(FULL);
        break;
        }
      case STATIC:{
        jj_consume_token(STATIC);
        break;
        }
      default:
        jj_la1[88] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
field.setFull();
      break;
      }
    case TOKENS:{
      jj_consume_token(TOKENS);
field.setTokens();
      break;
      }
    default:
      jj_la1[89] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void summaryElementsSelection(ParsedSummaryField field) throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case MATCHED_ELEMENTS_ONLY:{
      jj_consume_token(MATCHED_ELEMENTS_ONLY);
field.setMatchedElementsOnly();
      break;
      }
    case SELECT_ELEMENTS_BY_SL:{
      summaryElementsBy(field);
      break;
      }
    default:
      jj_la1[90] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void summaryElementsBy(ParsedSummaryField field) throws ParseException {String features;
    jj_consume_token(SELECT_ELEMENTS_BY_SL);
features = token.image.substring(token.image.indexOf(":") + 1).trim();
var featureList = getFeatureList(features);
        if (featureList.size() != 1) {
            throw new IllegalArgumentException("select-elements-by: feature list must have 1 feature, got " +
                                               featureList.size() + " features: " + featureList);
        }
        field.setSelectElementsBySummaryFeature(featureList.get(0).toString());
}

/**
 * This rule consumes a bolding statement for a summary field element.
 *
 * @param field The summary field to modify.
 */
  final public void summaryBolding(ParsedSummaryField field) throws ParseException {boolean bold;
    jj_consume_token(BOLDING);
    jj_consume_token(COLON);
    bold = bool();
field.setBold(bold);
}

/**
 * This rule consumes a source-list statement for a summary field element.
 *
 * @param field The summary field to modify.
 */
  final public void summarySourceList(ParsedSummaryField field) throws ParseException {String str;
    label_48:
    while (true) {
      jj_consume_token(SOURCE);
      jj_consume_token(COLON);
      str = identifier();
field.addSource(str);
      label_49:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case COMMA:{
          break;
          }
        default:
          jj_la1[91] = jj_gen;
          break label_49;
        }
        jj_consume_token(COMMA);
        str = identifier();
field.addSource(str);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case SOURCE:{
        break;
        }
      default:
        jj_la1[92] = jj_gen;
        break label_48;
      }
    }
}

/**
 * This rule consumes a destination-list statement for a summary field element.
 *
 * @param field The summary field to modify.
 */
  final public void summaryDestinationList(ParsedSummaryField field) throws ParseException {String str;
    jj_consume_token(TO);
    jj_consume_token(COLON);
    str = identifier();
field.addDestination(str);
    label_50:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[93] = jj_gen;
        break label_50;
      }
      jj_consume_token(COMMA);
      str = identifier();
field.addDestination(str);
    }
}

/**
 * This rule consumes a stemming block of a field element.
 *
 * @param field The field to modify.
 */
  final public void fieldStemming(ParsedField field) throws ParseException {String setting;
    jj_consume_token(STEMMING);
    jj_consume_token(COLON);
    setting = identifierWithDash();
field.setStemming(Stemming.get(setting));
}

/**
 * This rule consumes a stemming statement for a schema element.
 *
 * @param schema the schema to modify
 */
  final public void searchStemming(ParsedSchema schema) throws ParseException {String setting;
    jj_consume_token(STEMMING);
    jj_consume_token(COLON);
    setting = identifierWithDash();
schema.setStemming(Stemming.get(setting));
}

/**
 * This rule consumes a normalizing statement of a field element.
 * At the moment, this can only be used to turn off normalizing.
 *
 * @param field The field to modify.
 */
  final public void normalizing(ParsedField field) throws ParseException {String setting;
    jj_consume_token(NORMALIZING);
    jj_consume_token(COLON);
    setting = identifierWithDash();
field.setNormalizing(setting);
}

/**
 * This rule consumes a bolding statement of a field element.
 *
 * @param field The field to modify.
 */
  final public void bolding(ParsedField field) throws ParseException {boolean bold;
    jj_consume_token(BOLDING);
    jj_consume_token(COLON);
    bold = bool();
field.setBolding(bold);
}

/**
 * This rule consumes a dictionary statement of a field element.
 *
 * @param field The field to modify.
 */
  final public void dictionary(ParsedField field) throws ParseException {
    jj_consume_token(DICTIONARY);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
      dictionarySetting(field);
      break;
      }
    case NL:
    case LBRACE:{
      lbrace();
      label_51:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case HASH:
        case BTREE:
        case CASED:
        case UNCASED:{
          break;
          }
        default:
          jj_la1[94] = jj_gen;
          break label_51;
        }
        dictionarySetting(field);
        label_52:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case NL:{
            break;
            }
          default:
            jj_la1[95] = jj_gen;
            break label_52;
          }
          jj_consume_token(NL);
        }
      }
      jj_consume_token(RBRACE);
      break;
      }
    default:
      jj_la1[96] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }

}

  final public void dictionarySetting(ParsedField field) throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case HASH:{
      jj_consume_token(HASH);
field.dictionary(DictionaryOption.HASH);
      break;
      }
    case BTREE:{
      jj_consume_token(BTREE);
field.dictionary(DictionaryOption.BTREE);
      break;
      }
    case CASED:{
      jj_consume_token(CASED);
field.dictionary(DictionaryOption.CASED);
      break;
      }
    case UNCASED:{
      jj_consume_token(UNCASED);
field.dictionary(DictionaryOption.UNCASED);
      break;
      }
    default:
      jj_la1[97] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void queryCommand(ParsedField field) throws ParseException {String command;
    jj_consume_token(QUERY_COMMAND);
    jj_consume_token(COLON);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ANNOTATION:
    case ANNOTATIONREFERENCE:
    case SCHEMA:
    case SEARCH:
    case DIVERSITY:
    case MIN_GROUPS:
    case CUTOFF_FACTOR:
    case CUTOFF_STRATEGY:
    case LOOSE:
    case STRICT:
    case DOCUMENT:
    case OPERATION:
    case ON_MATCH:
    case ON_FIRST_PHASE:
    case ON_SECOND_PHASE:
    case ON_SUMMARY:
    case STRUCT:
    case INHERITS:
    case FIELD:
    case FIELDS:
    case FIELDSET:
    case STRUCT_FIELD:
    case IMPORT:
    case AS:
    case INDEXING:
    case SUMMARY_TO:
    case DOCUMENT_SUMMARY:
    case ELEMENT_GAP:
    case INFINITY:
    case RANK_TYPE:
    case WEIGHT:
    case TYPE:
    case INDEX:
    case INPUTS:
    case MTOKEN:
    case TEXT:
    case WORD:
    case GRAM:
    case GRAM_SIZE:
    case MAX_LENGTH:
    case PREFIX:
    case SUBSTRING:
    case SUFFIX:
    case CONSTANT:
    case ONNX_MODEL:
    case SIGNIFICANCE:
    case USE_MODEL:
    case WEAKAND:
    case STOPWORD_LIMIT:
    case ALLOW_DROP_ALL:
    case ADJUST_TARGET:
    case FILTER_THRESHOLD:
    case INTRAOP_THREADS:
    case INTEROP_THREADS:
    case GPU_DEVICE:
    case EXECUTION_MODE:
    case PARALLEL:
    case SEQUENTIAL:
    case MODEL:
    case MUTATE:
    case QUERY:
    case RANK_PROFILE:
    case RAW_AS_BASE64_IN_SUMMARY:
    case SUMMARY:
    case FULL:
    case STATIC:
    case DYNAMIC:
    case TOKENS:
    case MATCHED_ELEMENTS_ONLY:
    case SSCONTEXTUAL:
    case SSOVERRIDE:
    case SSTITLE:
    case SSURL:
    case PROPERTIES:
    case ATTRIBUTE:
    case SORTING:
    case DICTIONARY:
    case ASCENDING:
    case DESCENDING:
    case UCA:
    case RAW:
    case LOWERCASE:
    case FUNCTION:
    case LOCALE:
    case STRENGTH:
    case PRIMARY:
    case SECONDARY:
    case TERTIARY:
    case QUATERNARY:
    case IDENTICAL:
    case STEMMING:
    case NORMALIZING:
    case HASH:
    case BTREE:
    case CASED:
    case UNCASED:
    case BOLDING:
    case NONE:
    case ON:
    case OFF:
    case TRUE:
    case FALSE:
    case SYMMETRIC:
    case QUERY_COMMAND:
    case ALIAS:
    case MATCH:
    case RANK:
    case LITERAL:
    case EXACT:
    case FILTER:
    case NORMAL:
    case EXACT_TERMINATOR:
    case IGNORE_DEFAULT_RANK_FEATURES:
    case ID:
    case SOURCE:
    case TO:
    case DIRECT:
    case FROM_DISK:
    case OMIT_SUMMARY_FEATURES:
    case ALWAYS:
    case ON_DEMAND:
    case NEVER:
    case ENABLE_BIT_VECTORS:
    case ENABLE_ONLY_BIT_VECTOR:
    case FAST_ACCESS:
    case MUTABLE:
    case PAGED:
    case FAST_RANK:
    case FAST_SEARCH:
    case ARRAY:
    case WEIGHTEDSET:
    case MAP:
    case REFERENCE:
    case CREATE_IF_NONEXISTENT:
    case REMOVE_IF_ZERO:
    case MATCH_PHASE:
    case EVALUATION_POINT:
    case PRE_POST_FILTER_TIPPING_POINT:
    case ORDER:
    case MAX_FILTER_COVERAGE:
    case MAX_HITS:
    case FIRST_PHASE:
    case SECOND_PHASE:
    case GLOBAL_PHASE:
    case MACRO:
    case INLINE:
    case ARITY:
    case LOWER_BOUND:
    case UPPER_BOUND:
    case DENSE_POSTING_LIST_THRESHOLD:
    case ENABLE_BM25:
    case HNSW:
    case MAX_LINKS_PER_NODE:
    case DOUBLE_KEYWORD:
    case FLOAT_KEYWORD:
    case LONG_KEYWORD:
    case STRING_KEYWORD:
    case DISTANCE_METRIC:
    case NEIGHBORS_TO_EXPLORE_AT_INSERT:
    case MULTI_THREADED_INDEXING:
    case RANK_PROPERTIES:
    case RERANK_COUNT:
    case NUM_THREADS_PER_SEARCH:
    case MIN_HITS_PER_THREAD:
    case NUM_SEARCH_PARTITIONS:
    case TERMWISE_LIMIT:
    case POST_FILTER_THRESHOLD:
    case APPROXIMATE_THRESHOLD:
    case FILTER_FIRST_THRESHOLD:
    case FILTER_FIRST_EXPLORATION:
    case EXPLORATION_SLACK:
    case TARGET_HITS_MAX_ADJUSTMENT_FACTOR:
    case KEEP_RANK_COUNT:
    case RANK_SCORE_DROP_LIMIT:
    case CONSTANTS:
    case FILE:
    case URI:
    case IDENTIFIER:
    case IDENTIFIER_WITH_DASH:
    case CONTEXT:
    case INTEGER:
    case LONG:
    case STRING:
    case VARIABLE:{
      command = identifierWithDash();
      break;
      }
    case DOUBLEQUOTEDSTRING:
    case SINGLEQUOTEDSTRING:{
      command = quotedString();
      break;
      }
    default:
      jj_la1[98] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
field.addQueryCommand(command);
}

  final public void alias(ParsedField field) throws ParseException {String aliasedName = field.name();
    String alias;
    jj_consume_token(ALIAS);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ANNOTATION:
    case ANNOTATIONREFERENCE:
    case SCHEMA:
    case SEARCH:
    case DIVERSITY:
    case LOOSE:
    case STRICT:
    case DOCUMENT:
    case OPERATION:
    case STRUCT:
    case INHERITS:
    case FIELD:
    case FIELDS:
    case FIELDSET:
    case IMPORT:
    case AS:
    case INDEXING:
    case INFINITY:
    case WEIGHT:
    case TYPE:
    case INDEX:
    case INPUTS:
    case MTOKEN:
    case TEXT:
    case WORD:
    case GRAM:
    case PREFIX:
    case SUBSTRING:
    case SUFFIX:
    case CONSTANT:
    case SIGNIFICANCE:
    case WEAKAND:
    case PARALLEL:
    case SEQUENTIAL:
    case MODEL:
    case MUTATE:
    case QUERY:
    case SUMMARY:
    case FULL:
    case STATIC:
    case DYNAMIC:
    case TOKENS:
    case SSCONTEXTUAL:
    case SSOVERRIDE:
    case SSTITLE:
    case SSURL:
    case PROPERTIES:
    case ATTRIBUTE:
    case SORTING:
    case DICTIONARY:
    case ASCENDING:
    case DESCENDING:
    case UCA:
    case RAW:
    case LOWERCASE:
    case FUNCTION:
    case LOCALE:
    case STRENGTH:
    case PRIMARY:
    case SECONDARY:
    case TERTIARY:
    case QUATERNARY:
    case IDENTICAL:
    case STEMMING:
    case NORMALIZING:
    case HASH:
    case BTREE:
    case CASED:
    case UNCASED:
    case BOLDING:
    case NONE:
    case ON:
    case OFF:
    case TRUE:
    case FALSE:
    case SYMMETRIC:
    case ALIAS:
    case MATCH:
    case RANK:
    case LITERAL:
    case EXACT:
    case FILTER:
    case NORMAL:
    case ID:
    case SOURCE:
    case TO:
    case DIRECT:
    case ALWAYS:
    case NEVER:
    case MUTABLE:
    case PAGED:
    case ARRAY:
    case WEIGHTEDSET:
    case MAP:
    case REFERENCE:
    case ORDER:
    case MACRO:
    case INLINE:
    case ARITY:
    case HNSW:
    case DOUBLE_KEYWORD:
    case FLOAT_KEYWORD:
    case LONG_KEYWORD:
    case STRING_KEYWORD:
    case CONSTANTS:
    case FILE:
    case URI:
    case IDENTIFIER:
    case CONTEXT:
    case INTEGER:
    case LONG:
    case STRING:
    case VARIABLE:{
      aliasedName = identifier();
      break;
      }
    default:
      jj_la1[99] = jj_gen;
      ;
    }
    jj_consume_token(COLON);
    alias = identifierWithDash();
field.addAlias(aliasedName, alias);
}

  final public void matchSettings(ParsedMatchSettings matchInfo) throws ParseException {
    jj_consume_token(MATCH);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
      matchType(matchInfo);
      break;
      }
    case NL:
    case LBRACE:{
      lbrace();
      label_53:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case MTOKEN:
        case TEXT:
        case WORD:
        case GRAM:
        case GRAM_SIZE:
        case MAX_LENGTH:
        case MAX_OCCURRENCES:
        case MAX_TOKEN_LENGTH:
        case PREFIX:
        case SUBSTRING:
        case SUFFIX:
        case CASED:
        case UNCASED:
        case EXACT:
        case EXACT_TERMINATOR:{
          break;
          }
        default:
          jj_la1[100] = jj_gen;
          break label_53;
        }
        matchItem(matchInfo);
        label_54:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case NL:{
            break;
            }
          default:
            jj_la1[101] = jj_gen;
            break label_54;
          }
          jj_consume_token(NL);
        }
      }
      jj_consume_token(RBRACE);
      break;
      }
    default:
      jj_la1[102] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void matchType(ParsedMatchSettings matchInfo) throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case MTOKEN:{
      jj_consume_token(MTOKEN);
matchInfo.setType(MatchType.TEXT);
      break;
      }
    case TEXT:{
      jj_consume_token(TEXT);
matchInfo.setType(MatchType.TEXT);
      break;
      }
    case WORD:{
      jj_consume_token(WORD);
matchInfo.setType(MatchType.WORD);
      break;
      }
    case EXACT:{
      jj_consume_token(EXACT);
matchInfo.setType(MatchType.EXACT);
      break;
      }
    case GRAM:{
      jj_consume_token(GRAM);
matchInfo.setType(MatchType.GRAM);
      break;
      }
    case CASED:{
      jj_consume_token(CASED);
matchInfo.setCase(Case.CASED);
      break;
      }
    case UNCASED:{
      jj_consume_token(UNCASED);
matchInfo.setCase(Case.UNCASED);
      break;
      }
    case PREFIX:{
      jj_consume_token(PREFIX);
matchInfo.setAlgorithm(MatchAlgorithm.PREFIX);
      break;
      }
    case SUBSTRING:{
      jj_consume_token(SUBSTRING);
matchInfo.setAlgorithm(MatchAlgorithm.SUBSTRING);
      break;
      }
    case SUFFIX:{
      jj_consume_token(SUFFIX);
matchInfo.setAlgorithm(MatchAlgorithm.SUFFIX);
      break;
      }
    default:
      jj_la1[103] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

/**
 * This rule consumes a single match item for a match block.
 *
 * @param matchInfo The settings to modify.
 */
  final public void matchItem(ParsedMatchSettings matchInfo) throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case MTOKEN:
    case TEXT:
    case WORD:
    case GRAM:
    case PREFIX:
    case SUBSTRING:
    case SUFFIX:
    case CASED:
    case UNCASED:
    case EXACT:{
      matchType(matchInfo);
      break;
      }
    case EXACT_TERMINATOR:{
      exactTerminator(matchInfo);
      break;
      }
    case GRAM_SIZE:{
      gramSize(matchInfo);
      break;
      }
    case MAX_LENGTH:{
      matchSize(matchInfo);
      break;
      }
    case MAX_OCCURRENCES:{
      maxTermOccurrences(matchInfo);
      break;
      }
    case MAX_TOKEN_LENGTH:{
      maxTokenLength(matchInfo);
      break;
      }
    default:
      jj_la1[104] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void exactTerminator(ParsedMatchSettings matchInfo) throws ParseException {String terminator;
    jj_consume_token(EXACT_TERMINATOR);
    jj_consume_token(COLON);
    terminator = quotedString();
matchInfo.setExactTerminator(terminator);
}

  final public void gramSize(ParsedMatchSettings matchInfo) throws ParseException {int gramSize;
    jj_consume_token(GRAM_SIZE);
    jj_consume_token(COLON);
    gramSize = integer();
matchInfo.setGramSize(gramSize);
}

  final public void matchSize(ParsedMatchSettings matchInfo) throws ParseException {int matchSize;
    jj_consume_token(MAX_LENGTH);
    jj_consume_token(COLON);
    matchSize = integer();
matchInfo.setMaxLength(matchSize);
}

  final public void maxTermOccurrences(ParsedMatchSettings matchInfo) throws ParseException {int maxTermOccurrences;
    jj_consume_token(MAX_OCCURRENCES);
    jj_consume_token(COLON);
    maxTermOccurrences = integer();
matchInfo.setMaxTermOccurrences(maxTermOccurrences);
}

  final public void maxTokenLength(ParsedMatchSettings matchInfo) throws ParseException {int maxTokenLength;
    jj_consume_token(MAX_TOKEN_LENGTH);
    jj_consume_token(COLON);
    maxTokenLength = integer();
matchInfo.setMaxTokenLength(maxTokenLength);
}

/**
 * Consumes a rank statement of a field element.
 *
 * @param field The field to modify.
 */
  final public void rank(ParsedField field) throws ParseException {
    jj_consume_token(RANK);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
      rankSetting(field);
      break;
      }
    case NL:
    case LBRACE:{
      lbrace();
      label_55:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case LITERAL:
        case FILTER:
        case NORMAL:{
          break;
          }
        default:
          jj_la1[105] = jj_gen;
          break label_55;
        }
        rankSetting(field);
        label_56:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case NL:{
            break;
            }
          default:
            jj_la1[106] = jj_gen;
            break label_56;
          }
          jj_consume_token(NL);
        }
      }
      jj_consume_token(RBRACE);
      break;
      }
    default:
      jj_la1[107] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

/**
 * Consumes a single rank setting of a rank statement.
 *
 * @param field The field to modify.
 */
  final public void rankSetting(ParsedField field) throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LITERAL:{
      jj_consume_token(LITERAL);
field.setLiteral(true);
      break;
      }
    case NORMAL:{
      jj_consume_token(NORMAL);
field.setNormal(true);
      break;
      }
    case FILTER:{
      jj_consume_token(FILTER);
field.setFilter(true);
      break;
      }
    default:
      jj_la1[108] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

/**
 * Consumes an id statement of a field body block.
 *
 * @param field    The field to modify.
 */
  final public void id(ParsedField field) throws ParseException {int fieldId;
    jj_consume_token(ID);
    jj_consume_token(COLON);
    fieldId = integer();
field.setId(fieldId);
}

/**
 * Consumes a document-summary block from within a schema block.
 *
 * @param schema the schema object to add content to
 */
  final public void documentSummary(ParsedSchema schema) throws ParseException {String name;
    ParsedDocumentSummary summary;
    jj_consume_token(DOCUMENT_SUMMARY);
    name = identifierWithDash();
summary = new ParsedDocumentSummary(name);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case INHERITS:{
      inheritsDocumentSummary(summary);
      break;
      }
    default:
      jj_la1[109] = jj_gen;
      ;
    }
    lbrace();
    label_57:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NL:
      case SUMMARY:
      case FROM_DISK:
      case OMIT_SUMMARY_FEATURES:{
        break;
        }
      default:
        jj_la1[110] = jj_gen;
        break label_57;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case FROM_DISK:{
        jj_consume_token(FROM_DISK);
summary.setFromDisk(true);
        break;
        }
      case OMIT_SUMMARY_FEATURES:{
        jj_consume_token(OMIT_SUMMARY_FEATURES);
summary.setOmitSummaryFeatures(true);
        break;
        }
      case SUMMARY:{
        documentSummaryItem(summary);
        break;
        }
      case NL:{
        jj_consume_token(NL);
        break;
        }
      default:
        jj_la1[111] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RBRACE);
schema.addDocumentSummary(summary);
}

/**
 * This rule consumes an inherits statement of a document summary.
 *
 * @param documentSummary the document summary to modify
 */
  final public void inheritsDocumentSummary(ParsedDocumentSummary documentSummary) throws ParseException {String name;
    jj_consume_token(INHERITS);
    name = identifierWithDash();
documentSummary.inherit(name);
    label_58:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[112] = jj_gen;
        break label_58;
      }
      jj_consume_token(COMMA);
      name = identifierWithDash();
documentSummary.inherit(name);
    }
}

/**
 * Consumes a single document-summary item.
 *
 * @param summary The document summary to modify.
 */
  final public void documentSummaryItem(ParsedDocumentSummary summary) throws ParseException {
    summaryInDocument(summary);
}

/**
 * Consumes an index block in a schema element.
 *
 * @param schema the schema object to add content to
 */
  final public void indexOutsideDoc(ParsedSchema schema) throws ParseException {ParsedIndex op;
    String indexName;
    jj_consume_token(INDEX);
    indexName = identifier();
op = new ParsedIndex(indexName);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
      indexBody(op);
      label_59:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case COMMA:{
          break;
          }
        default:
          jj_la1[113] = jj_gen;
          break label_59;
        }
        jj_consume_token(COMMA);
        indexBody(op);
      }
      break;
      }
    case NL:
    case LBRACE:{
      lbrace();
      label_60:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case PREFIX:
        case STEMMING:
        case ALIAS:
        case ARITY:
        case LOWER_BOUND:
        case UPPER_BOUND:
        case DENSE_POSTING_LIST_THRESHOLD:
        case ENABLE_BM25:
        case HNSW:{
          break;
          }
        default:
          jj_la1[114] = jj_gen;
          break label_60;
        }
        indexBody(op);
        label_61:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case NL:{
            break;
            }
          default:
            jj_la1[115] = jj_gen;
            break label_61;
          }
          jj_consume_token(NL);
        }
      }
      jj_consume_token(RBRACE);
      break;
      }
    default:
      jj_la1[116] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
schema.addIndex(op);
}

/**
 * Consumes an index block for a field element.
 *
 * @param field  the field to modify
 */
  final public void indexInsideField(ParsedField field) throws ParseException {ParsedIndex op;
    String indexName = field.name();
    jj_consume_token(INDEX);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ANNOTATION:
    case ANNOTATIONREFERENCE:
    case SCHEMA:
    case SEARCH:
    case DIVERSITY:
    case LOOSE:
    case STRICT:
    case DOCUMENT:
    case OPERATION:
    case STRUCT:
    case INHERITS:
    case FIELD:
    case FIELDS:
    case FIELDSET:
    case IMPORT:
    case AS:
    case INDEXING:
    case INFINITY:
    case WEIGHT:
    case TYPE:
    case INDEX:
    case INPUTS:
    case MTOKEN:
    case TEXT:
    case WORD:
    case GRAM:
    case PREFIX:
    case SUBSTRING:
    case SUFFIX:
    case CONSTANT:
    case SIGNIFICANCE:
    case WEAKAND:
    case PARALLEL:
    case SEQUENTIAL:
    case MODEL:
    case MUTATE:
    case QUERY:
    case SUMMARY:
    case FULL:
    case STATIC:
    case DYNAMIC:
    case TOKENS:
    case SSCONTEXTUAL:
    case SSOVERRIDE:
    case SSTITLE:
    case SSURL:
    case PROPERTIES:
    case ATTRIBUTE:
    case SORTING:
    case DICTIONARY:
    case ASCENDING:
    case DESCENDING:
    case UCA:
    case RAW:
    case LOWERCASE:
    case FUNCTION:
    case LOCALE:
    case STRENGTH:
    case PRIMARY:
    case SECONDARY:
    case TERTIARY:
    case QUATERNARY:
    case IDENTICAL:
    case STEMMING:
    case NORMALIZING:
    case HASH:
    case BTREE:
    case CASED:
    case UNCASED:
    case BOLDING:
    case NONE:
    case ON:
    case OFF:
    case TRUE:
    case FALSE:
    case SYMMETRIC:
    case ALIAS:
    case MATCH:
    case RANK:
    case LITERAL:
    case EXACT:
    case FILTER:
    case NORMAL:
    case ID:
    case SOURCE:
    case TO:
    case DIRECT:
    case ALWAYS:
    case NEVER:
    case MUTABLE:
    case PAGED:
    case ARRAY:
    case WEIGHTEDSET:
    case MAP:
    case REFERENCE:
    case ORDER:
    case MACRO:
    case INLINE:
    case ARITY:
    case HNSW:
    case DOUBLE_KEYWORD:
    case FLOAT_KEYWORD:
    case LONG_KEYWORD:
    case STRING_KEYWORD:
    case CONSTANTS:
    case FILE:
    case URI:
    case IDENTIFIER:
    case CONTEXT:
    case INTEGER:
    case LONG:
    case STRING:
    case VARIABLE:{
      indexName = identifier();
      break;
      }
    default:
      jj_la1[117] = jj_gen;
      ;
    }
// TODO: Remove support for index with different name than field name in Vespa 9
        if ( ! indexName.equals(field.name()))
            deployLogger.logApplicationPackage(Level.WARNING, "Creating an index for field '" + field.name() +
            "' with a different name '" + indexName + "' than the field name" +
            " is deprecated, and support will be removed in Vespa 9. Define a field with the wanted name outside the document instead.");
        op = new ParsedIndex(indexName);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
      indexBody(op);
      label_62:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case COMMA:{
          break;
          }
        default:
          jj_la1[118] = jj_gen;
          break label_62;
        }
        jj_consume_token(COMMA);
        indexBody(op);
      }
      break;
      }
    case NL:
    case LBRACE:{
      lbrace();
      label_63:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case PREFIX:
        case STEMMING:
        case ALIAS:
        case ARITY:
        case LOWER_BOUND:
        case UPPER_BOUND:
        case DENSE_POSTING_LIST_THRESHOLD:
        case ENABLE_BM25:
        case HNSW:{
          break;
          }
        default:
          jj_la1[119] = jj_gen;
          break label_63;
        }
        indexBody(op);
        label_64:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case NL:{
            break;
            }
          default:
            jj_la1[120] = jj_gen;
            break label_64;
          }
          jj_consume_token(NL);
        }
      }
      jj_consume_token(RBRACE);
      break;
      }
    default:
      jj_la1[121] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
field.addIndex(op);
}

/**
 * Consumes a single index statement for an index block.
 *
 * @param index The index to modify.
 */
  final public void indexBody(ParsedIndex index) throws ParseException {String str;
    int arity;
    long num;
    double threshold;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case PREFIX:{
      jj_consume_token(PREFIX);
index.setPrefix(true);
      break;
      }
    case ALIAS:{
      jj_consume_token(ALIAS);
      jj_consume_token(COLON);
      str = identifierWithDash();
index.addAlias(str);
      break;
      }
    case STEMMING:{
      jj_consume_token(STEMMING);
      jj_consume_token(COLON);
      str = identifierWithDash();
index.setStemming(Stemming.get(str));
      break;
      }
    case ARITY:{
      jj_consume_token(ARITY);
      jj_consume_token(COLON);
      arity = integer();
index.setArity(arity);
      break;
      }
    case LOWER_BOUND:{
      jj_consume_token(LOWER_BOUND);
      jj_consume_token(COLON);
      num = longValue();
index.setLowerBound(num);
      break;
      }
    case UPPER_BOUND:{
      jj_consume_token(UPPER_BOUND);
      jj_consume_token(COLON);
      num = longValue();
index.setUpperBound(num);
      break;
      }
    case DENSE_POSTING_LIST_THRESHOLD:{
      jj_consume_token(DENSE_POSTING_LIST_THRESHOLD);
      jj_consume_token(COLON);
      threshold = floatValue();
index.setDensePostingListThreshold(threshold);
      break;
      }
    case ENABLE_BM25:{
      jj_consume_token(ENABLE_BM25);
index.setEnableBm25(true);
      break;
      }
    case HNSW:{
      hnswIndex(index);

      break;
      }
    default:
      jj_la1[122] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void hnswIndex(ParsedIndex index) throws ParseException {HnswIndexParams.Builder params = new HnswIndexParams.Builder();
    if (jj_2_8(2147483647)) {
      jj_consume_token(HNSW);
      lbrace();
      label_65:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case MAX_LINKS_PER_NODE:
        case NEIGHBORS_TO_EXPLORE_AT_INSERT:
        case MULTI_THREADED_INDEXING:{
          break;
          }
        default:
          jj_la1[123] = jj_gen;
          break label_65;
        }
        hnswIndexBody(params);
        label_66:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case NL:{
            break;
            }
          default:
            jj_la1[124] = jj_gen;
            break label_66;
          }
          jj_consume_token(NL);
        }
      }
      jj_consume_token(RBRACE);
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case HNSW:{
        jj_consume_token(HNSW);
        break;
        }
      default:
        jj_la1[125] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
index.setHnswIndexParams(params.build());
}

  final public void hnswIndexBody(HnswIndexParams.Builder params) throws ParseException {int num;
    boolean bool;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case MAX_LINKS_PER_NODE:{
      jj_consume_token(MAX_LINKS_PER_NODE);
      jj_consume_token(COLON);
      num = integer();
params.setMaxLinksPerNode(num);
      break;
      }
    case NEIGHBORS_TO_EXPLORE_AT_INSERT:{
      jj_consume_token(NEIGHBORS_TO_EXPLORE_AT_INSERT);
      jj_consume_token(COLON);
      num = integer();
params.setNeighborsToExploreAtInsert(num);
      break;
      }
    case MULTI_THREADED_INDEXING:{
      jj_consume_token(MULTI_THREADED_INDEXING);
      jj_consume_token(COLON);
      bool = bool();
params.setMultiThreadedIndexing(bool);
      break;
      }
    default:
      jj_la1[126] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void onnxModelInSchema(ParsedSchema schema) throws ParseException {OnnxModel onnxModel;
    onnxModel = onnxModel();
schema.add(onnxModel);
}

  final public void onnxModelInProfile(ParsedRankProfile profile) throws ParseException {OnnxModel onnxModel;
    onnxModel = onnxModel();
profile.add(onnxModel);
}

/** Consumes an onnx-model block. */
  final public OnnxModel onnxModel() throws ParseException {String name;
    OnnxModel onnxModel;
    jj_consume_token(ONNX_MODEL);
    name = identifier();
onnxModel = new OnnxModel(name);
    lbrace();
    label_67:
    while (true) {
      onnxModelItem(onnxModel);
      label_68:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NL:{
          break;
          }
        default:
          jj_la1[127] = jj_gen;
          break label_68;
        }
        jj_consume_token(NL);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case INTRAOP_THREADS:
      case INTEROP_THREADS:
      case GPU_DEVICE:
      case EXECUTION_MODE:
      case FILE:
      case URI:
      case ONNX_INPUT_SL:
      case ONNX_OUTPUT_SL:{
        break;
        }
      default:
        jj_la1[128] = jj_gen;
        break label_67;
      }
    }
    jj_consume_token(RBRACE);
{if ("" != null) return onnxModel;}
    throw new IllegalStateException ("Missing return statement in function");
}

/**
 * Consumes an onnx-model block.
 *
 * @param onnxModel the onnxModel to modify
 */
  final public void onnxModelItem(OnnxModel onnxModel) throws ParseException {String path = null;
    int num;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case FILE:{
      path = fileItem();
onnxModel.setFileName(path);
      break;
      }
    case URI:{
      path = uriItem();
onnxModel.setUri(path);
      break;
      }
    case GPU_DEVICE:{
      jj_consume_token(GPU_DEVICE);
      jj_consume_token(COLON);
      num = integer();
onnxModel.setGpuDevice(num, false);
      break;
      }
    case INTRAOP_THREADS:{
      jj_consume_token(INTRAOP_THREADS);
      jj_consume_token(COLON);
      num = integer();
onnxModel.setStatelessIntraOpThreads(num);
      break;
      }
    case INTEROP_THREADS:{
      jj_consume_token(INTEROP_THREADS);
      jj_consume_token(COLON);
      num = integer();
onnxModel.setStatelessInterOpThreads(num);
      break;
      }
    case EXECUTION_MODE:{
      jj_consume_token(EXECUTION_MODE);
      jj_consume_token(COLON);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PARALLEL:{
        jj_consume_token(PARALLEL);
onnxModel.setStatelessExecutionMode("parallel");
        break;
        }
      case SEQUENTIAL:{
        jj_consume_token(SEQUENTIAL);
onnxModel.setStatelessExecutionMode("sequential");
        break;
        }
      default:
        jj_la1[129] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case ONNX_INPUT_SL:{
      jj_consume_token(ONNX_INPUT_SL);
String name = token.image.substring(5, token.image.lastIndexOf(":")).trim();
            if (name.startsWith("\"")) { name = name.substring(1, name.length() - 1); }
            String source = token.image.substring(token.image.lastIndexOf(":") + 1).trim();
            onnxModel.addInputNameMapping(name, source);
      break;
      }
    case ONNX_OUTPUT_SL:{
      jj_consume_token(ONNX_OUTPUT_SL);
String name = token.image.substring(6, token.image.lastIndexOf(":")).trim();
            if (name.startsWith("\"")) { name = name.substring(1, name.length() - 1); }
            String as = token.image.substring(token.image.lastIndexOf(":") + 1).trim();
            onnxModel.addOutputNameMapping(name, as);
      break;
      }
    default:
      jj_la1[130] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

/**
 * Consumes a constant block of a schema element.
 *
 * @param schema the schema object to add content to
 */
  final public void rankingConstant(ParsedSchema schema) throws ParseException {String name;
    String path = null;
    DistributableResource.PathType pathType = DistributableResource.PathType.FILE;
    TensorType type = null;
    jj_consume_token(CONSTANT);
    name = identifier();
    lbrace();
    label_69:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case FILE:{
        path = fileItem();
pathType = DistributableResource.PathType.FILE;
        break;
        }
      case URI:{
        path = uriItem();
pathType = DistributableResource.PathType.URI;
        break;
        }
      case TYPE:{
        type = tensorTypeWithPrefix(rankingConstantErrorMessage(name));
        label_70:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case NL:{
            break;
            }
          default:
            jj_la1[131] = jj_gen;
            break label_70;
          }
          jj_consume_token(NL);
        }
        break;
        }
      default:
        jj_la1[132] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case TYPE:
      case FILE:
      case URI:{
        break;
        }
      default:
        jj_la1[133] = jj_gen;
        break label_69;
      }
    }
    jj_consume_token(RBRACE);
if (type == null) throw new IllegalArgumentException("constant '" + name + "' must have a type");
        if (path == null) throw new IllegalArgumentException("constant '" + name + "' must have a file");
        schema.add(new RankProfile.Constant(FeatureNames.asConstantFeature(name), type, path, pathType));
}

  final public String fileItem() throws ParseException {String path;
    jj_consume_token(FILE);
    jj_consume_token(COLON);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case FILE_PATH:{
      jj_consume_token(FILE_PATH);
      break;
      }
    case STRING:{
      jj_consume_token(STRING);
      break;
      }
    case IDENTIFIER:{
      jj_consume_token(IDENTIFIER);
      break;
      }
    default:
      jj_la1[134] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
path = com.yahoo.path.Path.fromString(token.image).getRelative();

    label_71:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NL:{
        break;
        }
      default:
        jj_la1[135] = jj_gen;
        break label_71;
      }
      jj_consume_token(NL);
    }
{if ("" != null) return path;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String uriItem() throws ParseException {String path;
    jj_consume_token(URI);
    jj_consume_token(COLON);
    jj_consume_token(URI_PATH);
path = token.image;
    label_72:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NL:{
        break;
        }
      default:
        jj_la1[136] = jj_gen;
        break label_72;
      }
      jj_consume_token(NL);
    }
{if ("" != null) return path;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String rankingConstantErrorMessage(String name) throws ParseException {
{if ("" != null) return "For ranking constant ' " + name + "'";}
    throw new IllegalStateException ("Missing return statement in function");
}

/**
 * Consumes a rank-profile block of a schema element.
 *
 * @param schema the schema object to add content to
 */
  final public void rankProfile(ParsedSchema schema) throws ParseException {String name;
    ParsedRankProfile profile;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case MODEL:{
      jj_consume_token(MODEL);
      break;
      }
    case RANK_PROFILE:{
      jj_consume_token(RANK_PROFILE);
      break;
      }
    default:
      jj_la1[137] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    name = identifierWithDash();
profile = new ParsedRankProfile(name);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case INHERITS:{
      inheritsRankProfile(profile);
      break;
      }
    default:
      jj_la1[138] = jj_gen;
      ;
    }
    lbrace();
    label_73:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DIVERSITY:
      case STRICT:
      case RANK_TYPE:
      case WEIGHT:
      case INPUTS:
      case ONNX_MODEL:
      case SIGNIFICANCE:
      case WEAKAND:
      case FILTER_THRESHOLD:
      case MUTATE:
      case FUNCTION:
      case RANK:
      case IGNORE_DEFAULT_RANK_FEATURES:
      case MATCH_PHASE:
      case FIRST_PHASE:
      case SECOND_PHASE:
      case GLOBAL_PHASE:
      case MACRO:
      case MATCHFEATURES_SL:
      case MATCHFEATURES_ML:
      case MATCHFEATURES_ML_INHERITS:
      case SUMMARYFEATURES_SL:
      case SUMMARYFEATURES_ML:
      case SUMMARYFEATURES_ML_INHERITS:
      case RANKFEATURES_SL:
      case RANKFEATURES_ML:
      case RANK_PROPERTIES:
      case NUM_THREADS_PER_SEARCH:
      case MIN_HITS_PER_THREAD:
      case NUM_SEARCH_PARTITIONS:
      case TERMWISE_LIMIT:
      case POST_FILTER_THRESHOLD:
      case APPROXIMATE_THRESHOLD:
      case FILTER_FIRST_THRESHOLD:
      case FILTER_FIRST_EXPLORATION:
      case EXPLORATION_SLACK:
      case TARGET_HITS_MAX_ADJUSTMENT_FACTOR:
      case CONSTANTS:{
        break;
        }
      default:
        jj_la1[139] = jj_gen;
        break label_73;
      }
      rankProfileItem(schema, profile);
      label_74:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NL:{
          break;
          }
        default:
          jj_la1[140] = jj_gen;
          break label_74;
        }
        jj_consume_token(NL);
      }
    }
    jj_consume_token(RBRACE);
schema.addRankProfile(profile);
}

/**
 * This rule consumes a single statement for a rank-profile block.
 *
 * @param profile The rank profile to modify.
 */
  final public void rankProfileItem(ParsedSchema schema, ParsedRankProfile profile) throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case RANK_TYPE:{
      fieldRankType(profile);
      break;
      }
    case WEIGHT:{
      fieldWeight(profile);
      break;
      }
    case RANK:{
      fieldRankFilter(profile);
      break;
      }
    case FIRST_PHASE:{
      firstPhase(profile);
      break;
      }
    case MATCH_PHASE:{
      matchPhase(profile);
      break;
      }
    case DIVERSITY:{
      diversity(profile);
      break;
      }
    case FUNCTION:
    case MACRO:{
      function(profile);
      break;
      }
    case MUTATE:{
      mutate(profile);
      break;
      }
    case IGNORE_DEFAULT_RANK_FEATURES:{
      ignoreRankFeatures(profile);
      break;
      }
    case NUM_THREADS_PER_SEARCH:{
      numThreadsPerSearch(profile);
      break;
      }
    case MIN_HITS_PER_THREAD:{
      minHitsPerThread(profile);
      break;
      }
    case NUM_SEARCH_PARTITIONS:{
      numSearchPartitions(profile);
      break;
      }
    case TERMWISE_LIMIT:{
      termwiseLimit(profile);
      break;
      }
    case POST_FILTER_THRESHOLD:{
      postFilterThreshold(profile);
      break;
      }
    case APPROXIMATE_THRESHOLD:{
      approximateThreshold(profile);
      break;
      }
    case FILTER_FIRST_THRESHOLD:{
      filterFirstThreshold(profile);
      break;
      }
    case FILTER_FIRST_EXPLORATION:{
      filterFirstExploration(profile);
      break;
      }
    case EXPLORATION_SLACK:{
      explorationSlack(profile);
      break;
      }
    case TARGET_HITS_MAX_ADJUSTMENT_FACTOR:{
      targetHitsMaxAdjustmentFactor(profile);
      break;
      }
    case RANKFEATURES_SL:
    case RANKFEATURES_ML:{
      rankFeatures(profile);
      break;
      }
    case RANK_PROPERTIES:{
      rankProperties(profile);
      break;
      }
    case SECOND_PHASE:{
      secondPhase(profile);
      break;
      }
    case GLOBAL_PHASE:{
      globalPhase(profile);
      break;
      }
    case INPUTS:{
      inputs(profile);
      break;
      }
    case CONSTANTS:{
      constants(schema, profile);
      break;
      }
    case MATCHFEATURES_SL:
    case MATCHFEATURES_ML:
    case MATCHFEATURES_ML_INHERITS:{
      matchFeatures(profile);
      break;
      }
    case SUMMARYFEATURES_SL:
    case SUMMARYFEATURES_ML:
    case SUMMARYFEATURES_ML_INHERITS:{
      summaryFeatures(profile);
      break;
      }
    case ONNX_MODEL:{
      onnxModelInProfile(profile);
      break;
      }
    case STRICT:{
      strict(profile);
      break;
      }
    case SIGNIFICANCE:{
      significance(profile);
      break;
      }
    case WEAKAND:{
      weakand(profile);
      break;
      }
    case FILTER_THRESHOLD:{
      filterThreshold(profile);
      break;
      }
    default:
      jj_la1[141] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

/**
 * Consumes an inherits statement of a rank-profile.
 *
 * @param profile the profile to modify
 */
  final public void inheritsRankProfile(ParsedRankProfile profile) throws ParseException {String name;
    jj_consume_token(INHERITS);
    name = identifierWithDash();
profile.inherit(name);
    label_75:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[142] = jj_gen;
        break label_75;
      }
      jj_consume_token(COMMA);
      name = identifierWithDash();
profile.inherit(name);
    }
}

/**
 * This rule consumes an mutate statement of a rank-profile.
 *
 * @param profile The profile to modify.
 */
  final public void mutate(ParsedRankProfile profile) throws ParseException {
    jj_consume_token(MUTATE);
    lbrace();
    label_76:
    while (true) {
      mutate_operation(profile);
      jj_consume_token(NL);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ON_MATCH:
      case ON_FIRST_PHASE:
      case ON_SECOND_PHASE:
      case ON_SUMMARY:{
        break;
        }
      default:
        jj_la1[143] = jj_gen;
        break label_76;
      }
    }
    jj_consume_token(RBRACE);
}

  final public void mutate_operation(ParsedRankProfile profile) throws ParseException {String attribute, operation;
    RankProfile.MutateOperation.Phase phase;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ON_MATCH:{
      jj_consume_token(ON_MATCH);
phase = RankProfile.MutateOperation.Phase.on_match;
      break;
      }
    case ON_FIRST_PHASE:{
      jj_consume_token(ON_FIRST_PHASE);
phase = RankProfile.MutateOperation.Phase.on_first_phase;
      break;
      }
    case ON_SECOND_PHASE:{
      jj_consume_token(ON_SECOND_PHASE);
phase = RankProfile.MutateOperation.Phase.on_second_phase;
      break;
      }
    case ON_SUMMARY:{
      jj_consume_token(ON_SUMMARY);
phase = RankProfile.MutateOperation.Phase.on_summary;
      break;
      }
    default:
      jj_la1[144] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    lbrace();
    attribute = identifier();
    operation = mutate_expr();
    label_77:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NL:{
        break;
        }
      default:
        jj_la1[145] = jj_gen;
        break label_77;
      }
      jj_consume_token(NL);
    }
    jj_consume_token(RBRACE);
profile.addMutateOperation(phase, attribute, operation);
}

  final public String mutate_expr() throws ParseException {String op;
     Number constant = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case 233:{
      jj_consume_token(233);
      break;
      }
    case 234:{
      jj_consume_token(234);
      break;
      }
    case 235:{
      jj_consume_token(235);
      break;
      }
    default:
      jj_la1[146] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
op = token.image;
    constant = number();
{if ("" != null) return constant != null ? (op + constant) : op;}
    throw new IllegalStateException ("Missing return statement in function");
}

/**
 * This rule consumes a function statement of a rank-profile.
 *
 * @param profile The profile to modify.
 */
  final public void function(ParsedRankProfile profile) throws ParseException {String name, expression, parameter;
    boolean inline = false;
    ParsedRankFunction func;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case FUNCTION:{
      jj_consume_token(FUNCTION);
      break;
      }
    case MACRO:{
      jj_consume_token(MACRO);
      break;
      }
    default:
      jj_la1[147] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    inline = inline();
    name = identifier();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case 236:{
      jj_consume_token(236);
name = name + token.image;
      break;
      }
    default:
      jj_la1[148] = jj_gen;
      ;
    }
    jj_consume_token(237);
func = new ParsedRankFunction(name);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ANNOTATION:
    case ANNOTATIONREFERENCE:
    case SCHEMA:
    case SEARCH:
    case DIVERSITY:
    case LOOSE:
    case STRICT:
    case DOCUMENT:
    case OPERATION:
    case STRUCT:
    case INHERITS:
    case FIELD:
    case FIELDS:
    case FIELDSET:
    case IMPORT:
    case AS:
    case INDEXING:
    case INFINITY:
    case WEIGHT:
    case TYPE:
    case INDEX:
    case INPUTS:
    case MTOKEN:
    case TEXT:
    case WORD:
    case GRAM:
    case PREFIX:
    case SUBSTRING:
    case SUFFIX:
    case CONSTANT:
    case SIGNIFICANCE:
    case WEAKAND:
    case PARALLEL:
    case SEQUENTIAL:
    case MODEL:
    case MUTATE:
    case QUERY:
    case SUMMARY:
    case FULL:
    case STATIC:
    case DYNAMIC:
    case TOKENS:
    case SSCONTEXTUAL:
    case SSOVERRIDE:
    case SSTITLE:
    case SSURL:
    case PROPERTIES:
    case ATTRIBUTE:
    case SORTING:
    case DICTIONARY:
    case ASCENDING:
    case DESCENDING:
    case UCA:
    case RAW:
    case LOWERCASE:
    case FUNCTION:
    case LOCALE:
    case STRENGTH:
    case PRIMARY:
    case SECONDARY:
    case TERTIARY:
    case QUATERNARY:
    case IDENTICAL:
    case STEMMING:
    case NORMALIZING:
    case HASH:
    case BTREE:
    case CASED:
    case UNCASED:
    case BOLDING:
    case NONE:
    case ON:
    case OFF:
    case TRUE:
    case FALSE:
    case SYMMETRIC:
    case ALIAS:
    case MATCH:
    case RANK:
    case LITERAL:
    case EXACT:
    case FILTER:
    case NORMAL:
    case ID:
    case SOURCE:
    case TO:
    case DIRECT:
    case ALWAYS:
    case NEVER:
    case MUTABLE:
    case PAGED:
    case ARRAY:
    case WEIGHTEDSET:
    case MAP:
    case REFERENCE:
    case ORDER:
    case MACRO:
    case INLINE:
    case ARITY:
    case HNSW:
    case DOUBLE_KEYWORD:
    case FLOAT_KEYWORD:
    case LONG_KEYWORD:
    case STRING_KEYWORD:
    case CONSTANTS:
    case FILE:
    case URI:
    case IDENTIFIER:
    case CONTEXT:
    case INTEGER:
    case LONG:
    case STRING:
    case VARIABLE:{
      parameter = identifier();
func.addParameter(parameter);
      label_78:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case COMMA:{
          break;
          }
        default:
          jj_la1[149] = jj_gen;
          break label_78;
        }
        jj_consume_token(COMMA);
        parameter = identifier();
func.addParameter(parameter);
      }
      break;
      }
    default:
      jj_la1[150] = jj_gen;
      ;
    }
    jj_consume_token(238);
    lbrace();
    expression = expression();
    label_79:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NL:{
        break;
        }
      default:
        jj_la1[151] = jj_gen;
        break label_79;
      }
      jj_consume_token(NL);
    }
    jj_consume_token(RBRACE);
func.setExpression(expression);
        func.setInline(inline);
        var old = profile.addOrReplaceFunction(func);
        if (old != null) {
            throw new IllegalArgumentException("Function '" + func.name()
                                               + "' is defined twice in rank profile '"
                                               + profile.name() + "'");
        }
}

  final public boolean inline() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case INLINE:{
      jj_consume_token(INLINE);
{if ("" != null) return true;}
      break;
      }
    default:
      jj_la1[152] = jj_gen;
      ;
    }
{if ("" != null) return false;}
    throw new IllegalStateException ("Missing return statement in function");
}

/**
 * This rule consumes a match-phase block of a rank profile.
 *
 * @param profile The rank profile to modify.
 */
  final public void matchPhase(ParsedRankProfile profile) throws ParseException {MatchPhaseSettings settings = new MatchPhaseSettings();
    jj_consume_token(MATCH_PHASE);
    lbrace();
    label_80:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DIVERSITY:
      case ATTRIBUTE:
      case EVALUATION_POINT:
      case PRE_POST_FILTER_TIPPING_POINT:
      case ORDER:
      case MAX_FILTER_COVERAGE:
      case MAX_HITS:{
        break;
        }
      default:
        jj_la1[153] = jj_gen;
        break label_80;
      }
      matchPhaseItem(profile, settings);
      label_81:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NL:{
          break;
          }
        default:
          jj_la1[154] = jj_gen;
          break label_81;
        }
        jj_consume_token(NL);
      }
    }
    jj_consume_token(RBRACE);
settings.checkValid();
        profile.setMatchPhase(settings);
}

  final public void matchPhaseItem(ParsedRankProfile profile, MatchPhaseSettings settings) throws ParseException {String str;
    int num;
    double multiplier;
    double coverage;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ATTRIBUTE:{
      jj_consume_token(ATTRIBUTE);
      jj_consume_token(COLON);
      str = identifier();
settings.setAttribute(str);
      break;
      }
    case DIVERSITY:{
      diversityDeprecated(profile);
      break;
      }
    case ORDER:{
      jj_consume_token(ORDER);
      jj_consume_token(COLON);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ASCENDING:{
        jj_consume_token(ASCENDING);
settings.setAscending(true);
        break;
        }
      case DESCENDING:{
        jj_consume_token(DESCENDING);
settings.setAscending(false);
        break;
        }
      default:
        jj_la1[155] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case MAX_HITS:{
      jj_consume_token(MAX_HITS);
      jj_consume_token(COLON);
      num = integer();
settings.setMaxHits(num);
      break;
      }
    case MAX_FILTER_COVERAGE:{
      jj_consume_token(MAX_FILTER_COVERAGE);
      jj_consume_token(COLON);
      coverage = floatValue();
settings.setMaxFilterCoverage(coverage);
      break;
      }
    case EVALUATION_POINT:{
      jj_consume_token(EVALUATION_POINT);
      jj_consume_token(COLON);
      multiplier = floatValue();
settings.setEvaluationPoint(multiplier);
      break;
      }
    case PRE_POST_FILTER_TIPPING_POINT:{
      jj_consume_token(PRE_POST_FILTER_TIPPING_POINT);
      jj_consume_token(COLON);
      multiplier = floatValue();
settings.setPrePostFilterTippingPoint(multiplier);
      break;
      }
    default:
      jj_la1[156] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

/**
 * This rule consumes a diversity block of a rank profile.
 *
 * @param profile The rank profile to modify.
 */
  final public void diversity(ParsedRankProfile profile) throws ParseException {DiversitySettings settings = new DiversitySettings();
    jj_consume_token(DIVERSITY);
    lbrace();
    label_82:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MIN_GROUPS:
      case CUTOFF_FACTOR:
      case CUTOFF_STRATEGY:
      case ATTRIBUTE:{
        break;
        }
      default:
        jj_la1[157] = jj_gen;
        break label_82;
      }
      diversityItem(settings);
      label_83:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NL:{
          break;
          }
        default:
          jj_la1[158] = jj_gen;
          break label_83;
        }
        jj_consume_token(NL);
      }
    }
    jj_consume_token(RBRACE);
profile.setDiversity(settings);
}

  final public void diversityDeprecated(ParsedRankProfile profile) throws ParseException {DiversitySettings settings = new DiversitySettings();
    jj_consume_token(DIVERSITY);
    lbrace();
    label_84:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case MIN_GROUPS:
      case CUTOFF_FACTOR:
      case CUTOFF_STRATEGY:
      case ATTRIBUTE:{
        break;
        }
      default:
        jj_la1[159] = jj_gen;
        break label_84;
      }
      diversityItem(settings);
      label_85:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NL:{
          break;
          }
        default:
          jj_la1[160] = jj_gen;
          break label_85;
        }
        jj_consume_token(NL);
      }
    }
    jj_consume_token(RBRACE);
profile.setDiversity(settings);
        deployLogger.logApplicationPackage(Level.WARNING, "'diversity is deprecated inside 'match-phase'. Specify it at 'rank-profile' level.");
}

  final public void diversityItem(DiversitySettings settings) throws ParseException {String str;
    int num;
    double multiplier;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ATTRIBUTE:{
      jj_consume_token(ATTRIBUTE);
      jj_consume_token(COLON);
      str = identifier();
settings.setAttribute(str);
      break;
      }
    case MIN_GROUPS:{
      jj_consume_token(MIN_GROUPS);
      jj_consume_token(COLON);
      num = integer();
settings.setMinGroups(num);
      break;
      }
    case CUTOFF_FACTOR:{
      jj_consume_token(CUTOFF_FACTOR);
      jj_consume_token(COLON);
      multiplier = floatValue();
settings.setCutoffFactor(multiplier);
      break;
      }
    case CUTOFF_STRATEGY:{
      jj_consume_token(CUTOFF_STRATEGY);
      jj_consume_token(COLON);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case STRICT:{
        jj_consume_token(STRICT);
settings.setCutoffStrategy(Diversity.CutoffStrategy.strict);
        break;
        }
      case LOOSE:{
        jj_consume_token(LOOSE);
settings.setCutoffStrategy(Diversity.CutoffStrategy.loose);
        break;
        }
      default:
        jj_la1[161] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[162] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

/**
 * Consumes the first-phase block of a rank profile.
 *
 * @param profile The rank profile to modify.
 */
  final public void firstPhase(ParsedRankProfile profile) throws ParseException {String exp;
    jj_consume_token(FIRST_PHASE);
    lbrace();
    label_86:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case EXPRESSION_SL:
      case EXPRESSION_ML:
      case KEEP_RANK_COUNT:
      case RANK_SCORE_DROP_LIMIT:{
        break;
        }
      default:
        jj_la1[163] = jj_gen;
        break label_86;
      }
      firstPhaseItem(profile);
      label_87:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NL:{
          break;
          }
        default:
          jj_la1[164] = jj_gen;
          break label_87;
        }
        jj_consume_token(NL);
      }
    }
    jj_consume_token(RBRACE);
}

  final public void firstPhaseItem(ParsedRankProfile profile) throws ParseException {String expression;
    int keepRankCount;
    double dropLimit;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case EXPRESSION_SL:
    case EXPRESSION_ML:{
      expression = expression();
profile.setFirstPhaseRanking(expression);
      break;
      }
    case KEEP_RANK_COUNT:{
      jj_consume_token(KEEP_RANK_COUNT);
      jj_consume_token(COLON);
      keepRankCount = integer();
profile.setKeepRankCount(keepRankCount);
      break;
      }
    case RANK_SCORE_DROP_LIMIT:{
      jj_consume_token(RANK_SCORE_DROP_LIMIT);
      jj_consume_token(COLON);
      dropLimit = floatValue();
profile.setRankScoreDropLimit(dropLimit);
      break;
      }
    default:
      jj_la1[165] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

/**
 * Consumes the second-phase block of a rank profile.
 *
 * @param profile The rank profile to modify.
 */
  final public void secondPhase(ParsedRankProfile profile) throws ParseException {
    jj_consume_token(SECOND_PHASE);
    lbrace();
    label_88:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case EXPRESSION_SL:
      case EXPRESSION_ML:
      case RERANK_COUNT:
      case RANK_SCORE_DROP_LIMIT:{
        break;
        }
      default:
        jj_la1[166] = jj_gen;
        break label_88;
      }
      secondPhaseItem(profile);
      label_89:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NL:{
          break;
          }
        default:
          jj_la1[167] = jj_gen;
          break label_89;
        }
        jj_consume_token(NL);
      }
    }
    jj_consume_token(RBRACE);
}

/**
 * Consumes a statement for a second-phase block.
 *
 * @param profile The rank profile to modify.
 */
  final public void secondPhaseItem(ParsedRankProfile profile) throws ParseException {String expression;
    int rerankCount;
    double dropLimit;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case EXPRESSION_SL:
    case EXPRESSION_ML:{
      expression = expression();
profile.setSecondPhaseRanking(expression);
      break;
      }
    case RERANK_COUNT:{
      jj_consume_token(RERANK_COUNT);
      jj_consume_token(COLON);
      rerankCount = integer();
profile.setRerankCount(rerankCount);
      break;
      }
    case RANK_SCORE_DROP_LIMIT:{
      jj_consume_token(RANK_SCORE_DROP_LIMIT);
      jj_consume_token(COLON);
      dropLimit = floatValue();
profile.setSecondPhaseRankScoreDropLimit(dropLimit);
      break;
      }
    default:
      jj_la1[168] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

/**
 * Consumes the global-phase block of a rank profile.
 *
 * @param profile The rank profile to modify.
 */
  final public void globalPhase(ParsedRankProfile profile) throws ParseException {
    jj_consume_token(GLOBAL_PHASE);
    lbrace();
    label_90:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case EXPRESSION_SL:
      case EXPRESSION_ML:
      case RERANK_COUNT:
      case RANK_SCORE_DROP_LIMIT:{
        break;
        }
      default:
        jj_la1[169] = jj_gen;
        break label_90;
      }
      globalPhaseItem(profile);
      label_91:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NL:{
          break;
          }
        default:
          jj_la1[170] = jj_gen;
          break label_91;
        }
        jj_consume_token(NL);
      }
    }
    jj_consume_token(RBRACE);
}

/**
 * Consumes a statement for a global-phase block.
 *
 * @param profile The rank profile to modify.
 */
  final public void globalPhaseItem(ParsedRankProfile profile) throws ParseException {String expression;
    int rerankCount;
    double dropLimit;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case EXPRESSION_SL:
    case EXPRESSION_ML:{
      expression = expression();
profile.setGlobalPhaseExpression(expression);
      break;
      }
    case RERANK_COUNT:{
      jj_consume_token(RERANK_COUNT);
      jj_consume_token(COLON);
      rerankCount = integer();
profile.setGlobalPhaseRerankCount(rerankCount);
      break;
      }
    case RANK_SCORE_DROP_LIMIT:{
      jj_consume_token(RANK_SCORE_DROP_LIMIT);
      jj_consume_token(COLON);
      dropLimit = floatValue();
profile.setGlobalPhaseRankScoreDropLimit(dropLimit);
      break;
      }
    default:
      jj_la1[171] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

/** Consumes an inputs block of a rank profile. */
  final public void inputs(ParsedRankProfile profile) throws ParseException {Reference reference;
    TensorType type;
    List<Reference> seenInputs = new ArrayList<>();
    jj_consume_token(INPUTS);
    jj_consume_token(LBRACE);
    label_92:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NL:{
        break;
        }
      default:
        jj_la1[172] = jj_gen;
        break label_92;
      }
      jj_consume_token(NL);
    }
    label_93:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ANNOTATION:
      case ANNOTATIONREFERENCE:
      case SCHEMA:
      case SEARCH:
      case DIVERSITY:
      case LOOSE:
      case STRICT:
      case DOCUMENT:
      case OPERATION:
      case STRUCT:
      case INHERITS:
      case FIELD:
      case FIELDS:
      case FIELDSET:
      case IMPORT:
      case AS:
      case INDEXING:
      case INFINITY:
      case WEIGHT:
      case TYPE:
      case INDEX:
      case INPUTS:
      case MTOKEN:
      case TEXT:
      case WORD:
      case GRAM:
      case PREFIX:
      case SUBSTRING:
      case SUFFIX:
      case CONSTANT:
      case SIGNIFICANCE:
      case WEAKAND:
      case PARALLEL:
      case SEQUENTIAL:
      case MODEL:
      case MUTATE:
      case QUERY:
      case SUMMARY:
      case FULL:
      case STATIC:
      case DYNAMIC:
      case TOKENS:
      case SSCONTEXTUAL:
      case SSOVERRIDE:
      case SSTITLE:
      case SSURL:
      case PROPERTIES:
      case ATTRIBUTE:
      case SORTING:
      case DICTIONARY:
      case ASCENDING:
      case DESCENDING:
      case UCA:
      case RAW:
      case LOWERCASE:
      case FUNCTION:
      case LOCALE:
      case STRENGTH:
      case PRIMARY:
      case SECONDARY:
      case TERTIARY:
      case QUATERNARY:
      case IDENTICAL:
      case STEMMING:
      case NORMALIZING:
      case HASH:
      case BTREE:
      case CASED:
      case UNCASED:
      case BOLDING:
      case NONE:
      case ON:
      case OFF:
      case TRUE:
      case FALSE:
      case SYMMETRIC:
      case ALIAS:
      case MATCH:
      case RANK:
      case LITERAL:
      case EXACT:
      case FILTER:
      case NORMAL:
      case ID:
      case SOURCE:
      case TO:
      case DIRECT:
      case ALWAYS:
      case NEVER:
      case MUTABLE:
      case PAGED:
      case ARRAY:
      case WEIGHTEDSET:
      case MAP:
      case REFERENCE:
      case ORDER:
      case MACRO:
      case INLINE:
      case ARITY:
      case HNSW:
      case DOUBLE_KEYWORD:
      case FLOAT_KEYWORD:
      case LONG_KEYWORD:
      case STRING_KEYWORD:
      case CONSTANTS:
      case FILE:
      case URI:
      case IDENTIFIER:
      case CONTEXT:
      case INTEGER:
      case LONG:
      case STRING:
      case VARIABLE:{
        break;
        }
      default:
        jj_la1[173] = jj_gen;
        break label_93;
      }
      reference = input(profile);
seenInputs.add(reference);
      label_94:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NL:{
          break;
          }
        default:
          jj_la1[174] = jj_gen;
          break label_94;
        }
        jj_consume_token(NL);
seenInputs.add(null);
      }
    }
    jj_consume_token(RBRACE);
Reference last = null;
        for (Reference current : seenInputs) {
            if (last != null && current != null) {
        deployLogger.logApplicationPackage(Level.WARNING, "Expected newline between inputs " + last + " and " + current);
    }
    last = current;
        }
}

  final public Reference input(ParsedRankProfile profile) throws ParseException {Reference reference;
    InputType type = new InputType(TensorType.empty, false);
    Tensor defaultValue = null;
    reference = inputName();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case TENSOR_TYPE:
    case DOUBLE_KEYWORD:
    case FLOAT_KEYWORD:
    case LONG_KEYWORD:
    case STRING_KEYWORD:{
      type = valueType(reference);
      break;
      }
    default:
      jj_la1[175] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
      label_95:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NL:{
          break;
          }
        default:
          jj_la1[176] = jj_gen;
          break label_95;
        }
        jj_consume_token(NL);
      }
      defaultValue = tensorValue(type.tensorType());
      break;
      }
    default:
      jj_la1[177] = jj_gen;
      ;
    }
profile.addInput(reference, new RankProfile.Input(reference, type, Optional.ofNullable(defaultValue)));
        {if ("" != null) return reference;}
    throw new IllegalStateException ("Missing return statement in function");
}

/** Returns the reference "query(name)" for both "query(name)" and "name". */
  final public Reference inputName() throws ParseException {String name;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case QUERY:{
      jj_consume_token(QUERY);
      jj_consume_token(237);
      name = identifier();
      jj_consume_token(238);
      break;
      }
    case ANNOTATION:
    case ANNOTATIONREFERENCE:
    case SCHEMA:
    case SEARCH:
    case DIVERSITY:
    case LOOSE:
    case STRICT:
    case DOCUMENT:
    case OPERATION:
    case STRUCT:
    case INHERITS:
    case FIELD:
    case FIELDS:
    case FIELDSET:
    case IMPORT:
    case AS:
    case INDEXING:
    case INFINITY:
    case WEIGHT:
    case TYPE:
    case INDEX:
    case INPUTS:
    case MTOKEN:
    case TEXT:
    case WORD:
    case GRAM:
    case PREFIX:
    case SUBSTRING:
    case SUFFIX:
    case CONSTANT:
    case SIGNIFICANCE:
    case WEAKAND:
    case PARALLEL:
    case SEQUENTIAL:
    case MODEL:
    case MUTATE:
    case SUMMARY:
    case FULL:
    case STATIC:
    case DYNAMIC:
    case TOKENS:
    case SSCONTEXTUAL:
    case SSOVERRIDE:
    case SSTITLE:
    case SSURL:
    case PROPERTIES:
    case ATTRIBUTE:
    case SORTING:
    case DICTIONARY:
    case ASCENDING:
    case DESCENDING:
    case UCA:
    case RAW:
    case LOWERCASE:
    case FUNCTION:
    case LOCALE:
    case STRENGTH:
    case PRIMARY:
    case SECONDARY:
    case TERTIARY:
    case QUATERNARY:
    case IDENTICAL:
    case STEMMING:
    case NORMALIZING:
    case HASH:
    case BTREE:
    case CASED:
    case UNCASED:
    case BOLDING:
    case NONE:
    case ON:
    case OFF:
    case TRUE:
    case FALSE:
    case SYMMETRIC:
    case ALIAS:
    case MATCH:
    case RANK:
    case LITERAL:
    case EXACT:
    case FILTER:
    case NORMAL:
    case ID:
    case SOURCE:
    case TO:
    case DIRECT:
    case ALWAYS:
    case NEVER:
    case MUTABLE:
    case PAGED:
    case ARRAY:
    case WEIGHTEDSET:
    case MAP:
    case REFERENCE:
    case ORDER:
    case MACRO:
    case INLINE:
    case ARITY:
    case HNSW:
    case DOUBLE_KEYWORD:
    case FLOAT_KEYWORD:
    case LONG_KEYWORD:
    case STRING_KEYWORD:
    case CONSTANTS:
    case FILE:
    case URI:
    case IDENTIFIER:
    case CONTEXT:
    case INTEGER:
    case LONG:
    case STRING:
    case VARIABLE:{
      name = identifier();
      break;
      }
    default:
      jj_la1[178] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return FeatureNames.asQueryFeature(name);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public InputType valueType(Reference reference) throws ParseException {TensorType type;
    InputType result;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case TENSOR_TYPE:{
      type = tensorType("Type of " + reference);
result = new InputType(type, false);
      break;
      }
    case DOUBLE_KEYWORD:{
      jj_consume_token(DOUBLE_KEYWORD);
result = new InputType(TensorType.empty, false);
      break;
      }
    case LONG_KEYWORD:{
      jj_consume_token(LONG_KEYWORD);
result = new InputType(TensorType.empty, false);
        deployLogger.logApplicationPackage(Level.WARNING, "Input " + reference + ": 'long' is not possible, treated as 'double'");
      break;
      }
    case FLOAT_KEYWORD:{
      jj_consume_token(FLOAT_KEYWORD);
result = new InputType(TensorType.empty, false);
        deployLogger.logApplicationPackage(Level.WARNING, "Input " + reference + ": 'float' is not possible, treated as 'double'");
      break;
      }
    case STRING_KEYWORD:{
      jj_consume_token(STRING_KEYWORD);
result = new InputType(TensorType.empty, true);
      break;
      }
    default:
      jj_la1[179] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return result;}
    throw new IllegalStateException ("Missing return statement in function");
}

/**
 * Consumes a summary-features block of a rank profile.
 *
 * @param profile the rank profile to modify
 */
  final public void summaryFeatures(ParsedRankProfile profile) throws ParseException {String features;
    String inherited = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case SUMMARYFEATURES_SL:{
      jj_consume_token(SUMMARYFEATURES_SL);
features = token.image.substring(token.image.indexOf(":") + 1).trim();
      break;
      }
    case SUMMARYFEATURES_ML:{
      jj_consume_token(SUMMARYFEATURES_ML);
features = token.image.substring(token.image.indexOf("{") + 1,
                                                              token.image.lastIndexOf("}")).trim();
      break;
      }
    case SUMMARYFEATURES_ML_INHERITS:{
      jj_consume_token(SUMMARYFEATURES_ML_INHERITS);
MlInheritsSplit split = new MlInheritsSplit(token.image);
          profile.setInheritedSummaryFeatures(split.inherits);
          features = split.features;
      break;
      }
    default:
      jj_la1[180] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
profile.addSummaryFeatures(getFeatureList(features));
}

  final public void strict(ParsedRankProfile profile) throws ParseException {
    jj_consume_token(STRICT);
    jj_consume_token(COLON);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case TRUE:{
      jj_consume_token(TRUE);
profile.setStrict(true);
      break;
      }
    case FALSE:{
      jj_consume_token(FALSE);
profile.setStrict(false);
      break;
      }
    default:
      jj_la1[181] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void significance(ParsedRankProfile profile) throws ParseException {
    jj_consume_token(SIGNIFICANCE);
    lbrace();
    label_96:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case USE_MODEL:{
        break;
        }
      default:
        jj_la1[182] = jj_gen;
        break label_96;
      }
      significanceItem(profile);
      label_97:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NL:{
          break;
          }
        default:
          jj_la1[183] = jj_gen;
          break label_97;
        }
        jj_consume_token(NL);
      }
    }
    jj_consume_token(RBRACE);

}

  final public void significanceItem(ParsedRankProfile profile) throws ParseException {
    jj_consume_token(USE_MODEL);
    jj_consume_token(COLON);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case TRUE:{
      jj_consume_token(TRUE);
profile.setUseSignificanceModel(true);
      break;
      }
    case FALSE:{
      jj_consume_token(FALSE);
profile.setUseSignificanceModel(false);
      break;
      }
    default:
      jj_la1[184] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void weakand(ParsedRankProfile profile) throws ParseException {
    jj_consume_token(WEAKAND);
    lbrace();
    label_98:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case STOPWORD_LIMIT:
      case ALLOW_DROP_ALL:
      case ADJUST_TARGET:{
        break;
        }
      default:
        jj_la1[185] = jj_gen;
        break label_98;
      }
      weakandItem(profile);
      label_99:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NL:{
          break;
          }
        default:
          jj_la1[186] = jj_gen;
          break label_99;
        }
        jj_consume_token(NL);
      }
    }
    jj_consume_token(RBRACE);

}

  final public void weakandItem(ParsedRankProfile profile) throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case STOPWORD_LIMIT:{
      weakandStopwordLimit(profile);
      break;
      }
    case ALLOW_DROP_ALL:{
      weakandAllowDropAll(profile);
      break;
      }
    case ADJUST_TARGET:{
      weakandAdjustTarget(profile);
      break;
      }
    default:
      jj_la1[187] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void weakandStopwordLimit(ParsedRankProfile profile) throws ParseException {double limit;
    jj_consume_token(STOPWORD_LIMIT);
    jj_consume_token(COLON);
    limit = floatValue();
profile.setWeakandStopwordLimit(limit);
}

  final public void weakandAllowDropAll(ParsedRankProfile profile) throws ParseException {boolean value;
    jj_consume_token(ALLOW_DROP_ALL);
    jj_consume_token(COLON);
    value = bool();
profile.setWeakandAllowDropAll(value);
}

  final public void weakandAdjustTarget(ParsedRankProfile profile) throws ParseException {double target;
    jj_consume_token(ADJUST_TARGET);
    jj_consume_token(COLON);
    target = floatValue();
profile.setWeakandAdjustTarget(target);
}

  final public void filterThreshold(ParsedRankProfile profile) throws ParseException {double threshold;
    jj_consume_token(FILTER_THRESHOLD);
    jj_consume_token(COLON);
    threshold = floatValue();
profile.setFilterThreshold(threshold);
}

/**
 * Consumes a match-features block of a rank profile.
 *
 * @param profile the rank profile to modify
 */
  final public void matchFeatures(ParsedRankProfile profile) throws ParseException {String features;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case MATCHFEATURES_SL:{
      jj_consume_token(MATCHFEATURES_SL);
features = token.image.substring(token.image.indexOf(":") + 1).trim();
      break;
      }
    case MATCHFEATURES_ML:{
      jj_consume_token(MATCHFEATURES_ML);
features = token.image.substring(token.image.indexOf("{") + 1,
                                                              token.image.lastIndexOf("}")).trim();
      break;
      }
    case MATCHFEATURES_ML_INHERITS:{
      jj_consume_token(MATCHFEATURES_ML_INHERITS);
MlInheritsSplit split = new MlInheritsSplit(token.image);
          profile.setInheritedMatchFeatures(split.inherits);
          features = split.features;
      break;
      }
    default:
      jj_la1[188] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
profile.addMatchFeatures(getFeatureList(features));
}

/** Consumes a rank-features block of a rank profile */
  final public void rankFeatures(ParsedRankProfile profile) throws ParseException {String features;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case RANKFEATURES_SL:{
      jj_consume_token(RANKFEATURES_SL);
features = token.image.substring(token.image.indexOf(":") + 1).trim();
      break;
      }
    case RANKFEATURES_ML:{
      jj_consume_token(RANKFEATURES_ML);
features = token.image.substring(token.image.indexOf("{") + 1,
                                                           token.image.lastIndexOf("}")).trim();
      break;
      }
    default:
      jj_la1[189] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
profile.addRankFeatures(getFeatureList(features));
}

/**
 * This rule consumes a ignore-default-rank-features statement for a rank profile.
 *
 * @param profile The rank profile to modify.
 */
  final public void ignoreRankFeatures(ParsedRankProfile profile) throws ParseException {
    jj_consume_token(IGNORE_DEFAULT_RANK_FEATURES);
profile.setIgnoreDefaultRankFeatures(true);
}

/**
 * This rule consumes a num-threads-per-search statement for a rank profile.
 *
 * @param profile The rank profile to modify.
 */
  final public void numThreadsPerSearch(ParsedRankProfile profile) throws ParseException {int num;
    jj_consume_token(NUM_THREADS_PER_SEARCH);
    jj_consume_token(COLON);
    num = integer();
profile.setNumThreadsPerSearch(num);
}

/**
 * This rule consumes a min-hits-per-thread statement for a rank profile.
 *
 * @param profile The rank profile to modify.
 */
  final public void minHitsPerThread(ParsedRankProfile profile) throws ParseException {int num;
    jj_consume_token(MIN_HITS_PER_THREAD);
    jj_consume_token(COLON);
    num = integer();
profile.setMinHitsPerThread(num);
}

/**
 * This rule consumes a num-search-partitions statement for a rank profile.
 *
 * @param profile the rank profile to modify
 */
  final public void numSearchPartitions(ParsedRankProfile profile) throws ParseException {int num;
    jj_consume_token(NUM_SEARCH_PARTITIONS);
    jj_consume_token(COLON);
    num = integer();
profile.setNumSearchPartitions(num);
}

/**
 * This rule consumes a termwise-limit statement for a rank profile.
 *
 * @param profile the rank profile to modify
 */
  final public void termwiseLimit(ParsedRankProfile profile) throws ParseException {double num;
    jj_consume_token(TERMWISE_LIMIT);
    jj_consume_token(COLON);
    num = floatValue();
profile.setTermwiseLimit(num);
}

/**
 * This rule consumes a post-filter-threshold statement for a rank profile.
 *
 * @param profile the rank profile to modify
 */
  final public void postFilterThreshold(ParsedRankProfile profile) throws ParseException {double threshold;
    jj_consume_token(POST_FILTER_THRESHOLD);
    jj_consume_token(COLON);
    threshold = floatValue();
profile.setPostFilterThreshold(threshold);
}

/**
 * This rule consumes an approximate-threshold statement for a rank profile.
 *
 * @param profile the rank profile to modify
 */
  final public void approximateThreshold(ParsedRankProfile profile) throws ParseException {double threshold;
    jj_consume_token(APPROXIMATE_THRESHOLD);
    jj_consume_token(COLON);
    threshold = floatValue();
profile.setApproximateThreshold(threshold);
}

/**
 * This rule consumes a filter-first-threshold statement for a rank profile.
 *
 * @param profile the rank profile to modify
 */
  final public void filterFirstThreshold(ParsedRankProfile profile) throws ParseException {double threshold;
    jj_consume_token(FILTER_FIRST_THRESHOLD);
    jj_consume_token(COLON);
    threshold = floatValue();
profile.setFilterFirstThreshold(threshold);
}

/**
 * This rule consumes a filter-first-exploration statement for a rank profile.
 *
 * @param profile the rank profile to modify
 */
  final public void filterFirstExploration(ParsedRankProfile profile) throws ParseException {double exploration;
    jj_consume_token(FILTER_FIRST_EXPLORATION);
    jj_consume_token(COLON);
    exploration = floatValue();
profile.setFilterFirstExploration(exploration);
}

/**
 * This rule consumes an exploration-slack statement for a rank profile.
 *
 * @param profile the rank profile to modify
 */
  final public void explorationSlack(ParsedRankProfile profile) throws ParseException {double slack;
    jj_consume_token(EXPLORATION_SLACK);
    jj_consume_token(COLON);
    slack = floatValue();
profile.setExplorationSlack(slack);
}

/**
 * This rule consumes a target-hits-max-adjustment-factor statement for a rank profile.
 *
 * @param profile the rank profile to modify
 */
  final public void targetHitsMaxAdjustmentFactor(ParsedRankProfile profile) throws ParseException {double factor;
    jj_consume_token(TARGET_HITS_MAX_ADJUSTMENT_FACTOR);
    jj_consume_token(COLON);
    factor = floatValue();
profile.setTargetHitsMaxAdjustmentFactor(factor);
}

/**
 * Consumes a rank-properties block of a rank profile. There
 * is a little trick within this rule to allow the final rank property
 * to skip the terminating newline token.
 *
 * @param profile the rank profile to modify
 */
  final public void rankProperties(ParsedRankProfile profile) throws ParseException {
    jj_consume_token(RANK_PROPERTIES);
    lbrace();
    label_100:
    while (true) {
      if (jj_2_9(2147483647)) {
      } else {
        break label_100;
      }
      rankProperty(profile);
      label_101:
      while (true) {
        jj_consume_token(NL);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NL:{
          break;
          }
        default:
          jj_la1[190] = jj_gen;
          break label_101;
        }
      }
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ANNOTATION:
    case ANNOTATIONREFERENCE:
    case SCHEMA:
    case SEARCH:
    case DIVERSITY:
    case MIN_GROUPS:
    case CUTOFF_FACTOR:
    case CUTOFF_STRATEGY:
    case LOOSE:
    case STRICT:
    case DOCUMENT:
    case OPERATION:
    case ON_MATCH:
    case ON_FIRST_PHASE:
    case ON_SECOND_PHASE:
    case ON_SUMMARY:
    case STRUCT:
    case INHERITS:
    case FIELD:
    case FIELDS:
    case FIELDSET:
    case STRUCT_FIELD:
    case IMPORT:
    case AS:
    case INDEXING:
    case SUMMARY_TO:
    case DOCUMENT_SUMMARY:
    case ELEMENT_GAP:
    case INFINITY:
    case RANK_TYPE:
    case WEIGHT:
    case TYPE:
    case INDEX:
    case INPUTS:
    case MTOKEN:
    case TEXT:
    case WORD:
    case GRAM:
    case GRAM_SIZE:
    case MAX_LENGTH:
    case PREFIX:
    case SUBSTRING:
    case SUFFIX:
    case CONSTANT:
    case ONNX_MODEL:
    case SIGNIFICANCE:
    case USE_MODEL:
    case WEAKAND:
    case STOPWORD_LIMIT:
    case ALLOW_DROP_ALL:
    case ADJUST_TARGET:
    case FILTER_THRESHOLD:
    case INTRAOP_THREADS:
    case INTEROP_THREADS:
    case GPU_DEVICE:
    case EXECUTION_MODE:
    case PARALLEL:
    case SEQUENTIAL:
    case MODEL:
    case MUTATE:
    case QUERY:
    case RANK_PROFILE:
    case RAW_AS_BASE64_IN_SUMMARY:
    case SUMMARY:
    case FULL:
    case STATIC:
    case DYNAMIC:
    case TOKENS:
    case MATCHED_ELEMENTS_ONLY:
    case SSCONTEXTUAL:
    case SSOVERRIDE:
    case SSTITLE:
    case SSURL:
    case PROPERTIES:
    case ATTRIBUTE:
    case SORTING:
    case DICTIONARY:
    case ASCENDING:
    case DESCENDING:
    case UCA:
    case RAW:
    case LOWERCASE:
    case FUNCTION:
    case LOCALE:
    case STRENGTH:
    case PRIMARY:
    case SECONDARY:
    case TERTIARY:
    case QUATERNARY:
    case IDENTICAL:
    case STEMMING:
    case NORMALIZING:
    case HASH:
    case BTREE:
    case CASED:
    case UNCASED:
    case BOLDING:
    case NONE:
    case ON:
    case OFF:
    case TRUE:
    case FALSE:
    case SYMMETRIC:
    case QUERY_COMMAND:
    case ALIAS:
    case MATCH:
    case RANK:
    case LITERAL:
    case EXACT:
    case FILTER:
    case NORMAL:
    case EXACT_TERMINATOR:
    case IGNORE_DEFAULT_RANK_FEATURES:
    case ID:
    case SOURCE:
    case TO:
    case DIRECT:
    case FROM_DISK:
    case OMIT_SUMMARY_FEATURES:
    case ALWAYS:
    case ON_DEMAND:
    case NEVER:
    case ENABLE_BIT_VECTORS:
    case ENABLE_ONLY_BIT_VECTOR:
    case FAST_ACCESS:
    case MUTABLE:
    case PAGED:
    case FAST_RANK:
    case FAST_SEARCH:
    case DOT:
    case COMMA:
    case ARRAY:
    case WEIGHTEDSET:
    case MAP:
    case REFERENCE:
    case CREATE_IF_NONEXISTENT:
    case REMOVE_IF_ZERO:
    case MATCH_PHASE:
    case EVALUATION_POINT:
    case PRE_POST_FILTER_TIPPING_POINT:
    case ORDER:
    case MAX_FILTER_COVERAGE:
    case MAX_HITS:
    case FIRST_PHASE:
    case SECOND_PHASE:
    case GLOBAL_PHASE:
    case MACRO:
    case INLINE:
    case ARITY:
    case LOWER_BOUND:
    case UPPER_BOUND:
    case DENSE_POSTING_LIST_THRESHOLD:
    case ENABLE_BM25:
    case HNSW:
    case MAX_LINKS_PER_NODE:
    case DOUBLE_KEYWORD:
    case FLOAT_KEYWORD:
    case LONG_KEYWORD:
    case STRING_KEYWORD:
    case DISTANCE_METRIC:
    case NEIGHBORS_TO_EXPLORE_AT_INSERT:
    case MULTI_THREADED_INDEXING:
    case RANK_PROPERTIES:
    case RERANK_COUNT:
    case NUM_THREADS_PER_SEARCH:
    case MIN_HITS_PER_THREAD:
    case NUM_SEARCH_PARTITIONS:
    case TERMWISE_LIMIT:
    case POST_FILTER_THRESHOLD:
    case APPROXIMATE_THRESHOLD:
    case FILTER_FIRST_THRESHOLD:
    case FILTER_FIRST_EXPLORATION:
    case EXPLORATION_SLACK:
    case TARGET_HITS_MAX_ADJUSTMENT_FACTOR:
    case KEEP_RANK_COUNT:
    case RANK_SCORE_DROP_LIMIT:
    case CONSTANTS:
    case FILE:
    case URI:
    case IDENTIFIER:
    case IDENTIFIER_WITH_DASH:
    case DOUBLEQUOTEDSTRING:
    case SINGLEQUOTEDSTRING:
    case CONTEXT:
    case DOUBLE:
    case INTEGER:
    case LONG:
    case STRING:
    case VARIABLE:
    case 237:
    case 238:{
      rankProperty(profile);
      break;
      }
    default:
      jj_la1[191] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
}

/**
 * Consumes a single rank property pair for a rank profile.
 *
 * @param profile the rank profile to modify
 */
  final public void rankProperty(ParsedRankProfile profile) throws ParseException {String key, val;
    key = rankPropertyItem();
    jj_consume_token(COLON);
    val = rankPropertyItem();
profile.addRankProperty(key, val);
}

/**
 * Consumes a single rank property for a rank-properties block.
 *
 * @return the token image of the consumed item
 */
  final public String rankPropertyItem() throws ParseException {String image = null;
    String ret = "";
    Token dToken = null;
    label_102:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ANNOTATION:
      case ANNOTATIONREFERENCE:
      case SCHEMA:
      case SEARCH:
      case DIVERSITY:
      case MIN_GROUPS:
      case CUTOFF_FACTOR:
      case CUTOFF_STRATEGY:
      case LOOSE:
      case STRICT:
      case DOCUMENT:
      case OPERATION:
      case ON_MATCH:
      case ON_FIRST_PHASE:
      case ON_SECOND_PHASE:
      case ON_SUMMARY:
      case STRUCT:
      case INHERITS:
      case FIELD:
      case FIELDS:
      case FIELDSET:
      case STRUCT_FIELD:
      case IMPORT:
      case AS:
      case INDEXING:
      case SUMMARY_TO:
      case DOCUMENT_SUMMARY:
      case ELEMENT_GAP:
      case INFINITY:
      case RANK_TYPE:
      case WEIGHT:
      case TYPE:
      case INDEX:
      case INPUTS:
      case MTOKEN:
      case TEXT:
      case WORD:
      case GRAM:
      case GRAM_SIZE:
      case MAX_LENGTH:
      case PREFIX:
      case SUBSTRING:
      case SUFFIX:
      case CONSTANT:
      case ONNX_MODEL:
      case SIGNIFICANCE:
      case USE_MODEL:
      case WEAKAND:
      case STOPWORD_LIMIT:
      case ALLOW_DROP_ALL:
      case ADJUST_TARGET:
      case FILTER_THRESHOLD:
      case INTRAOP_THREADS:
      case INTEROP_THREADS:
      case GPU_DEVICE:
      case EXECUTION_MODE:
      case PARALLEL:
      case SEQUENTIAL:
      case MODEL:
      case MUTATE:
      case QUERY:
      case RANK_PROFILE:
      case RAW_AS_BASE64_IN_SUMMARY:
      case SUMMARY:
      case FULL:
      case STATIC:
      case DYNAMIC:
      case TOKENS:
      case MATCHED_ELEMENTS_ONLY:
      case SSCONTEXTUAL:
      case SSOVERRIDE:
      case SSTITLE:
      case SSURL:
      case PROPERTIES:
      case ATTRIBUTE:
      case SORTING:
      case DICTIONARY:
      case ASCENDING:
      case DESCENDING:
      case UCA:
      case RAW:
      case LOWERCASE:
      case FUNCTION:
      case LOCALE:
      case STRENGTH:
      case PRIMARY:
      case SECONDARY:
      case TERTIARY:
      case QUATERNARY:
      case IDENTICAL:
      case STEMMING:
      case NORMALIZING:
      case HASH:
      case BTREE:
      case CASED:
      case UNCASED:
      case BOLDING:
      case NONE:
      case ON:
      case OFF:
      case TRUE:
      case FALSE:
      case SYMMETRIC:
      case QUERY_COMMAND:
      case ALIAS:
      case MATCH:
      case RANK:
      case LITERAL:
      case EXACT:
      case FILTER:
      case NORMAL:
      case EXACT_TERMINATOR:
      case IGNORE_DEFAULT_RANK_FEATURES:
      case ID:
      case SOURCE:
      case TO:
      case DIRECT:
      case FROM_DISK:
      case OMIT_SUMMARY_FEATURES:
      case ALWAYS:
      case ON_DEMAND:
      case NEVER:
      case ENABLE_BIT_VECTORS:
      case ENABLE_ONLY_BIT_VECTOR:
      case FAST_ACCESS:
      case MUTABLE:
      case PAGED:
      case FAST_RANK:
      case FAST_SEARCH:
      case ARRAY:
      case WEIGHTEDSET:
      case MAP:
      case REFERENCE:
      case CREATE_IF_NONEXISTENT:
      case REMOVE_IF_ZERO:
      case MATCH_PHASE:
      case EVALUATION_POINT:
      case PRE_POST_FILTER_TIPPING_POINT:
      case ORDER:
      case MAX_FILTER_COVERAGE:
      case MAX_HITS:
      case FIRST_PHASE:
      case SECOND_PHASE:
      case GLOBAL_PHASE:
      case MACRO:
      case INLINE:
      case ARITY:
      case LOWER_BOUND:
      case UPPER_BOUND:
      case DENSE_POSTING_LIST_THRESHOLD:
      case ENABLE_BM25:
      case HNSW:
      case MAX_LINKS_PER_NODE:
      case DOUBLE_KEYWORD:
      case FLOAT_KEYWORD:
      case LONG_KEYWORD:
      case STRING_KEYWORD:
      case DISTANCE_METRIC:
      case NEIGHBORS_TO_EXPLORE_AT_INSERT:
      case MULTI_THREADED_INDEXING:
      case RANK_PROPERTIES:
      case RERANK_COUNT:
      case NUM_THREADS_PER_SEARCH:
      case MIN_HITS_PER_THREAD:
      case NUM_SEARCH_PARTITIONS:
      case TERMWISE_LIMIT:
      case POST_FILTER_THRESHOLD:
      case APPROXIMATE_THRESHOLD:
      case FILTER_FIRST_THRESHOLD:
      case FILTER_FIRST_EXPLORATION:
      case EXPLORATION_SLACK:
      case TARGET_HITS_MAX_ADJUSTMENT_FACTOR:
      case KEEP_RANK_COUNT:
      case RANK_SCORE_DROP_LIMIT:
      case CONSTANTS:
      case FILE:
      case URI:
      case IDENTIFIER:
      case IDENTIFIER_WITH_DASH:
      case CONTEXT:
      case INTEGER:
      case LONG:
      case STRING:
      case VARIABLE:{
        image = identifierWithDash();
ret += image;
        break;
        }
      case DOUBLE:{
        dToken = jj_consume_token(DOUBLE);
ret += dToken.image;
        break;
        }
      case DOUBLEQUOTEDSTRING:
      case SINGLEQUOTEDSTRING:{
        image = quotedString();
ret += image;
        break;
        }
      case DOT:
      case COMMA:
      case 237:
      case 238:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case 237:{
          jj_consume_token(237);
          break;
          }
        case 238:{
          jj_consume_token(238);
          break;
          }
        case DOT:{
          jj_consume_token(DOT);
          break;
          }
        case COMMA:{
          jj_consume_token(COMMA);
          break;
          }
        default:
          jj_la1[192] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
ret += token.image;
        break;
        }
      default:
        jj_la1[193] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ANNOTATION:
      case ANNOTATIONREFERENCE:
      case SCHEMA:
      case SEARCH:
      case DIVERSITY:
      case MIN_GROUPS:
      case CUTOFF_FACTOR:
      case CUTOFF_STRATEGY:
      case LOOSE:
      case STRICT:
      case DOCUMENT:
      case OPERATION:
      case ON_MATCH:
      case ON_FIRST_PHASE:
      case ON_SECOND_PHASE:
      case ON_SUMMARY:
      case STRUCT:
      case INHERITS:
      case FIELD:
      case FIELDS:
      case FIELDSET:
      case STRUCT_FIELD:
      case IMPORT:
      case AS:
      case INDEXING:
      case SUMMARY_TO:
      case DOCUMENT_SUMMARY:
      case ELEMENT_GAP:
      case INFINITY:
      case RANK_TYPE:
      case WEIGHT:
      case TYPE:
      case INDEX:
      case INPUTS:
      case MTOKEN:
      case TEXT:
      case WORD:
      case GRAM:
      case GRAM_SIZE:
      case MAX_LENGTH:
      case PREFIX:
      case SUBSTRING:
      case SUFFIX:
      case CONSTANT:
      case ONNX_MODEL:
      case SIGNIFICANCE:
      case USE_MODEL:
      case WEAKAND:
      case STOPWORD_LIMIT:
      case ALLOW_DROP_ALL:
      case ADJUST_TARGET:
      case FILTER_THRESHOLD:
      case INTRAOP_THREADS:
      case INTEROP_THREADS:
      case GPU_DEVICE:
      case EXECUTION_MODE:
      case PARALLEL:
      case SEQUENTIAL:
      case MODEL:
      case MUTATE:
      case QUERY:
      case RANK_PROFILE:
      case RAW_AS_BASE64_IN_SUMMARY:
      case SUMMARY:
      case FULL:
      case STATIC:
      case DYNAMIC:
      case TOKENS:
      case MATCHED_ELEMENTS_ONLY:
      case SSCONTEXTUAL:
      case SSOVERRIDE:
      case SSTITLE:
      case SSURL:
      case PROPERTIES:
      case ATTRIBUTE:
      case SORTING:
      case DICTIONARY:
      case ASCENDING:
      case DESCENDING:
      case UCA:
      case RAW:
      case LOWERCASE:
      case FUNCTION:
      case LOCALE:
      case STRENGTH:
      case PRIMARY:
      case SECONDARY:
      case TERTIARY:
      case QUATERNARY:
      case IDENTICAL:
      case STEMMING:
      case NORMALIZING:
      case HASH:
      case BTREE:
      case CASED:
      case UNCASED:
      case BOLDING:
      case NONE:
      case ON:
      case OFF:
      case TRUE:
      case FALSE:
      case SYMMETRIC:
      case QUERY_COMMAND:
      case ALIAS:
      case MATCH:
      case RANK:
      case LITERAL:
      case EXACT:
      case FILTER:
      case NORMAL:
      case EXACT_TERMINATOR:
      case IGNORE_DEFAULT_RANK_FEATURES:
      case ID:
      case SOURCE:
      case TO:
      case DIRECT:
      case FROM_DISK:
      case OMIT_SUMMARY_FEATURES:
      case ALWAYS:
      case ON_DEMAND:
      case NEVER:
      case ENABLE_BIT_VECTORS:
      case ENABLE_ONLY_BIT_VECTOR:
      case FAST_ACCESS:
      case MUTABLE:
      case PAGED:
      case FAST_RANK:
      case FAST_SEARCH:
      case DOT:
      case COMMA:
      case ARRAY:
      case WEIGHTEDSET:
      case MAP:
      case REFERENCE:
      case CREATE_IF_NONEXISTENT:
      case REMOVE_IF_ZERO:
      case MATCH_PHASE:
      case EVALUATION_POINT:
      case PRE_POST_FILTER_TIPPING_POINT:
      case ORDER:
      case MAX_FILTER_COVERAGE:
      case MAX_HITS:
      case FIRST_PHASE:
      case SECOND_PHASE:
      case GLOBAL_PHASE:
      case MACRO:
      case INLINE:
      case ARITY:
      case LOWER_BOUND:
      case UPPER_BOUND:
      case DENSE_POSTING_LIST_THRESHOLD:
      case ENABLE_BM25:
      case HNSW:
      case MAX_LINKS_PER_NODE:
      case DOUBLE_KEYWORD:
      case FLOAT_KEYWORD:
      case LONG_KEYWORD:
      case STRING_KEYWORD:
      case DISTANCE_METRIC:
      case NEIGHBORS_TO_EXPLORE_AT_INSERT:
      case MULTI_THREADED_INDEXING:
      case RANK_PROPERTIES:
      case RERANK_COUNT:
      case NUM_THREADS_PER_SEARCH:
      case MIN_HITS_PER_THREAD:
      case NUM_SEARCH_PARTITIONS:
      case TERMWISE_LIMIT:
      case POST_FILTER_THRESHOLD:
      case APPROXIMATE_THRESHOLD:
      case FILTER_FIRST_THRESHOLD:
      case FILTER_FIRST_EXPLORATION:
      case EXPLORATION_SLACK:
      case TARGET_HITS_MAX_ADJUSTMENT_FACTOR:
      case KEEP_RANK_COUNT:
      case RANK_SCORE_DROP_LIMIT:
      case CONSTANTS:
      case FILE:
      case URI:
      case IDENTIFIER:
      case IDENTIFIER_WITH_DASH:
      case DOUBLEQUOTEDSTRING:
      case SINGLEQUOTEDSTRING:
      case CONTEXT:
      case DOUBLE:
      case INTEGER:
      case LONG:
      case STRING:
      case VARIABLE:
      case 237:
      case 238:{
        break;
        }
      default:
        jj_la1[194] = jj_gen;
        break label_102;
      }
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

/**
 * Consumes a field-weight statement of a rank profile.
 *
 * @param profile the rank profile to modify
 */
  final public void fieldWeight(ParsedRankProfile profile) throws ParseException {Integer num;
    String name;
    jj_consume_token(WEIGHT);
    name = identifier();
    jj_consume_token(COLON);
    num = integer();
profile.addFieldRankWeight(name, num);
}

/**
 * Consumes a rank-type statement of a rank profile.
 *
 * @param profile the rank profile to modify
 */
  final public void fieldRankType(ParsedRankProfile profile) throws ParseException {String name;
    String type;
    jj_consume_token(RANK_TYPE);
    name = identifier();
    jj_consume_token(COLON);
    type = identifier();
profile.addFieldRankType(name, type);
}

/**
 * Consumes a rank filter statement of a rank profile.
 *
 * @param profile the rank profile to modify
 */
  final public void fieldRankFilter(ParsedRankProfile profile) throws ParseException {String name;
    jj_consume_token(RANK);
    name = identifier();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
      jj_consume_token(FILTER);
profile.addFieldRankFilter(name, true);
      break;
      }
    case NL:
    case LBRACE:{
      lbrace();
      label_103:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ELEMENT_GAP:
        case FILTER_THRESHOLD:{
          break;
          }
        default:
          jj_la1[195] = jj_gen;
          break label_103;
        }
        fieldRankItem(profile, name);
        label_104:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case NL:{
            break;
            }
          default:
            jj_la1[196] = jj_gen;
            break label_104;
          }
          jj_consume_token(NL);
        }
      }
      jj_consume_token(RBRACE);
      break;
      }
    default:
      jj_la1[197] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void fieldRankItem(ParsedRankProfile profile, String field) throws ParseException {double filterThreshold;
    ElementGap elementGap;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case FILTER_THRESHOLD:{
      jj_consume_token(FILTER_THRESHOLD);
      jj_consume_token(COLON);
      filterThreshold = floatValue();
profile.addFieldRankFilterThreshold(field, filterThreshold);
      break;
      }
    case ELEMENT_GAP:{
      jj_consume_token(ELEMENT_GAP);
      jj_consume_token(COLON);
      elementGap = elementGapValue();
profile.addFieldRankElementGap(field, elementGap);
      break;
      }
    default:
      jj_la1[198] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public ElementGap elementGapValue() throws ParseException {int gap;
    ElementGap elementGap;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case INTEGER:{
      gap = integer();
elementGap = ElementGap.of(gap);
      break;
      }
    case INFINITY:{
      jj_consume_token(INFINITY);
elementGap = ElementGap.empty();
      break;
      }
    default:
      jj_la1[199] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return elementGap;}
    throw new IllegalStateException ("Missing return statement in function");
}

/**
 * Consumes a set of constants available in ranking expressions in the enclosing profile.
 */
  final public void constants(ParsedSchema schema, ParsedRankProfile profile) throws ParseException {String name;
    jj_consume_token(CONSTANTS);
    jj_consume_token(LBRACE);
    label_105:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NL:{
        break;
        }
      default:
        jj_la1[200] = jj_gen;
        break label_105;
      }
      jj_consume_token(NL);
    }
    label_106:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ANNOTATION:
      case ANNOTATIONREFERENCE:
      case SCHEMA:
      case SEARCH:
      case DIVERSITY:
      case LOOSE:
      case STRICT:
      case DOCUMENT:
      case OPERATION:
      case STRUCT:
      case INHERITS:
      case FIELD:
      case FIELDS:
      case FIELDSET:
      case IMPORT:
      case AS:
      case INDEXING:
      case INFINITY:
      case WEIGHT:
      case TYPE:
      case INDEX:
      case INPUTS:
      case MTOKEN:
      case TEXT:
      case WORD:
      case GRAM:
      case PREFIX:
      case SUBSTRING:
      case SUFFIX:
      case CONSTANT:
      case SIGNIFICANCE:
      case WEAKAND:
      case PARALLEL:
      case SEQUENTIAL:
      case MODEL:
      case MUTATE:
      case QUERY:
      case SUMMARY:
      case FULL:
      case STATIC:
      case DYNAMIC:
      case TOKENS:
      case SSCONTEXTUAL:
      case SSOVERRIDE:
      case SSTITLE:
      case SSURL:
      case PROPERTIES:
      case ATTRIBUTE:
      case SORTING:
      case DICTIONARY:
      case ASCENDING:
      case DESCENDING:
      case UCA:
      case RAW:
      case LOWERCASE:
      case FUNCTION:
      case LOCALE:
      case STRENGTH:
      case PRIMARY:
      case SECONDARY:
      case TERTIARY:
      case QUATERNARY:
      case IDENTICAL:
      case STEMMING:
      case NORMALIZING:
      case HASH:
      case BTREE:
      case CASED:
      case UNCASED:
      case BOLDING:
      case NONE:
      case ON:
      case OFF:
      case TRUE:
      case FALSE:
      case SYMMETRIC:
      case ALIAS:
      case MATCH:
      case RANK:
      case LITERAL:
      case EXACT:
      case FILTER:
      case NORMAL:
      case ID:
      case SOURCE:
      case TO:
      case DIRECT:
      case ALWAYS:
      case NEVER:
      case MUTABLE:
      case PAGED:
      case ARRAY:
      case WEIGHTEDSET:
      case MAP:
      case REFERENCE:
      case ORDER:
      case MACRO:
      case INLINE:
      case ARITY:
      case HNSW:
      case DOUBLE_KEYWORD:
      case FLOAT_KEYWORD:
      case LONG_KEYWORD:
      case STRING_KEYWORD:
      case CONSTANTS:
      case FILE:
      case URI:
      case IDENTIFIER:
      case CONTEXT:
      case INTEGER:
      case LONG:
      case STRING:
      case VARIABLE:{
        break;
        }
      default:
        jj_la1[201] = jj_gen;
        break label_106;
      }
      constant(schema, profile);
      label_107:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NL:{
          break;
          }
        default:
          jj_la1[202] = jj_gen;
          break label_107;
        }
        jj_consume_token(NL);
      }
    }
    jj_consume_token(RBRACE);
}

  final public void constant(ParsedSchema schema, ParsedRankProfile profile) throws ParseException {Reference name = null;
    InputType type = new InputType(TensorType.empty, false);
    Tensor value = null;
    String valuePath = null;
    name = constantName();
    if (jj_2_10(4)) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case TENSOR_TYPE:
      case DOUBLE_KEYWORD:
      case FLOAT_KEYWORD:
      case LONG_KEYWORD:
      case STRING_KEYWORD:{
        type = valueType(name);
        break;
        }
      default:
        jj_la1[203] = jj_gen;
        ;
      }
      jj_consume_token(COLON);
      label_108:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NL:{
          break;
          }
        default:
          jj_la1[204] = jj_gen;
          break label_108;
        }
        jj_consume_token(NL);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LBRACE:
      case DOUBLE:
      case INTEGER:
      case LONG:
      case 239:{
        value = tensorValue(type.tensorType());
        break;
        }
      case FILE:{
        valuePath = fileItem();
        break;
        }
      default:
        jj_la1[205] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
if (value != null)
                profile.add(new RankProfile.Constant(name, value));
            else
                profile.add(new RankProfile.Constant(name, type.tensorType(), valuePath));
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LBRACE:
      case COLON:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case COLON:{
          constantValue(profile, name);
          break;
          }
        case LBRACE:{
          constantTensor(profile, name);
          break;
          }
        default:
          jj_la1[206] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[207] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
}

/** Returns the reference "constant(name)" for both "constant(name)" and "name". */
  final public Reference constantName() throws ParseException {String name;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case CONSTANT:{
      jj_consume_token(CONSTANT);
      jj_consume_token(237);
      name = identifier();
      jj_consume_token(238);
      break;
      }
    case ANNOTATION:
    case ANNOTATIONREFERENCE:
    case SCHEMA:
    case SEARCH:
    case DIVERSITY:
    case LOOSE:
    case STRICT:
    case DOCUMENT:
    case OPERATION:
    case STRUCT:
    case INHERITS:
    case FIELD:
    case FIELDS:
    case FIELDSET:
    case IMPORT:
    case AS:
    case INDEXING:
    case INFINITY:
    case WEIGHT:
    case TYPE:
    case INDEX:
    case INPUTS:
    case MTOKEN:
    case TEXT:
    case WORD:
    case GRAM:
    case PREFIX:
    case SUBSTRING:
    case SUFFIX:
    case SIGNIFICANCE:
    case WEAKAND:
    case PARALLEL:
    case SEQUENTIAL:
    case MODEL:
    case MUTATE:
    case QUERY:
    case SUMMARY:
    case FULL:
    case STATIC:
    case DYNAMIC:
    case TOKENS:
    case SSCONTEXTUAL:
    case SSOVERRIDE:
    case SSTITLE:
    case SSURL:
    case PROPERTIES:
    case ATTRIBUTE:
    case SORTING:
    case DICTIONARY:
    case ASCENDING:
    case DESCENDING:
    case UCA:
    case RAW:
    case LOWERCASE:
    case FUNCTION:
    case LOCALE:
    case STRENGTH:
    case PRIMARY:
    case SECONDARY:
    case TERTIARY:
    case QUATERNARY:
    case IDENTICAL:
    case STEMMING:
    case NORMALIZING:
    case HASH:
    case BTREE:
    case CASED:
    case UNCASED:
    case BOLDING:
    case NONE:
    case ON:
    case OFF:
    case TRUE:
    case FALSE:
    case SYMMETRIC:
    case ALIAS:
    case MATCH:
    case RANK:
    case LITERAL:
    case EXACT:
    case FILTER:
    case NORMAL:
    case ID:
    case SOURCE:
    case TO:
    case DIRECT:
    case ALWAYS:
    case NEVER:
    case MUTABLE:
    case PAGED:
    case ARRAY:
    case WEIGHTEDSET:
    case MAP:
    case REFERENCE:
    case ORDER:
    case MACRO:
    case INLINE:
    case ARITY:
    case HNSW:
    case DOUBLE_KEYWORD:
    case FLOAT_KEYWORD:
    case LONG_KEYWORD:
    case STRING_KEYWORD:
    case CONSTANTS:
    case FILE:
    case URI:
    case IDENTIFIER:
    case CONTEXT:
    case INTEGER:
    case LONG:
    case STRING:
    case VARIABLE:{
      name = identifier();
      break;
      }
    default:
      jj_la1[208] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return FeatureNames.asConstantFeature(name);}
    throw new IllegalStateException ("Missing return statement in function");
}

// Deprecated form
  final public void constantValue(ParsedRankProfile profile, Reference name) throws ParseException {Token value;
    jj_consume_token(COLON);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DOUBLE:{
      value = jj_consume_token(DOUBLE);
      break;
      }
    case INTEGER:{
      value = jj_consume_token(INTEGER);
      break;
      }
    case IDENTIFIER:{
      value = jj_consume_token(IDENTIFIER);
      break;
      }
    default:
      jj_la1[209] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
profile.add(new RankProfile.Constant(name, Tensor.from(value.image)));
}

// Deprecated form
  final public void constantTensor(ParsedRankProfile profile, Reference name) throws ParseException {String tensorString = "";
    TensorType type = null;
    jj_consume_token(LBRACE);
    label_109:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NL:{
        break;
        }
      default:
        jj_la1[210] = jj_gen;
        break label_109;
      }
      jj_consume_token(NL);
    }
    label_110:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case TYPE:
      case TENSOR_VALUE_SL:
      case TENSOR_VALUE_ML:{
        break;
        }
      default:
        jj_la1[211] = jj_gen;
        break label_110;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case TENSOR_VALUE_SL:
      case TENSOR_VALUE_ML:{
        tensorString = tensorValuePrefixedByValue();
        break;
        }
      case TYPE:{
        type = tensorTypeWithPrefix(constantTensorErrorMessage(profile.name(), name));
        break;
        }
      default:
        jj_la1[212] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_111:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NL:{
          break;
          }
        default:
          jj_la1[213] = jj_gen;
          break label_111;
        }
        jj_consume_token(NL);
      }
    }
    jj_consume_token(RBRACE);
profile.add(new RankProfile.Constant(name, type != null ? Tensor.from(type, tensorString) : Tensor.from(tensorString)));
}

  final public String constantTensorErrorMessage(String rankProfileName, Reference name) throws ParseException {
{if ("" != null) return "For constant tensor '" + name + "' in rank profile '" + rankProfileName + "'";}
    throw new IllegalStateException ("Missing return statement in function");
}

/**
 * Parses a tensor written in a tensor literal form,
 * https://docs.vespa.ai/en/reference/tensor.html#tensor-literal-form
 */
  final public Tensor tensorValue(TensorType type) throws ParseException {Tensor.Builder builder = Tensor.Builder.of(type);
    Number doubleValue = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LBRACE:{
      mappedTensorValue(builder);
      break;
      }
    case 239:{
      indexedTensorValues(builder);
      break;
      }
    case DOUBLE:
    case INTEGER:
    case LONG:{
      doubleValue = number();
      break;
      }
    default:
      jj_la1[214] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (doubleValue != null) {
            if (type.rank() > 0)
                throw new IllegalArgumentException("A tensor of type " + type + " cannot be a number");
            builder.cell(doubleValue.doubleValue());
        }
        {if ("" != null) return builder.build();}
    throw new IllegalStateException ("Missing return statement in function");
}

/** A mapped or mixed tensor value. */
  final public void mappedTensorValue(Tensor.Builder builder) throws ParseException {
    jj_consume_token(LBRACE);
    label_112:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ANNOTATION:
      case ANNOTATIONREFERENCE:
      case SCHEMA:
      case SEARCH:
      case DIVERSITY:
      case LOOSE:
      case STRICT:
      case DOCUMENT:
      case OPERATION:
      case STRUCT:
      case INHERITS:
      case FIELD:
      case FIELDS:
      case FIELDSET:
      case IMPORT:
      case AS:
      case INDEXING:
      case INFINITY:
      case WEIGHT:
      case TYPE:
      case INDEX:
      case INPUTS:
      case MTOKEN:
      case TEXT:
      case WORD:
      case GRAM:
      case PREFIX:
      case SUBSTRING:
      case SUFFIX:
      case CONSTANT:
      case SIGNIFICANCE:
      case WEAKAND:
      case PARALLEL:
      case SEQUENTIAL:
      case MODEL:
      case MUTATE:
      case QUERY:
      case SUMMARY:
      case FULL:
      case STATIC:
      case DYNAMIC:
      case TOKENS:
      case SSCONTEXTUAL:
      case SSOVERRIDE:
      case SSTITLE:
      case SSURL:
      case PROPERTIES:
      case ATTRIBUTE:
      case SORTING:
      case DICTIONARY:
      case ASCENDING:
      case DESCENDING:
      case UCA:
      case RAW:
      case LOWERCASE:
      case FUNCTION:
      case LOCALE:
      case STRENGTH:
      case PRIMARY:
      case SECONDARY:
      case TERTIARY:
      case QUATERNARY:
      case IDENTICAL:
      case STEMMING:
      case NORMALIZING:
      case HASH:
      case BTREE:
      case CASED:
      case UNCASED:
      case BOLDING:
      case NONE:
      case ON:
      case OFF:
      case TRUE:
      case FALSE:
      case SYMMETRIC:
      case ALIAS:
      case MATCH:
      case RANK:
      case LITERAL:
      case EXACT:
      case FILTER:
      case NORMAL:
      case ID:
      case SOURCE:
      case TO:
      case DIRECT:
      case ALWAYS:
      case NEVER:
      case MUTABLE:
      case PAGED:
      case LBRACE:
      case ARRAY:
      case WEIGHTEDSET:
      case MAP:
      case REFERENCE:
      case ORDER:
      case MACRO:
      case INLINE:
      case ARITY:
      case HNSW:
      case DOUBLE_KEYWORD:
      case FLOAT_KEYWORD:
      case LONG_KEYWORD:
      case STRING_KEYWORD:
      case CONSTANTS:
      case FILE:
      case URI:
      case IDENTIFIER:
      case DOUBLEQUOTEDSTRING:
      case SINGLEQUOTEDSTRING:
      case CONTEXT:
      case INTEGER:
      case LONG:
      case STRING:
      case VARIABLE:{
        break;
        }
      default:
        jj_la1[215] = jj_gen;
        break label_112;
      }
      mappedTensorBlock(builder);
    }
    label_113:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[216] = jj_gen;
        break label_113;
      }
      jj_consume_token(COMMA);
      label_114:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NL:{
          break;
          }
        default:
          jj_la1[217] = jj_gen;
          break label_114;
        }
        jj_consume_token(NL);
      }
      mappedTensorBlock(builder);
    }
    jj_consume_token(RBRACE);
}

  final public void mappedTensorBlock(Tensor.Builder builder) throws ParseException {TensorAddress mappedAddress;
    mappedAddress = tensorAddress(builder.type());
    jj_consume_token(COLON);
    label_115:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NL:{
        break;
        }
      default:
        jj_la1[218] = jj_gen;
        break label_115;
      }
      jj_consume_token(NL);
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DOUBLE:
    case INTEGER:
    case LONG:{
      mappedTensorCellValue(mappedAddress, builder);
      break;
      }
    case 239:{
      indexedTensorBlockValues(mappedAddress, builder);
      break;
      }
    default:
      jj_la1[219] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void indexedTensorBlockValues(TensorAddress mappedAddress, Tensor.Builder builder) throws ParseException {List<Double> values = new ArrayList<Double>();
    arrayTensorValues(values);
MixedTensor.BoundBuilder boundBuilder = (MixedTensor.BoundBuilder)builder;
        double[] arrayValues = new double[values.size()];
        for (int i = 0; i < values.size(); i++ ) {
            arrayValues[i] = values.get(i);
        }
        boundBuilder.block(mappedAddress, arrayValues);
}

  final public void indexedTensorValues(Tensor.Builder builder) throws ParseException {List<Double> values = new ArrayList<Double>();
    arrayTensorValues(values);
IndexedTensor.BoundBuilder boundBuilder = (IndexedTensor.BoundBuilder)builder;
        double[] arrayValues = new double[values.size()];
        for (int i = 0; i < values.size(); i++ ) {
            arrayValues[i] = values.get(i);
        }
        boundBuilder.fill(arrayValues);
}

/** Tensor array values. Using sub-bracketing for multiple dimensions is optional and therefore ignored here. */
  final public void arrayTensorValues(List<Double> values) throws ParseException {
    jj_consume_token(239);
    label_116:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DOUBLE:
      case INTEGER:
      case LONG:
      case 239:{
        break;
        }
      default:
        jj_la1[220] = jj_gen;
        break label_116;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DOUBLE:
      case INTEGER:
      case LONG:{
        indexedTensorValue(values);
        break;
        }
      case 239:{
        arrayTensorValues(values);
        break;
        }
      default:
        jj_la1[221] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    label_117:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[222] = jj_gen;
        break label_117;
      }
      jj_consume_token(COMMA);
      label_118:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NL:{
          break;
          }
        default:
          jj_la1[223] = jj_gen;
          break label_118;
        }
        jj_consume_token(NL);
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DOUBLE:
      case INTEGER:
      case LONG:{
        indexedTensorValue(values);
        break;
        }
      case 239:{
        arrayTensorValues(values);
        break;
        }
      default:
        jj_la1[224] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(240);
}

  final public void indexedTensorValue(List<Double> values) throws ParseException {Number value;
    value = number();
values.add(value.doubleValue());
}

  final public void mappedTensorCellValue(TensorAddress address, Tensor.Builder builder) throws ParseException {double value;
    value = tensorCellValue();
builder.cell(address, value);
}

  final public TensorAddress tensorAddress(TensorType type) throws ParseException {TensorAddress.Builder builder = new TensorAddress.PartialBuilder(type);
    String label;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ANNOTATION:
    case ANNOTATIONREFERENCE:
    case SCHEMA:
    case SEARCH:
    case DIVERSITY:
    case LOOSE:
    case STRICT:
    case DOCUMENT:
    case OPERATION:
    case STRUCT:
    case INHERITS:
    case FIELD:
    case FIELDS:
    case FIELDSET:
    case IMPORT:
    case AS:
    case INDEXING:
    case INFINITY:
    case WEIGHT:
    case TYPE:
    case INDEX:
    case INPUTS:
    case MTOKEN:
    case TEXT:
    case WORD:
    case GRAM:
    case PREFIX:
    case SUBSTRING:
    case SUFFIX:
    case CONSTANT:
    case SIGNIFICANCE:
    case WEAKAND:
    case PARALLEL:
    case SEQUENTIAL:
    case MODEL:
    case MUTATE:
    case QUERY:
    case SUMMARY:
    case FULL:
    case STATIC:
    case DYNAMIC:
    case TOKENS:
    case SSCONTEXTUAL:
    case SSOVERRIDE:
    case SSTITLE:
    case SSURL:
    case PROPERTIES:
    case ATTRIBUTE:
    case SORTING:
    case DICTIONARY:
    case ASCENDING:
    case DESCENDING:
    case UCA:
    case RAW:
    case LOWERCASE:
    case FUNCTION:
    case LOCALE:
    case STRENGTH:
    case PRIMARY:
    case SECONDARY:
    case TERTIARY:
    case QUATERNARY:
    case IDENTICAL:
    case STEMMING:
    case NORMALIZING:
    case HASH:
    case BTREE:
    case CASED:
    case UNCASED:
    case BOLDING:
    case NONE:
    case ON:
    case OFF:
    case TRUE:
    case FALSE:
    case SYMMETRIC:
    case ALIAS:
    case MATCH:
    case RANK:
    case LITERAL:
    case EXACT:
    case FILTER:
    case NORMAL:
    case ID:
    case SOURCE:
    case TO:
    case DIRECT:
    case ALWAYS:
    case NEVER:
    case MUTABLE:
    case PAGED:
    case ARRAY:
    case WEIGHTEDSET:
    case MAP:
    case REFERENCE:
    case ORDER:
    case MACRO:
    case INLINE:
    case ARITY:
    case HNSW:
    case DOUBLE_KEYWORD:
    case FLOAT_KEYWORD:
    case LONG_KEYWORD:
    case STRING_KEYWORD:
    case CONSTANTS:
    case FILE:
    case URI:
    case IDENTIFIER:
    case DOUBLEQUOTEDSTRING:
    case SINGLEQUOTEDSTRING:
    case CONTEXT:
    case INTEGER:
    case LONG:
    case STRING:
    case VARIABLE:{
      label = tensorAddressLabel();
builder.add(label);
      break;
      }
    case LBRACE:{
      jj_consume_token(LBRACE);
      label_119:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ANNOTATION:
        case ANNOTATIONREFERENCE:
        case SCHEMA:
        case SEARCH:
        case DIVERSITY:
        case LOOSE:
        case STRICT:
        case DOCUMENT:
        case OPERATION:
        case STRUCT:
        case INHERITS:
        case FIELD:
        case FIELDS:
        case FIELDSET:
        case IMPORT:
        case AS:
        case INDEXING:
        case INFINITY:
        case WEIGHT:
        case TYPE:
        case INDEX:
        case INPUTS:
        case MTOKEN:
        case TEXT:
        case WORD:
        case GRAM:
        case PREFIX:
        case SUBSTRING:
        case SUFFIX:
        case CONSTANT:
        case SIGNIFICANCE:
        case WEAKAND:
        case PARALLEL:
        case SEQUENTIAL:
        case MODEL:
        case MUTATE:
        case QUERY:
        case SUMMARY:
        case FULL:
        case STATIC:
        case DYNAMIC:
        case TOKENS:
        case SSCONTEXTUAL:
        case SSOVERRIDE:
        case SSTITLE:
        case SSURL:
        case PROPERTIES:
        case ATTRIBUTE:
        case SORTING:
        case DICTIONARY:
        case ASCENDING:
        case DESCENDING:
        case UCA:
        case RAW:
        case LOWERCASE:
        case FUNCTION:
        case LOCALE:
        case STRENGTH:
        case PRIMARY:
        case SECONDARY:
        case TERTIARY:
        case QUATERNARY:
        case IDENTICAL:
        case STEMMING:
        case NORMALIZING:
        case HASH:
        case BTREE:
        case CASED:
        case UNCASED:
        case BOLDING:
        case NONE:
        case ON:
        case OFF:
        case TRUE:
        case FALSE:
        case SYMMETRIC:
        case ALIAS:
        case MATCH:
        case RANK:
        case LITERAL:
        case EXACT:
        case FILTER:
        case NORMAL:
        case ID:
        case SOURCE:
        case TO:
        case DIRECT:
        case ALWAYS:
        case NEVER:
        case MUTABLE:
        case PAGED:
        case ARRAY:
        case WEIGHTEDSET:
        case MAP:
        case REFERENCE:
        case ORDER:
        case MACRO:
        case INLINE:
        case ARITY:
        case HNSW:
        case DOUBLE_KEYWORD:
        case FLOAT_KEYWORD:
        case LONG_KEYWORD:
        case STRING_KEYWORD:
        case CONSTANTS:
        case FILE:
        case URI:
        case IDENTIFIER:
        case CONTEXT:
        case INTEGER:
        case LONG:
        case STRING:
        case VARIABLE:{
          break;
          }
        default:
          jj_la1[225] = jj_gen;
          break label_119;
        }
        tensorAddressElement(builder);
      }
      label_120:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case COMMA:{
          break;
          }
        default:
          jj_la1[226] = jj_gen;
          break label_120;
        }
        jj_consume_token(COMMA);
        tensorAddressElement(builder);
      }
      jj_consume_token(RBRACE);
      break;
      }
    default:
      jj_la1[227] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return builder.build();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public void tensorAddressElement(TensorAddress.Builder builder) throws ParseException {String dimension;
    String label;
    dimension = identifier();
    jj_consume_token(COLON);
    label_121:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NL:{
        break;
        }
      default:
        jj_la1[228] = jj_gen;
        break label_121;
      }
      jj_consume_token(NL);
    }
    label = tensorAddressLabel();
builder.add(dimension, label);
}

  final public String tensorAddressLabel() throws ParseException {String label;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ANNOTATION:
    case ANNOTATIONREFERENCE:
    case SCHEMA:
    case SEARCH:
    case DIVERSITY:
    case LOOSE:
    case STRICT:
    case DOCUMENT:
    case OPERATION:
    case STRUCT:
    case INHERITS:
    case FIELD:
    case FIELDS:
    case FIELDSET:
    case IMPORT:
    case AS:
    case INDEXING:
    case INFINITY:
    case WEIGHT:
    case TYPE:
    case INDEX:
    case INPUTS:
    case MTOKEN:
    case TEXT:
    case WORD:
    case GRAM:
    case PREFIX:
    case SUBSTRING:
    case SUFFIX:
    case CONSTANT:
    case SIGNIFICANCE:
    case WEAKAND:
    case PARALLEL:
    case SEQUENTIAL:
    case MODEL:
    case MUTATE:
    case QUERY:
    case SUMMARY:
    case FULL:
    case STATIC:
    case DYNAMIC:
    case TOKENS:
    case SSCONTEXTUAL:
    case SSOVERRIDE:
    case SSTITLE:
    case SSURL:
    case PROPERTIES:
    case ATTRIBUTE:
    case SORTING:
    case DICTIONARY:
    case ASCENDING:
    case DESCENDING:
    case UCA:
    case RAW:
    case LOWERCASE:
    case FUNCTION:
    case LOCALE:
    case STRENGTH:
    case PRIMARY:
    case SECONDARY:
    case TERTIARY:
    case QUATERNARY:
    case IDENTICAL:
    case STEMMING:
    case NORMALIZING:
    case HASH:
    case BTREE:
    case CASED:
    case UNCASED:
    case BOLDING:
    case NONE:
    case ON:
    case OFF:
    case TRUE:
    case FALSE:
    case SYMMETRIC:
    case ALIAS:
    case MATCH:
    case RANK:
    case LITERAL:
    case EXACT:
    case FILTER:
    case NORMAL:
    case ID:
    case SOURCE:
    case TO:
    case DIRECT:
    case ALWAYS:
    case NEVER:
    case MUTABLE:
    case PAGED:
    case ARRAY:
    case WEIGHTEDSET:
    case MAP:
    case REFERENCE:
    case ORDER:
    case MACRO:
    case INLINE:
    case ARITY:
    case HNSW:
    case DOUBLE_KEYWORD:
    case FLOAT_KEYWORD:
    case LONG_KEYWORD:
    case STRING_KEYWORD:
    case CONSTANTS:
    case FILE:
    case URI:
    case IDENTIFIER:
    case CONTEXT:
    case INTEGER:
    case LONG:
    case STRING:
    case VARIABLE:{
      label = identifier();
      break;
      }
    case DOUBLEQUOTEDSTRING:
    case SINGLEQUOTEDSTRING:{
      label = quotedString();
      break;
      }
    default:
      jj_la1[229] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return label;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public double tensorCellValue() throws ParseException {Number value;
    value = number();
{if ("" != null) return value.doubleValue();}
    throw new IllegalStateException ("Missing return statement in function");
}

/** Undocumented syntax for supplying a tensor constant value by a string prefixed by "value" */
  final public String tensorValuePrefixedByValue() throws ParseException {String tensor;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case TENSOR_VALUE_SL:{
      jj_consume_token(TENSOR_VALUE_SL);
tensor = token.image.substring(token.image.indexOf(":") + 1);
      break;
      }
    case TENSOR_VALUE_ML:{
      jj_consume_token(TENSOR_VALUE_ML);
tensor = token.image.substring(token.image.indexOf("{") + 1,
                                                         token.image.lastIndexOf("}"));
      break;
      }
    default:
      jj_la1[230] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return tensor;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TensorType tensorTypeWithPrefix(String errorMessage) throws ParseException {TensorType type;
    jj_consume_token(TYPE);
    jj_consume_token(COLON);
    type = tensorType(errorMessage);
{if ("" != null) return type;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TensorType tensorType(String errorMessage) throws ParseException {String tensorTypeString;
    jj_consume_token(TENSOR_TYPE);
tensorTypeString = token.image;
TensorType tensorType;
        try {
            tensorType = TensorType.fromSpec(tensorTypeString);
        } catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(errorMessage + ": Illegal tensor type spec: " + e.getMessage());
        }
        {if ("" != null) return tensorType;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public void importField(ParsedSchema schema) throws ParseException {String fieldRefSpec;
    String aliasFieldName;
    jj_consume_token(IMPORT);
    jj_consume_token(FIELD);
    fieldRefSpec = identifier();
    jj_consume_token(AS);
    aliasFieldName = identifier();
    lbrace();
    jj_consume_token(RBRACE);
long nDots = Utils.count(fieldRefSpec, '.');
        if (nDots != 1) {
            throw new IllegalArgumentException("Illegal field reference spec '" + fieldRefSpec + "': Does not include a single '.'");
        }
        int indexOfDot = fieldRefSpec.indexOf('.');
        String documentReferenceFieldName = fieldRefSpec.substring(0, indexOfDot);
        String foreignFieldName = fieldRefSpec.substring(indexOfDot + 1);
        schema.addImportedField(aliasFieldName, documentReferenceFieldName, foreignFieldName);
}

/**
 * This rule consumes an expression token and returns its image.
 *
 * @return The consumed token image.
 */
  final public String expression() throws ParseException {String exp;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case EXPRESSION_SL:{
      jj_consume_token(EXPRESSION_SL);
exp = token.image.substring(token.image.indexOf(":") + 1);
      break;
      }
    case EXPRESSION_ML:{
      jj_consume_token(EXPRESSION_ML);
exp = token.image.substring(token.image.indexOf("{") + 1,
                                                    token.image.lastIndexOf("}"));
      break;
      }
    default:
      jj_la1[231] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return exp.trim();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String identifierWithDash() throws ParseException {String identifier;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ANNOTATION:
    case ANNOTATIONREFERENCE:
    case SCHEMA:
    case SEARCH:
    case DIVERSITY:
    case LOOSE:
    case STRICT:
    case DOCUMENT:
    case OPERATION:
    case STRUCT:
    case INHERITS:
    case FIELD:
    case FIELDS:
    case FIELDSET:
    case IMPORT:
    case AS:
    case INDEXING:
    case INFINITY:
    case WEIGHT:
    case TYPE:
    case INDEX:
    case INPUTS:
    case MTOKEN:
    case TEXT:
    case WORD:
    case GRAM:
    case PREFIX:
    case SUBSTRING:
    case SUFFIX:
    case CONSTANT:
    case SIGNIFICANCE:
    case WEAKAND:
    case PARALLEL:
    case SEQUENTIAL:
    case MODEL:
    case MUTATE:
    case QUERY:
    case SUMMARY:
    case FULL:
    case STATIC:
    case DYNAMIC:
    case TOKENS:
    case SSCONTEXTUAL:
    case SSOVERRIDE:
    case SSTITLE:
    case SSURL:
    case PROPERTIES:
    case ATTRIBUTE:
    case SORTING:
    case DICTIONARY:
    case ASCENDING:
    case DESCENDING:
    case UCA:
    case RAW:
    case LOWERCASE:
    case FUNCTION:
    case LOCALE:
    case STRENGTH:
    case PRIMARY:
    case SECONDARY:
    case TERTIARY:
    case QUATERNARY:
    case IDENTICAL:
    case STEMMING:
    case NORMALIZING:
    case HASH:
    case BTREE:
    case CASED:
    case UNCASED:
    case BOLDING:
    case NONE:
    case ON:
    case OFF:
    case TRUE:
    case FALSE:
    case SYMMETRIC:
    case ALIAS:
    case MATCH:
    case RANK:
    case LITERAL:
    case EXACT:
    case FILTER:
    case NORMAL:
    case ID:
    case SOURCE:
    case TO:
    case DIRECT:
    case ALWAYS:
    case NEVER:
    case MUTABLE:
    case PAGED:
    case ARRAY:
    case WEIGHTEDSET:
    case MAP:
    case REFERENCE:
    case ORDER:
    case MACRO:
    case INLINE:
    case ARITY:
    case HNSW:
    case DOUBLE_KEYWORD:
    case FLOAT_KEYWORD:
    case LONG_KEYWORD:
    case STRING_KEYWORD:
    case CONSTANTS:
    case FILE:
    case URI:
    case IDENTIFIER:
    case CONTEXT:
    case INTEGER:
    case LONG:
    case STRING:
    case VARIABLE:{
      identifier = identifier();
{if ("" != null) return identifier;}
      break;
      }
    case MIN_GROUPS:
    case CUTOFF_FACTOR:
    case CUTOFF_STRATEGY:
    case ON_MATCH:
    case ON_FIRST_PHASE:
    case ON_SECOND_PHASE:
    case ON_SUMMARY:
    case STRUCT_FIELD:
    case SUMMARY_TO:
    case DOCUMENT_SUMMARY:
    case ELEMENT_GAP:
    case RANK_TYPE:
    case GRAM_SIZE:
    case MAX_LENGTH:
    case ONNX_MODEL:
    case USE_MODEL:
    case STOPWORD_LIMIT:
    case ALLOW_DROP_ALL:
    case ADJUST_TARGET:
    case FILTER_THRESHOLD:
    case INTRAOP_THREADS:
    case INTEROP_THREADS:
    case GPU_DEVICE:
    case EXECUTION_MODE:
    case RANK_PROFILE:
    case RAW_AS_BASE64_IN_SUMMARY:
    case MATCHED_ELEMENTS_ONLY:
    case QUERY_COMMAND:
    case EXACT_TERMINATOR:
    case IGNORE_DEFAULT_RANK_FEATURES:
    case FROM_DISK:
    case OMIT_SUMMARY_FEATURES:
    case ON_DEMAND:
    case ENABLE_BIT_VECTORS:
    case ENABLE_ONLY_BIT_VECTOR:
    case FAST_ACCESS:
    case FAST_RANK:
    case FAST_SEARCH:
    case CREATE_IF_NONEXISTENT:
    case REMOVE_IF_ZERO:
    case MATCH_PHASE:
    case EVALUATION_POINT:
    case PRE_POST_FILTER_TIPPING_POINT:
    case MAX_FILTER_COVERAGE:
    case MAX_HITS:
    case FIRST_PHASE:
    case SECOND_PHASE:
    case GLOBAL_PHASE:
    case LOWER_BOUND:
    case UPPER_BOUND:
    case DENSE_POSTING_LIST_THRESHOLD:
    case ENABLE_BM25:
    case MAX_LINKS_PER_NODE:
    case DISTANCE_METRIC:
    case NEIGHBORS_TO_EXPLORE_AT_INSERT:
    case MULTI_THREADED_INDEXING:
    case RANK_PROPERTIES:
    case RERANK_COUNT:
    case NUM_THREADS_PER_SEARCH:
    case MIN_HITS_PER_THREAD:
    case NUM_SEARCH_PARTITIONS:
    case TERMWISE_LIMIT:
    case POST_FILTER_THRESHOLD:
    case APPROXIMATE_THRESHOLD:
    case FILTER_FIRST_THRESHOLD:
    case FILTER_FIRST_EXPLORATION:
    case EXPLORATION_SLACK:
    case TARGET_HITS_MAX_ADJUSTMENT_FACTOR:
    case KEEP_RANK_COUNT:
    case RANK_SCORE_DROP_LIMIT:
    case IDENTIFIER_WITH_DASH:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case IDENTIFIER_WITH_DASH:{
        jj_consume_token(IDENTIFIER_WITH_DASH);
        break;
        }
      case ADJUST_TARGET:{
        jj_consume_token(ADJUST_TARGET);
        break;
        }
      case ALLOW_DROP_ALL:{
        jj_consume_token(ALLOW_DROP_ALL);
        break;
        }
      case APPROXIMATE_THRESHOLD:{
        jj_consume_token(APPROXIMATE_THRESHOLD);
        break;
        }
      case CREATE_IF_NONEXISTENT:{
        jj_consume_token(CREATE_IF_NONEXISTENT);
        break;
        }
      case CUTOFF_FACTOR:{
        jj_consume_token(CUTOFF_FACTOR);
        break;
        }
      case CUTOFF_STRATEGY:{
        jj_consume_token(CUTOFF_STRATEGY);
        break;
        }
      case DENSE_POSTING_LIST_THRESHOLD:{
        jj_consume_token(DENSE_POSTING_LIST_THRESHOLD);
        break;
        }
      case DISTANCE_METRIC:{
        jj_consume_token(DISTANCE_METRIC);
        break;
        }
      case DOCUMENT_SUMMARY:{
        jj_consume_token(DOCUMENT_SUMMARY);
        break;
        }
      case ELEMENT_GAP:{
        jj_consume_token(ELEMENT_GAP);
        break;
        }
      case ENABLE_BIT_VECTORS:{
        jj_consume_token(ENABLE_BIT_VECTORS);
        break;
        }
      case ENABLE_BM25:{
        jj_consume_token(ENABLE_BM25);
        break;
        }
      case ENABLE_ONLY_BIT_VECTOR:{
        jj_consume_token(ENABLE_ONLY_BIT_VECTOR);
        break;
        }
      case EVALUATION_POINT:{
        jj_consume_token(EVALUATION_POINT);
        break;
        }
      case EXACT_TERMINATOR:{
        jj_consume_token(EXACT_TERMINATOR);
        break;
        }
      case EXECUTION_MODE:{
        jj_consume_token(EXECUTION_MODE);
        break;
        }
      case EXPLORATION_SLACK:{
        jj_consume_token(EXPLORATION_SLACK);
        break;
        }
      case FAST_ACCESS:{
        jj_consume_token(FAST_ACCESS);
        break;
        }
      case FAST_RANK:{
        jj_consume_token(FAST_RANK);
        break;
        }
      case FAST_SEARCH:{
        jj_consume_token(FAST_SEARCH);
        break;
        }
      case FILTER_FIRST_EXPLORATION:{
        jj_consume_token(FILTER_FIRST_EXPLORATION);
        break;
        }
      case FILTER_FIRST_THRESHOLD:{
        jj_consume_token(FILTER_FIRST_THRESHOLD);
        break;
        }
      case FILTER_THRESHOLD:{
        jj_consume_token(FILTER_THRESHOLD);
        break;
        }
      case FIRST_PHASE:{
        jj_consume_token(FIRST_PHASE);
        break;
        }
      case FROM_DISK:{
        jj_consume_token(FROM_DISK);
        break;
        }
      case GLOBAL_PHASE:{
        jj_consume_token(GLOBAL_PHASE);
        break;
        }
      case GPU_DEVICE:{
        jj_consume_token(GPU_DEVICE);
        break;
        }
      case GRAM_SIZE:{
        jj_consume_token(GRAM_SIZE);
        break;
        }
      case IGNORE_DEFAULT_RANK_FEATURES:{
        jj_consume_token(IGNORE_DEFAULT_RANK_FEATURES);
        break;
        }
      case INTEROP_THREADS:{
        jj_consume_token(INTEROP_THREADS);
        break;
        }
      case INTRAOP_THREADS:{
        jj_consume_token(INTRAOP_THREADS);
        break;
        }
      case KEEP_RANK_COUNT:{
        jj_consume_token(KEEP_RANK_COUNT);
        break;
        }
      case LOWER_BOUND:{
        jj_consume_token(LOWER_BOUND);
        break;
        }
      case MATCHED_ELEMENTS_ONLY:{
        jj_consume_token(MATCHED_ELEMENTS_ONLY);
        break;
        }
      case MATCH_PHASE:{
        jj_consume_token(MATCH_PHASE);
        break;
        }
      case MAX_FILTER_COVERAGE:{
        jj_consume_token(MAX_FILTER_COVERAGE);
        break;
        }
      case MAX_HITS:{
        jj_consume_token(MAX_HITS);
        break;
        }
      case MAX_LENGTH:{
        jj_consume_token(MAX_LENGTH);
        break;
        }
      case MAX_LINKS_PER_NODE:{
        jj_consume_token(MAX_LINKS_PER_NODE);
        break;
        }
      case MIN_GROUPS:{
        jj_consume_token(MIN_GROUPS);
        break;
        }
      case MIN_HITS_PER_THREAD:{
        jj_consume_token(MIN_HITS_PER_THREAD);
        break;
        }
      case MULTI_THREADED_INDEXING:{
        jj_consume_token(MULTI_THREADED_INDEXING);
        break;
        }
      case NEIGHBORS_TO_EXPLORE_AT_INSERT:{
        jj_consume_token(NEIGHBORS_TO_EXPLORE_AT_INSERT);
        break;
        }
      case NUM_SEARCH_PARTITIONS:{
        jj_consume_token(NUM_SEARCH_PARTITIONS);
        break;
        }
      case NUM_THREADS_PER_SEARCH:{
        jj_consume_token(NUM_THREADS_PER_SEARCH);
        break;
        }
      case OMIT_SUMMARY_FEATURES:{
        jj_consume_token(OMIT_SUMMARY_FEATURES);
        break;
        }
      case ON_DEMAND:{
        jj_consume_token(ON_DEMAND);
        break;
        }
      case ON_FIRST_PHASE:{
        jj_consume_token(ON_FIRST_PHASE);
        break;
        }
      case ON_MATCH:{
        jj_consume_token(ON_MATCH);
        break;
        }
      case ONNX_MODEL:{
        jj_consume_token(ONNX_MODEL);
        break;
        }
      case ON_SECOND_PHASE:{
        jj_consume_token(ON_SECOND_PHASE);
        break;
        }
      case ON_SUMMARY:{
        jj_consume_token(ON_SUMMARY);
        break;
        }
      case POST_FILTER_THRESHOLD:{
        jj_consume_token(POST_FILTER_THRESHOLD);
        break;
        }
      case PRE_POST_FILTER_TIPPING_POINT:{
        jj_consume_token(PRE_POST_FILTER_TIPPING_POINT);
        break;
        }
      case QUERY_COMMAND:{
        jj_consume_token(QUERY_COMMAND);
        break;
        }
      case RANK_PROFILE:{
        jj_consume_token(RANK_PROFILE);
        break;
        }
      case RANK_PROPERTIES:{
        jj_consume_token(RANK_PROPERTIES);
        break;
        }
      case RANK_SCORE_DROP_LIMIT:{
        jj_consume_token(RANK_SCORE_DROP_LIMIT);
        break;
        }
      case RANK_TYPE:{
        jj_consume_token(RANK_TYPE);
        break;
        }
      case RAW_AS_BASE64_IN_SUMMARY:{
        jj_consume_token(RAW_AS_BASE64_IN_SUMMARY);
        break;
        }
      case REMOVE_IF_ZERO:{
        jj_consume_token(REMOVE_IF_ZERO);
        break;
        }
      case RERANK_COUNT:{
        jj_consume_token(RERANK_COUNT);
        break;
        }
      case SECOND_PHASE:{
        jj_consume_token(SECOND_PHASE);
        break;
        }
      case STOPWORD_LIMIT:{
        jj_consume_token(STOPWORD_LIMIT);
        break;
        }
      case STRUCT_FIELD:{
        jj_consume_token(STRUCT_FIELD);
        break;
        }
      case SUMMARY_TO:{
        jj_consume_token(SUMMARY_TO);
        break;
        }
      case TARGET_HITS_MAX_ADJUSTMENT_FACTOR:{
        jj_consume_token(TARGET_HITS_MAX_ADJUSTMENT_FACTOR);
        break;
        }
      case TERMWISE_LIMIT:{
        jj_consume_token(TERMWISE_LIMIT);
        break;
        }
      case UPPER_BOUND:{
        jj_consume_token(UPPER_BOUND);
        break;
        }
      case USE_MODEL:{
        jj_consume_token(USE_MODEL);
        break;
        }
      default:
        jj_la1[232] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
{if ("" != null) return token.image;}
      break;
      }
    default:
      jj_la1[233] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

/**
 * Consumes an identifier. This must be kept in sync with all word tokens that should be parseable as
 * identifiers.
 *
 * @return the identifier string
 */
  final public String identifier() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ALIAS:{
      jj_consume_token(ALIAS);
      break;
      }
    case ALWAYS:{
      jj_consume_token(ALWAYS);
      break;
      }
    case ANNOTATION:{
      jj_consume_token(ANNOTATION);
      break;
      }
    case ANNOTATIONREFERENCE:{
      jj_consume_token(ANNOTATIONREFERENCE);
      break;
      }
    case ARITY:{
      jj_consume_token(ARITY);
      break;
      }
    case ARRAY:{
      jj_consume_token(ARRAY);
      break;
      }
    case AS:{
      jj_consume_token(AS);
      break;
      }
    case ASCENDING:{
      jj_consume_token(ASCENDING);
      break;
      }
    case ATTRIBUTE:{
      jj_consume_token(ATTRIBUTE);
      break;
      }
    case BOLDING:{
      jj_consume_token(BOLDING);
      break;
      }
    case BTREE:{
      jj_consume_token(BTREE);
      break;
      }
    case CASED:{
      jj_consume_token(CASED);
      break;
      }
    case CONSTANT:{
      jj_consume_token(CONSTANT);
      break;
      }
    case CONSTANTS:{
      jj_consume_token(CONSTANTS);
      break;
      }
    case CONTEXT:{
      jj_consume_token(CONTEXT);
      break;
      }
    case DESCENDING:{
      jj_consume_token(DESCENDING);
      break;
      }
    case DICTIONARY:{
      jj_consume_token(DICTIONARY);
      break;
      }
    case DIRECT:{
      jj_consume_token(DIRECT);
      break;
      }
    case DIVERSITY:{
      jj_consume_token(DIVERSITY);
      break;
      }
    case DOCUMENT:{
      jj_consume_token(DOCUMENT);
      break;
      }
    case DOUBLE_KEYWORD:{
      jj_consume_token(DOUBLE_KEYWORD);
      break;
      }
    case FLOAT_KEYWORD:{
      jj_consume_token(FLOAT_KEYWORD);
      break;
      }
    case LONG_KEYWORD:{
      jj_consume_token(LONG_KEYWORD);
      break;
      }
    case STRING_KEYWORD:{
      jj_consume_token(STRING_KEYWORD);
      break;
      }
    case DYNAMIC:{
      jj_consume_token(DYNAMIC);
      break;
      }
    case EXACT:{
      jj_consume_token(EXACT);
      break;
      }
    case FALSE:{
      jj_consume_token(FALSE);
      break;
      }
    case FIELD:{
      jj_consume_token(FIELD);
      break;
      }
    case FIELDS:{
      jj_consume_token(FIELDS);
      break;
      }
    case FIELDSET:{
      jj_consume_token(FIELDSET);
      break;
      }
    case FILE:{
      jj_consume_token(FILE);
      break;
      }
    case FILTER:{
      jj_consume_token(FILTER);
      break;
      }
    case FULL:{
      jj_consume_token(FULL);
      break;
      }
    case FUNCTION:{
      jj_consume_token(FUNCTION);
      break;
      }
    case GRAM:{
      jj_consume_token(GRAM);
      break;
      }
    case HASH:{
      jj_consume_token(HASH);
      break;
      }
    case HNSW:{
      jj_consume_token(HNSW);
      break;
      }
    case ID:{
      jj_consume_token(ID);
      break;
      }
    case IDENTICAL:{
      jj_consume_token(IDENTICAL);
      break;
      }
    case IDENTIFIER:{
      jj_consume_token(IDENTIFIER);
      break;
      }
    case IMPORT:{
      jj_consume_token(IMPORT);
      break;
      }
    case INDEX:{
      jj_consume_token(INDEX);
      break;
      }
    case INDEXING:{
      jj_consume_token(INDEXING);
      break;
      }
    case INFINITY:{
      jj_consume_token(INFINITY);
      break;
      }
    case INHERITS:{
      jj_consume_token(INHERITS);
      break;
      }
    case INLINE:{
      jj_consume_token(INLINE);
      break;
      }
    case INPUTS:{
      jj_consume_token(INPUTS);
      break;
      }
    case INTEGER:{
      jj_consume_token(INTEGER);
      break;
      }
    case LITERAL:{
      jj_consume_token(LITERAL);
      break;
      }
    case LOCALE:{
      jj_consume_token(LOCALE);
      break;
      }
    case LONG:{
      jj_consume_token(LONG);
      break;
      }
    case LOOSE:{
      jj_consume_token(LOOSE);
      break;
      }
    case LOWERCASE:{
      jj_consume_token(LOWERCASE);
      break;
      }
    case MACRO:{
      jj_consume_token(MACRO);
      break;
      }
    case MAP:{
      jj_consume_token(MAP);
      break;
      }
    case MATCH:{
      jj_consume_token(MATCH);
      break;
      }
    case MODEL:{
      jj_consume_token(MODEL);
      break;
      }
    case MTOKEN:{
      jj_consume_token(MTOKEN);
      break;
      }
    case MUTABLE:{
      jj_consume_token(MUTABLE);
      break;
      }
    case MUTATE:{
      jj_consume_token(MUTATE);
      break;
      }
    case NEVER:{
      jj_consume_token(NEVER);
      break;
      }
    case NONE:{
      jj_consume_token(NONE);
      break;
      }
    case NORMAL:{
      jj_consume_token(NORMAL);
      break;
      }
    case NORMALIZING:{
      jj_consume_token(NORMALIZING);
      break;
      }
    case OFF:{
      jj_consume_token(OFF);
      break;
      }
    case ON:{
      jj_consume_token(ON);
      break;
      }
    case OPERATION:{
      jj_consume_token(OPERATION);
      break;
      }
    case ORDER:{
      jj_consume_token(ORDER);
      break;
      }
    case PAGED:{
      jj_consume_token(PAGED);
      break;
      }
    case PARALLEL:{
      jj_consume_token(PARALLEL);
      break;
      }
    case PREFIX:{
      jj_consume_token(PREFIX);
      break;
      }
    case PRIMARY:{
      jj_consume_token(PRIMARY);
      break;
      }
    case PROPERTIES:{
      jj_consume_token(PROPERTIES);
      break;
      }
    case QUATERNARY:{
      jj_consume_token(QUATERNARY);
      break;
      }
    case QUERY:{
      jj_consume_token(QUERY);
      break;
      }
    case RANK:{
      jj_consume_token(RANK);
      break;
      }
    case RAW:{
      jj_consume_token(RAW);
      break;
      }
    case REFERENCE:{
      jj_consume_token(REFERENCE);
      break;
      }
    case SCHEMA:{
      jj_consume_token(SCHEMA);
      break;
      }
    case SEARCH:{
      jj_consume_token(SEARCH);
      break;
      }
    case SECONDARY:{
      jj_consume_token(SECONDARY);
      break;
      }
    case SEQUENTIAL:{
      jj_consume_token(SEQUENTIAL);
      break;
      }
    case SORTING:{
      jj_consume_token(SORTING);
      break;
      }
    case SOURCE:{
      jj_consume_token(SOURCE);
      break;
      }
    case SSCONTEXTUAL:{
      jj_consume_token(SSCONTEXTUAL);
      break;
      }
    case SSOVERRIDE:{
      jj_consume_token(SSOVERRIDE);
      break;
      }
    case SSTITLE:{
      jj_consume_token(SSTITLE);
      break;
      }
    case SSURL:{
      jj_consume_token(SSURL);
      break;
      }
    case SIGNIFICANCE:{
      jj_consume_token(SIGNIFICANCE);
      break;
      }
    case STATIC:{
      jj_consume_token(STATIC);
      break;
      }
    case STEMMING:{
      jj_consume_token(STEMMING);
      break;
      }
    case STRENGTH:{
      jj_consume_token(STRENGTH);
      break;
      }
    case STRICT:{
      jj_consume_token(STRICT);
      break;
      }
    case STRING:{
      jj_consume_token(STRING);
      break;
      }
    case STRUCT:{
      jj_consume_token(STRUCT);
      break;
      }
    case SUBSTRING:{
      jj_consume_token(SUBSTRING);
      break;
      }
    case SUFFIX:{
      jj_consume_token(SUFFIX);
      break;
      }
    case SUMMARY:{
      jj_consume_token(SUMMARY);
      break;
      }
    case SYMMETRIC:{
      jj_consume_token(SYMMETRIC);
      break;
      }
    case TERTIARY:{
      jj_consume_token(TERTIARY);
      break;
      }
    case TEXT:{
      jj_consume_token(TEXT);
      break;
      }
    case TO:{
      jj_consume_token(TO);
      break;
      }
    case TOKENS:{
      jj_consume_token(TOKENS);
      break;
      }
    case TRUE:{
      jj_consume_token(TRUE);
      break;
      }
    case TYPE:{
      jj_consume_token(TYPE);
      break;
      }
    case UCA:{
      jj_consume_token(UCA);
      break;
      }
    case UNCASED:{
      jj_consume_token(UNCASED);
      break;
      }
    case URI:{
      jj_consume_token(URI);
      break;
      }
    case VARIABLE:{
      jj_consume_token(VARIABLE);
      break;
      }
    case WEAKAND:{
      jj_consume_token(WEAKAND);
      break;
      }
    case WEIGHT:{
      jj_consume_token(WEIGHT);
      break;
      }
    case WEIGHTEDSET:{
      jj_consume_token(WEIGHTEDSET);
      break;
      }
    case WORD:{
      jj_consume_token(WORD);
      break;
      }
    default:
      jj_la1[234] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return token.image;}
    throw new IllegalStateException ("Missing return statement in function");
}

/**
 * Consumes a string token and returns the token image.
 *
 * @return The consumed token image.
 */
  final public String string() throws ParseException {
    jj_consume_token(STRING);
{if ("" != null) return token.image;}
    throw new IllegalStateException ("Missing return statement in function");
}

/**
 * Consumes a quoted string token and returns the token image minus the quotes. This does not perform
 * unescaping of the content, it simply removes the first and last character of the image. However, the token itself can
 * contain anything but a double quote.
 *
 * @return the unquoted token image
 */
  final public String quotedString() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DOUBLEQUOTEDSTRING:{
      jj_consume_token(DOUBLEQUOTEDSTRING);
      break;
      }
    case SINGLEQUOTEDSTRING:{
      jj_consume_token(SINGLEQUOTEDSTRING);
      break;
      }
    default:
      jj_la1[235] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return token.image.substring(1, token.image.length() - 1);}
    throw new IllegalStateException ("Missing return statement in function");
}

/** A boolean value. */
  final public Boolean bool() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ON:
    case TRUE:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ON:{
        jj_consume_token(ON);
        break;
        }
      case TRUE:{
        jj_consume_token(TRUE);
        break;
        }
      default:
        jj_la1[236] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
{if ("" != null) return true;}
      break;
      }
    case OFF:
    case FALSE:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case OFF:{
        jj_consume_token(OFF);
        break;
        }
      case FALSE:{
        jj_consume_token(FALSE);
        break;
        }
      default:
        jj_la1[237] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
{if ("" != null) return false;}
      break;
      }
    default:
      jj_la1[238] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

/** Consumes an integer token and returns its numeric value. */
  final public int integer() throws ParseException {
    jj_consume_token(INTEGER);
{if ("" != null) return Integer.parseInt(token.image);}
    throw new IllegalStateException ("Missing return statement in function");
}

/** Consumes a long or integer token and returns its numeric value. */
  final public long longValue() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case INTEGER:{
      jj_consume_token(INTEGER);
{if ("" != null) return Long.parseLong(token.image);}
      break;
      }
    case LONG:{
      jj_consume_token(LONG);
{if ("" != null) return Long.parseLong(token.image.substring(0, token.image.length()-1));}
      break;
      }
    default:
      jj_la1[239] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

/** Consumes a floating-point token and returns its numeric value. */
  final public double floatValue() throws ParseException {
    jj_consume_token(DOUBLE);
{if ("" != null) return Double.valueOf(token.image);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Number number() throws ParseException {Number num;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DOUBLE:{
      num = floatValue();
      break;
      }
    case INTEGER:
    case LONG:{
      num = longValue();
      break;
      }
    default:
      jj_la1[240] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return num;}
    throw new IllegalStateException ("Missing return statement in function");
}

/** Consumes an opening brace with leading and trailing newline tokens. */
  final public void lbrace() throws ParseException {
    label_122:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NL:{
        break;
        }
      default:
        jj_la1[241] = jj_gen;
        break label_122;
      }
      jj_consume_token(NL);
    }
    jj_consume_token(LBRACE);
    label_123:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NL:{
        break;
        }
      default:
        jj_la1[242] = jj_gen;
        break label_123;
      }
      jj_consume_token(NL);
    }
}

  private boolean jj_2_1(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_4()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_5()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_6()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_7()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_8()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_9()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_10()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_3_1()
 {
    if (jj_scan_token(ARRAY)) return true;
    if (jj_scan_token(LESSTHAN)) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_scan_token(WEIGHTEDSET)) return true;
    if (jj_scan_token(LESSTHAN)) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_scan_token(MAP)) return true;
    if (jj_scan_token(LESSTHAN)) return true;
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_scan_token(ANNOTATIONREFERENCE)) return true;
    if (jj_scan_token(LESSTHAN)) return true;
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_scan_token(TENSOR_TYPE)) return true;
    return false;
  }

  private boolean jj_3_6()
 {
    if (jj_scan_token(REFERENCE)) return true;
    return false;
  }

  private boolean jj_3_10()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_127()) jj_scanpos = xsp;
    if (jj_scan_token(COLON)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(5)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_128()) {
    jj_scanpos = xsp;
    if (jj_3R_129()) return true;
    }
    return false;
  }

  private boolean jj_3R_169()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_175()) {
    jj_scanpos = xsp;
    if (jj_3R_176()) return true;
    }
    return false;
  }

  private boolean jj_3R_175()
 {
    if (jj_scan_token(INTEGER)) return true;
    return false;
  }

  private boolean jj_3R_176()
 {
    if (jj_scan_token(LONG)) return true;
    return false;
  }

  private boolean jj_3R_168()
 {
    if (jj_scan_token(DOUBLE)) return true;
    return false;
  }

  private boolean jj_3R_127()
 {
    if (jj_3R_136()) return true;
    return false;
  }

  private boolean jj_3R_152()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_158()) {
    jj_scanpos = xsp;
    if (jj_3R_159()) return true;
    }
    return false;
  }

  private boolean jj_3R_157()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_163()) {
    jj_scanpos = xsp;
    if (jj_3R_164()) return true;
    }
    return false;
  }

  private boolean jj_3R_158()
 {
    if (jj_3R_139()) return true;
    return false;
  }

  private boolean jj_3R_159()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(215)) {
    jj_scanpos = xsp;
    if (jj_scan_token(58)) {
    jj_scanpos = xsp;
    if (jj_scan_token(57)) {
    jj_scanpos = xsp;
    if (jj_scan_token(204)) {
    jj_scanpos = xsp;
    if (jj_scan_token(150)) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(166)) {
    jj_scanpos = xsp;
    if (jj_scan_token(174)) {
    jj_scanpos = xsp;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) {
    jj_scanpos = xsp;
    if (jj_scan_token(130)) {
    jj_scanpos = xsp;
    if (jj_scan_token(167)) {
    jj_scanpos = xsp;
    if (jj_scan_token(131)) {
    jj_scanpos = xsp;
    if (jj_scan_token(153)) {
    jj_scanpos = xsp;
    if (jj_scan_token(119)) {
    jj_scanpos = xsp;
    if (jj_scan_token(63)) {
    jj_scanpos = xsp;
    if (jj_scan_token(207)) {
    jj_scanpos = xsp;
    if (jj_scan_token(132)) {
    jj_scanpos = xsp;
    if (jj_scan_token(135)) {
    jj_scanpos = xsp;
    if (jj_scan_token(136)) {
    jj_scanpos = xsp;
    if (jj_scan_token(206)) {
    jj_scanpos = xsp;
    if (jj_scan_token(205)) {
    jj_scanpos = xsp;
    if (jj_scan_token(59)) {
    jj_scanpos = xsp;
    if (jj_scan_token(158)) {
    jj_scanpos = xsp;
    if (jj_scan_token(125)) {
    jj_scanpos = xsp;
    if (jj_scan_token(160)) {
    jj_scanpos = xsp;
    if (jj_scan_token(62)) {
    jj_scanpos = xsp;
    if (jj_scan_token(44)) {
    jj_scanpos = xsp;
    if (jj_scan_token(120)) {
    jj_scanpos = xsp;
    if (jj_scan_token(61)) {
    jj_scanpos = xsp;
    if (jj_scan_token(60)) {
    jj_scanpos = xsp;
    if (jj_scan_token(209)) {
    jj_scanpos = xsp;
    if (jj_scan_token(164)) {
    jj_scanpos = xsp;
    if (jj_scan_token(76)) {
    jj_scanpos = xsp;
    if (jj_scan_token(152)) {
    jj_scanpos = xsp;
    if (jj_scan_token(156)) {
    jj_scanpos = xsp;
    if (jj_scan_token(157)) {
    jj_scanpos = xsp;
    if (jj_scan_token(45)) {
    jj_scanpos = xsp;
    if (jj_scan_token(169)) {
    jj_scanpos = xsp;
    if (jj_scan_token(11)) {
    jj_scanpos = xsp;
    if (jj_scan_token(200)) {
    jj_scanpos = xsp;
    if (jj_scan_token(176)) {
    jj_scanpos = xsp;
    if (jj_scan_token(175)) {
    jj_scanpos = xsp;
    if (jj_scan_token(201)) {
    jj_scanpos = xsp;
    if (jj_scan_token(199)) {
    jj_scanpos = xsp;
    if (jj_scan_token(126)) {
    jj_scanpos = xsp;
    if (jj_scan_token(128)) {
    jj_scanpos = xsp;
    if (jj_scan_token(19)) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(52)) {
    jj_scanpos = xsp;
    if (jj_scan_token(20)) {
    jj_scanpos = xsp;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_scan_token(203)) {
    jj_scanpos = xsp;
    if (jj_scan_token(154)) {
    jj_scanpos = xsp;
    if (jj_scan_token(111)) {
    jj_scanpos = xsp;
    if (jj_scan_token(69)) {
    jj_scanpos = xsp;
    if (jj_scan_token(197)) {
    jj_scanpos = xsp;
    if (jj_scan_token(210)) {
    jj_scanpos = xsp;
    if (jj_scan_token(35)) {
    jj_scanpos = xsp;
    if (jj_scan_token(70)) {
    jj_scanpos = xsp;
    if (jj_scan_token(151)) {
    jj_scanpos = xsp;
    if (jj_scan_token(198)) {
    jj_scanpos = xsp;
    if (jj_scan_token(159)) {
    jj_scanpos = xsp;
    if (jj_scan_token(56)) {
    jj_scanpos = xsp;
    if (jj_scan_token(27)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) {
    jj_scanpos = xsp;
    if (jj_scan_token(208)) {
    jj_scanpos = xsp;
    if (jj_scan_token(202)) {
    jj_scanpos = xsp;
    if (jj_scan_token(165)) {
    jj_scanpos = xsp;
    if (jj_scan_token(54)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_163()
 {
    if (jj_3R_168()) return true;
    return false;
  }

  private boolean jj_3R_125()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(5)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(LBRACE)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(5)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_164()
 {
    if (jj_3R_169()) return true;
    return false;
  }

  private boolean jj_3R_128()
 {
    if (jj_3R_137()) return true;
    return false;
  }

  private boolean jj_3R_137()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_149()) {
    jj_scanpos = xsp;
    if (jj_3R_150()) {
    jj_scanpos = xsp;
    if (jj_3R_151()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_149()
 {
    if (jj_3R_155()) return true;
    return false;
  }

  private boolean jj_3R_136()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_144()) {
    jj_scanpos = xsp;
    if (jj_3R_145()) {
    jj_scanpos = xsp;
    if (jj_3R_146()) {
    jj_scanpos = xsp;
    if (jj_3R_147()) {
    jj_scanpos = xsp;
    if (jj_3R_148()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_144()
 {
    if (jj_3R_154()) return true;
    return false;
  }

  private boolean jj_3R_145()
 {
    if (jj_scan_token(DOUBLE_KEYWORD)) return true;
    return false;
  }

  private boolean jj_3R_155()
 {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_160()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_161()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_146()
 {
    if (jj_scan_token(LONG_KEYWORD)) return true;
    return false;
  }

  private boolean jj_3R_160()
 {
    if (jj_3R_165()) return true;
    return false;
  }

  private boolean jj_3R_161()
 {
    if (jj_scan_token(COMMA)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(5)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_165()) return true;
    return false;
  }

  private boolean jj_3R_147()
 {
    if (jj_scan_token(FLOAT_KEYWORD)) return true;
    return false;
  }

  private boolean jj_3R_148()
 {
    if (jj_scan_token(STRING_KEYWORD)) return true;
    return false;
  }

  private boolean jj_3R_165()
 {
    if (jj_3R_170()) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3_8()
 {
    if (jj_scan_token(HNSW)) return true;
    if (jj_3R_125()) return true;
    return false;
  }

  private boolean jj_3R_150()
 {
    if (jj_3R_156()) return true;
    return false;
  }

  private boolean jj_3R_139()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(112)) {
    jj_scanpos = xsp;
    if (jj_scan_token(127)) {
    jj_scanpos = xsp;
    if (jj_scan_token(6)) {
    jj_scanpos = xsp;
    if (jj_scan_token(7)) {
    jj_scanpos = xsp;
    if (jj_scan_token(163)) {
    jj_scanpos = xsp;
    if (jj_scan_token(145)) {
    jj_scanpos = xsp;
    if (jj_scan_token(29)) {
    jj_scanpos = xsp;
    if (jj_scan_token(85)) {
    jj_scanpos = xsp;
    if (jj_scan_token(82)) {
    jj_scanpos = xsp;
    if (jj_scan_token(104)) {
    jj_scanpos = xsp;
    if (jj_scan_token(101)) {
    jj_scanpos = xsp;
    if (jj_scan_token(102)) {
    jj_scanpos = xsp;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(211)) {
    jj_scanpos = xsp;
    if (jj_scan_token(218)) {
    jj_scanpos = xsp;
    if (jj_scan_token(86)) {
    jj_scanpos = xsp;
    if (jj_scan_token(84)) {
    jj_scanpos = xsp;
    if (jj_scan_token(124)) {
    jj_scanpos = xsp;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_scan_token(16)) {
    jj_scanpos = xsp;
    if (jj_scan_token(170)) {
    jj_scanpos = xsp;
    if (jj_scan_token(171)) {
    jj_scanpos = xsp;
    if (jj_scan_token(172)) {
    jj_scanpos = xsp;
    if (jj_scan_token(173)) {
    jj_scanpos = xsp;
    if (jj_scan_token(74)) {
    jj_scanpos = xsp;
    if (jj_scan_token(116)) {
    jj_scanpos = xsp;
    if (jj_scan_token(109)) {
    jj_scanpos = xsp;
    if (jj_scan_token(24)) {
    jj_scanpos = xsp;
    if (jj_scan_token(25)) {
    jj_scanpos = xsp;
    if (jj_scan_token(26)) {
    jj_scanpos = xsp;
    if (jj_scan_token(212)) {
    jj_scanpos = xsp;
    if (jj_scan_token(117)) {
    jj_scanpos = xsp;
    if (jj_scan_token(72)) {
    jj_scanpos = xsp;
    if (jj_scan_token(90)) {
    jj_scanpos = xsp;
    if (jj_scan_token(43)) {
    jj_scanpos = xsp;
    if (jj_scan_token(100)) {
    jj_scanpos = xsp;
    if (jj_scan_token(168)) {
    jj_scanpos = xsp;
    if (jj_scan_token(121)) {
    jj_scanpos = xsp;
    if (jj_scan_token(97)) {
    jj_scanpos = xsp;
    if (jj_scan_token(214)) {
    jj_scanpos = xsp;
    if (jj_scan_token(28)) {
    jj_scanpos = xsp;
    if (jj_scan_token(38)) {
    jj_scanpos = xsp;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(34)) {
    jj_scanpos = xsp;
    if (jj_scan_token(23)) {
    jj_scanpos = xsp;
    if (jj_scan_token(162)) {
    jj_scanpos = xsp;
    if (jj_scan_token(39)) {
    jj_scanpos = xsp;
    if (jj_scan_token(220)) {
    jj_scanpos = xsp;
    if (jj_scan_token(115)) {
    jj_scanpos = xsp;
    if (jj_scan_token(91)) {
    jj_scanpos = xsp;
    if (jj_scan_token(221)) {
    jj_scanpos = xsp;
    if (jj_scan_token(14)) {
    jj_scanpos = xsp;
    if (jj_scan_token(89)) {
    jj_scanpos = xsp;
    if (jj_scan_token(161)) {
    jj_scanpos = xsp;
    if (jj_scan_token(147)) {
    jj_scanpos = xsp;
    if (jj_scan_token(113)) {
    jj_scanpos = xsp;
    if (jj_scan_token(66)) {
    jj_scanpos = xsp;
    if (jj_scan_token(40)) {
    jj_scanpos = xsp;
    if (jj_scan_token(133)) {
    jj_scanpos = xsp;
    if (jj_scan_token(67)) {
    jj_scanpos = xsp;
    if (jj_scan_token(129)) {
    jj_scanpos = xsp;
    if (jj_scan_token(105)) {
    jj_scanpos = xsp;
    if (jj_scan_token(118)) {
    jj_scanpos = xsp;
    if (jj_scan_token(99)) {
    jj_scanpos = xsp;
    if (jj_scan_token(107)) {
    jj_scanpos = xsp;
    if (jj_scan_token(106)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(155)) {
    jj_scanpos = xsp;
    if (jj_scan_token(134)) {
    jj_scanpos = xsp;
    if (jj_scan_token(64)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(93)) {
    jj_scanpos = xsp;
    if (jj_scan_token(81)) {
    jj_scanpos = xsp;
    if (jj_scan_token(96)) {
    jj_scanpos = xsp;
    if (jj_scan_token(68)) {
    jj_scanpos = xsp;
    if (jj_scan_token(114)) {
    jj_scanpos = xsp;
    if (jj_scan_token(88)) {
    jj_scanpos = xsp;
    if (jj_scan_token(148)) {
    jj_scanpos = xsp;
    if (jj_scan_token(8)) {
    jj_scanpos = xsp;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_scan_token(94)) {
    jj_scanpos = xsp;
    if (jj_scan_token(65)) {
    jj_scanpos = xsp;
    if (jj_scan_token(83)) {
    jj_scanpos = xsp;
    if (jj_scan_token(122)) {
    jj_scanpos = xsp;
    if (jj_scan_token(77)) {
    jj_scanpos = xsp;
    if (jj_scan_token(78)) {
    jj_scanpos = xsp;
    if (jj_scan_token(79)) {
    jj_scanpos = xsp;
    if (jj_scan_token(80)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) {
    jj_scanpos = xsp;
    if (jj_scan_token(73)) {
    jj_scanpos = xsp;
    if (jj_scan_token(98)) {
    jj_scanpos = xsp;
    if (jj_scan_token(92)) {
    jj_scanpos = xsp;
    if (jj_scan_token(15)) {
    jj_scanpos = xsp;
    if (jj_scan_token(222)) {
    jj_scanpos = xsp;
    if (jj_scan_token(22)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) {
    jj_scanpos = xsp;
    if (jj_scan_token(50)) {
    jj_scanpos = xsp;
    if (jj_scan_token(71)) {
    jj_scanpos = xsp;
    if (jj_scan_token(110)) {
    jj_scanpos = xsp;
    if (jj_scan_token(95)) {
    jj_scanpos = xsp;
    if (jj_scan_token(41)) {
    jj_scanpos = xsp;
    if (jj_scan_token(123)) {
    jj_scanpos = xsp;
    if (jj_scan_token(75)) {
    jj_scanpos = xsp;
    if (jj_scan_token(108)) {
    jj_scanpos = xsp;
    if (jj_scan_token(37)) {
    jj_scanpos = xsp;
    if (jj_scan_token(87)) {
    jj_scanpos = xsp;
    if (jj_scan_token(103)) {
    jj_scanpos = xsp;
    if (jj_scan_token(213)) {
    jj_scanpos = xsp;
    if (jj_scan_token(228)) {
    jj_scanpos = xsp;
    if (jj_scan_token(55)) {
    jj_scanpos = xsp;
    if (jj_scan_token(36)) {
    jj_scanpos = xsp;
    if (jj_scan_token(146)) {
    jj_scanpos = xsp;
    if (jj_scan_token(42)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_129()
 {
    if (jj_3R_138()) return true;
    return false;
  }

  private boolean jj_3_7()
 {
    if (jj_3R_124()) return true;
    return false;
  }

  private boolean jj_3R_124()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_130()) jj_scanpos = xsp;
    if (jj_scan_token(COLON)) return true;
    xsp = jj_scanpos;
    if (jj_3R_131()) {
    jj_scanpos = xsp;
    if (jj_3R_132()) {
    jj_scanpos = xsp;
    if (jj_3R_133()) {
    jj_scanpos = xsp;
    if (jj_3R_134()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_130()
 {
    if (jj_3R_139()) return true;
    return false;
  }

  private boolean jj_3R_156()
 {
    if (jj_3R_162()) return true;
    return false;
  }

  private boolean jj_3R_131()
 {
    if (jj_scan_token(DYNAMIC)) return true;
    return false;
  }

  private boolean jj_3R_132()
 {
    if (jj_scan_token(MATCHED_ELEMENTS_ONLY)) return true;
    return false;
  }

  private boolean jj_3R_133()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(72)) {
    jj_scanpos = xsp;
    if (jj_scan_token(73)) return true;
    }
    return false;
  }

  private boolean jj_3R_151()
 {
    if (jj_3R_157()) return true;
    return false;
  }

  private boolean jj_3R_134()
 {
    if (jj_scan_token(TOKENS)) return true;
    return false;
  }

  private boolean jj_3R_162()
 {
    if (jj_scan_token(239)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_166()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_167()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(240)) return true;
    return false;
  }

  private boolean jj_3R_167()
 {
    if (jj_scan_token(COMMA)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(5)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_173()) {
    jj_scanpos = xsp;
    if (jj_3R_174()) return true;
    }
    return false;
  }

  private boolean jj_3R_179()
 {
    if (jj_3R_157()) return true;
    return false;
  }

  private boolean jj_3R_126()
 {
    Token xsp;
    if (jj_3R_135()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_135()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_166()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_171()) {
    jj_scanpos = xsp;
    if (jj_3R_172()) return true;
    }
    return false;
  }

  private boolean jj_3R_171()
 {
    if (jj_3R_179()) return true;
    return false;
  }

  private boolean jj_3R_135()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_140()) {
    jj_scanpos = xsp;
    if (jj_3R_141()) {
    jj_scanpos = xsp;
    if (jj_3R_142()) {
    jj_scanpos = xsp;
    if (jj_3R_143()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_140()
 {
    if (jj_3R_152()) return true;
    return false;
  }

  private boolean jj_3R_173()
 {
    if (jj_3R_179()) return true;
    return false;
  }

  private boolean jj_3R_141()
 {
    if (jj_scan_token(DOUBLE)) return true;
    return false;
  }

  private boolean jj_3_9()
 {
    if (jj_3R_126()) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_126()) return true;
    if (jj_scan_token(NL)) return true;
    return false;
  }

  private boolean jj_3R_142()
 {
    if (jj_3R_153()) return true;
    return false;
  }

  private boolean jj_3R_170()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_177()) {
    jj_scanpos = xsp;
    if (jj_3R_178()) return true;
    }
    return false;
  }

  private boolean jj_3R_143()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(237)) {
    jj_scanpos = xsp;
    if (jj_scan_token(238)) {
    jj_scanpos = xsp;
    if (jj_scan_token(143)) {
    jj_scanpos = xsp;
    if (jj_scan_token(144)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_177()
 {
    if (jj_3R_180()) return true;
    return false;
  }

  private boolean jj_3R_178()
 {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_181()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_182()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_185()
 {
    if (jj_3R_139()) return true;
    return false;
  }

  private boolean jj_3R_181()
 {
    if (jj_3R_185()) return true;
    return false;
  }

  private boolean jj_3R_180()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_183()) {
    jj_scanpos = xsp;
    if (jj_3R_184()) return true;
    }
    return false;
  }

  private boolean jj_3R_172()
 {
    if (jj_3R_162()) return true;
    return false;
  }

  private boolean jj_3R_174()
 {
    if (jj_3R_162()) return true;
    return false;
  }

  private boolean jj_3R_183()
 {
    if (jj_3R_139()) return true;
    return false;
  }

  private boolean jj_3R_138()
 {
    if (jj_scan_token(FILE)) return true;
    if (jj_scan_token(COLON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(223)) {
    jj_scanpos = xsp;
    if (jj_scan_token(222)) {
    jj_scanpos = xsp;
    if (jj_scan_token(214)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_184()
 {
    if (jj_3R_153()) return true;
    return false;
  }

  private boolean jj_3R_182()
 {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_154()
 {
    if (jj_scan_token(TENSOR_TYPE)) return true;
    return false;
  }

  private boolean jj_3R_153()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(216)) {
    jj_scanpos = xsp;
    if (jj_scan_token(217)) return true;
    }
    return false;
  }

  /** Generated Token Manager. */
  public SchemaParserTokenManager token_source;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[243];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static private int[] jj_la1_5;
  static private int[] jj_la1_6;
  static private int[] jj_la1_7;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	   jj_la1_init_2();
	   jj_la1_init_3();
	   jj_la1_init_4();
	   jj_la1_init_5();
	   jj_la1_init_6();
	   jj_la1_init_7();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x20,0x10301,0x300,0x800000,0x15410040,0x20,0x20,0x15410040,0x10000,0x20,0x77c3c7c0,0x20,0x20,0x800000,0x20,0x1400040,0x20,0x20,0x20,0x800000,0x20,0x1400040,0x20,0x1400040,0x0,0x0,0x0,0x0,0xc8000000,0x20,0x0,0xffffffc0,0x2000000,0x20,0x2000000,0x20,0x800000,0x20,0x800000,0x1000000,0x20,0x20,0x20,0x800000,0x1000000,0x20,0x0,0x77c3c7c0,0x20,0x0,0x0,0x20,0xc8000000,0x20,0xc8000000,0xc8000000,0x0,0x77c3c7c0,0x0,0x0,0x20,0x20,0x0,0x77c3c7c0,0x77c3c7c0,0x0,0x20,0x20,0x0,0x20,0x20,0x0,0x0,0x0,0x77c3c7c0,0x0,0x0,0x0,0x20,0x77c3c7e0,0x77c3c7c0,0x0,0x0,0x0,0x77c3c7c0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x20,0x0,0xffffffc0,0x77c3c7c0,0x0,0x20,0x20,0x0,0x0,0x0,0x20,0x20,0x0,0x800000,0x20,0x20,0x0,0x0,0x0,0x20,0x20,0x77c3c7c0,0x0,0x0,0x20,0x20,0x0,0x0,0x20,0x0,0x0,0x20,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x20,0x20,0x0,0x800000,0x8400,0x20,0x8400,0x0,0x3c0000,0x3c0000,0x20,0x0,0x0,0x0,0x0,0x77c3c7c0,0x20,0x0,0x400,0x20,0x0,0x400,0x3800,0x20,0x3800,0x20,0xc000,0x3800,0x0,0x20,0x0,0x0,0x20,0x0,0x0,0x20,0x0,0x20,0x77c3c7c0,0x20,0x0,0x20,0x0,0x77c3c7c0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x20,0x0,0x0,0x0,0x20,0xffffffc0,0x0,0xffffffc0,0xffffffc0,0x0,0x20,0x20,0x0,0x0,0x20,0x77c3c7c0,0x20,0x0,0x20,0x0,0x0,0x0,0x77c3c7c0,0x0,0x20,0x0,0x0,0x20,0x0,0x77c3c7c0,0x0,0x20,0x20,0x0,0x0,0x0,0x0,0x20,0x0,0x77c3c7c0,0x0,0x77c3c7c0,0x20,0x77c3c7c0,0x0,0x0,0x883c3800,0xffffffc0,0x77c3c7c0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x20,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x0,0x0,0x0,0x0,0x180041,0x0,0x0,0x180041,0x0,0x0,0xaf0ff4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x58,0x0,0x0,0xffff3fff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xaf0ff4,0x0,0x0,0x0,0x0,0x0,0x0,0x58,0x0,0x0,0xaf0ff4,0x0,0x0,0x0,0x0,0x0,0xaf0ff4,0xaf0ff4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xaf0ff4,0x0,0x20,0x0,0x0,0xaf0ff4,0xaf0ff4,0x0,0x0,0x20,0xaf0ff4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffff3fff,0xaf0ff4,0x7ff00,0x0,0x0,0x70f00,0x7ff00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0xaf0ff4,0x0,0x10000,0x0,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0xf0000000,0x0,0xf0000000,0x0,0x20,0x20,0x0,0x0,0x0,0x0,0x0,0x8b00098,0x0,0x8b00098,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xaf0ff4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xaf0ff4,0x0,0x0,0x0,0x0,0xaf0ff4,0x0,0x0,0x0,0x400000,0x0,0x0,0x7000000,0x0,0x7000000,0x0,0x0,0x0,0xffff3fff,0x0,0xffff3fff,0xffff3fff,0x8000002,0x0,0x0,0x8000002,0x4,0x0,0xaf0ff4,0x0,0x0,0x0,0x0,0x0,0x0,0xaf0ff4,0x0,0x0,0x20,0x20,0x0,0x0,0xaf0ff4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xaf0ff4,0x0,0xaf0ff4,0x0,0xaf0ff4,0x0,0x0,0xff50300b,0xffff3fff,0xaf0ff4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_2() {
	   jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x64,0x0,0x0,0x64,0x0,0x0,0xffffef9f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1c0080,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffef9f,0x0,0x0,0x0,0x0,0x40080,0x0,0x1c0080,0x40080,0x0,0xffffef9f,0x0,0x0,0x0,0x0,0x0,0xffffef9f,0xffffef9f,0x80000,0x0,0x0,0x1c600000,0x0,0x0,0x3800000,0xe0000000,0x1c600000,0xffffef9f,0x80000,0x0,0x1f00,0x0,0xffffef9f,0xffffef9f,0x300,0x1f00,0x0,0xffffef9f,0x1f00,0x0,0x1f00,0x300,0xf00,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0xffffef9f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x80,0x0,0x0,0x0,0x0,0x0,0xffffef9f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x24,0x0,0x4000008,0x0,0x4000008,0x0,0x0,0x0,0x0,0x0,0x4000000,0x0,0x0,0xffffef9f,0x0,0x0,0x40000,0x0,0x600000,0x40000,0x40000,0x0,0x40000,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffef9f,0x0,0x0,0x0,0x0,0xffffef9f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0xffffffff,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0xffffef9f,0x0,0x0,0x0,0x0,0x0,0x0,0xffffef9f,0x0,0x0,0x0,0x0,0x0,0x0,0xffffef9f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffef9f,0x0,0xffffef9f,0x0,0xffffef9f,0x0,0x0,0x1060,0xffffffff,0xffffef9f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_3() {
	   jj_la1_3 = new int[] {0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x4,0x0,0x0,0x9e7f7fff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3000,0x0,0x0,0x0,0x207810c,0x0,0x0,0xffffffff,0x28000,0x0,0x28000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x9e7f7fff,0x0,0x2000000,0x20000,0x0,0x68000,0x0,0x207810c,0x68000,0x0,0x9e7f7fff,0x0,0x0,0x0,0x0,0x0,0x9e7f7fff,0x9e7f7fff,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x0,0x9e7f7fff,0x10000,0x0,0xc000100,0x0,0x9e7f7fff,0x9e7f7fff,0x0,0x0,0x0,0x9e7f7fff,0xc000100,0x0,0xc000100,0x0,0x0,0x0,0x0,0x4000000,0x0,0xf0,0x0,0x0,0xf0,0xffffffff,0x9e7f7fff,0x9000c0,0x0,0x0,0x1000c0,0x9000c0,0x680000,0x0,0x0,0x680000,0x0,0x60000000,0x60000000,0x0,0x0,0x10004,0x0,0x0,0x9e7f7fff,0x0,0x10004,0x0,0x0,0x10004,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1040000,0x0,0x1040000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x9e7f7fff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x9e7f7fff,0x0,0x0,0x0,0x0,0x9e7f7fff,0x0,0x0,0x3000,0x0,0x0,0x3000,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0xffffffff,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x9e7f7fff,0x0,0x0,0x0,0x0,0x0,0x0,0x9e7f7fff,0x0,0x0,0x0,0x0,0x0,0x0,0x9e7f7fff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x9e7f7fff,0x0,0x9e7f7fff,0x0,0x9e7f7fff,0x0,0x0,0x61808000,0xffffffff,0x9e7f7fff,0x0,0x1400,0x2800,0x3c00,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_4() {
	   jj_la1_4 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x81e0062,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x10000,0x10000,0x40000,0x0,0x10000,0xffde01ff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x81e0062,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x4000,0x81e0062,0x10000,0xc00000,0x0,0x5000,0xc00000,0x81e0062,0x81e0062,0x1fc,0x0,0x5000,0x0,0x0,0x5000,0x0,0x0,0x0,0x81e0062,0x1fc,0x0,0x0,0x0,0x81e1062,0x81e0062,0x0,0x0,0x0,0x81e0062,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x10000,0x0,0x0,0x5000,0x0,0xffde01ff,0x81e0062,0x0,0x0,0x5000,0x0,0x0,0x0,0x0,0x5000,0x0,0x0,0x0,0x0,0x10000,0x10000,0x0,0x0,0x5000,0x81e0062,0x10000,0x0,0x0,0x5000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc1000000,0x0,0xc1000000,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x81e0062,0x0,0x0,0x3e000000,0x0,0x0,0x3e000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x81e0062,0x0,0x200,0x0,0x4000,0x81e0062,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffdf81ff,0x18000,0xffdf81ff,0xffdf81ff,0x0,0x0,0x5000,0x0,0x0,0x0,0x81e0062,0x0,0x200,0x0,0x1000,0x5000,0x5000,0x81e0062,0x0,0x0,0xc00,0xc00,0x0,0x1000,0x81e1062,0x10000,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x81e0062,0x10000,0x81e1062,0x0,0x81e0062,0xc00,0x0,0xf7c0019d,0xffde01ff,0x81e0062,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_5() {
	   jj_la1_5 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3d0e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1ffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3d0e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3d0e,0x0,0x0,0x0,0x0,0x0,0x3d0e,0x3d0e,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3d0e,0x4000,0x0,0x100000,0x0,0x3d0e,0x3d0e,0x0,0x0,0x0,0x3d0e,0x100000,0x0,0x100000,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1ffff,0x3d0e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1f8,0x0,0x0,0x3d0e,0x0,0x1f8,0x0,0x0,0x1f8,0x18200,0x0,0x100,0x18200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3ee0003,0x0,0x3ee0003,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x3d0e,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc000000,0x0,0xc000000,0xc000000,0x0,0xc000000,0xc000000,0x0,0xc000000,0x0,0x3d0e,0x0,0x3c00,0x0,0x0,0x3d0e,0x3c00,0xe00000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0000,0x3000000,0x0,0x1ffff,0x0,0x1ffff,0x1ffff,0x0,0x0,0x0,0x0,0x0,0x0,0x3d0e,0x0,0x3c00,0x0,0x0,0x0,0x0,0x3d0e,0x0,0x0,0x0,0x0,0x0,0x0,0x3d0e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3d0e,0x0,0x3d0e,0x0,0x3d0e,0x0,0xc000000,0x1c2f1,0x1ffff,0x3d0e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_6() {
	   jj_la1_6 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x74780000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x77ffffe0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x74780000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x74780000,0x0,0x0,0x0,0x0,0x0,0x74780000,0x74780000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x74780000,0x0,0x0,0x0,0x0,0x74780000,0x74780000,0x0,0x0,0x0,0x74780000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x77ffffe0,0x74780000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x74780000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x300000,0x0,0x300000,0x0,0x300000,0x300000,0xc0400000,0x0,0x0,0x0,0x0,0x9ffa0,0x0,0x9ffa0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x74780000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x60000,0x0,0x60000,0x40040,0x0,0x40040,0x40040,0x0,0x40040,0x0,0x74780000,0x0,0x0,0x0,0x0,0x74780000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7fffffe0,0x0,0x7fffffe0,0x7fffffe0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x74780000,0x0,0x0,0x0,0x38100000,0x0,0x0,0x74780000,0x18400000,0x0,0x0,0x0,0x0,0x38000000,0x77780000,0x0,0x0,0x0,0x38000000,0x38000000,0x38000000,0x0,0x0,0x38000000,0x74780000,0x0,0x77780000,0x0,0x77780000,0x0,0x0,0x87ffe0,0x74ffffe0,0x74780000,0x3000000,0x0,0x0,0x0,0x30000000,0x38000000,0x0,0x0,};
	}
	private static void jj_la1_init_7() {
	   jj_la1_7 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x10,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x10,0x10,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x60,0x0,0x60,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe00,0x0,0x1000,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6010,0x6000,0x6010,0x6010,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x8000,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x8000,0x10,0x0,0x0,0x0,0x8000,0x8000,0x8000,0x0,0x0,0x8000,0x10,0x0,0x10,0x0,0x10,0x0,0x0,0x0,0x10,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
  private final JJCalls[] jj_2_rtns = new JJCalls[10];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /**
   * Constructor with user supplied CharStream.
   * @param stream stream to init with
   */
  public SchemaParser(final CharStream stream) {
	 token_source = new SchemaParserTokenManager(stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 243; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Reinitialise.
   * @param stream stream to init with
   */
  public void ReInit(final CharStream stream) {
	 token_source.ReInit(stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
   for (int i = 0; i < 243; i++)
     jj_la1[i] = -1;
   for (int i = 0; i < jj_2_rtns.length; i++)
     jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Constructor with generated Token Manager.
   * @param tm Token manager to use
   */
  public SchemaParser(final SchemaParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 243; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Reinitialise
   * @param tm Token manager to use
   */
  public void ReInit(final SchemaParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 243; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(final int kind) throws ParseException {
    final Token oldToken = token;
    if (token.next != null)
      token = token.next;
    else {
      token.next = token_source.getNextToken();
      token = token.next;
    }
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen)
              c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  private static final class LookaheadSuccess extends IllegalStateException {}
  private final LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		   jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		   jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


  /**
   * @return the next Token.
   */
  public final Token getNextToken() {
   if (token.next != null)
     token = token.next;
   else
     token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

  /**
   * @param index index to be retrieved
   * @return the specific Token.
   */
  public final Token getToken(final int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next == null)
        t.next = token_source.getNextToken();
      t = t.next;
    }
    return t;
  }

  private int jj_ntk_f() {
    final Token nt = jj_nt = token.next;
    final int ret;
    if (nt == null) {
      token.next = token_source.getNextToken();
      ret = jj_ntk = token.next.kind;
    }
    else
      ret = jj_ntk = nt.kind;
    return ret;
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
  if (pos >= 100) {
    return;
  }

  if (pos == jj_endpos + 1) {
    jj_lasttokens[jj_endpos++] = kind;
  } else if (jj_endpos != 0) {
    jj_expentry = new int[jj_endpos];

    for (int i = 0; i < jj_endpos; i++) {
      jj_expentry[i] = jj_lasttokens[i];
    }

    for (final int[] oldentry : jj_expentries) {
      if (oldentry.length == jj_expentry.length) {
        boolean isMatched = true;
        for (int i = 0; i < jj_expentry.length; i++) {
          if (oldentry[i] != jj_expentry[i]) {
            isMatched = false;
            break;
          }
        }
        if (isMatched) {
          jj_expentries.add(jj_expentry);
          break;
        }
      }
    }

    if (pos != 0) {
      jj_endpos = pos;
      jj_lasttokens[jj_endpos - 1] = kind;
    }
  }
}

  /**
   * Generate ParseException.
   * @return new Exception object. Never <code>null</code>
   */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[241];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 243; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
          if ((jj_la1_5[i] & (1<<j)) != 0) {
            la1tokens[160+j] = true;
          }
          if ((jj_la1_6[i] & (1<<j)) != 0) {
            la1tokens[192+j] = true;
          }
          if ((jj_la1_7[i] & (1<<j)) != 0) {
            la1tokens[224+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 241; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /**
   * @return Always <code>false</code>.
   */
  public final boolean trace_enabled() {
    return false;
  }

  /** Enable tracing. */
  public final void enable_tracing() {}

  /** Disable tracing. */
  public final void disable_tracing() {}

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 10; i++) {
      try {
        JJCalls p = jj_2_rtns[i];
        do {
          if (p.gen > jj_gen) {
            jj_la = p.arg;
            jj_scanpos = p.first;
            jj_lastpos = p.first;
            switch (i) {
              case 0: jj_3_1(); break;
              case 1: jj_3_2(); break;
              case 2: jj_3_3(); break;
              case 3: jj_3_4(); break;
              case 4: jj_3_5(); break;
              case 5: jj_3_6(); break;
              case 6: jj_3_7(); break;
              case 7: jj_3_8(); break;
              case 8: jj_3_9(); break;
              case 9: jj_3_10(); break;
            }
          }
          p = p.next;
        } while (p != null);
      } catch(LookaheadSuccess ls) { /* ignore */ }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) {
        p.next = new JJCalls();
        p = p.next;
        break;
      }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; 
    p.first = token;
    p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}
