/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom.chains;

import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.chain.Phase;
import com.yahoo.component.chain.dependencies.Dependencies;
import com.yahoo.component.chain.model.ChainSpecification;
import com.yahoo.config.model.builder.xml.XmlHelper;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.builder.xml.dom.chains.DependenciesBuilder;
import com.yahoo.vespa.model.builder.xml.dom.chains.InheritanceBuilder;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.w3c.dom.Element;

public class ChainSpecificationBuilder {
    private final ComponentId componentId;
    private final ChainSpecification.Inheritance inheritance;
    private final Collection<Phase> phases;

    public ChainSpecificationBuilder(Element chainElement) {
        this.componentId = this.readComponentId(chainElement);
        this.inheritance = this.readInheritance(chainElement);
        this.phases = this.readPhases(chainElement);
    }

    private Set<Phase> readPhases(Element parentElement) {
        LinkedHashSet<Phase> phases = new LinkedHashSet<Phase>();
        for (Element phaseSpec : XML.getChildren((Element)parentElement, (String)"phase")) {
            String name = XmlHelper.getIdString(phaseSpec);
            Dependencies dependencies = new DependenciesBuilder(phaseSpec).build();
            phases.add(new Phase(name, dependencies));
        }
        return phases;
    }

    private ComponentId readComponentId(Element spec) {
        return XmlHelper.getId(spec);
    }

    private ChainSpecification.Inheritance readInheritance(Element spec) {
        return new InheritanceBuilder(spec).build();
    }

    public ChainSpecification build(Set<ComponentSpecification> outerComponentReferences) {
        return new ChainSpecification(this.componentId, this.inheritance, this.phases, outerComponentReferences);
    }
}

