/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.ml;

import com.yahoo.path.Path;
import com.yahoo.searchlib.rankingexpression.rule.Arguments;
import com.yahoo.searchlib.rankingexpression.rule.ConstantNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import java.util.Optional;

public class FeatureArguments {
    private final Path path;
    private final Optional<String> signature;
    private final Optional<String> output;

    public FeatureArguments(Arguments arguments) {
        this(Path.fromString((String)FeatureArguments.argument(0, arguments)), FeatureArguments.optionalArgument(1, arguments), FeatureArguments.optionalArgument(2, arguments));
    }

    private FeatureArguments(Path path, Optional<String> signature, Optional<String> output) {
        this.path = path;
        this.signature = signature;
        this.output = output;
    }

    public Path path() {
        return this.path;
    }

    public Optional<String> signature() {
        return this.signature;
    }

    public Optional<String> output() {
        return this.output;
    }

    public String toName() {
        return (this.signature.isPresent() ? this.signature.get() : "") + (String)(this.output.isPresent() ? "." + this.output.get() : "");
    }

    private static String argument(int argumentIndex, Arguments arguments) {
        if (argumentIndex >= arguments.expressions().size()) {
            throw new IllegalArgumentException("Requires at least " + argumentIndex + " arguments, but got just " + arguments.size());
        }
        return FeatureArguments.asString((ExpressionNode)arguments.expressions().get(argumentIndex));
    }

    private static Optional<String> optionalArgument(int argumentIndex, Arguments arguments) {
        if (argumentIndex >= arguments.expressions().size()) {
            return Optional.empty();
        }
        return Optional.of(FeatureArguments.asString((ExpressionNode)arguments.expressions().get(argumentIndex)));
    }

    private static String asString(ExpressionNode node) {
        if (!(node instanceof ConstantNode)) {
            throw new IllegalArgumentException("Expected a constant string as argument, but got '" + String.valueOf(node));
        }
        return FeatureArguments.stripQuotes(node.toString());
    }

    private static String stripQuotes(String s) {
        if (!FeatureArguments.isQuoteSign(s.codePointAt(0))) {
            return s;
        }
        if (!FeatureArguments.isQuoteSign(s.codePointAt(s.length() - 1))) {
            throw new IllegalArgumentException("argument [" + s + "] is missing endquote");
        }
        return s.substring(1, s.length() - 1);
    }

    private static boolean isQuoteSign(int c) {
        return c == 39 || c == 34;
    }
}

