/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.component.chain;

import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.chain.model.ChainSpecification;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.container.core.ChainsConfig;
import com.yahoo.vespa.model.container.component.ComponentGroup;
import com.yahoo.vespa.model.container.component.chain.ChainedComponent;
import java.util.ArrayList;
import java.util.Collection;

public class Chain<T extends ChainedComponent<?>>
extends TreeConfigProducer<AnyConfigProducer> {
    private final ComponentId componentId;
    private final ChainSpecification specWithoutInnerComponents;
    private final ComponentGroup<T> innerComponentsGroup;
    private static final ChainsConfig.Chains.Type.Enum TYPE = ChainsConfig.Chains.Type.SEARCH;

    public Chain(ChainSpecification specWithoutInnerComponents) {
        super(specWithoutInnerComponents.componentId.stringValue());
        this.componentId = specWithoutInnerComponents.componentId;
        this.specWithoutInnerComponents = specWithoutInnerComponents;
        this.assertNoInnerComponents(specWithoutInnerComponents);
        this.innerComponentsGroup = new ComponentGroup((TreeConfigProducer<AnyConfigProducer>)this, "component");
    }

    private void assertNoInnerComponents(ChainSpecification specWithoutInnerComponents) {
        for (ComponentSpecification component : specWithoutInnerComponents.componentReferences) {
            assert (component.getNamespace() == null);
        }
    }

    public void addInnerComponent(T component) {
        this.innerComponentsGroup.addComponent(component);
    }

    public ChainSpecification getChainSpecification() {
        ArrayList<ComponentSpecification> innerComponentSpecifications = new ArrayList<ComponentSpecification>();
        for (ChainedComponent innerComponent : this.getInnerComponents()) {
            innerComponentSpecifications.add(innerComponent.getGlobalComponentId().toSpecification());
        }
        return this.specWithoutInnerComponents.addComponents(innerComponentSpecifications).setComponentId(this.getGlobalComponentId());
    }

    public Collection<T> getInnerComponents() {
        return this.innerComponentsGroup.getComponents();
    }

    public ComponentId getGlobalComponentId() {
        return this.componentId;
    }

    public final ComponentId getId() {
        return this.getGlobalComponentId();
    }

    public final ComponentId getComponentId() {
        return this.componentId;
    }

    public ChainsConfig.Chains.Type.Enum getType() {
        return TYPE;
    }

    public String toString() {
        return "chain '" + String.valueOf(this.componentId) + "'";
    }
}

