// Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
package com.yahoo.vespa.model.container.xml;

import com.yahoo.text.XML;
import com.yahoo.vespa.model.clients.ContainerDocumentApi;
import org.w3c.dom.Element;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;

/**
 * @author Einar M R Rosenvinge
 */
public class DocumentApiOptionsBuilder {

    private static final Logger log = Logger.getLogger(DocumentApiOptionsBuilder.class.getName());

    public static ContainerDocumentApi.HandlerOptions build(Element spec) {
        return new ContainerDocumentApi.HandlerOptions(getBindings(spec), XML.getChild(spec, "http-client-api"));
    }

    private static List<String> getBindings(Element spec) {
        Collection<Element> bindingElems =  XML.getChildren(spec, "binding");
        if (bindingElems.isEmpty())
            return List.of();
        List<String> bindings = new ArrayList<>();
        for (Element e :bindingElems) {
            String binding = getBinding(e);
            bindings.add(binding);
        }
        return bindings;
    }

    private static String getBinding(Element e) {
        String binding = XML.getValue(e);
        if (! binding.endsWith("/")) {
            log.warning("Adding a trailing '/' to the document-api binding: " + binding + " -> " + binding + "/");
            binding = binding + "/";
        }
        return binding;
    }

}
