/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.search.config.QrStartConfig;
import com.yahoo.vespa.model.admin.LogserverContainer;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.PlatformBundles;
import com.yahoo.vespa.model.container.component.Handler;
import com.yahoo.vespa.model.container.component.SystemBindingPattern;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LogserverContainerCluster
extends ContainerCluster<LogserverContainer> {
    public LogserverContainerCluster(TreeConfigProducer<?> parent, String name, DeployState deployState) {
        super(parent, name, name, deployState, true);
        this.addDefaultHandlersWithVip();
        this.addLogHandler();
        this.setJvmGCOptions(deployState.getProperties().jvmGCOptions(Optional.of(ClusterSpec.Type.admin)));
        if (this.isHostedVespa()) {
            this.addAccessLog(this.getName());
        }
    }

    @Override
    public void getConfig(QrStartConfig.Builder builder) {
        super.getConfig(builder);
        builder.jvm.heapsize(128);
    }

    @Override
    protected boolean messageBusEnabled() {
        return false;
    }

    private void addLogHandler() {
        Handler logHandler = Handler.fromClassName(ContainerCluster.LOG_HANDLER_CLASS);
        logHandler.addServerBindings(SystemBindingPattern.fromHttpPath("/logs"));
        this.addComponent(logHandler);
    }

    @Override
    protected Set<Path> unnecessaryPlatformBundles() {
        return Stream.concat(PlatformBundles.VESPA_SECURITY_BUNDLES.stream(), PlatformBundles.VESPA_ZK_BUNDLES.stream()).collect(Collectors.toSet());
    }
}

