/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.derived;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.document.Field;
import com.yahoo.io.IOUtils;
import com.yahoo.schema.Index;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.ImmutableSDField;
import com.yahoo.schema.document.SDDocumentType;
import com.yahoo.schema.document.SDField;
import com.yahoo.text.StringUtilities;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public abstract class Derived {
    private String name;

    public Derived() {
        this("");
    }

    public Derived(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    protected final void setName(String name) {
        this.name = name;
    }

    protected void derive(Schema schema) {
        this.setName(schema.getName());
        this.derive(schema.getDocument(), schema);
        for (Index index : schema.getExplicitIndices()) {
            this.derive(index, schema);
        }
        for (SDField field : schema.allExtraFields()) {
            this.derive(field, schema);
        }
        schema.allImportedFields().forEach(importedField -> this.derive((ImmutableSDField)importedField, schema));
    }

    protected void derive(SDDocumentType document, Schema schema) {
        for (Field field : document.fieldSet()) {
            SDField sdField = (SDField)field;
            if (sdField.isExtraField()) continue;
            this.derive(sdField, schema);
        }
    }

    protected void derive(ImmutableSDField field, Schema schema) {
    }

    protected void derive(Index index, Schema schema) {
    }

    protected abstract String getDerivedName();

    protected String getIndex(int number, boolean labels) {
        return labels ? this.getName() : String.valueOf(number);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void export(String toDirectory, ConfigInstance cfg) throws IOException {
        BufferedWriter writer = null;
        try {
            String fileName = this.getDerivedName() + ".cfg";
            if (toDirectory != null) {
                writer = IOUtils.createWriter((String)(toDirectory + "/" + fileName), (boolean)false);
                this.exportConfig(writer, cfg);
            }
        }
        finally {
            if (writer != null) {
                IOUtils.closeWriter(writer);
            }
        }
    }

    private void exportConfig(Writer writer, ConfigInstance cfg) throws IOException {
        List payloadL = ConfigInstance.serialize((InnerNode)cfg);
        String payload = StringUtilities.implodeMultiline((List)payloadL);
        writer.write(payload);
    }
}

