/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.derived;

import com.yahoo.config.ConfigInstance;
import com.yahoo.schema.Schema;
import com.yahoo.schema.derived.Derived;
import com.yahoo.schema.document.GeoPos;
import com.yahoo.schema.document.ImmutableSDField;
import com.yahoo.vespa.configdefinition.IlscriptsConfig;
import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.ExpressionVisitor;
import com.yahoo.vespa.indexinglanguage.expressions.AttributeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ClearStateExpression;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.GuardExpression;
import com.yahoo.vespa.indexinglanguage.expressions.InputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.OutputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.PassthroughExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ScriptExpression;
import com.yahoo.vespa.indexinglanguage.expressions.SetLanguageExpression;
import com.yahoo.vespa.indexinglanguage.expressions.StatementExpression;
import com.yahoo.vespa.indexinglanguage.expressions.TokenizeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ZCurveExpression;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class IndexingScript
extends Derived {
    private final List<String> docFields = new ArrayList<String>();
    private final List<Expression> expressions = new ArrayList<Expression>();
    private List<ImmutableSDField> fieldsSettingLanguage;
    private final boolean isStreaming;

    public IndexingScript(Schema schema, boolean isStreaming) {
        this.isStreaming = isStreaming;
        this.derive(schema);
    }

    @Override
    protected void derive(Schema schema) {
        this.fieldsSettingLanguage = this.fieldsSettingLanguage(schema);
        if (this.fieldsSettingLanguage.size() == 1) {
            this.addExpression(this.fieldsSettingLanguage.get(0).getIndexingScript());
        }
        super.derive(schema);
    }

    @Override
    protected void derive(ImmutableSDField field, Schema schema) {
        if (field.isImportedField()) {
            return;
        }
        if (field.hasFullIndexingDocprocRights()) {
            this.docFields.add(field.getName());
        }
        if (field.usesStructOrMap() && !GeoPos.isAnyPos(field)) {
            return;
        }
        if (this.fieldsSettingLanguage.size() == 1 && this.fieldsSettingLanguage.get(0).equals(field)) {
            return;
        }
        this.addExpression(field.getIndexingScript());
    }

    private void addExpression(ScriptExpression expression) {
        if (expression.isEmpty()) {
            return;
        }
        this.expressions.add((Expression)new StatementExpression(new Expression[]{new ClearStateExpression(), new GuardExpression((Expression)expression)}));
    }

    private List<ImmutableSDField> fieldsSettingLanguage(Schema schema) {
        return schema.allFieldsList().stream().filter(field -> !field.isImportedField()).filter(field -> field.containsExpression(SetLanguageExpression.class)).toList();
    }

    public Iterable<Expression> expressions() {
        return Collections.unmodifiableCollection(this.expressions);
    }

    @Override
    public String getDerivedName() {
        return "ilscripts";
    }

    public void getConfig(IlscriptsConfig.Builder configBuilder) {
        IlscriptsConfig.Ilscript.Builder ilscriptBuilder = new IlscriptsConfig.Ilscript.Builder();
        ilscriptBuilder.doctype(this.getName());
        ilscriptBuilder.docfield(this.docFields);
        this.addContentInOrder(ilscriptBuilder);
        configBuilder.ilscript(ilscriptBuilder);
    }

    public void export(String toDirectory) throws IOException {
        IlscriptsConfig.Builder builder = new IlscriptsConfig.Builder();
        this.getConfig(builder);
        this.export(toDirectory, (ConfigInstance)builder.build());
    }

    private void addContentInOrder(IlscriptsConfig.Ilscript.Builder ilscriptBuilder) {
        List<Expression> ordered = this.orderExpressions(this.expressions);
        HashSet<String> touchedFields = new HashSet<String>();
        for (Expression expression : ordered) {
            if (this.isStreaming) {
                expression = expression.convertChildren((ExpressionConverter)new DropTokenize());
                expression = expression.convertChildren((ExpressionConverter)new DropZcurve());
            }
            ilscriptBuilder.content(expression.toString());
            FieldScanVisitor fieldFetcher = new FieldScanVisitor();
            fieldFetcher.visit(expression);
            touchedFields.addAll(fieldFetcher.touchedFields());
        }
        this.generateSyntheticStatementsForUntouchedFields(ilscriptBuilder, touchedFields);
    }

    private List<Expression> orderExpressions(List<Expression> expressions) {
        ArrayList<Expression> result = new ArrayList<Expression>();
        List toProcess = expressions.stream().map(ToProcess::new).collect(Collectors.toList());
        for (ToProcess entry : toProcess) {
            if (entry.done) continue;
            for (String modifyingField : entry.modifiesSelf) {
                for (ToProcess checkUsing : toProcess) {
                    if (checkUsing.done || checkUsing == entry || !checkUsing.inputs.contains(modifyingField)) continue;
                    result.add(checkUsing.getExpression());
                }
            }
            result.add(entry.getExpression());
        }
        return result;
    }

    private void generateSyntheticStatementsForUntouchedFields(IlscriptsConfig.Ilscript.Builder ilscriptBuilder, Set<String> touchedFields) {
        HashSet<String> fieldsWithSyntheticStatements = new HashSet<String>(this.docFields);
        fieldsWithSyntheticStatements.removeAll(touchedFields);
        ArrayList<String> orderedFields = new ArrayList<String>(fieldsWithSyntheticStatements);
        Collections.sort(orderedFields);
        for (String fieldName : orderedFields) {
            StatementExpression copyField = new StatementExpression(new Expression[]{new InputExpression(fieldName), new PassthroughExpression(fieldName)});
            ilscriptBuilder.content(copyField.toString());
        }
    }

    private boolean setsLanguage(Expression expression) {
        SetsLanguageVisitor visitor = new SetsLanguageVisitor();
        visitor.visit(expression);
        return visitor.setsLanguage;
    }

    private boolean modifiesSelf(Expression expression) {
        ModifiesSelfVisitor visitor = new ModifiesSelfVisitor();
        visitor.visit(expression);
        return visitor.modifiesSelf();
    }

    private static class DropTokenize
    extends ExpressionConverter {
        private DropTokenize() {
        }

        protected boolean shouldConvert(Expression exp) {
            return exp instanceof TokenizeExpression;
        }

        protected Expression doConvert(Expression exp) {
            return null;
        }
    }

    private static class DropZcurve
    extends ExpressionConverter {
        private static final String zSuffix = "_zcurve";
        private static final int zSuffixLen = "_zcurve".length();
        private boolean seenZcurve = false;

        private DropZcurve() {
        }

        protected boolean shouldConvert(Expression exp) {
            if (exp instanceof ZCurveExpression) {
                this.seenZcurve = true;
                return true;
            }
            if (this.seenZcurve && exp instanceof AttributeExpression) {
                AttributeExpression attrExp = (AttributeExpression)exp;
                return attrExp.getFieldName().endsWith(zSuffix);
            }
            return false;
        }

        protected Expression doConvert(Expression exp) {
            AttributeExpression attrExp;
            String orig;
            int len;
            if (exp instanceof ZCurveExpression) {
                return null;
            }
            if (exp instanceof AttributeExpression && (len = (orig = (attrExp = (AttributeExpression)exp).getFieldName()).length()) > zSuffixLen && orig.endsWith(zSuffix)) {
                String fieldName = orig.substring(0, len - zSuffixLen);
                AttributeExpression result = new AttributeExpression(fieldName);
                return result;
            }
            return exp;
        }
    }

    private static class FieldScanVisitor
    extends ExpressionVisitor {
        List<String> touchedFields = new ArrayList<String>();
        List<String> candidates = new ArrayList<String>();

        private FieldScanVisitor() {
        }

        protected void doVisit(Expression exp) {
            if (exp instanceof OutputExpression) {
                this.touchedFields.add(((OutputExpression)exp).getFieldName());
            }
            if (exp instanceof InputExpression) {
                this.candidates.add(((InputExpression)exp).getFieldName());
            }
            if (exp instanceof ZCurveExpression) {
                this.touchedFields.addAll(this.candidates);
            }
        }

        Collection<String> touchedFields() {
            List<String> output = this.touchedFields;
            this.touchedFields = null;
            return output;
        }
    }

    private static class ToProcess {
        boolean done = false;
        final Set<String> inputs = new HashSet<String>();
        final Set<String> outputs = new HashSet<String>();
        final Set<String> modifiesSelf = new HashSet<String>();
        private Expression expr;

        Expression getExpression() {
            this.done = true;
            return this.expr;
        }

        ToProcess(Expression expr) {
            this.expr = expr;
            GetIOVisitor visitor = new GetIOVisitor();
            visitor.visit(expr);
            for (String out : this.outputs) {
                if (!this.inputs.contains(out)) continue;
                this.modifiesSelf.add(out);
            }
        }

        private class GetIOVisitor
        extends ExpressionVisitor {
            private GetIOVisitor() {
            }

            protected void doVisit(Expression expression) {
                if (expression instanceof InputExpression) {
                    InputExpression in = (InputExpression)expression;
                    ToProcess.this.inputs.add(in.getFieldName());
                }
                if (expression instanceof OutputExpression) {
                    OutputExpression out = (OutputExpression)expression;
                    ToProcess.this.outputs.add(out.getFieldName());
                }
            }
        }
    }

    private static class SetsLanguageVisitor
    extends ExpressionVisitor {
        boolean setsLanguage = false;

        private SetsLanguageVisitor() {
        }

        protected void doVisit(Expression expression) {
            if (expression instanceof SetLanguageExpression) {
                this.setsLanguage = true;
            }
        }
    }

    private static class ModifiesSelfVisitor
    extends ExpressionVisitor {
        private String inputField = null;
        private String outputField = null;

        private ModifiesSelfVisitor() {
        }

        public boolean modifiesSelf() {
            return this.outputField != null && this.outputField.equals(this.inputField);
        }

        protected void doVisit(Expression expression) {
            if (this.modifiesSelf()) {
                return;
            }
            if (expression instanceof InputExpression) {
                this.inputField = ((InputExpression)expression).getFieldName();
            }
            if (expression instanceof OutputExpression) {
                this.outputField = ((OutputExpression)expression).getFieldName();
            }
        }
    }
}

