/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.application.provider;

import com.yahoo.config.model.application.provider.FilesApplicationPackage;
import com.yahoo.io.IOUtils;
import com.yahoo.text.XML;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.w3c.dom.Element;

public class ApplicationDefinition {
    private final List<String> inherited;

    private ApplicationDefinition(List<String> inherited) {
        this.inherited = List.copyOf(inherited);
    }

    public List<String> inherited() {
        return this.inherited;
    }

    public List<FilesApplicationPackage> resolveInherited(Map<String, FilesApplicationPackage> inheritableApplications) {
        ArrayList<FilesApplicationPackage> inheritedPackages = new ArrayList<FilesApplicationPackage>();
        for (String inheritedId : this.inherited) {
            FilesApplicationPackage inheritedPackage = inheritableApplications.get(inheritedId);
            if (inheritedPackage == null) {
                throw new IllegalArgumentException("Inherited application '" + inheritedId + "' does not exist. Available applications: " + String.valueOf(inheritableApplications.keySet()));
            }
            inheritedPackages.add(inheritedPackage);
        }
        return inheritedPackages;
    }

    public static ApplicationDefinition empty() {
        return new ApplicationDefinition(List.of());
    }

    public static class XmlReader {
        public ApplicationDefinition read(Optional<Reader> reader) {
            return reader.isEmpty() ? ApplicationDefinition.empty() : this.read(reader.get());
        }

        public ApplicationDefinition read(Reader reader) {
            try {
                return this.read(IOUtils.readAll((Reader)reader));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not read application definition", e);
            }
        }

        public ApplicationDefinition read(String xmlForm) {
            Element root = XML.getDocument((String)xmlForm).getDocumentElement();
            return new ApplicationDefinition(this.readInherited(root));
        }

        private List<String> readInherited(Element root) {
            Element inherits = XML.getChild((Element)root, (String)"inherits");
            if (inherits == null) {
                return List.of();
            }
            return Arrays.stream(XML.getValue((Element)inherits).split(" ")).map(String::trim).toList();
        }
    }
}

