/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.application.provider;

import com.yahoo.component.Version;
import com.yahoo.component.Vtag;
import com.yahoo.config.application.Xml;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.application.api.ApplicationMetaData;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.ComponentInfo;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.DeploymentSpec;
import com.yahoo.config.application.api.UnparsedConfigDefinition;
import com.yahoo.config.codegen.CNode;
import com.yahoo.config.codegen.DefParser;
import com.yahoo.config.model.application.AbstractApplicationPackage;
import com.yahoo.config.model.application.provider.ApplicationDefinition;
import com.yahoo.config.model.application.provider.ApplicationPackagePreprocessor;
import com.yahoo.config.model.application.provider.ApplicationPackageXmlFilesValidator;
import com.yahoo.config.model.application.provider.Bundle;
import com.yahoo.config.model.application.provider.DeployData;
import com.yahoo.config.model.application.provider.FilesApplicationFile;
import com.yahoo.config.model.application.provider.IncludeDirs;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.ApplicationName;
import com.yahoo.config.provision.InstanceName;
import com.yahoo.config.provision.TenantName;
import com.yahoo.config.provision.Zone;
import com.yahoo.io.IOUtils;
import com.yahoo.io.reader.NamedReader;
import com.yahoo.path.Path;
import com.yahoo.vespa.config.ConfigDefinition;
import com.yahoo.vespa.config.ConfigDefinitionBuilder;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import com.yahoo.vespa.config.util.ConfigUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FilesApplicationPackage
extends AbstractApplicationPackage {
    public static final String preprocessed = ".preprocessed";
    private static final String META_FILE_NAME = ".applicationMetaData";
    private static final Map<Path, Set<String>> validFileExtensions = Map.ofEntries(Map.entry(Path.fromString((String)"components"), Set.of(".jar")), Map.entry(CONSTANTS_DIR, Set.of(".json", ".json.lz4")), Map.entry(Path.fromString((String)"docproc/chains"), Set.of(".xml")), Map.entry(PAGE_TEMPLATES_DIR, Set.of(".xml")), Map.entry(Path.fromString((String)"processor/chains"), Set.of(".xml")), Map.entry(QUERY_PROFILES_DIR, Set.of(".xml")), Map.entry(QUERY_PROFILE_TYPES_DIR, Set.of(".xml")), Map.entry(Path.fromString((String)"routing/tables"), Set.of(".xml")), Map.entry(RULES_DIR, Set.of(".sr")), Map.entry(SCHEMAS_DIR, Set.of(".sd", ".expression", ".profile")), Map.entry(Path.fromString((String)"search/chains"), Set.of(".xml")), Map.entry(SEARCH_DEFINITIONS_DIR, Set.of(".sd", ".expression", ".profile")), Map.entry(SECURITY_DIR, Set.of(".pem")));
    private final File appDir;
    private final File configDefsDir;
    private final List<String> userIncludeDirs = new ArrayList<String>();
    private final ApplicationMetaData metaData;
    private final boolean includeSourceFiles;
    private ApplicationDefinition applicationDefinition;
    private final List<FilesApplicationPackage> inherited;
    private DeploymentSpec deploymentSpec = null;
    private final ApplicationPackagePreprocessor preprocessor;

    private FilesApplicationPackage(File appDir, Optional<File> preprocessedDir, Optional<ApplicationMetaData> metaData, boolean includeSourceFiles, Map<String, FilesApplicationPackage> inheritableApplications) {
        this.verifyAppDir(appDir);
        this.appDir = appDir;
        this.includeSourceFiles = includeSourceFiles;
        this.applicationDefinition = new ApplicationDefinition.XmlReader().read(this.getApplicationDefinition());
        this.inherited = this.applicationDefinition.resolveInherited(inheritableApplications);
        this.metaData = metaData.orElse(this.readMetaData(appDir));
        this.configDefsDir = this.applicationFile("configdefinitions");
        this.addUserIncludeDirs();
        this.preprocessor = new ApplicationPackagePreprocessor(this, preprocessedDir, includeSourceFiles, inheritableApplications);
    }

    public ApplicationId getApplicationId() {
        return this.metaData.getApplicationId();
    }

    public List<NamedReader> getFiles(Path relativePath, String suffix, boolean recurse) {
        return this.getFiles(relativePath, "", suffix, recurse);
    }

    public ApplicationFile getFile(Path path) {
        File file = path.isRoot() ? this.appDir : this.applicationFile(path.getRelative());
        return new FilesApplicationFile(path, file);
    }

    public ApplicationFile getFileInThis(Path path) {
        File file = path.isRoot() ? this.appDir : FilesApplicationPackage.fileUnder(this.appDir, Path.fromString((String)path.getRelative()));
        return new FilesApplicationFile(path, file);
    }

    public ApplicationMetaData getMetaData() {
        return this.metaData;
    }

    private List<NamedReader> getFiles(Path relativePath, String namePrefix, String suffix, boolean recurse) {
        try {
            File dir = this.applicationFile(relativePath);
            if (!dir.isDirectory()) {
                return List.of();
            }
            LinkedHashSet<NamedReader> readers = new LinkedHashSet<NamedReader>();
            File[] files = dir.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isDirectory()) {
                        if (!recurse) continue;
                        readers.addAll(this.getFiles(relativePath.append(file.getName()), namePrefix + "/" + file.getName(), suffix, recurse));
                        continue;
                    }
                    if (suffix != null && !file.getName().endsWith(suffix)) continue;
                    readers.add(new NamedReader(file.getName(), (Reader)new FileReader(file)));
                }
            }
            for (FilesApplicationPackage inheritedPackage : this.inherited) {
                readers.addAll(inheritedPackage.getFiles(relativePath, namePrefix, suffix, recurse));
            }
            return List.copyOf(readers);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not open (all) files in '" + String.valueOf(relativePath) + "'", e);
        }
    }

    private void verifyAppDir(File appDir) {
        Objects.requireNonNull(appDir, "Path cannot be null");
        if (!appDir.exists()) {
            throw new IllegalArgumentException("Path '" + String.valueOf(appDir) + "' does not exist");
        }
        if (!appDir.isDirectory()) {
            throw new IllegalArgumentException("Path '" + String.valueOf(appDir) + "' is not a directory");
        }
        if (!appDir.canRead()) {
            throw new IllegalArgumentException("Cannot read from application directory '" + String.valueOf(appDir) + "'");
        }
    }

    public Reader getHosts() {
        try {
            File hostsFile = this.applicationFile("hosts.xml");
            if (!hostsFile.exists()) {
                return null;
            }
            return new FileReader(hostsFile);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Optional<Reader> getApplicationDefinition() {
        return this.asOptionalReader(this.getFileInThis(APPLICATION_DEFINITION_FILE));
    }

    public Optional<Reader> getDeployment() {
        return this.asOptionalReader(this.getFile(DEPLOYMENT_FILE));
    }

    public Optional<Reader> getValidationOverrides() {
        return this.asOptionalReader(this.getFile(VALIDATION_OVERRIDES));
    }

    private Optional<Reader> asOptionalReader(ApplicationFile file) {
        try {
            if (!file.exists()) {
                return Optional.empty();
            }
            return Optional.of(file.createReader());
        }
        catch (FileNotFoundException e) {
            return Optional.empty();
        }
    }

    public List<String> getUserIncludeDirs() {
        return Collections.unmodifiableList(this.userIncludeDirs);
    }

    public void addUserIncludeDirs() {
        Document services;
        try {
            services = Xml.getDocument(this.getServices());
        }
        catch (Exception e) {
            return;
        }
        NodeList includeNodes = services.getElementsByTagName("include");
        for (int i = 0; i < includeNodes.getLength(); ++i) {
            Node includeNode = includeNodes.item(i);
            this.addIncludeDir(includeNode);
        }
    }

    private void addIncludeDir(Node includeNode) {
        if (!(includeNode instanceof Element)) {
            return;
        }
        Element include = (Element)includeNode;
        if (!include.hasAttribute("dir")) {
            return;
        }
        String dir = include.getAttribute("dir");
        this.validateIncludeDir(dir);
        IncludeDirs.validateFilesInIncludedDir(dir, include.getParentNode(), this);
        this.userIncludeDirs.add(dir);
    }

    public void validateIncludeDir(String dirName) {
        IncludeDirs.validateIncludeDir(dirName, this);
    }

    public Collection<NamedReader> getSchemas() {
        LinkedHashSet<NamedReader> ret = new LinkedHashSet<NamedReader>();
        try {
            for (File f : this.getSchemaFiles()) {
                ret.add(new NamedReader(f.getName(), (Reader)new FileReader(f)));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Couldn't get schema contents.", e);
        }
        return ret;
    }

    private Reader retrieveConfigDefReaderFromThis(File defPath) {
        try {
            return new NamedReader(defPath.getPath(), (Reader)new FileReader(defPath));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read config definition file '" + String.valueOf(defPath) + "'", e);
        }
    }

    public Map<ConfigDefinitionKey, UnparsedConfigDefinition> getAllExistingConfigDefs() {
        LinkedHashMap<ConfigDefinitionKey, UnparsedConfigDefinition> defs = new LinkedHashMap<ConfigDefinitionKey, UnparsedConfigDefinition>();
        this.addAllDefsFromConfigDirInThis(defs, this.configDefsDir);
        if (this.includeSourceFiles) {
            this.addAllDefsFromConfigDirInThis(defs, new File("src/main/resources/configdefinitions"));
            this.addAllDefsFromConfigDirInThis(defs, new File("src/test/resources/configdefinitions"));
        }
        this.addAllDefsFromBundles(defs, this.getBundles());
        for (FilesApplicationPackage inheritedPackage : this.inherited) {
            inheritedPackage.addAllDefsFromConfigDirInThis(defs, this.configDefsDir);
            inheritedPackage.addAllDefsFromBundles(defs, this.getBundles());
        }
        return defs;
    }

    private void addAllDefsFromBundles(Map<ConfigDefinitionKey, UnparsedConfigDefinition> defs, List<Bundle> bundles) {
        for (Bundle bundle : bundles) {
            for (final Bundle.DefEntry def : bundle.getDefEntries()) {
                final ConfigDefinitionKey defKey = new ConfigDefinitionKey(def.defName, def.defNamespace);
                if (defs.containsKey(defKey)) continue;
                defs.put(defKey, new UnparsedConfigDefinition(){

                    public ConfigDefinition parse() {
                        DefParser parser = new DefParser(defKey.getName(), (Reader)new StringReader(def.contents));
                        return ConfigDefinitionBuilder.createConfigDefinition((CNode)parser.getTree());
                    }

                    public String getUnparsedContent() {
                        return def.contents;
                    }
                });
            }
        }
    }

    private void addAllDefsFromConfigDirInThis(Map<ConfigDefinitionKey, UnparsedConfigDefinition> defs, File configDefsDir) {
        if (!configDefsDir.isDirectory()) {
            return;
        }
        for (final File def : configDefsDir.listFiles((dir, name) -> name.matches(".*\\.def"))) {
            ConfigDefinitionKey key;
            try {
                key = ConfigUtils.createConfigDefinitionKeyFromDefFile((File)def);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read " + String.valueOf(def), e);
            }
            if (key.getNamespace().isEmpty()) {
                throw new IllegalArgumentException("Config definition '" + String.valueOf(def) + "' has no namespace");
            }
            if (defs.containsKey(key)) continue;
            defs.put(key, new UnparsedConfigDefinition(){

                public ConfigDefinition parse() {
                    DefParser parser = new DefParser(key.getName(), FilesApplicationPackage.this.retrieveConfigDefReaderFromThis(def));
                    return ConfigDefinitionBuilder.createConfigDefinition((CNode)parser.getTree());
                }

                public String getUnparsedContent() {
                    String string;
                    block8: {
                        Reader reader = FilesApplicationPackage.this.retrieveConfigDefReaderFromThis(def);
                        try {
                            string = IOUtils.readAll((Reader)reader);
                            if (reader == null) break block8;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (reader != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IOException e) {
                                throw new RuntimeException("Error reading config definition '" + String.valueOf(def) + "'", e);
                            }
                        }
                        reader.close();
                    }
                    return string;
                }
            });
        }
    }

    public Reader getServices() {
        try {
            return new FileReader(this.applicationFile("services.xml").getPath());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public List<File> getSchemaFiles() {
        HashMap<String, File> schemaFiles = new HashMap<String, File>();
        File sdDir = this.applicationFile(SEARCH_DEFINITIONS_DIR.getRelative());
        if (sdDir.isDirectory()) {
            for (File schemaFile : List.of(sdDir.listFiles((dir, name) -> FilesApplicationPackage.validSchemaFilename(name)))) {
                schemaFiles.putIfAbsent(schemaFile.getName(), schemaFile);
            }
        }
        if ((sdDir = this.applicationFile(SCHEMAS_DIR.getRelative())).isDirectory()) {
            for (File schemaFile : List.of(sdDir.listFiles((dir, name) -> FilesApplicationPackage.validSchemaFilename(name)))) {
                schemaFiles.putIfAbsent(schemaFile.getName(), schemaFile);
            }
        }
        for (FilesApplicationPackage inheritedPackage : this.inherited) {
            for (File schemaFile : inheritedPackage.getSchemaFiles()) {
                schemaFiles.putIfAbsent(schemaFile.getName(), schemaFile);
            }
        }
        return new ArrayList<File>(schemaFiles.values());
    }

    public List<Bundle> getBundles() {
        return Bundle.getBundles(this.applicationFile("components"));
    }

    private List<ComponentInfo> getComponentsInfo(File appDir) {
        return this.getBundles().stream().map(bundle -> new ComponentInfo(Path.fromString((String)"components").append(bundle.getFile().getName()).getRelative())).toList();
    }

    public List<ComponentInfo> getComponentsInfo(Version vespaVersion) {
        return this.getComponentsInfo(this.appDir);
    }

    public File getAppDir() {
        try {
            return this.appDir.getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not access " + String.valueOf(this.appDir), e);
        }
    }

    private ApplicationMetaData readMetaData(File appDir) {
        ApplicationMetaData applicationMetaData;
        String originalAppDir = preprocessed.equals(appDir.getName()) ? appDir.getParentFile().getName() : appDir.getName();
        ApplicationMetaData defaultMetaData = new ApplicationMetaData(Long.valueOf(0L), false, ApplicationId.from((TenantName)TenantName.defaultName(), (ApplicationName)ApplicationName.from((String)originalAppDir), (InstanceName)InstanceName.defaultName()), "", Long.valueOf(0L), 0L);
        File metaFile = this.applicationFile(META_FILE_NAME);
        if (!metaFile.exists()) {
            return defaultMetaData;
        }
        FileReader reader = new FileReader(metaFile);
        try {
            applicationMetaData = ApplicationMetaData.fromJsonString((String)IOUtils.readAll((Reader)reader));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return defaultMetaData;
            }
        }
        reader.close();
        return applicationMetaData;
    }

    public Reader getRankingExpression(String name) {
        try {
            return IOUtils.createReader((File)this.expressionFileNameToFile(name), (String)"utf-8");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read ranking expression file '" + name + "'", e);
        }
    }

    private File expressionFileNameToFile(String name) {
        if (new File(name).isAbsolute()) {
            throw new IllegalArgumentException("Absolute path to ranking expression file is not allowed: " + name);
        }
        Path path = Path.fromString((String)name);
        File expressionFile = this.applicationFile(SCHEMAS_DIR.append(path));
        if (!expressionFile.exists()) {
            expressionFile = this.applicationFile(SEARCH_DEFINITIONS_DIR.append(path));
        }
        return expressionFile;
    }

    public File getFileReference(Path pathRelativeToAppDir) {
        return this.applicationFile(pathRelativeToAppDir.getRelative());
    }

    public void validateXML() throws IOException {
        this.validateXMLFor(Optional.empty());
    }

    public void validateXMLFor(Optional<Version> vespaVersion) throws IOException {
        Version modelVersion = vespaVersion.orElse(Vtag.currentVersion);
        ApplicationPackageXmlFilesValidator validator = ApplicationPackageXmlFilesValidator.create(this.appDir, modelVersion);
        validator.checkApplication();
        validator.checkIncludedDirs(this);
    }

    public void writeMetaData() {
        File metaFile = this.applicationFile(META_FILE_NAME);
        IOUtils.writeFile((File)metaFile, (byte[])this.metaData.asJsonBytes());
    }

    public DeploymentSpec getDeploymentSpec() {
        if (this.deploymentSpec != null) {
            return this.deploymentSpec;
        }
        this.deploymentSpec = this.parseDeploymentSpec(false);
        return this.deploymentSpec;
    }

    public ApplicationPackage preprocess(Zone zone, DeployLogger logger) throws IOException {
        return this.preprocessor.preprocess(zone);
    }

    File applicationFile(String path) {
        return this.applicationFile(Path.fromString((String)path));
    }

    File applicationFile(Path path) {
        File file = FilesApplicationPackage.fileUnder(this.appDir, path);
        if (file.exists()) {
            return file;
        }
        for (FilesApplicationPackage inheritedPackage : this.inherited) {
            file = inheritedPackage.applicationFile(path);
            if (!file.exists()) continue;
            return file;
        }
        return FilesApplicationPackage.fileUnder(this.appDir, path);
    }

    public void validateFileExtensions() {
        validFileExtensions.forEach((subDir, __) -> this.validateInDir(subDir.toFile().toPath()));
    }

    private void validateInDir(java.nio.file.Path subDir) {
        java.nio.file.Path path = this.appDir.toPath().resolve(subDir);
        File subDirectory = path.toFile();
        if (!subDirectory.exists() || !subDirectory.isDirectory()) {
            return;
        }
        try (Stream<java.nio.file.Path> filesInPath = Files.list(path);){
            filesInPath.forEach(filePath -> {
                if (filePath.toFile().isDirectory()) {
                    this.validateInDir(this.appDir.toPath().relativize((java.nio.file.Path)filePath));
                } else {
                    this.validateFileExtensions((java.nio.file.Path)filePath);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to list files in '" + String.valueOf(subDirectory) + "'", e);
        }
    }

    private void validateFileExtensions(java.nio.file.Path pathToFile) {
        Set<String> allowedExtensions = this.findAllowedExtensions(this.appDir.toPath().relativize(pathToFile).getParent());
        String fileName = pathToFile.toFile().getName();
        if (allowedExtensions.stream().noneMatch(fileName::endsWith)) {
            String message = "File in application package with unknown extension: " + String.valueOf(this.appDir.toPath().relativize(pathToFile.getParent()).resolve(fileName)) + ", please delete or move file to another directory.";
            throw new IllegalArgumentException(message);
        }
    }

    private Set<String> findAllowedExtensions(java.nio.file.Path relativeDirectory) {
        HashSet<String> validExtensions = new HashSet<String>();
        validExtensions.add(".gitignore");
        if (this.isSchemasSubDir(relativeDirectory)) {
            validExtensions.add(".profile");
        } else {
            validExtensions.addAll(validFileExtensions.entrySet().stream().filter(entry -> ((Path)entry.getKey()).equals((Object)Path.fromString((String)relativeDirectory.toString()))).map(Map.Entry::getValue).findFirst().orElse(Set.of()));
        }
        return validExtensions;
    }

    private boolean isSchemasSubDir(java.nio.file.Path relativeDirectory) {
        java.nio.file.Path searchDefinitionsPath;
        java.nio.file.Path schemasPath = SCHEMAS_DIR.toFile().toPath().getName(0);
        if (List.of(schemasPath, searchDefinitionsPath = SEARCH_DEFINITIONS_DIR.toFile().toPath().getName(0)).contains(relativeDirectory)) {
            return false;
        }
        return relativeDirectory.startsWith(String.valueOf(schemasPath) + "/") || relativeDirectory.startsWith(String.valueOf(searchDefinitionsPath) + "/");
    }

    public String toString() {
        return "application package '" + String.valueOf(this.appDir) + "'";
    }

    static File fileUnder(File root, Path path) {
        File file = new File(root, path.getRelative());
        if (!file.getAbsolutePath().startsWith(root.getAbsolutePath())) {
            throw new IllegalArgumentException(String.valueOf(file) + " is not a child of " + String.valueOf(root));
        }
        return file;
    }

    public static FilesApplicationPackage fromDir(File appDir, Map<String, FilesApplicationPackage> inheritableApplications) {
        return FilesApplicationPackage.fromDir(appDir, false, inheritableApplications);
    }

    public static FilesApplicationPackage fromDir(File appDir, boolean includeSourceFiles, Map<String, FilesApplicationPackage> inheritableApplications) {
        return new Builder(appDir).preprocessedDir(FilesApplicationPackage.fileUnder(appDir, Path.fromString((String)preprocessed))).includeSourceFiles(includeSourceFiles).inheritableApplications(inheritableApplications).build();
    }

    public static FilesApplicationPackage fromDir(File appDir, DeployData deployData, Map<String, FilesApplicationPackage> inheritableApplications) {
        return FilesApplicationPackage.fromDir(appDir, deployData, false, inheritableApplications);
    }

    public static FilesApplicationPackage fromDir(File appDir, DeployData deployData, boolean includeSourceFiles, Map<String, FilesApplicationPackage> inheritableApplications) {
        return new Builder(appDir).includeSourceFiles(includeSourceFiles).deployData(deployData).inheritableApplications(inheritableApplications).build();
    }

    public static class Builder {
        private final File appDir;
        private Optional<File> preprocessedDir = Optional.empty();
        private Optional<ApplicationMetaData> metaData = Optional.empty();
        private boolean includeSourceFiles = false;
        private Map<String, FilesApplicationPackage> inheritableApplications = new HashMap<String, FilesApplicationPackage>();

        public Builder(File appDir) {
            this.appDir = appDir;
        }

        public Builder preprocessedDir(File preprocessedDir) {
            this.preprocessedDir = Optional.ofNullable(preprocessedDir);
            return this;
        }

        public Builder deployData(DeployData deployData) {
            this.metaData = Optional.of(deployData.toMetaData(this.appDir));
            return this;
        }

        public Builder includeSourceFiles(boolean includeSourceFiles) {
            this.includeSourceFiles = includeSourceFiles;
            return this;
        }

        public Builder inheritableApplications(Map<String, FilesApplicationPackage> inheritableApplications) {
            this.inheritableApplications = Map.copyOf(inheritableApplications);
            return this;
        }

        public FilesApplicationPackage build() {
            return new FilesApplicationPackage(this.appDir, this.preprocessedDir, this.metaData, this.includeSourceFiles, this.inheritableApplications);
        }
    }
}

