/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.classanalysis;

import com.google.common.collect.Sets;
import com.yahoo.api.annotations.PublicApi;
import com.yahoo.container.plugin.classanalysis.ClassFileMetaData;
import com.yahoo.container.plugin.classanalysis.ExportPackageAnnotation;
import com.yahoo.container.plugin.classanalysis.PackageInfo;
import com.yahoo.container.plugin.classanalysis.Packages;
import com.yahoo.container.plugin.util.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class PackageTally {
    private final Map<String, PackageInfo> definedPackages;
    private final Set<String> referencedPackagesUnfiltered;

    PackageTally(Map<String, PackageInfo> definedPackages, Set<String> referencedPackagesUnfiltered) {
        this.definedPackages = definedPackages;
        this.referencedPackagesUnfiltered = referencedPackagesUnfiltered;
    }

    public Set<String> definedPackages() {
        return this.definedPackages.keySet();
    }

    public Set<String> referencedPackages() {
        return Sets.difference(this.referencedPackagesUnfiltered, this.definedPackages());
    }

    public Map<String, ExportPackageAnnotation> exportedPackages() {
        HashMap<String, ExportPackageAnnotation> ret = new HashMap<String, ExportPackageAnnotation>();
        this.definedPackages.forEach((pkg, pkgInfo) -> pkgInfo.exportPackage().ifPresent(a -> ret.put((String)pkg, (ExportPackageAnnotation)a)));
        return ret;
    }

    public Set<String> publicApiPackages() {
        return this.definedPackages.values().stream().filter(PackageInfo::isPublicApi).map(PackageInfo::name).collect(Collectors.toSet());
    }

    public Set<String> nonPublicApiExportedPackages() {
        return this.definedPackages.values().stream().filter(pkgInfo -> pkgInfo.exportPackage().isPresent()).filter(pkgInfo -> !pkgInfo.isPublicApi()).map(PackageInfo::name).collect(Collectors.toSet());
    }

    public Set<String> referencedPackagesMissingFrom(Set<String> definedAndExportedPackages) {
        return Sets.difference(this.referencedPackages(), definedAndExportedPackages).stream().filter(pkg -> !pkg.startsWith("java.")).filter(pkg -> !pkg.equals(PublicApi.class.getPackageName())).collect(Collectors.toSet());
    }

    public PackageTally combine(PackageTally other) {
        Map<String, PackageInfo> definedPkgs = Maps.combine(this.definedPackages, other.definedPackages, PackageInfo::hasExportPackageOrElse);
        HashSet<String> referencedPkgs = new HashSet<String>(this.referencedPackagesUnfiltered);
        referencedPkgs.addAll(other.referencedPackagesUnfiltered);
        return new PackageTally(definedPkgs, referencedPkgs);
    }

    public static PackageTally combine(Collection<PackageTally> packageTallies) {
        HashMap<String, PackageInfo> definedPkgs = new HashMap<String, PackageInfo>();
        HashSet<String> referencedPkgs = new HashSet<String>();
        for (PackageTally tally : packageTallies) {
            tally.definedPackages.forEach((pkg, info) -> definedPkgs.merge((String)pkg, (PackageInfo)info, PackageInfo::hasExportPackageOrElse));
            referencedPkgs.addAll(tally.referencedPackagesUnfiltered);
        }
        return new PackageTally(definedPkgs, referencedPkgs);
    }

    public static PackageTally fromAnalyzedClassFiles(Collection<ClassFileMetaData> analyzedClassFiles) {
        HashMap<String, PackageInfo> definedPkgs = new HashMap<String, PackageInfo>();
        HashSet<String> referencedPkgs = new HashSet<String>();
        for (ClassFileMetaData classData : analyzedClassFiles) {
            String pkgName = classData.packageInfo().name();
            definedPkgs.merge(pkgName, classData.packageInfo(), PackageInfo::hasExportPackageOrElse);
            classData.getReferencedClasses().forEach(className -> referencedPkgs.add(Packages.packageName(className)));
        }
        return new PackageTally(definedPkgs, referencedPkgs);
    }
}

