// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.application;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of mock-application
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class MockApplicationConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "344d60741788d0ae7e460c04670c3a17";
  public final static String CONFIG_DEF_NAME = "mock-application";
  public final static String CONFIG_DEF_NAMESPACE = "application";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=application",
    "mystruct.id string",
    "mystruct.value string",
    "mystructlist[].id string",
    "mystructlist[].value string",
    "mylist[] string",
    "mymap{} string",
    "mymapstruct{}.id string",
    "mymapstruct{}.value string"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public Mystruct.Builder mystruct = new Mystruct.Builder();
    public List<Mystructlist.Builder> mystructlist = new ArrayList<>();
    public List<String> mylist = new ArrayList<>();
    public Map<String, String> mymap = new LinkedHashMap<>();
    public Map<String, Mymapstruct.Builder> mymapstruct = new LinkedHashMap<>();

    public Builder() { }

    public Builder(MockApplicationConfig config) {
      mystruct(new Mystruct.Builder(config.mystruct()));
      for (Mystructlist m : config.mystructlist()) {
        mystructlist(new Mystructlist.Builder(m));
      }
      mylist(config.mylist());
      mymap(config.mymap());
      for (Map.Entry<String, Mymapstruct> __entry : config.mymapstruct().entrySet()) {
        mymapstruct(__entry.getKey(), new Mymapstruct.Builder(__entry.getValue()));
      }
    }

    private Builder override(Builder __superior) {
      mystruct(mystruct.override(__superior.mystruct));
      if (!__superior.mystructlist.isEmpty())
        mystructlist.addAll(__superior.mystructlist);
      if (!__superior.mylist.isEmpty())
        mylist.addAll(__superior.mylist);
      mymap(__superior.mymap);
      mymapstruct(__superior.mymapstruct);
      return this;
    }

    public Builder mystruct(Mystruct.Builder __builder) {
      mystruct = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder mystruct(java.util.function.Consumer<Mystruct.Builder> __func) {
      Mystruct.Builder __inner = new Mystruct.Builder();
      __func.accept(__inner);
      mystruct = __inner;
      return this;
    }

    /**
     * Add the given builder to this builder's list of Mystructlist builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder mystructlist(Mystructlist.Builder __builder) {
      mystructlist.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder mystructlist(java.util.function.Consumer<Mystructlist.Builder> __func) {
      Mystructlist.Builder __inner = new Mystructlist.Builder();
      __func.accept(__inner);
      mystructlist.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Mystructlist builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder mystructlist(List<Mystructlist.Builder> __builders) {
      mystructlist = __builders;
      return this;
    }

    public Builder mylist(String __value) {
      mylist.add(__value);
      return this;
    }

    public Builder mylist(Collection<String> __values) {
      mylist.addAll(__values);
      return this;
    }

    public Builder mymap(String __key, String __value) {
      mymap.put(__key, __value);
      return this;
    }

    public Builder mymap(Map<String, String> __values) {
      mymap.putAll(__values);
      return this;
    }

    public Builder mymapstruct(String __key, Mymapstruct.Builder __value) {
      mymapstruct.put(__key, __value);
      return this;
    }

    public Builder mymapstruct(Map<String, Mymapstruct.Builder> __values) {
      mymapstruct.putAll(__values);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before using it as the value
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder mymapstruct(String __key, java.util.function.Consumer<Mymapstruct.Builder> __func) {
      Mymapstruct.Builder __inner = new Mymapstruct.Builder();
      __func.accept(__inner);
      mymapstruct.put(__key, __inner);
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public MockApplicationConfig build() {
      return new MockApplicationConfig(this);
    }

  }

  private final Mystruct mystruct;
  private final InnerNodeVector<Mystructlist> mystructlist;
  private final LeafNodeVector<String, StringNode> mylist;
  private final Map<String, StringNode> mymap;
  private final Map<String, Mymapstruct> mymapstruct;

  public MockApplicationConfig(Builder builder) {
    this(builder, true);
  }

  private MockApplicationConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "mock-application must be initialized: " + builder.__uninitialized);

    mystruct = new Mystruct(builder.mystruct, throwIfUninitialized);
    mystructlist = Mystructlist.createVector(builder.mystructlist);
    mylist = new LeafNodeVector<>(builder.mylist, new StringNode());
    mymap = LeafNodeMaps.asNodeMap(builder.mymap, new StringNode());
    mymapstruct = Mymapstruct.createMap(builder.mymapstruct);
  }

  /**
   * @return mock-application.mystruct
   */
  public Mystruct mystruct() {
    return mystruct;
  }

  /**
   * @return mock-application.mystructlist[]
   */
  public List<Mystructlist> mystructlist() {
    return mystructlist;
  }

  /**
   * @param i the index of the value to return
   * @return mock-application.mystructlist[]
   */
  public Mystructlist mystructlist(int i) {
    return mystructlist.get(i);
  }

  /**
   * @return mock-application.mylist[]
   */
  public List<String> mylist() {
    return mylist.asList();
  }

  /**
   * @param i the index of the value to return
   * @return mock-application.mylist[]
   */
  public String mylist(int i) {
    return mylist.get(i).value();
  }

  /**
   * @return mock-application.mymap{}
   */
  public Map<String, String> mymap() {
    return LeafNodeMaps.asValueMap(mymap);
  }

  /**
   * @param key the key of the value to return
   * @return mock-application.mymap{}
   */
  public String mymap(String key) {
    return mymap.get(key).value();
  }

  /**
   * @return mock-application.mymapstruct{}
   */
  public Map<String, Mymapstruct> mymapstruct() {
    return Collections.unmodifiableMap(mymapstruct);
  }

  /**
   * @param key the key of the value to return
   * @return mock-application.mymapstruct{}
   */
  public Mymapstruct mymapstruct(String key) {
    return mymapstruct.get(key);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(MockApplicationConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("mock-application");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents mock-application.mystruct
   */
  public final static class Mystruct extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "id",
        "value"
        ));

      private String id = null;
      private String value = null;

      public Builder() { }

      public Builder(Mystruct config) {
        id(config.id());
        value(config.value());
      }

      private Builder override(Builder __superior) {
        if (__superior.id != null)
          id(__superior.id);
        if (__superior.value != null)
          value(__superior.value);
        return this;
      }

      public Builder id(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        id = __value;
        __uninitialized.remove("id");
        return this;
      }


      public Builder value(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        value = __value;
        __uninitialized.remove("value");
        return this;
      }


      public Mystruct build() {
        return new Mystruct(this);
      }

    }

    private final StringNode id;
    private final StringNode value;

    public Mystruct(Builder builder) {
      this(builder, true);
    }

    private Mystruct(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "mock-application.mystruct must be initialized: " + builder.__uninitialized);

      id = (builder.id == null) ?
          new StringNode() : new StringNode(builder.id);
      value = (builder.value == null) ?
          new StringNode() : new StringNode(builder.value);
    }

    /**
     * @return mock-application.mystruct.id
     */
    public String id() {
      return id.value();
    }

    /**
     * @return mock-application.mystruct.value
     */
    public String value() {
      return value.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Mystruct newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("mystruct");
      return changes;
    }
  }

  /**
   * This class represents mock-application.mystructlist[]
   */
  public final static class Mystructlist extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "id",
        "value"
        ));

      private String id = null;
      private String value = null;

      public Builder() { }

      public Builder(Mystructlist config) {
        id(config.id());
        value(config.value());
      }

      private Builder override(Builder __superior) {
        if (__superior.id != null)
          id(__superior.id);
        if (__superior.value != null)
          value(__superior.value);
        return this;
      }

      public Builder id(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        id = __value;
        __uninitialized.remove("id");
        return this;
      }


      public Builder value(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        value = __value;
        __uninitialized.remove("value");
        return this;
      }


      public Mystructlist build() {
        return new Mystructlist(this);
      }

    }

    private final StringNode id;
    private final StringNode value;

    public Mystructlist(Builder builder) {
      this(builder, true);
    }

    private Mystructlist(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "mock-application.mystructlist[] must be initialized: " + builder.__uninitialized);

      id = (builder.id == null) ?
          new StringNode() : new StringNode(builder.id);
      value = (builder.value == null) ?
          new StringNode() : new StringNode(builder.value);
    }

    /**
     * @return mock-application.mystructlist[].id
     */
    public String id() {
      return id.value();
    }

    /**
     * @return mock-application.mystructlist[].value
     */
    public String value() {
      return value.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Mystructlist newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("mystructlist");
      return changes;
    }

    private static InnerNodeVector<Mystructlist> createVector(List<Builder> builders) {
        List<Mystructlist> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Mystructlist(b));
        }
        return new InnerNodeVector<Mystructlist>(elems);
    }
  }

  /**
   * This class represents mock-application.mymapstruct{}
   */
  public final static class Mymapstruct extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "id",
        "value"
        ));

      private String id = null;
      private String value = null;

      public Builder() { }

      public Builder(Mymapstruct config) {
        id(config.id());
        value(config.value());
      }

      private Builder override(Builder __superior) {
        if (__superior.id != null)
          id(__superior.id);
        if (__superior.value != null)
          value(__superior.value);
        return this;
      }

      public Builder id(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        id = __value;
        __uninitialized.remove("id");
        return this;
      }


      public Builder value(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        value = __value;
        __uninitialized.remove("value");
        return this;
      }


      public Mymapstruct build() {
        return new Mymapstruct(this);
      }

    }

    private final StringNode id;
    private final StringNode value;

    public Mymapstruct(Builder builder) {
      this(builder, true);
    }

    private Mymapstruct(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "mock-application.mymapstruct{} must be initialized: " + builder.__uninitialized);

      id = (builder.id == null) ?
          new StringNode() : new StringNode(builder.id);
      value = (builder.value == null) ?
          new StringNode() : new StringNode(builder.value);
    }

    /**
     * @return mock-application.mymapstruct{}.id
     */
    public String id() {
      return id.value();
    }

    /**
     * @return mock-application.mymapstruct{}.value
     */
    public String value() {
      return value.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Mymapstruct newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("mymapstruct");
      return changes;
    }

    private static Map<String, Mymapstruct> createMap(Map<String, Builder> builders) {
      Map<String, Mymapstruct> ret = new LinkedHashMap<>();
      for(String key : builders.keySet()) {
        ret.put(key, new Mymapstruct(builders.get(key)));
      }
      return Collections.unmodifiableMap(ret);
    }
  }

}
