/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.zms;

import com.yahoo.athenz.zms.AssertionEffect;
import com.yahoo.rdl.Schema;
import com.yahoo.rdl.SchemaBuilder;

public class ZMSSchema {
    private static final Schema INSTANCE = ZMSSchema.build();

    public static Schema instance() {
        return INSTANCE;
    }

    private static Schema build() {
        SchemaBuilder sb = new SchemaBuilder("ZMS");
        sb.version(1);
        sb.namespace("com.yahoo.athenz.zms");
        sb.comment("Copyright 2016 Yahoo Inc. Licensed under the terms of the Apache version 2.0 license. See LICENSE file for terms. The Authorization Management Service (ZMS) Classes");
        sb.stringType("SimpleName").comment("Copyright 2016 Yahoo Inc. Licensed under the terms of the Apache version 2.0 license. See LICENSE file for terms. Common name types used by several API definitions A simple identifier, an element of compound name.").pattern("[a-zA-Z0-9_][a-zA-Z0-9_-]*");
        sb.stringType("CompoundName").comment("A compound name. Most names in this API are compound names.").pattern("([a-zA-Z0-9_][a-zA-Z0-9_-]*\\.)*[a-zA-Z0-9_][a-zA-Z0-9_-]*");
        sb.stringType("DomainName").comment("A domain name is the general qualifier prefix, as its uniqueness is managed.").pattern("([a-zA-Z0-9_][a-zA-Z0-9_-]*\\.)*[a-zA-Z0-9_][a-zA-Z0-9_-]*");
        sb.stringType("EntityName").comment("An entity name is a short form of a resource name, including only the domain and entity.").pattern("([a-zA-Z0-9_][a-zA-Z0-9_-]*\\.)*[a-zA-Z0-9_][a-zA-Z0-9_-]*");
        sb.stringType("ServiceName").comment("A service name will generally be a unique subdomain.").pattern("([a-zA-Z0-9_][a-zA-Z0-9_-]*\\.)*[a-zA-Z0-9_][a-zA-Z0-9_-]*");
        sb.stringType("LocationName").comment("A location name is not yet defined, but will be a dotted name like everything else.").pattern("([a-zA-Z0-9_][a-zA-Z0-9_-]*\\.)*[a-zA-Z0-9_][a-zA-Z0-9_-]*");
        sb.stringType("ActionName").comment("An action (operation) name.").pattern("([a-zA-Z0-9_][a-zA-Z0-9_-]*\\.)*[a-zA-Z0-9_][a-zA-Z0-9_-]*");
        sb.stringType("ResourceName").comment("A resource name Note that the EntityName part is optional, that is, a domain name followed by a colon is valid resource name.").pattern("([a-zA-Z0-9_][a-zA-Z0-9_-]*\\.)*[a-zA-Z0-9_][a-zA-Z0-9_-]*(:([a-zA-Z0-9_][a-zA-Z0-9_-]*\\.)*[a-zA-Z0-9_][a-zA-Z0-9_-]*)?");
        sb.stringType("ResourceNames").comment("A comma separated list of resource names").pattern("(([a-zA-Z0-9_][a-zA-Z0-9_-]*\\.)*[a-zA-Z0-9_][a-zA-Z0-9_-]*(:([a-zA-Z0-9_][a-zA-Z0-9_-]*\\.)*[a-zA-Z0-9_][a-zA-Z0-9_-]*)?,)*([a-zA-Z0-9_][a-zA-Z0-9_-]*\\.)*[a-zA-Z0-9_][a-zA-Z0-9_-]*(:([a-zA-Z0-9_][a-zA-Z0-9_-]*\\.)*[a-zA-Z0-9_][a-zA-Z0-9_-]*)?");
        sb.stringType("YBase64").comment("The Y-specific URL-safe Base64 variant.").pattern("[a-zA-Z0-9\\._-]+");
        sb.stringType("YEncoded").comment("YEncoded includes ybase64 chars, as well as = and %. This can represent a user cookie and URL-encoded values.").pattern("[a-zA-Z0-9\\._%=-]*");
        sb.stringType("AuthorityName").comment("Used as the prefix in a signed assertion. This uniquely identifies a signing authority.").pattern("([a-zA-Z0-9_][a-zA-Z0-9_-]*\\.)*[a-zA-Z0-9_][a-zA-Z0-9_-]*");
        sb.stringType("SignedToken").comment("A signed assertion if identity. i.e. the user cookie value. This token will only make sense to the authority that generated it, so it is beneficial to have something in the value that is cheaply recognized to quickly reject if it belongs to another authority. In addition to the YEncoded set our token includes ; to separate components and , to separate roles and : for IPv6 addresses").pattern("[a-zA-Z0-9\\._%=:;,-]*");
        sb.stringType("GroupName").comment("A group name").pattern("([a-zA-Z0-9_][a-zA-Z0-9_-]*\\.)*[a-zA-Z0-9_][a-zA-Z0-9_-]*:group\\.([a-zA-Z0-9_][a-zA-Z0-9_-]*\\.)*[a-zA-Z0-9_][a-zA-Z0-9_-]*");
        sb.stringType("GroupMemberName").comment("A group member name").pattern("([a-zA-Z0-9_][a-zA-Z0-9_-]*\\.)*[a-zA-Z0-9_][a-zA-Z0-9_-]*");
        sb.stringType("MemberName").comment("Role Member name - could be one of four values: *, DomainName.* or ServiceName[*], or GroupNames").pattern("\\*|([a-zA-Z0-9_][a-zA-Z0-9_-]*\\.)*[a-zA-Z0-9_][a-zA-Z0-9_-]*\\.\\*|([a-zA-Z0-9_][a-zA-Z0-9_-]*\\.)*[a-zA-Z0-9_][a-zA-Z0-9_-]*(\\*)?|([a-zA-Z0-9_][a-zA-Z0-9_-]*\\.)*[a-zA-Z0-9_][a-zA-Z0-9_-]*:group\\.([a-zA-Z0-9_][a-zA-Z0-9_-]*\\.)*[a-zA-Z0-9_][a-zA-Z0-9_-]*");
        sb.stringType("AuthorityKeyword").comment("A comma separated list of authority keywords").pattern("[a-zA-Z0-9_][a-zA-Z0-9_-]*");
        sb.stringType("AuthorityKeywords").pattern("([a-zA-Z0-9_][a-zA-Z0-9_-]*,)*[a-zA-Z0-9_][a-zA-Z0-9_-]*");
        sb.stringType("TagValue").comment("TagValue to contain generic string patterns").pattern("[a-zA-Z0-9_:,\\/][a-zA-Z0-9_:,\\/-]*");
        sb.stringType("TagCompoundValue").comment("A compound value of TagValue").pattern("([a-zA-Z0-9_:,\\/][a-zA-Z0-9_:,\\/-]*\\.)*[a-zA-Z0-9_:,\\/][a-zA-Z0-9_:,\\/-]*");
        sb.structType("TagValueList").arrayField("list", "TagCompoundValue", false, "list of tag values");
        sb.stringType("AssertionConditionKeyPattern").pattern("[a-zA-Z][a-zA-Z0-9_-]+");
        sb.stringType("AssertionConditionKey").pattern("([a-zA-Z][a-zA-Z0-9_-]+\\.)*[a-zA-Z][a-zA-Z0-9_-]+");
        sb.stringType("AssertionConditionValuePattern").pattern("[a-zA-Z0-9\\*][a-zA-Z0-9_\\.\\*-]*");
        sb.stringType("AssertionConditionValue").pattern("([a-zA-Z0-9\\*][a-zA-Z0-9_\\.\\*-]*,)*[a-zA-Z0-9\\*][a-zA-Z0-9_\\.\\*-]*");
        sb.structType("DomainMeta").comment("Set of metadata attributes that all domains may have and can be changed.").field("description", "String", true, "a description of the domain").field("org", "ResourceName", true, "a reference to an audit organization defined in athenz").field("enabled", "Bool", true, "Future use only, currently not used", (Object)true).field("auditEnabled", "Bool", true, "Flag indicates whether or not domain modifications should be logged for SOX+Auditing. If true, the auditRef parameter must be supplied(not empty) for any API defining it.", (Object)false).field("account", "String", true, "associated aws account id (system attribute - uniqueness check)").field("ypmId", "Int32", true, "associated product id (system attribute - uniqueness check)").field("applicationId", "String", true, "associated application id").field("certDnsDomain", "String", true, "domain certificate dns domain (system attribute)").field("memberExpiryDays", "Int32", true, "all user members in the domain will have specified max expiry days").field("tokenExpiryMins", "Int32", true, "tokens issued for this domain will have specified max timeout in mins").field("serviceCertExpiryMins", "Int32", true, "service identity certs issued for this domain will have specified max timeout in mins").field("roleCertExpiryMins", "Int32", true, "role certs issued for this domain will have specified max timeout in mins").field("signAlgorithm", "SimpleName", true, "rsa or ec signing algorithm to be used for tokens").field("serviceExpiryDays", "Int32", true, "all services in the domain roles will have specified max expiry days").field("groupExpiryDays", "Int32", true, "all groups in the domain roles will have specified max expiry days").field("userAuthorityFilter", "String", true, "membership filtered based on user authority configured attributes").field("azureSubscription", "String", true, "associated azure subscription id (system attribute - uniqueness check)").mapField("tags", "CompoundName", "TagValueList", true, "key-value pair tags, tag might contain multiple values").field("businessService", "String", true, "associated business service with domain");
        sb.structType("Domain", "DomainMeta").comment("A domain is an independent partition of users, roles, and resources. Its name represents the definition of a namespace; the only way a new namespace can be created, from the top, is by creating Domains. Administration of a domain is governed by the parent domain (using reverse-DNS namespaces). The top level domains are governed by the special \"sys.auth\" domain.").field("name", "DomainName", false, "the common name to be referred to, the symbolic id. It is immutable").field("modified", "Timestamp", true, "the last modification timestamp of any object or attribute in this domain").field("id", "UUID", true, "unique identifier of the domain. generated on create, never reused");
        sb.structType("DomainMetaList").comment("A list of domain objects with their meta attributes.").arrayField("domains", "Domain", false, "list of domain objects");
        sb.structType("DomainList").comment("A paginated list of domains.").arrayField("names", "DomainName", false, "list of domain names").field("next", "String", true, "if the response is a paginated list, this attribute specifies the value to be used in the next domain list request as the value for the skip query parameter.");
        sb.structType("RoleList").comment("The representation for an enumeration of roles in the namespace, with pagination.").arrayField("names", "EntityName", false, "list of role names").field("next", "String", true, "if the response is a paginated list, this attribute specifies the value to be used in the next role list request as the value for the skip query parameter.");
        sb.structType("RoleAuditLog").comment("An audit log entry for role membership change.").field("member", "MemberName", false, "name of the role member").field("admin", "ResourceName", false, "name of the principal executing the change").field("created", "Timestamp", false, "timestamp of the entry").field("action", "String", false, "log action - e.g. add, delete, approve, etc").field("auditRef", "String", true, "audit reference string for the change as supplied by admin");
        sb.structType("RoleMember").field("memberName", "MemberName", false, "name of the member").field("expiration", "Timestamp", true, "the expiration timestamp").field("reviewReminder", "Timestamp", true, "the review reminder timestamp").field("active", "Bool", true, "Flag to indicate whether membership is active", (Object)true).field("approved", "Bool", true, "Flag to indicate whether membership is approved either by delegates ( in case of auditEnabled roles ) or by domain admins ( in case of selfserve roles )", (Object)true).field("auditRef", "String", true, "audit reference string for the change as supplied by admin").field("requestTime", "Timestamp", true, "for pending membership requests, the request time").field("lastNotifiedTime", "Timestamp", true, "for pending membership requests, time when last notification was sent").field("requestPrincipal", "ResourceName", true, "pending members only - name of the principal requesting the change").field("reviewLastNotifiedTime", "Timestamp", true, "for pending membership requests, time when last notification was sent (for file store)").field("systemDisabled", "Int32", true, "user disabled by system based on configured role setting").field("principalType", "Int32", true, "server use only - principal type: unknown(0), user(1), service(2), or group(3)");
        sb.structType("RoleMeta").comment("Set of metadata attributes that all roles may have and can be changed by domain admins.").field("selfServe", "Bool", true, "Flag indicates whether or not role allows self service. Users can add themselves in the role, but it has to be approved by domain admins to be effective.", (Object)false).field("memberExpiryDays", "Int32", true, "all user members in the role will have specified max expiry days").field("tokenExpiryMins", "Int32", true, "tokens issued for this role will have specified max timeout in mins").field("certExpiryMins", "Int32", true, "certs issued for this role will have specified max timeout in mins").field("signAlgorithm", "SimpleName", true, "rsa or ec signing algorithm to be used for tokens").field("serviceExpiryDays", "Int32", true, "all services in the role will have specified max expiry days").field("memberReviewDays", "Int32", true, "all user members in the role will have specified max review days").field("serviceReviewDays", "Int32", true, "all services in the role will have specified max review days").field("reviewEnabled", "Bool", true, "Flag indicates whether or not role updates require another review and approval", (Object)false).field("notifyRoles", "String", true, "list of roles whose members should be notified for member review/approval").field("userAuthorityFilter", "String", true, "membership filtered based on user authority configured attributes").field("userAuthorityExpiration", "String", true, "expiration enforced by a user authority configured attribute").field("groupExpiryDays", "Int32", true, "all groups in the domain roles will have specified max expiry days").field("groupReviewDays", "Int32", true, "all groups in the domain roles will have specified max review days").mapField("tags", "CompoundName", "TagValueList", true, "key-value pair tags, tag might contain multiple values");
        sb.structType("Role", "RoleMeta").comment("The representation for a Role with set of members.").field("name", "ResourceName", false, "name of the role").field("modified", "Timestamp", true, "last modification timestamp of the role").arrayField("members", "MemberName", true, "an explicit list of members. Might be empty or null, if trust is set").arrayField("roleMembers", "RoleMember", true, "members with expiration").field("trust", "DomainName", true, "a trusted domain to delegate membership decisions to").arrayField("auditLog", "RoleAuditLog", true, "an audit log for role membership changes").field("auditEnabled", "Bool", true, "Flag indicates whether or not role updates should require GRC approval. If true, the auditRef parameter must be supplied(not empty) for any API defining it", (Object)false).field("lastReviewedDate", "Timestamp", true, "last review timestamp of the role");
        sb.structType("Roles").comment("The representation for a list of roles with full details").arrayField("list", "Role", false, "list of role objects");
        sb.structType("Membership").comment("The representation for a role membership.").field("memberName", "MemberName", false, "name of the member").field("isMember", "Bool", true, "flag to indicate whether or the user is a member or not", (Object)true).field("roleName", "ResourceName", true, "name of the role").field("expiration", "Timestamp", true, "the expiration timestamp").field("reviewReminder", "Timestamp", true, "the review reminder timestamp").field("active", "Bool", true, "Flag to indicate whether membership is active", (Object)true).field("approved", "Bool", true, "Flag to indicate whether membership is approved either by delegates ( in case of auditEnabled roles ) or by domain admins ( in case of selfserve roles )", (Object)true).field("auditRef", "String", true, "audit reference string for the change as supplied by admin").field("requestPrincipal", "ResourceName", true, "pending members only - name of the principal requesting the change").field("systemDisabled", "Int32", true, "user disabled by system based on configured role setting");
        sb.structType("DefaultAdmins").comment("The list of domain administrators.").arrayField("admins", "ResourceName", false, "list of domain administrators");
        sb.structType("MemberRole").field("roleName", "ResourceName", false, "name of the role").field("domainName", "DomainName", true, "name of the domain").field("memberName", "MemberName", true, "name of the member").field("expiration", "Timestamp", true, "the expiration timestamp").field("reviewReminder", "Timestamp", true, "the review reminder timestamp").field("active", "Bool", true, "Flag to indicate whether membership is active", (Object)true).field("auditRef", "String", true, "audit reference string for the change as supplied by admin").field("requestPrincipal", "EntityName", true, "pending members only - name of the principal requesting the change").field("requestTime", "Timestamp", true, "for pending membership requests, the request time").field("systemDisabled", "Int32", true, "user disabled by system based on configured role setting");
        sb.structType("DomainRoleMember").field("memberName", "MemberName", false, "name of the member").arrayField("memberRoles", "MemberRole", false, "roles for this member");
        sb.structType("DomainRoleMembers").field("domainName", "DomainName", false, "name of the domain").arrayField("members", "DomainRoleMember", false, "role members");
        sb.structType("RoleSystemMeta").comment("Set of system metadata attributes that all roles may have and can be changed by system admins.").field("auditEnabled", "Bool", true, "Flag indicates whether or not role updates should be approved by GRC. If true, the auditRef parameter must be supplied(not empty) for any API defining it.", (Object)false);
        sb.enumType("AssertionEffect").comment("Every assertion can have the effect of ALLOW or DENY.").element("ALLOW").element("DENY");
        sb.enumType("AssertionConditionOperator").comment("Allowed operators for assertion conditions").element("EQUALS");
        sb.structType("AssertionConditionData").comment("A representation of details associated with an assertion condition key").field("operator", "AssertionConditionOperator", false, "Operator for the assertion condition").field("value", "AssertionConditionValue", false, "Value of the assertion condition");
        sb.structType("AssertionCondition").comment("A representation of condition associated with an assertion").field("id", "Int32", true, "condition id - auto generated by server. Not required during put operations.").mapField("conditionsMap", "AssertionConditionKey", "AssertionConditionData", false, "each key in the map represents a unique condition. All the keys present in the map form a logical condition with AND operation.");
        sb.structType("AssertionConditions").comment("The representation of list of assertion conditions").arrayField("conditionsList", "AssertionCondition", false, "list of assertion conditions.");
        sb.structType("Assertion").comment("A representation for the encapsulation of an action to be performed on a resource by a principal.").field("role", "String", false, "the subject of the assertion - a role").field("resource", "String", false, "the object of the assertion. Must be in the local namespace. Can contain wildcards").field("action", "String", false, "the predicate of the assertion. Can contain wildcards").field("effect", "AssertionEffect", true, "the effect of the assertion in the policy language", (Object)AssertionEffect.ALLOW).field("id", "Int64", true, "assertion id - auto generated by server. Not required during put operations.").field("caseSensitive", "Bool", true, "If true, we should store action and resource in their original case").field("conditions", "AssertionConditions", true, "optional list of assertion conditions associated with given assertion");
        sb.structType("Policy").comment("The representation for a Policy with set of assertions.").field("name", "ResourceName", false, "name of the policy").field("modified", "Timestamp", true, "last modification timestamp of this policy").arrayField("assertions", "Assertion", false, "list of defined assertions for this policy").field("caseSensitive", "Bool", true, "If true, we should store action and resource in their original case").field("version", "SimpleName", true, "optional version string, defaults to 0").field("active", "Bool", true, "if multi-version policy then indicates active version");
        sb.structType("Policies").comment("The representation of list of policy objects").arrayField("list", "Policy", false, "list of policy objects");
        sb.structType("PolicyOptions").comment("Options for Policy Management Requests").field("version", "SimpleName", false, "policy version").field("fromVersion", "SimpleName", true, "optional source version used when creating a new version, defaults to 0");
        sb.structType("PublicKeyEntry").comment("The representation of the public key in a service identity object.").field("key", "String", false, "the public key for the service").field("id", "String", false, "the key identifier (version or zone name)");
        sb.structType("ServiceIdentity").comment("The representation of the service identity object.").field("name", "ServiceName", false, "the full name of the service, i.e. \"sports.storage\"").field("description", "String", true, "description of the service").arrayField("publicKeys", "PublicKeyEntry", true, "array of public keys for key rotation").field("providerEndpoint", "String", true, "if present, then this service can provision tenants via this endpoint.").field("modified", "Timestamp", true, "the timestamp when this entry was last modified").field("executable", "String", true, "the path of the executable that runs the service").arrayField("hosts", "String", true, "list of host names that this service can run on").field("user", "String", true, "local (unix) user name this service can run as").field("group", "String", true, "local (unix) group name this service can run as");
        sb.structType("ServiceIdentities").comment("The representation of list of services").arrayField("list", "ServiceIdentity", false, "list of services");
        sb.structType("ServiceIdentityList").comment("The representation for an enumeration of services in the namespace, with pagination.").arrayField("names", "EntityName", false, "list of service names").field("next", "String", true, "if the response is a paginated list, this attribute specifies the value to be used in the next service list request as the value for the skip query parameter.");
        sb.structType("ServiceIdentitySystemMeta").comment("Set of system metadata attributes that all services may have and can be changed by system admins.").field("providerEndpoint", "String", true, "provider callback endpoint");
        sb.structType("TemplateMetaData").comment("MetaData for template.").field("templateName", "String", true, "name of the template").field("description", "String", true, "description of the template").field("currentVersion", "Int32", true, "Version from DB(zms_store->domain_template->version)").field("latestVersion", "Int32", true, "Bumped up version from solutions-template.json when there is a change").field("keywordsToReplace", "String", true, "placeholders in the template roles/policies to replace (ex:_service_)").field("timestamp", "Timestamp", true, "the updated timestamp of the template(solution_templates.json)").field("autoUpdate", "Bool", true, "flag to automatically update the roles/policies that belongs to the template");
        sb.structType("Template").comment("Solution Template object defined on the server").arrayField("roles", "Role", false, "list of roles in the template").arrayField("policies", "Policy", false, "list of policies defined in this template").arrayField("services", "ServiceIdentity", true, "list of services defined in this template").field("metadata", "TemplateMetaData", true, "list of services defined in this template");
        sb.structType("TemplateList").comment("List of template names that is the base struct for server and domain templates").arrayField("templateNames", "SimpleName", false, "list of template names");
        sb.structType("TemplateParam").field("name", "SimpleName", false, "name of the parameter").field("value", "CompoundName", false, "value of the parameter");
        sb.structType("DomainTemplate", "TemplateList").comment("solution template(s) to be applied to a domain").arrayField("params", "TemplateParam", true, "optional template parameters");
        sb.structType("DomainTemplateList", "TemplateList").comment("List of solution templates to be applied to a domain");
        sb.structType("ServerTemplateList", "TemplateList").comment("List of solution templates available in the server");
        sb.structType("DomainTemplateDetailsList").comment("List of templates with metadata details given a domain").arrayField("metaData", "TemplateMetaData", false, "list of template metadata");
        sb.structType("TopLevelDomain", "DomainMeta").comment("Top Level Domain object. The required attributes include the name of the domain and list of domain administrators.").field("name", "SimpleName", false, "name of the domain").arrayField("adminUsers", "ResourceName", false, "list of domain administrators").field("templates", "DomainTemplateList", true, "list of solution template names");
        sb.structType("SubDomain", "TopLevelDomain").comment("A Subdomain is a TopLevelDomain, except it has a parent.").field("parent", "DomainName", false, "name of the parent domain");
        sb.structType("UserDomain", "DomainMeta").comment("A UserDomain is the user's own top level domain in user - e.g. user.hga").field("name", "SimpleName", false, "user id which will be the domain name").field("templates", "DomainTemplateList", true, "list of solution template names");
        sb.structType("DomainMetaStoreValidValuesList").comment("List of valid domain meta attribute values").arrayField("validValues", "String", false, "list of valid values for attribute");
        sb.structType("DanglingPolicy").comment("A dangling policy where the assertion is referencing a role name that doesn't exist in the domain").field("policyName", "EntityName", false, "").field("roleName", "EntityName", false, "");
        sb.structType("DomainDataCheck").comment("Domain data object representing the results of a check operation looking for dangling roles, policies and trust relationships that are set either on tenant or provider side only").arrayField("danglingRoles", "EntityName", true, "Names of roles not specified in any assertion. Might be empty or null if no dangling roles.").arrayField("danglingPolicies", "DanglingPolicy", true, "Policy+role tuples where role doesnt exist. Might be empty or null if no dangling policies.").field("policyCount", "Int32", false, "total number of policies").field("assertionCount", "Int32", false, "total number of assertions").field("roleWildCardCount", "Int32", false, "total number of assertions containing roles as wildcards").arrayField("providersWithoutTrust", "ServiceName", true, "Service names (domain.service) that dont contain trust role if this is a tenant domain. Might be empty or null, if not a tenant or if all providers support this tenant.").arrayField("tenantsWithoutAssumeRole", "DomainName", true, "Names of Tenant domains that dont contain assume role assertions if this is a provider domain. Might be empty or null, if not a provider or if all tenants support use this provider.");
        sb.structType("Entity").comment("An entity is a name and a structured value. some entity names/prefixes are reserved (i.e. \"role\",  \"policy\", \"meta\", \"domain\", \"service\")").field("name", "ResourceName", false, "name of the entity object").field("value", "Struct", false, "value of the entity");
        sb.structType("EntityList").comment("The representation for an enumeration of entities in the namespace").arrayField("names", "EntityName", false, "list of entity names");
        sb.structType("GroupAuditLog").comment("An audit log entry for group membership change.").field("member", "GroupMemberName", false, "name of the group member").field("admin", "ResourceName", false, "name of the principal executing the change").field("created", "Timestamp", false, "timestamp of the entry").field("action", "String", false, "log action - e.g. add, delete, approve, etc").field("auditRef", "String", true, "audit reference string for the change as supplied by admin");
        sb.structType("GroupMember").field("memberName", "GroupMemberName", true, "name of the member").field("groupName", "ResourceName", true, "name of the group").field("domainName", "DomainName", true, "name of the domain").field("expiration", "Timestamp", true, "the expiration timestamp").field("active", "Bool", true, "Flag to indicate whether membership is active", (Object)true).field("approved", "Bool", true, "Flag to indicate whether membership is approved either by delegates ( in case of auditEnabled groups ) or by domain admins ( in case of selfserve groups )", (Object)true).field("auditRef", "String", true, "audit reference string for the change as supplied by admin").field("requestTime", "Timestamp", true, "for pending membership requests, the request time").field("lastNotifiedTime", "Timestamp", true, "for pending membership requests, time when last notification was sent").field("requestPrincipal", "ResourceName", true, "pending members only - name of the principal requesting the change").field("reviewLastNotifiedTime", "Timestamp", true, "for pending membership requests, time when last notification was sent (for file store)").field("systemDisabled", "Int32", true, "user disabled by system based on configured group setting").field("principalType", "Int32", true, "server use only - principal type: unknown(0), user(1) or service(2)");
        sb.structType("GroupMembership").comment("The representation for a group membership.").field("memberName", "GroupMemberName", false, "name of the member").field("isMember", "Bool", true, "flag to indicate whether or the user is a member or not", (Object)true).field("groupName", "ResourceName", true, "name of the group").field("expiration", "Timestamp", true, "the expiration timestamp").field("active", "Bool", true, "Flag to indicate whether membership is active", (Object)true).field("approved", "Bool", true, "Flag to indicate whether membership is approved either by delegates ( in case of auditEnabled groups ) or by domain admins ( in case of selfserve groups )", (Object)true).field("auditRef", "String", true, "audit reference string for the change as supplied by admin").field("requestPrincipal", "ResourceName", true, "pending members only - name of the principal requesting the change").field("systemDisabled", "Int32", true, "user disabled by system based on configured group setting");
        sb.structType("GroupMeta").comment("Set of metadata attributes that all groups may have and can be changed by domain admins.").field("selfServe", "Bool", true, "Flag indicates whether or not group allows self service. Users can add themselves in the group, but it has to be approved by domain admins to be effective.", (Object)false).field("reviewEnabled", "Bool", true, "Flag indicates whether or not group updates require another review and approval", (Object)false).field("notifyRoles", "String", true, "list of roles whose members should be notified for member review/approval").field("userAuthorityFilter", "String", true, "membership filtered based on user authority configured attributes").field("userAuthorityExpiration", "String", true, "expiration enforced by a user authority configured attribute").field("memberExpiryDays", "Int32", true, "all user members in the group will have specified max expiry days").field("serviceExpiryDays", "Int32", true, "all services in the group will have specified max expiry days").mapField("tags", "CompoundName", "TagValueList", true, "key-value pair tags, tag might contain multiple values");
        sb.structType("Group", "GroupMeta").comment("The representation for a Group with set of members.").field("name", "ResourceName", false, "name of the group").field("modified", "Timestamp", true, "last modification timestamp of the group").arrayField("groupMembers", "GroupMember", true, "members with expiration").arrayField("auditLog", "GroupAuditLog", true, "an audit log for group membership changes").field("auditEnabled", "Bool", true, "Flag indicates whether or not group updates should require GRC approval. If true, the auditRef parameter must be supplied(not empty) for any API defining it", (Object)false).field("lastReviewedDate", "Timestamp", true, "last review timestamp of the group");
        sb.structType("Groups").comment("The representation for a list of groups with full details").arrayField("list", "Group", false, "list of group objects");
        sb.structType("DomainGroupMember").field("memberName", "GroupMemberName", false, "name of the member").arrayField("memberGroups", "GroupMember", false, "groups for this member");
        sb.structType("DomainGroupMembers").field("domainName", "DomainName", false, "name of the domain").arrayField("members", "DomainGroupMember", false, "group members");
        sb.structType("DomainGroupMembership").arrayField("domainGroupMembersList", "DomainGroupMembers", false, "");
        sb.structType("GroupSystemMeta").comment("Set of system metadata attributes that all groups may have and can be changed by system admins.").field("auditEnabled", "Bool", true, "Flag indicates whether or not group updates should be approved by GRC. If true, the auditRef parameter must be supplied(not empty) for any API defining it.", (Object)false);
        sb.structType("PolicyList").comment("The representation for an enumeration of policies in the namespace, with pagination.").arrayField("names", "EntityName", false, "list of policy names").field("next", "String", true, "if the response is a paginated list, this attribute specifies the value to be used in the next policy list request as the value for the skip query parameter.");
        sb.structType("Tenancy").comment("A representation of tenant.").field("domain", "DomainName", false, "the domain that is to get a tenancy").field("service", "ServiceName", false, "the provider service on which the tenancy is to reside").arrayField("resourceGroups", "EntityName", true, "registered resource groups for this tenant").field("createAdminRole", "Bool", true, "optional flag indicating whether to create a default tenancy admin role", (Object)true);
        sb.structType("TenantRoleAction").comment("A representation of tenant role action.").field("role", "SimpleName", false, "name of the role").field("action", "String", false, "action value for the generated policy assertion");
        sb.structType("TenantResourceGroupRoles").comment("A representation of tenant roles for resource groups to be provisioned.").field("domain", "DomainName", false, "name of the provider domain").field("service", "SimpleName", false, "name of the provider service").field("tenant", "DomainName", false, "name of the tenant domain").arrayField("roles", "TenantRoleAction", false, "the role/action pairs to provision").field("resourceGroup", "EntityName", false, "tenant resource group");
        sb.structType("ProviderResourceGroupRoles").comment("A representation of provider roles to be provisioned.").field("domain", "DomainName", false, "name of the provider domain").field("service", "SimpleName", false, "name of the provider service").field("tenant", "DomainName", false, "name of the tenant domain").arrayField("roles", "TenantRoleAction", false, "the role/action pairs to provision").field("resourceGroup", "EntityName", false, "tenant resource group").field("createAdminRole", "Bool", true, "optional flag indicating whether to create a default tenancy admin role", (Object)true).field("skipPrincipalMember", "Bool", true, "optional flag indicating to skip adding the caller principal into the resource role", (Object)false);
        sb.structType("Access").comment("Access can be checked and returned as this resource.").field("granted", "Bool", false, "true (allowed) or false (denied)");
        sb.structType("ResourceAccess").field("principal", "ResourceName", false, "").arrayField("assertions", "Assertion", false, "");
        sb.structType("ResourceAccessList").arrayField("resources", "ResourceAccess", false, "");
        sb.structType("DomainPolicies").comment("We need to include the name of the domain in this struct since this data will be passed back to ZPU through ZTS so we need to sign not only the list of policies but also the corresponding domain name that the policies belong to.").field("domain", "DomainName", false, "name of the domain").arrayField("policies", "Policy", false, "list of policies defined in this server");
        sb.structType("SignedPolicies").comment("A signed bulk transfer of policies. The data is signed with server's private key.").field("contents", "DomainPolicies", false, "list of policies defined in a domain").field("signature", "String", false, "signature generated based on the domain active policies object").field("keyId", "String", false, "the identifier of the key used to generate the signature");
        sb.structType("DomainData", "DomainMeta").comment("A domain object that includes its roles, policies and services.").field("name", "DomainName", false, "name of the domain").arrayField("roles", "Role", false, "list of roles in the domain").field("policies", "SignedPolicies", false, "list of policies in the domain signed with ZMS private key").arrayField("services", "ServiceIdentity", false, "list of services in the domain").arrayField("entities", "Entity", false, "list of entities in the domain").arrayField("groups", "Group", false, "list of groups in the domain").field("modified", "Timestamp", false, "last modification timestamp");
        sb.structType("SignedDomain").comment("A domain object signed with server's private key. The signature and keyid are optional if the metaonly flag is set to true in the getSignedDomains api call").field("domain", "DomainData", false, "domain object with its roles, policies and services").field("signature", "String", true, "signature generated based on the domain object").field("keyId", "String", true, "the identifier of the key used to generate the signature");
        sb.structType("SignedDomains").comment("A list of signed domain objects").arrayField("domains", "SignedDomain", false, "");
        sb.structType("JWSDomain").comment("SignedDomain using flattened JWS JSON Serialization syntax. https://tools.ietf.org/html/rfc7515#section-7.2.2").field("payload", "String", false, "").field("protected", "String", false, "").mapField("header", "String", "String", false, "").field("signature", "String", false, "");
        sb.structType("UserToken").comment("A user token generated based on user's credentials").field("token", "SignedToken", false, "Signed user token identifying a specific authenticated user").field("header", "String", true, "Authorization header name for the token");
        sb.structType("ServicePrincipal").comment("A service principal object identifying a given service.").field("domain", "DomainName", false, "name of the domain").field("service", "EntityName", false, "name of the service").field("token", "SignedToken", false, "service's signed token");
        sb.structType("User").comment("The representation for a user").field("name", "SimpleName", false, "name of the user");
        sb.structType("UserList").arrayField("names", "SimpleName", false, "list of user names");
        sb.structType("Quota").comment("The representation for a quota object").field("name", "DomainName", false, "name of the domain object").field("subdomain", "Int32", false, "number of subdomains allowed (applied at top level domain level)").field("role", "Int32", false, "number of roles allowed").field("roleMember", "Int32", false, "number of members a role may have").field("policy", "Int32", false, "number of policies allowed").field("assertion", "Int32", false, "total number of assertions a policy may have").field("entity", "Int32", false, "total number of entity objects").field("service", "Int32", false, "number of services allowed").field("serviceHost", "Int32", false, "number of hosts allowed per service").field("publicKey", "Int32", false, "number of public keys per service").field("group", "Int32", false, "number of groups per domain").field("groupMember", "Int32", false, "number of members a group may have").field("modified", "Timestamp", true, "the last modification timestamp of the quota object");
        sb.structType("Status").comment("The representation for a status object").field("code", "Int32", false, "status message code").field("message", "String", false, "status message of the server");
        sb.structType("DomainRoleMembership").arrayField("domainRoleMembersList", "DomainRoleMembers", false, "");
        sb.structType("UserAuthorityAttributes").comment("Copyright Athenz Authors Licensed under the terms of the Apache version 2.0 license. See LICENSE file for terms.").arrayField("values", "String", false, "");
        sb.structType("UserAuthorityAttributeMap").comment("Map of user authority attributes").mapField("attributes", "SimpleName", "UserAuthorityAttributes", false, "map of type to attribute values");
        sb.structType("Stats").comment("The representation for a stats object").field("name", "DomainName", true, "name of the domain object, null for system stats").field("subdomain", "Int32", false, "number of subdomains in this domain (all levels)").field("role", "Int32", false, "number of roles").field("roleMember", "Int32", false, "number of members in all the roles").field("policy", "Int32", false, "number of policies").field("assertion", "Int32", false, "total number of assertions in all policies").field("entity", "Int32", false, "total number of entity objects").field("service", "Int32", false, "number of services").field("serviceHost", "Int32", false, "number of hosts defined in all services").field("publicKey", "Int32", false, "number of public keys in all services").field("group", "Int32", false, "number of groups").field("groupMember", "Int32", false, "number of members in all the groups");
        sb.structType("DependentService").comment("Dependent service provider details").field("service", "ServiceName", false, "name of the service");
        sb.resource("Domain", "GET", "/domain/{domain}").comment("Get info for the specified domain, by name. This request only returns the configured domain attributes and not any domain objects like roles, policies or service identities.").pathParam("domain", "DomainName", "name of the domain").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("DomainList", "GET", "/domain").comment("Enumerate domains. Can be filtered by prefix and depth, and paginated. Most of the query options that are looking for specific domain attributes (e.g. aws account, azure subscriptions, business service, tags, etc) are mutually exclusive. The server will only process the first query argument and ignore the others.").queryParam("limit", "limit", "Int32", null, "restrict the number of results in this call").queryParam("skip", "skip", "String", null, "restrict the set to those after the specified \"next\" token returned from a previous call").queryParam("prefix", "prefix", "String", null, "restrict to names that start with the prefix").queryParam("depth", "depth", "Int32", null, "restrict the depth of the name, specifying the number of '.' characters that can appear").queryParam("account", "account", "String", null, "restrict to domain names that have specified account name").queryParam("ypmid", "productId", "Int32", null, "restrict the domain names that have specified product id").queryParam("member", "roleMember", "ResourceName", null, "restrict the domain names where the specified user is in a role - see roleName").queryParam("role", "roleName", "ResourceName", null, "restrict the domain names where the specified user is in this role - see roleMember").queryParam("azure", "subscription", "String", null, "restrict to domain names that have specified azure subscription name").queryParam("tagKey", "tagKey", "CompoundName", null, "flag to query all domains that have a given tagName").queryParam("tagValue", "tagValue", "CompoundName", null, "flag to query all domains that have a given tag name and value").queryParam("businessService", "businessService", "String", null, "restrict to domain names that have specified business service name").headerParam("If-Modified-Since", "modifiedSince", "String", null, "This header specifies to the server to return any domains modified since this HTTP date").auth("", "", true).expected("OK").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("TopLevelDomain", "POST", "/domain").comment("Create a new top level domain. This is a privileged action for the \"sys.auth\" administrators.").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").input("detail", "TopLevelDomain", "TopLevelDomain object to be created").auth("create", "sys.auth:domain").expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("SubDomain", "POST", "/subdomain/{parent}").comment("Create a new subdomain. The domain administrators of the {parent} domain have the privilege to create subdomains.").pathParam("parent", "DomainName", "name of the parent domain").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").input("detail", "SubDomain", "Subdomain object to be created").auth("create", "{parent}:domain").expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("UserDomain", "POST", "/userdomain/{name}").comment("Create a new user domain. The user domain will be created in the user top level domain and the user himself will be set as the administrator for this domain.").pathParam("name", "SimpleName", "name of the domain which will be the user id").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").input("detail", "UserDomain", "UserDomain object to be created").auth("create", "user.{name}:domain").expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("TopLevelDomain", "DELETE", "/domain/{name}").comment("Delete the specified domain.  This is a privileged action for the \"sys.auth\" administrators. Upon successful completion of this delete request, the server will return NO_CONTENT status code without any data (no object will be returned).").pathParam("name", "SimpleName", "name of the domain to be deleted").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").auth("delete", "sys.auth:domain").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("SubDomain", "DELETE", "/subdomain/{parent}/{name}").comment("Delete the specified subdomain. Caller must have domain delete permissions in parent. Upon successful completion of this delete request, the server will return NO_CONTENT status code without any data (no object will be returned).").pathParam("parent", "DomainName", "name of the parent domain").pathParam("name", "SimpleName", "name of the subdomain to be deleted").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").auth("delete", "{parent}:domain").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("UserDomain", "DELETE", "/userdomain/{name}").comment("Delete the specified userdomain. Caller must have domain delete permissions in the domain. Upon successful completion of this delete request, the server will return NO_CONTENT status code without any data (no object will be returned).").pathParam("name", "SimpleName", "name of the domain to be deleted which will be the user id").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").auth("delete", "user.{name}:domain").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("DomainMeta", "PUT", "/domain/{name}/meta").comment("Update the specified top level domain metadata. Note that entities in the domain are not affected. Caller must have update privileges on the domain itself.").pathParam("name", "DomainName", "name of the domain to be updated").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").input("detail", "DomainMeta", "DomainMeta object with updated attribute values").auth("update", "{name}:").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("DomainMeta", "PUT", "/domain/{name}/meta/system/{attribute}").comment("Set the specified top level domain metadata. Note that entities in the domain are not affected. Caller must have update privileges on the domain itself. If the system attribute is one of the string attributes, then the caller must also have delete action on the same resource in order to reset the configured value").name("PutDomainSystemMeta").pathParam("name", "DomainName", "name of the domain to be updated").pathParam("attribute", "SimpleName", "name of the system attribute to be modified").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").input("detail", "DomainMeta", "DomainMeta object with updated attribute values").auth("update", "sys.auth:meta.domain.{attribute}.{name}").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("DomainTemplate", "PUT", "/domain/{name}/template").comment("Update the given domain by applying the roles and policies defined in the specified solution template(s). Caller must have UPDATE privileges on the domain itself.").pathParam("name", "DomainName", "name of the domain to be updated").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").input("domainTemplate", "DomainTemplate", "DomainTemplate object with solution template name(s)").auth("update", "{name}:template").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("DomainTemplate", "PUT", "/domain/{name}/template/{template}").comment("Update the given domain by applying the roles and policies defined in the specified solution template(s). Caller must have UPDATE privileges on the domain itself.").name("PutDomainTemplateExt").pathParam("name", "DomainName", "name of the domain to be updated").pathParam("template", "SimpleName", "name of the solution template").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").input("domainTemplate", "DomainTemplate", "DomainTemplate object with a single template name to match URI").auth("update", "{name}:template.{template}").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("DomainTemplateList", "GET", "/domain/{name}/template").comment("Get the list of solution templates applied to a domain").pathParam("name", "DomainName", "name of the domain").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("DomainTemplate", "DELETE", "/domain/{name}/template/{template}").comment("Update the given domain by deleting the specified template from the domain template list. Cycles through the roles and policies defined in the template and deletes them. Caller must have delete privileges on the domain itself.").pathParam("name", "DomainName", "name of the domain to be updated").pathParam("template", "SimpleName", "name of the solution template").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").auth("delete", "{name}:template.{template}").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("DomainMetaStoreValidValuesList", "GET", "/domain/metastore").comment("List all valid values for the given attribute and user").queryParam("attribute", "attributeName", "String", null, "name of attribute").queryParam("user", "userName", "String", null, "restrict to values associated with the given user").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("DomainDataCheck", "GET", "/domain/{domainName}/check").comment("Carry out data check operation for the specified domain.").pathParam("domainName", "DomainName", "name of the domain").auth("", "", true).expected("OK").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Entity", "PUT", "/domain/{domainName}/entity/{entityName}").comment("Put an entity into the domain.").pathParam("domainName", "DomainName", "name of the domain").pathParam("entityName", "EntityName", "name of entity").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").input("entity", "Entity", "Entity object to be added to the domain").auth("update", "{domainName}:entity.{entityName}").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Entity", "GET", "/domain/{domainName}/entity/{entityName}").comment("Get a entity from a domain. open for all authenticated users to read").pathParam("domainName", "DomainName", "name of the domain").pathParam("entityName", "EntityName", "name of entity").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Entity", "DELETE", "/domain/{domainName}/entity/{entityName}").comment("Delete the entity from the domain. Upon successful completion of this delete request, the server will return NO_CONTENT status code without any data (no object will be returned).").pathParam("domainName", "DomainName", "name of the domain").pathParam("entityName", "EntityName", "name of entity").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").auth("delete", "{domainName}:entity.{entityName}").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("EntityList", "GET", "/domain/{domainName}/entity").comment("Enumerate entities provisioned in this domain.").pathParam("domainName", "DomainName", "name of the domain").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("RoleList", "GET", "/domain/{domainName}/role").comment("Enumerate roles provisioned in this domain.").pathParam("domainName", "DomainName", "name of the domain").queryParam("limit", "limit", "Int32", null, "restrict the number of results in this call").queryParam("skip", "skip", "String", null, "restrict the set to those after the specified \"next\" token returned from a previous call").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Roles", "GET", "/domain/{domainName}/roles").comment("Get the list of all roles in a domain with optional flag whether or not include members").pathParam("domainName", "DomainName", "name of the domain").queryParam("members", "members", "Bool", (Object)false, "return list of members in the role").queryParam("tagKey", "tagKey", "CompoundName", null, "flag to query all roles that have a given tagName").queryParam("tagValue", "tagValue", "CompoundName", null, "flag to query all roles that have a given tag name and value").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Role", "GET", "/domain/{domainName}/role/{roleName}").comment("Get the specified role in the domain.").pathParam("domainName", "DomainName", "name of the domain").pathParam("roleName", "EntityName", "name of the role to be retrieved").queryParam("auditLog", "auditLog", "Bool", (Object)false, "flag to indicate whether or not to return role audit log").queryParam("expand", "expand", "Bool", (Object)false, "expand delegated trust roles and return trusted members").queryParam("pending", "pending", "Bool", (Object)false, "include pending members").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Role", "PUT", "/domain/{domainName}/role/{roleName}").comment("Create/update the specified role.").pathParam("domainName", "DomainName", "name of the domain").pathParam("roleName", "EntityName", "name of the role to be added/updated").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").input("role", "Role", "Role object to be added/updated in the domain").auth("update", "{domainName}:role.{roleName}").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Role", "DELETE", "/domain/{domainName}/role/{roleName}").comment("Delete the specified role. Upon successful completion of this delete request, the server will return NO_CONTENT status code without any data (no object will be returned).").pathParam("domainName", "DomainName", "name of the domain").pathParam("roleName", "EntityName", "name of the role to be deleted").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").auth("delete", "{domainName}:role.{roleName}").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Membership", "GET", "/domain/{domainName}/role/{roleName}/member/{memberName}").comment("Get the membership status for a specified user in a role.").pathParam("domainName", "DomainName", "name of the domain").pathParam("roleName", "EntityName", "name of the role").pathParam("memberName", "MemberName", "user name to be checked for membership").queryParam("expiration", "expiration", "String", null, "the expiration timestamp").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("DomainRoleMembers", "GET", "/domain/{domainName}/overdue").comment("Get members with overdue review").name("GetOverdueReview").pathParam("domainName", "DomainName", "name of the domain").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("DomainRoleMembers", "GET", "/domain/{domainName}/member").comment("Get list of principals defined in roles in the given domain").pathParam("domainName", "DomainName", "name of the domain").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("DomainRoleMember", "GET", "/role").comment("Fetch all the roles across domains by either calling or specified principal").name("getPrincipalRoles").queryParam("principal", "principal", "ResourceName", null, "If not present, will return roles for the user making the call").queryParam("domain", "domainName", "DomainName", null, "If not present, will return roles from all domains").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Membership", "PUT", "/domain/{domainName}/role/{roleName}/member/{memberName}").comment("Add the specified user to the role's member list. If the role is neither auditEnabled nor selfserve, then it will use authorize (\"update\", \"{domainName}:role.{roleName}\") or (\"update_members\", \"{domainName}:role.{roleName}\"). This only allows access to members and not role attributes. otherwise membership will be sent for approval to either designated delegates ( in case of auditEnabled roles ) or to domain admins ( in case of selfserve roles )").pathParam("domainName", "DomainName", "name of the domain").pathParam("roleName", "EntityName", "name of the role").pathParam("memberName", "MemberName", "name of the user to be added as a member").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").input("membership", "Membership", "Membership object (must contain role/member names as specified in the URI)").auth("", "", true).expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Membership", "DELETE", "/domain/{domainName}/role/{roleName}/member/{memberName}").comment("Delete the specified role membership. Upon successful completion of this delete request, the server will return NO_CONTENT status code without any data (no object will be returned). The required authorization includes two options: (\"update\", \"{domainName}:role.{roleName}\") or (\"update_members\", \"{domainName}:role.{roleName}\")").pathParam("domainName", "DomainName", "name of the domain").pathParam("roleName", "EntityName", "name of the role").pathParam("memberName", "MemberName", "name of the user to be removed as a member").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").auth("", "", true).expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Membership", "DELETE", "/domain/{domainName}/role/{roleName}/pendingmember/{memberName}").comment("Delete the specified pending role membership. Upon successful completion of this delete request, the server will return NO_CONTENT status code without any data (no object will be returned). Authorization will be completed within the server itself since there are two possibilities: 1) The domain admins can delete any pending requests 2) the requestor can also delete his/her own pending request.").name("DeletePendingMembership").pathParam("domainName", "DomainName", "name of the domain").pathParam("roleName", "EntityName", "name of the role").pathParam("memberName", "MemberName", "name of the user to be removed as a pending member").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").auth("", "", true).expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("DefaultAdmins", "PUT", "/domain/{domainName}/admins").comment("Verify and, if necessary, fix domain roles and policies to make sure the given set of users have administrative access to the domain. This request is only restricted to \"sys.auth\" domain administrators and can be used when the domain administrators incorrectly have blocked their own access to their domains.").pathParam("domainName", "DomainName", "name of the domain").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").input("defaultAdmins", "DefaultAdmins", "list of domain administrators").auth("update", "sys.auth:domain").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("RoleSystemMeta", "PUT", "/domain/{domainName}/role/{roleName}/meta/system/{attribute}").comment("Set the specified role metadata. Caller must have update privileges on the sys.auth domain. If the system attribute is one of the string attributes, then the caller must also have delete action on the same resource in order to reset the configured value").pathParam("domainName", "DomainName", "name of the domain").pathParam("roleName", "EntityName", "name of the role").pathParam("attribute", "SimpleName", "name of the system attribute to be modified").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").input("detail", "RoleSystemMeta", "RoleSystemMeta object with updated attribute values").auth("update", "sys.auth:meta.role.{attribute}.{domainName}").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("RoleMeta", "PUT", "/domain/{domainName}/role/{roleName}/meta").comment("Update the specified role metadata. Caller must have update privileges on the domain itself.").pathParam("domainName", "DomainName", "name of the domain to be updated").pathParam("roleName", "EntityName", "name of the role").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").input("detail", "RoleMeta", "RoleMeta object with updated attribute values").auth("", "", true).expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Membership", "PUT", "/domain/{domainName}/role/{roleName}/member/{memberName}/decision").comment("Approve or Reject the request to add specified user to role membership. This endpoint will be used by 2 use cases: 1. Audit enabled roles with authorize (\"update\", \"sys.auth:meta.role.{attribute}.{domainName}\") 2. Selfserve roles in any domain with authorize (\"update\", \"{domainName}:\")").name("PutMembershipDecision").pathParam("domainName", "DomainName", "name of the domain").pathParam("roleName", "EntityName", "name of the role").pathParam("memberName", "MemberName", "name of the user to be added as a member").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").input("membership", "Membership", "Membership object (must contain role/member names as specified in the URI)").auth("", "", true).expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Role", "PUT", "/domain/{domainName}/role/{roleName}/review").comment("Review role membership and take action to either extend and/or delete existing members.").name("PutRoleReview").pathParam("domainName", "DomainName", "name of the domain").pathParam("roleName", "EntityName", "name of the role").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").input("role", "Role", "Role object with updated and/or deleted members").auth("update", "{domainName}:role.{roleName}").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Groups", "GET", "/domain/{domainName}/groups").comment("Get the list of all groups in a domain with optional flag whether or not include members").pathParam("domainName", "DomainName", "name of the domain").queryParam("members", "members", "Bool", (Object)false, "return list of members in the group").queryParam("tagKey", "tagKey", "CompoundName", null, "flag to query all groups that have a given tagName").queryParam("tagValue", "tagValue", "CompoundName", null, "flag to query all groups that have a given tag name and value").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Group", "GET", "/domain/{domainName}/group/{groupName}").comment("Get the specified group in the domain.").pathParam("domainName", "DomainName", "name of the domain").pathParam("groupName", "EntityName", "name of the group to be retrieved").queryParam("auditLog", "auditLog", "Bool", (Object)false, "flag to indicate whether or not to return group audit log").queryParam("pending", "pending", "Bool", (Object)false, "include pending members").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Group", "PUT", "/domain/{domainName}/group/{groupName}").comment("Create/update the specified group.").pathParam("domainName", "DomainName", "name of the domain").pathParam("groupName", "EntityName", "name of the group to be added/updated").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").input("group", "Group", "Group object to be added/updated in the domain").auth("update", "{domainName}:group.{groupName}").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Group", "DELETE", "/domain/{domainName}/group/{groupName}").comment("Delete the specified group. Upon successful completion of this delete request, the server will return NO_CONTENT status code without any data (no object will be returned).").pathParam("domainName", "DomainName", "name of the domain").pathParam("groupName", "EntityName", "name of the group to be deleted").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").auth("delete", "{domainName}:group.{groupName}").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("GroupMembership", "GET", "/domain/{domainName}/group/{groupName}/member/{memberName}").comment("Get the membership status for a specified user in a group.").pathParam("domainName", "DomainName", "name of the domain").pathParam("groupName", "EntityName", "name of the group").pathParam("memberName", "GroupMemberName", "user name to be checked for membership").queryParam("expiration", "expiration", "String", null, "the expiration timestamp").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("DomainGroupMember", "GET", "/group").comment("Fetch all the groups across domains by either calling or specified principal").name("getPrincipalGroups").queryParam("principal", "principal", "EntityName", null, "If not present, will return groups for the user making the call").queryParam("domain", "domainName", "DomainName", null, "If not present, will return groups from all domains").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("GroupMembership", "PUT", "/domain/{domainName}/group/{groupName}/member/{memberName}").comment("Add the specified user to the group's member list. If the group is neither auditEnabled nor selfserve, then it will use authorize (\"update\", \"{domainName}:group.{groupName}\") otherwise membership will be sent for approval to either designated delegates ( in case of auditEnabled groups ) or to domain admins ( in case of selfserve groups )").pathParam("domainName", "DomainName", "name of the domain").pathParam("groupName", "EntityName", "name of the group").pathParam("memberName", "GroupMemberName", "name of the user to be added as a member").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").input("membership", "GroupMembership", "Membership object (must contain group/member names as specified in the URI)").auth("", "", true).expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("GroupMembership", "DELETE", "/domain/{domainName}/group/{groupName}/member/{memberName}").comment("Delete the specified group membership. Upon successful completion of this delete request, the server will return NO_CONTENT status code without any data (no object will be returned).").pathParam("domainName", "DomainName", "name of the domain").pathParam("groupName", "EntityName", "name of the group").pathParam("memberName", "GroupMemberName", "name of the user to be removed as a member").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").auth("update", "{domainName}:group.{groupName}").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("GroupMembership", "DELETE", "/domain/{domainName}/group/{groupName}/pendingmember/{memberName}").comment("Delete the specified pending group membership. Upon successful completion of this delete request, the server will return NO_CONTENT status code without any data (no object will be returned). Authorization will be completed within the server itself since there are two possibilities: 1) The domain admins can delete any pending requests 2) the requestor can also delete his/her own pending request.").name("DeletePendingGroupMembership").pathParam("domainName", "DomainName", "name of the domain").pathParam("groupName", "EntityName", "name of the group").pathParam("memberName", "GroupMemberName", "name of the user to be removed as a pending member").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").auth("", "", true).expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("GroupSystemMeta", "PUT", "/domain/{domainName}/group/{groupName}/meta/system/{attribute}").comment("Set the specified group metadata. Caller must have update privileges on the sys.auth domain. If the system attribute is one of the string attributes, then the caller must also have delete action on the same resource in order to reset the configured value").pathParam("domainName", "DomainName", "name of the domain").pathParam("groupName", "EntityName", "name of the group").pathParam("attribute", "SimpleName", "name of the system attribute to be modified").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").input("detail", "GroupSystemMeta", "GroupSystemMeta object with updated attribute values").auth("update", "sys.auth:meta.group.{attribute}.{domainName}").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("GroupMeta", "PUT", "/domain/{domainName}/group/{groupName}/meta").comment("Update the specified group metadata. Caller must have update privileges on the domain itself.").pathParam("domainName", "DomainName", "name of the domain to be updated").pathParam("groupName", "EntityName", "name of the group").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").input("detail", "GroupMeta", "GroupMeta object with updated attribute values").auth("update", "{domainName}:group.{groupName}").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("GroupMembership", "PUT", "/domain/{domainName}/group/{groupName}/member/{memberName}/decision").comment("Approve or Reject the request to add specified user to group membership. This endpoint will be used by 2 use cases: 1. Audit enabled groups with authorize (\"update\", \"sys.auth:meta.group.{attribute}.{domainName}\") 2. Selfserve groups in any domain with authorize (\"update\", \"{domainName}:\")").name("PutGroupMembershipDecision").pathParam("domainName", "DomainName", "name of the domain").pathParam("groupName", "EntityName", "name of the group").pathParam("memberName", "GroupMemberName", "name of the user to be added as a member").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").input("membership", "GroupMembership", "GroupMembership object (must contain group/member names as specified in the URI)").auth("", "", true).expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Group", "PUT", "/domain/{domainName}/group/{groupName}/review").comment("Review group membership and take action to either extend and/or delete existing members.").name("PutGroupReview").pathParam("domainName", "DomainName", "name of the domain").pathParam("groupName", "EntityName", "name of the group").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").input("group", "Group", "Group object with updated and/or deleted members").auth("update", "{domainName}:group.{groupName}").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("DomainGroupMembership", "GET", "/pending_group_members").comment("List of domains containing groups and corresponding members to be approved by either calling or specified principal").name("getPendingDomainGroupMembersList").queryParam("principal", "principal", "EntityName", null, "If present, return pending list for this principal").queryParam("domain", "domainName", "String", null, "If present, return pending list for this domain").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("PolicyList", "GET", "/domain/{domainName}/policy").comment("List policies provisioned in this namespace.").pathParam("domainName", "DomainName", "name of the domain").queryParam("limit", "limit", "Int32", null, "restrict the number of results in this call").queryParam("skip", "skip", "String", null, "restrict the set to those after the specified \"next\" token returned from a previous call").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Policies", "GET", "/domain/{domainName}/policies").comment("List policies provisioned in this namespace.").pathParam("domainName", "DomainName", "name of the domain").queryParam("assertions", "assertions", "Bool", (Object)false, "return list of assertions in the policy").queryParam("includeNonActive", "includeNonActive", "Bool", (Object)false, "include non-active policy versions").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Policy", "GET", "/domain/{domainName}/policy/{policyName}").comment("Read the specified policy.").pathParam("domainName", "DomainName", "name of the domain").pathParam("policyName", "EntityName", "name of the policy to be retrieved").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Policy", "PUT", "/domain/{domainName}/policy/{policyName}").comment("Create or update the specified policy.").pathParam("domainName", "DomainName", "name of the domain").pathParam("policyName", "EntityName", "name of the policy to be added/updated").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").input("policy", "Policy", "Policy object to be added or updated in the domain").auth("update", "{domainName}:policy.{policyName}").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Policy", "DELETE", "/domain/{domainName}/policy/{policyName}").comment("Delete the specified policy. Upon successful completion of this delete request, the server will return NO_CONTENT status code without any data (no object will be returned).").pathParam("domainName", "DomainName", "name of the domain").pathParam("policyName", "EntityName", "name of the policy to be deleted").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").auth("delete", "{domainName}:policy.{policyName}").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Assertion", "GET", "/domain/{domainName}/policy/{policyName}/assertion/{assertionId}").comment("Get the assertion details with specified id in the given policy").pathParam("domainName", "DomainName", "name of the domain").pathParam("policyName", "EntityName", "name of the policy").pathParam("assertionId", "Int64", "assertion id").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Assertion", "PUT", "/domain/{domainName}/policy/{policyName}/assertion").comment("Add the specified assertion to the given policy").pathParam("domainName", "DomainName", "name of the domain").pathParam("policyName", "EntityName", "name of the policy").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").input("assertion", "Assertion", "Assertion object to be added to the given policy").auth("update", "{domainName}:policy.{policyName}").expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Assertion", "PUT", "/domain/{domainName}/policy/{policyName}/version/{version}/assertion").comment("Add the specified assertion to the given policy version").name("putAssertionPolicyVersion").pathParam("domainName", "DomainName", "name of the domain").pathParam("policyName", "EntityName", "name of the policy").pathParam("version", "SimpleName", "name of the version").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").input("assertion", "Assertion", "Assertion object to be added to the given policy version").auth("update", "{domainName}:policy.{policyName}").expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Assertion", "DELETE", "/domain/{domainName}/policy/{policyName}/assertion/{assertionId}").comment("Delete the specified policy assertion. Upon successful completion of this delete request, the server will return NO_CONTENT status code without any data (no object will be returned).").pathParam("domainName", "DomainName", "name of the domain").pathParam("policyName", "EntityName", "name of the policy").pathParam("assertionId", "Int64", "assertion id").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").auth("update", "{domainName}:policy.{policyName}").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Assertion", "DELETE", "/domain/{domainName}/policy/{policyName}/version/{version}/assertion/{assertionId}").comment("Delete the specified policy version assertion. Upon successful completion of this delete request, the server will return NO_CONTENT status code without any data (no object will be returned).").name("deleteAssertionPolicyVersion").pathParam("domainName", "DomainName", "name of the domain").pathParam("policyName", "EntityName", "name of the policy").pathParam("version", "SimpleName", "name of the version").pathParam("assertionId", "Int64", "assertion id").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").auth("update", "{domainName}:policy.{policyName}").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("AssertionConditions", "PUT", "/domain/{domainName}/policy/{policyName}/assertion/{assertionId}/conditions").comment("Add the specified conditions to the given assertion").pathParam("domainName", "DomainName", "name of the domain").pathParam("policyName", "EntityName", "name of the policy").pathParam("assertionId", "Int64", "assertion id").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").input("assertionConditions", "AssertionConditions", "Assertion conditions object to be added to the given assertion").auth("update", "{domainName}:policy.{policyName}").expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("AssertionCondition", "PUT", "/domain/{domainName}/policy/{policyName}/assertion/{assertionId}/condition").comment("Add the specified condition to the existing assertion conditions of an assertion").pathParam("domainName", "DomainName", "name of the domain").pathParam("policyName", "EntityName", "name of the policy").pathParam("assertionId", "Int64", "assertion id").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").input("assertionCondition", "AssertionCondition", "Assertion conditions object to be added to the given assertion").auth("update", "{domainName}:policy.{policyName}").expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("AssertionConditions", "DELETE", "/domain/{domainName}/policy/{policyName}/assertion/{assertionId}/conditions").comment("Delete all assertion conditions for specified assertion id. Upon successful completion of this delete request, the server will return NO_CONTENT status code without any data (no object will be returned).").pathParam("domainName", "DomainName", "name of the domain").pathParam("policyName", "EntityName", "name of the policy").pathParam("assertionId", "Int64", "assertion id").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").auth("update", "{domainName}:policy.{policyName}").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("AssertionCondition", "DELETE", "/domain/{domainName}/policy/{policyName}/assertion/{assertionId}/condition/{conditionId}").comment("Delete the assertion condition(s) for specified assertion id and condition id. Upon successful completion of this delete request, the server will return NO_CONTENT status code without any data (no object will be returned).").pathParam("domainName", "DomainName", "name of the domain").pathParam("policyName", "EntityName", "name of the policy").pathParam("assertionId", "Int64", "assertion id").pathParam("conditionId", "Int32", "condition id").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").auth("update", "{domainName}:policy.{policyName}").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("PolicyList", "GET", "/domain/{domainName}/policy/{policyName}/version").comment("List policy versions.").name("getPolicyVersionList").pathParam("domainName", "DomainName", "name of the domain").pathParam("policyName", "EntityName", "name of the policy").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Policy", "GET", "/domain/{domainName}/policy/{policyName}/version/{version}").comment("Get the specified policy version.").name("getPolicyVersion").pathParam("domainName", "DomainName", "name of the domain").pathParam("policyName", "EntityName", "name of the policy").pathParam("version", "SimpleName", "name of the version to be retrieved").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("PolicyOptions", "PUT", "/domain/{domainName}/policy/{policyName}/version/create").comment("Create a new disabled policy version based on active policy").name("putPolicyVersion").pathParam("domainName", "DomainName", "name of the domain").pathParam("policyName", "EntityName", "name of the policy to be added/updated").input("policyOptions", "PolicyOptions", "name of the source version to copy from and name of new version").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").auth("update", "{domainName}:policy.{policyName}").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("PolicyOptions", "PUT", "/domain/{domainName}/policy/{policyName}/version/active").comment("Mark the specified policy version as active").name("setActivePolicyVersion").pathParam("domainName", "DomainName", "name of the domain").pathParam("policyName", "EntityName", "name of the policy").input("policyOptions", "PolicyOptions", "name of the version").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").auth("update", "{domainName}:policy.{policyName}").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Policy", "DELETE", "/domain/{domainName}/policy/{policyName}/version/{version}").comment("Delete the specified policy version. Upon successful completion of this delete request, the server will return NO_CONTENT status code without any data (no object will be returned).").name("deletePolicyVersion").pathParam("domainName", "DomainName", "name of the domain").pathParam("policyName", "EntityName", "name of the policy").pathParam("version", "SimpleName", "name of the version to be deleted").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").auth("delete", "{domainName}:policy.{policyName}").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("ServiceIdentity", "PUT", "/domain/{domain}/service/{service}").comment("Register the specified ServiceIdentity in the specified domain").pathParam("domain", "DomainName", "name of the domain").pathParam("service", "SimpleName", "name of the service").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").input("detail", "ServiceIdentity", "ServiceIdentity object to be added/updated in the domain").auth("update", "{domain}:service.{service}").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("ServiceIdentity", "GET", "/domain/{domain}/service/{service}").comment("Get info for the specified ServiceIdentity.").pathParam("domain", "DomainName", "name of the domain").pathParam("service", "SimpleName", "name of the service to be retrieved").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("ServiceIdentity", "DELETE", "/domain/{domain}/service/{service}").comment("Delete the specified ServiceIdentity. Upon successful completion of this delete request, the server will return NO_CONTENT status code without any data (no object will be returned).").pathParam("domain", "DomainName", "name of the domain").pathParam("service", "SimpleName", "name of the service to be deleted").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").auth("delete", "{domain}:service.{service}").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("ServiceIdentities", "GET", "/domain/{domainName}/services").comment("Retrieve list of service identities").pathParam("domainName", "DomainName", "name of the domain").queryParam("publickeys", "publickeys", "Bool", (Object)false, "return list of public keys in the service").queryParam("hosts", "hosts", "Bool", (Object)false, "return list of hosts in the service").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("ServiceIdentityList", "GET", "/domain/{domainName}/service").comment("Enumerate services provisioned in this domain.").pathParam("domainName", "DomainName", "name of the domain").queryParam("limit", "limit", "Int32", null, "restrict the number of results in this call").queryParam("skip", "skip", "String", null, "restrict the set to those after the specified \"next\" token returned from a previous call").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("PublicKeyEntry", "GET", "/domain/{domain}/service/{service}/publickey/{id}").comment("Retrieve the specified public key from the service.").pathParam("domain", "DomainName", "name of the domain").pathParam("service", "SimpleName", "name of the service").pathParam("id", "String", "the identifier of the public key to be retrieved").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("PublicKeyEntry", "PUT", "/domain/{domain}/service/{service}/publickey/{id}").comment("Add the specified public key to the service.").pathParam("domain", "DomainName", "name of the domain").pathParam("service", "SimpleName", "name of the service").pathParam("id", "String", "the identifier of the public key to be added").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").input("publicKeyEntry", "PublicKeyEntry", "PublicKeyEntry object to be added/updated in the service").auth("update", "{domain}:service.{service}").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("PublicKeyEntry", "DELETE", "/domain/{domain}/service/{service}/publickey/{id}").comment("Remove the specified public key from the service. Upon successful completion of this delete request, the server will return NO_CONTENT status code without any data (no object will be returned).").pathParam("domain", "DomainName", "name of the domain").pathParam("service", "SimpleName", "name of the service").pathParam("id", "String", "the identifier of the public key to be deleted").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").auth("update", "{domain}:service.{service}").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("ServiceIdentitySystemMeta", "PUT", "/domain/{domain}/service/{service}/meta/system/{attribute}").comment("Set the specified service metadata. Caller must have update privileges on the sys.auth domain.").pathParam("domain", "DomainName", "name of the domain").pathParam("service", "SimpleName", "name of the service").pathParam("attribute", "SimpleName", "name of the system attribute to be modified").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").input("detail", "ServiceIdentitySystemMeta", "ServiceIdentitySystemMeta object with updated attribute values").auth("update", "sys.auth:meta.service.{attribute}.{domain}").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Tenancy", "PUT", "/domain/{domain}/tenancy/{service}").comment("Register the provider service in the tenant's domain.").pathParam("domain", "DomainName", "name of the tenant domain").pathParam("service", "ServiceName", "name of the provider service").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").input("detail", "Tenancy", "tenancy object").auth("update", "{domain}:tenancy").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Tenancy", "DELETE", "/domain/{domain}/tenancy/{service}").comment("Delete the provider service from the specified tenant domain. Upon successful completion of this delete request, the server will return NO_CONTENT status code without any data (no object will be returned).").pathParam("domain", "DomainName", "name of the tenant domain").pathParam("service", "ServiceName", "name of the provider service").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").auth("delete", "{domain}:tenancy").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Tenancy", "PUT", "/domain/{domain}/service/{service}/tenant/{tenantDomain}").comment("Register a tenant domain for given provider service").name("PutTenant").pathParam("domain", "DomainName", "name of the provider domain").pathParam("service", "SimpleName", "name of the provider service").pathParam("tenantDomain", "DomainName", "name of the tenant domain").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").input("detail", "Tenancy", "tenancy object").auth("update", "{domain}:tenant.{service}").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Tenancy", "DELETE", "/domain/{domain}/service/{service}/tenant/{tenantDomain}").comment("Delete the tenant domain from the provider service. Upon successful completion of this delete request, the server will return NO_CONTENT status code without any data (no object will be returned).").name("DeleteTenant").pathParam("domain", "DomainName", "name of the provider domain").pathParam("service", "SimpleName", "name of the provider service").pathParam("tenantDomain", "DomainName", "name of the tenant domain").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").auth("delete", "{domain}:tenant.{service}").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("TenantResourceGroupRoles", "PUT", "/domain/{domain}/service/{service}/tenant/{tenantDomain}/resourceGroup/{resourceGroup}").comment("Create/update set of roles for a given tenant and resource group").pathParam("domain", "DomainName", "name of the provider domain").pathParam("service", "SimpleName", "name of the provider service").pathParam("tenantDomain", "DomainName", "name of the tenant domain").pathParam("resourceGroup", "EntityName", "tenant resource group").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").input("detail", "TenantResourceGroupRoles", "list of roles to be added/updated for the tenant").auth("update", "{domain}:tenant.{service}").expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("TenantResourceGroupRoles", "GET", "/domain/{domain}/service/{service}/tenant/{tenantDomain}/resourceGroup/{resourceGroup}").comment("Retrieve the configured set of roles for the tenant and resource group").pathParam("domain", "DomainName", "name of the provider domain").pathParam("service", "SimpleName", "name of the provider service").pathParam("tenantDomain", "DomainName", "name of the tenant domain").pathParam("resourceGroup", "EntityName", "tenant resource group").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("TenantResourceGroupRoles", "DELETE", "/domain/{domain}/service/{service}/tenant/{tenantDomain}/resourceGroup/{resourceGroup}").comment("Delete the configured set of roles for the tenant and resource group").pathParam("domain", "DomainName", "name of the provider domain").pathParam("service", "SimpleName", "name of the provider service").pathParam("tenantDomain", "DomainName", "name of the tenant domain").pathParam("resourceGroup", "EntityName", "tenant resource group").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").auth("update", "{domain}:tenant.{service}").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("ProviderResourceGroupRoles", "PUT", "/domain/{tenantDomain}/provDomain/{provDomain}/provService/{provService}/resourceGroup/{resourceGroup}").comment("Create/update set of roles for a given provider and resource group").pathParam("tenantDomain", "DomainName", "name of the tenant domain").pathParam("provDomain", "DomainName", "name of the provider domain").pathParam("provService", "SimpleName", "name of the provider service").pathParam("resourceGroup", "EntityName", "tenant resource group").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").input("detail", "ProviderResourceGroupRoles", "list of roles to be added/updated for the provider").auth("update", "{tenantDomain}:tenancy.{provDomain}.{provService}").expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("ProviderResourceGroupRoles", "GET", "/domain/{tenantDomain}/provDomain/{provDomain}/provService/{provService}/resourceGroup/{resourceGroup}").comment("Retrieve the configured set of roles for the provider and resource group").pathParam("tenantDomain", "DomainName", "name of the tenant domain").pathParam("provDomain", "DomainName", "name of the provider domain").pathParam("provService", "SimpleName", "name of the provider service").pathParam("resourceGroup", "EntityName", "tenant resource group").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("ProviderResourceGroupRoles", "DELETE", "/domain/{tenantDomain}/provDomain/{provDomain}/provService/{provService}/resourceGroup/{resourceGroup}").comment("Delete the configured set of roles for the provider and resource group").pathParam("tenantDomain", "DomainName", "name of the tenant domain").pathParam("provDomain", "DomainName", "name of the provider domain").pathParam("provService", "SimpleName", "name of the provider service").pathParam("resourceGroup", "EntityName", "tenant resource group").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").auth("update", "{tenantDomain}:tenancy.{provDomain}.{provService}").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Access", "GET", "/access/{action}/{resource}").comment("Check access for the specified operation on the specified resource for the currently authenticated user. This is the slow centralized access for control-plane purposes. Use distributed mechanisms for decentralized (data-plane) access by fetching signed policies and role tokens for users. With this endpoint the resource is part of the uri and restricted to its strict definition of resource name. If needed, you can use the GetAccessExt api that allows resource name to be less restrictive.").pathParam("action", "ActionName", "action as specified in the policy assertion, i.e. update or read").pathParam("resource", "ResourceName", "the resource to check access against, i.e. \"media.news:articles\"").queryParam("domain", "domain", "DomainName", null, "usually null. If present, it specifies an alternate domain for cross-domain trust relation").queryParam("principal", "checkPrincipal", "EntityName", null, "usually null. If present, carry out the access check for this principal").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Access", "GET", "/access/{action}").comment("Check access for the specified operation on the specified resource for the currently authenticated user. This is the slow centralized access for control-plane purposes.").name("GetAccessExt").pathParam("action", "ActionName", "action as specified in the policy assertion, i.e. update or read").queryParam("resource", "resource", "String", null, "the resource to check access against, i.e. \"media.news:articles\"").queryParam("domain", "domain", "DomainName", null, "usually null. If present, it specifies an alternate domain for cross-domain trust relation").queryParam("principal", "checkPrincipal", "EntityName", null, "usually null. If present, carry out the access check for this principal").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("ResourceAccessList", "GET", "/resource").comment("Return list of resources that the given principal has access to. Even though the principal is marked as optional, it must be specified").queryParam("principal", "principal", "ResourceName", null, "specifies principal to query the resource list for").queryParam("action", "action", "ActionName", null, "action as specified in the policy assertion").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("SignedDomains", "GET", "/sys/modified_domains").comment("Retrieve the list of modified domains since the specified timestamp. The server will return the list of all modified domains and the latest modification timestamp as the value of the ETag header. The client will need to use this value during its next call to request the changes since the previous request. When metaonly set to true, don't add roles, policies or services, don't sign").queryParam("domain", "domain", "DomainName", null, "filter the domain list only to the specified name").queryParam("metaonly", "metaOnly", "String", null, "valid values are \"true\" or \"false\"").queryParam("metaattr", "metaAttr", "SimpleName", null, "domain meta attribute to filter/return, valid values \"account\", \"ypmId\", or \"all\"").queryParam("master", "master", "Bool", null, "for system principals only - request data from master data store and not read replicas if any are configured").queryParam("conditions", "conditions", "Bool", null, "for specific purpose only. If this flag is passed, assertion id and assertion conditions will be included in the response assertions if available").headerParam("If-None-Match", "matchingTag", "String", null, "Retrieved from the previous request, this timestamp specifies to the server to return any domains modified since this time").output("ETag", "tag", "String", "The current latest modification timestamp is returned in this header").auth("", "", true).expected("OK").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("JWSDomain", "GET", "/domain/{name}/signed").pathParam("name", "DomainName", "name of the domain to be retrieved").queryParam("signaturep1363format", "signatureP1363Format", "Bool", null, "true if signature must be in P1363 format instead of ASN.1 DER").headerParam("If-None-Match", "matchingTag", "String", null, "Retrieved from the previous request, this timestamp specifies to the server to return if the domain was modified since this time").output("ETag", "tag", "String", "The current latest modification timestamp is returned in this header").auth("", "", true).expected("OK").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("UserToken", "GET", "/user/{userName}/token").comment("Return a user/principal token for the specified authenticated user. Typical authenticated users with their native credentials are not allowed to update their domain data. They must first obtain a UserToken and then use that token for authentication and authorization of their update requests.").pathParam("userName", "SimpleName", "name of the user").queryParam("services", "serviceNames", "String", null, "comma separated list of on-behalf-of service names").queryParam("header", "header", "Bool", (Object)false, "include Authorization header name in response").auth("", "", true).expected("OK").exception("FORBIDDEN", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("UserToken", "OPTIONS", "/user/{userName}/token").comment("CORS (Cross-Origin Resource Sharing) support to allow Provider Services to obtain AuthorizedService Tokens on behalf of Tenant administrators").pathParam("userName", "SimpleName", "name of the user").queryParam("services", "serviceNames", "String", null, "comma separated list of on-behalf-of service names").expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "");
        sb.resource("ServicePrincipal", "GET", "/principal").comment("Return a ServicePrincipal object if the serviceToken is valid. This request provides a simple operation that an external application can execute to validate a service token.").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("ServerTemplateList", "GET", "/template").comment("Get the list of solution templates defined in the server").auth("", "", true).expected("OK").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Template", "GET", "/template/{template}").comment("Get solution template details. Includes the roles and policies that will be automatically provisioned when the template is applied to a domain").pathParam("template", "SimpleName", "name of the solution template").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("DomainTemplateDetailsList", "GET", "/domain/{name}/templatedetails").comment("Get a list of Solution templates with meta data details given a domain name").pathParam("name", "DomainName", "List of templates given a domain name").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("DomainTemplateDetailsList", "GET", "/templatedetails").comment("Get a list of Solution templates with meta data details defined in the server").name("GetServerTemplateDetailsList").auth("", "", true).expected("OK").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("UserList", "GET", "/user").comment("Enumerate users that are registered as principals in the system This will return only the principals with \"<user-domain>.\" prefix").queryParam("domain", "domainName", "DomainName", null, "name of the allowed user-domains and/or aliases").auth("", "", true).expected("OK").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("User", "DELETE", "/user/{name}").comment("Delete the specified user. This command will delete the home.<name> domain and all of its sub-domains (if they exist) and remove the user.<name> from all the roles in the system that it's member of. Upon successful completion of this delete request, the server will return NO_CONTENT status code without any data (no object will be returned).").pathParam("name", "SimpleName", "name of the user").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit reference").auth("delete", "sys.auth:user").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("DomainRoleMember", "DELETE", "/domain/{domainName}/member/{memberName}").comment("Delete the specified role member from the given domain. This command will remove the member from all the roles in the domain that it's member of. Upon successful completion of this delete request, the server will return NO_CONTENT status code without any data (no object will be returned).").pathParam("domainName", "DomainName", "name of the domain").pathParam("memberName", "MemberName", "name of the role member/principal").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit reference").auth("update", "{domainName}:").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Quota", "GET", "/domain/{name}/quota").comment("Retrieve the quota object defined for the domain").pathParam("name", "DomainName", "name of the domain").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "");
        sb.resource("Quota", "PUT", "/domain/{name}/quota").comment("Update the specified domain's quota object").pathParam("name", "DomainName", "name of the domain").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit reference").input("quota", "Quota", "Quota object with limits for the domain").auth("update", "sys.auth:quota").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Quota", "DELETE", "/domain/{name}/quota").comment("Delete the specified domain's quota").pathParam("name", "DomainName", "name of the domain").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit reference").auth("update", "sys.auth:quota").expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Status", "GET", "/status").comment("Retrieve the server status").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("DomainRoleMembership", "GET", "/pending_members").comment("List of domains containing roles and corresponding members to be approved by either calling or specified principal").name("getPendingDomainRoleMembersList").queryParam("principal", "principal", "EntityName", null, "If present, return pending list for this principal").queryParam("domain", "domainName", "String", null, "If present, return pending list for this domain").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("UserAuthorityAttributeMap", "GET", "/authority/user/attribute").comment("Map of type to attribute values for the user authority").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("Stats", "GET", "/domain/{name}/stats").comment("Retrieve the stats object defined for the domain").pathParam("name", "DomainName", "name of the domain").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "");
        sb.resource("Stats", "GET", "/sys/stats").comment("Retrieve the stats object defined for the system").name("getSystemStats").auth("get", "sys.auth:stats").expected("OK").exception("BAD_REQUEST", "ResourceError", "");
        sb.resource("DependentService", "PUT", "/dependency/domain/{domainName}").comment("Register domain as a dependency to service There are two possible authorization checks for this endpoint: 1) System Administrator 2) Authorized Service Provider").name("putDomainDependency").pathParam("domainName", "DomainName", "name of the domain").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").input("service", "DependentService", "Dependent service provider details").auth("", "", true).expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("ServiceName", "DELETE", "/dependency/domain/{domainName}/service/{service}").comment("De-register domain as a dependency to service There are two possible authorization checks for this endpoint: 1) System Administrator 2) Authorized Service Provider").name("deleteDomainDependency").pathParam("domainName", "DomainName", "name of the domain").pathParam("service", "ServiceName", "name of the service").headerParam("Y-Audit-Ref", "auditRef", "String", null, "Audit param required(not empty) if domain auditEnabled is true.").auth("", "", true).expected("NO_CONTENT").exception("BAD_REQUEST", "ResourceError", "").exception("CONFLICT", "ResourceError", "").exception("FORBIDDEN", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("ServiceIdentityList", "GET", "/dependency/domain/{domainName}").comment("List registered services for domain").name("getDependentServiceList").pathParam("domainName", "DomainName", "name of the domain").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        sb.resource("DomainList", "GET", "/dependency/service/{service}").comment("List dependent domains for service").name("getDependentDomainList").pathParam("service", "ServiceName", "name of the service").auth("", "", true).expected("OK").exception("BAD_REQUEST", "ResourceError", "").exception("NOT_FOUND", "ResourceError", "").exception("TOO_MANY_REQUESTS", "ResourceError", "").exception("UNAUTHORIZED", "ResourceError", "");
        return sb.build();
    }
}

