/*
 * Decompiled with CFR 0.152.
 */
package com.xiongyingqi.util.xml;

import com.xiongyingqi.util.Assert;
import com.xiongyingqi.util.StringUtils;
import com.xiongyingqi.util.xml.AbstractStaxContentHandler;
import com.xiongyingqi.util.xml.SimpleNamespaceContext;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

class StaxStreamContentHandler
extends AbstractStaxContentHandler {
    private final XMLStreamWriter streamWriter;

    StaxStreamContentHandler(XMLStreamWriter streamWriter) {
        Assert.notNull(streamWriter, "'streamWriter' must not be null");
        this.streamWriter = streamWriter;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    protected void charactersInternal(char[] ch, int start, int length) throws XMLStreamException {
        this.streamWriter.writeCharacters(ch, start, length);
    }

    @Override
    protected void endDocumentInternal() throws XMLStreamException {
        this.streamWriter.writeEndDocument();
    }

    @Override
    protected void endElementInternal(QName name, SimpleNamespaceContext namespaceContext) throws XMLStreamException {
        this.streamWriter.writeEndElement();
    }

    @Override
    protected void ignorableWhitespaceInternal(char[] ch, int start, int length) throws XMLStreamException {
        this.streamWriter.writeCharacters(ch, start, length);
    }

    @Override
    protected void processingInstructionInternal(String target, String data) throws XMLStreamException {
        this.streamWriter.writeProcessingInstruction(target, data);
    }

    @Override
    protected void skippedEntityInternal(String name) {
    }

    @Override
    protected void startDocumentInternal() throws XMLStreamException {
        this.streamWriter.writeStartDocument();
    }

    @Override
    protected void startElementInternal(QName name, Attributes attributes, SimpleNamespaceContext namespaceContext) throws XMLStreamException {
        this.streamWriter.writeStartElement(name.getPrefix(), name.getLocalPart(), name.getNamespaceURI());
        if (namespaceContext != null) {
            String defaultNamespaceUri = namespaceContext.getNamespaceURI("");
            if (StringUtils.hasLength(defaultNamespaceUri)) {
                this.streamWriter.writeNamespace("", defaultNamespaceUri);
                this.streamWriter.setDefaultNamespace(defaultNamespaceUri);
            }
            Iterator<String> iterator = namespaceContext.getBoundPrefixes();
            while (iterator.hasNext()) {
                String prefix = iterator.next();
                this.streamWriter.writeNamespace(prefix, namespaceContext.getNamespaceURI(prefix));
                this.streamWriter.setPrefix(prefix, namespaceContext.getNamespaceURI(prefix));
            }
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            QName attrName = this.toQName(attributes.getURI(i), attributes.getQName(i));
            if ("xmlns".equals(attrName.getLocalPart()) || "xmlns".equals(attrName.getPrefix())) continue;
            this.streamWriter.writeAttribute(attrName.getPrefix(), attrName.getNamespaceURI(), attrName.getLocalPart(), attributes.getValue(i));
        }
    }
}

