/*
 * Decompiled with CFR 0.152.
 */
package com.xiongyingqi.util.concurrent;

import com.xiongyingqi.util.concurrent.ListenableFuture;
import com.xiongyingqi.util.concurrent.ListenableFutureCallback;
import com.xiongyingqi.util.concurrent.ListenableFutureCallbackRegistry;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

public class ListenableFutureTask<T>
extends FutureTask<T>
implements ListenableFuture<T> {
    private final ListenableFutureCallbackRegistry<T> callbacks = new ListenableFutureCallbackRegistry();

    public ListenableFutureTask(Callable<T> callable) {
        super(callable);
    }

    public ListenableFutureTask(Runnable runnable, T result) {
        super(runnable, result);
    }

    @Override
    public void addCallback(ListenableFutureCallback<? super T> callback) {
        this.callbacks.addCallback(callback);
    }

    @Override
    protected final void done() {
        Throwable cause;
        try {
            Object result = this.get();
            this.callbacks.success(result);
            return;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (ExecutionException ex) {
            cause = ex.getCause();
            if (cause == null) {
                cause = ex;
            }
        }
        catch (Throwable t) {
            cause = t;
        }
        this.callbacks.failure(cause);
    }
}

