/*
 * Decompiled with CFR 0.152.
 */
package com.xiongyingqi.util.concurrent;

import com.xiongyingqi.util.concurrent.FutureAdapter;
import com.xiongyingqi.util.concurrent.ListenableFuture;
import com.xiongyingqi.util.concurrent.ListenableFutureCallback;
import java.util.concurrent.ExecutionException;

public abstract class ListenableFutureAdapter<T, S>
extends FutureAdapter<T, S>
implements ListenableFuture<T> {
    protected ListenableFutureAdapter(ListenableFuture<S> adaptee) {
        super(adaptee);
    }

    @Override
    public void addCallback(final ListenableFutureCallback<? super T> callback) {
        ListenableFuture listenableAdaptee = (ListenableFuture)this.getAdaptee();
        listenableAdaptee.addCallback(new ListenableFutureCallback<S>(){

            @Override
            public void onSuccess(S result) {
                try {
                    callback.onSuccess(ListenableFutureAdapter.this.adaptInternal(result));
                }
                catch (ExecutionException ex) {
                    Throwable cause = ex.getCause();
                    this.onFailure(cause != null ? cause : ex);
                }
                catch (Throwable t) {
                    this.onFailure(t);
                }
            }

            @Override
            public void onFailure(Throwable t) {
                callback.onFailure(t);
            }
        });
    }
}

