/*
 * Decompiled with CFR 0.152.
 */
package com.xiongyingqi.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;

public class WinRegisterDemo {
    private static final String REGQUERY_UTIL = "reg query ";
    private static final String REGSTR_TOKEN = "REG_SZ";
    private static final String REGDWORD_TOKEN = "REG_DWORD";
    private static final String PERSONAL_FOLDER_CMD = "reg query \"HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders\" /v Personal";

    public static void main(String[] args) {
        System.out.println(WinRegisterDemo.getMyDocumentsFromWinRegistry());
    }

    public static String getMyDocumentsFromWinRegistry() {
        try {
            Process process = Runtime.getRuntime().exec(PERSONAL_FOLDER_CMD);
            StreamReader streamreader = new StreamReader(process.getInputStream());
            streamreader.start();
            process.waitFor();
            streamreader.join();
            String result = streamreader.getResult();
            int p = result.indexOf(REGSTR_TOKEN);
            if (p == -1) {
                return null;
            }
            return result.substring(p + REGSTR_TOKEN.length()).trim();
        }
        catch (Exception e) {
            return null;
        }
    }

    static class StreamReader
    extends Thread {
        private InputStream is;
        private StringWriter sw;

        StreamReader(InputStream is) {
            this.is = is;
            this.sw = new StringWriter();
        }

        @Override
        public void run() {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                int c = -1;
                while ((c = this.is.read()) != -1) {
                    bos.write(c);
                }
                this.sw.write(new String(bos.toString("GBK").getBytes("UTF-8")));
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }

        String getResult() {
            return this.sw.toString();
        }
    }
}

