/*
 * Decompiled with CFR 0.152.
 */
package com.xiongyingqi.util;

import com.xiongyingqi.util.EntityHelper;
import com.xiongyingqi.util.StackTraceHelper;
import com.xiongyingqi.util.ThreadPoolException;
import com.xiongyingqi.util.TimerHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;

public class ThreadPool {
    private static ExecutorService pool = new ScheduledThreadPoolExecutor(5);
    private static PoolStatus status = PoolStatus.STOPED;

    public static PoolStatus getStatus() {
        return status;
    }

    public static void setStatus(PoolStatus status) {
        ThreadPool.status = status;
    }

    public static void setPoolSize(int poolSize) throws ThreadPoolException {
        if (poolSize < 0) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e2a\u6570\u4e0d\u80fd\u5c0f\u4e8e0\uff01");
        }
        if (status != PoolStatus.STOPED) {
            throw new ThreadPoolException("\u7ebf\u7a0b\u6c60\u5df2\u7ecf\u5f00\u59cb\u8fd0\u884c\uff0c\u4e0d\u80fd\u91cd\u65b0\u8bbe\u7f6e\u5927\u5c0f");
        }
        pool = new ScheduledThreadPoolExecutor(poolSize);
    }

    public static void invoke(Runnable runnable) {
        try {
            pool.execute(runnable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void invoke(Object callBackInstance, Method callBackMethod, Object instance, Method method, Object ... parameters) {
        if (method != null) {
            ProxyThread proxyThread = new ProxyThread(callBackInstance, callBackMethod, instance, method, parameters);
            pool.execute(proxyThread);
        } else {
            EntityHelper.print("\u7a7a\u5bf9\u8c61");
            StackTraceHelper.printStackTrace();
        }
    }

    public static void invoke(Object instance, Method method, Object ... parameters) {
        ThreadPool.invoke(null, null, instance, method, parameters);
    }

    public static void shutDown() {
        status = PoolStatus.STOPING;
        new Thread(new StateThread()).start();
    }

    private static void shutDowned() {
        status = PoolStatus.STOPED;
    }

    public static void callBack(Object object, Throwable throwable, Object ... parameters) {
        System.out.println(object);
        throwable.printStackTrace();
        for (int i = 0; i < parameters.length; ++i) {
            Object parameter = parameters[i];
            System.out.println("parameter ======== " + parameter);
        }
        System.out.println(TimerHelper.getTime(1));
    }

    public static void main(String[] args) {
        try {
            TimerHelper.getTime(1);
            Thread.sleep(1000L);
            ThreadPool.invoke(null, ThreadPool.class.getDeclaredMethod("callBack", Object.class, Throwable.class, Object[].class), null, Integer.class.getDeclaredMethod("parseInt", String.class), "ss");
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    static class StateThread
    implements Runnable {
        StateThread() {
        }

        @Override
        public void run() {
            ExecutorService executorService = pool;
            while (true) {
                Thread[] leastThreads = new Thread[Thread.activeCount()];
                int length = Thread.enumerate(leastThreads);
                boolean isAllWaiting = false;
                for (int i = 0; i < leastThreads.length; ++i) {
                    Thread thread = leastThreads[i];
                    System.out.println("thread: " + thread.toString());
                    System.out.println((Object)thread.getState());
                    System.out.println("thread.getState() == State.WAITING: " + (thread.getState() == Thread.State.WAITING));
                    if (!thread.getName().startsWith("pool")) continue;
                    isAllWaiting = thread.getState() == Thread.State.WAITING;
                }
                if (isAllWaiting) {
                    executorService.shutdownNow();
                    if (executorService.isShutdown()) {
                        System.out.println("pool.isShutdown() ================= " + executorService.isShutdown());
                        ThreadPool.shutDowned();
                        return;
                    }
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    static class ProxyThread
    implements Runnable {
        private Object instance;
        private Method method;
        private Object[] parameters;
        private Method callBackMethod;
        private Object callBackInstance;

        public ProxyThread() {
        }

        public ProxyThread(Object callBackInstance, Method callBackMethod, Object instance, Method method, Object ... parameters) {
            this.instance = instance;
            this.method = method;
            this.parameters = parameters;
            this.callBackMethod = callBackMethod;
            this.callBackInstance = callBackInstance;
        }

        @Override
        public void run() {
            try {
                Object object = this.method.invoke(this.instance, this.parameters);
                if (this.callBackMethod != null) {
                    try {
                        this.callBackMethod.invoke(this.callBackInstance, object, null, this.parameters);
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        Throwable t = e.getTargetException();
                        t.printStackTrace();
                    }
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                try {
                    this.callBackMethod.invoke(this.callBackInstance, null, t, this.parameters);
                }
                catch (IllegalArgumentException e1) {
                    e1.printStackTrace();
                }
                catch (IllegalAccessException e1) {
                    e1.printStackTrace();
                }
                catch (InvocationTargetException e1) {
                    e1.printStackTrace();
                }
            }
        }

        public Method getCallBackMethod() {
            return this.callBackMethod;
        }

        public void setCallBackMethod(Method callBackMethod) {
            this.callBackMethod = callBackMethod;
        }

        public Object getCallBackInstance() {
            return this.callBackInstance;
        }

        public void setCallBackInstance(Object callBackInstance) {
            this.callBackInstance = callBackInstance;
        }

        public Object getInstance() {
            return this.instance;
        }

        public void setInstance(Object instance) {
            this.instance = instance;
        }

        public Method getMethod() {
            return this.method;
        }

        public void setMethod(Method method) {
            this.method = method;
        }

        public Object[] getParameters() {
            return this.parameters;
        }

        public void setParameters(Object[] parameters) {
            this.parameters = parameters;
        }
    }

    static enum PoolStatus {
        STARTING,
        STARTED,
        STOPING,
        STOPED,
        WAITING;

    }
}

