/*
 * Decompiled with CFR 0.152.
 */
package com.xiongyingqi.util;

import com.xiongyingqi.util.Assert;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.util.UUID;
import sun.security.action.GetPropertyAction;

public class StringHelper {
    public static boolean compareNumberString(String firstString, String secondString) {
        Assert.notNull(firstString, "\u7b2c\u4e00\u4e2a\u5b57\u7b26\u4e32\u4e3a\u7a7a\uff01");
        Assert.notNull(secondString, "\u7b2c\u4e8c\u4e2a\u5b57\u7b26\u4e32\u4e3a\u7a7a\uff01");
        char[] chars1 = firstString.toCharArray();
        char[] chars2 = secondString.toCharArray();
        int length1 = chars1.length;
        int length2 = chars2.length;
        int maxLength = length1 > length2 ? length1 : length2;
        int i = 0;
        if (i < maxLength) {
            int value1 = -1;
            int value2 = -1;
            if (i < length1) {
                value1 = chars1[i];
            }
            if (i < length2) {
                value2 = chars2[i];
            }
            return value1 < value2;
        }
        return false;
    }

    public static String encode(String str, String charset) {
        String content = null;
        try {
            content = new String(str.getBytes("ISO-8859-1"), charset);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return content;
    }

    public static boolean notNullAndNotEmpty(String input) {
        return input != null && !"".equals(input.trim());
    }

    public static int hashCodeOfStringArray(String[] stringArray) {
        if (stringArray == null) {
            return 0;
        }
        int hashCode = 17;
        for (int i = 0; i < stringArray.length; ++i) {
            String value = stringArray[i];
            hashCode = hashCode * 31 + (value == null ? 0 : value.hashCode());
        }
        return hashCode;
    }

    public static boolean nullOrEmpty(String input) {
        return input == null || "".equals(input.trim());
    }

    public static String line() {
        String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        return lineSeparator;
    }

    public static String convertEncode(String str) {
        if (StringHelper.nullOrEmpty(str)) {
            return null;
        }
        try {
            return new String(str.getBytes(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return str;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String stringReaderToString(StringReader reader) {
        StringBuilder builder = new StringBuilder();
        char[] buffer = new char[128];
        int length = -1;
        try {
            while ((length = reader.read(buffer)) != -1) {
                if (buffer.length != length) {
                    System.arraycopy(buffer, 0, buffer, 0, length);
                }
                builder.append(buffer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            reader.close();
        }
        return builder.toString();
    }

    public static String replaceFirst(String content, String target, String replacement) {
        int index = content.indexOf(target);
        if (index < 0) {
            return content;
        }
        StringBuilder builder = new StringBuilder();
        String front = content.substring(0, index);
        String last = content.substring(index + target.length());
        return builder.append(front).append(replacement).append(last).toString();
    }

    public static String UUID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static void main(String[] args) {
        System.out.println(StringHelper.replaceFirst("asfasf.ccc.bbb.ccc.cccc.", "ccc.", "dddd."));
        System.out.println(StringHelper.compareNumberString("", ""));
        System.out.println(StringHelper.compareNumberString("abc", "aac"));
        System.out.println(StringHelper.compareNumberString("1234", "2234"));
        System.out.println(StringHelper.compareNumberString("1234", "123"));
        System.out.println(StringHelper.compareNumberString("223", "1234"));
    }
}

