/*
 * Decompiled with CFR 0.152.
 */
package com.xiongyingqi.util;

import com.xiongyingqi.util.StringHelper;

public class StackTraceHelper {
    public static void printStackTrace() {
        Throwable throwable = new Throwable();
        StackTraceElement[] stackTraceElements = throwable.getStackTrace();
        StackTraceElement[] stackTraceElementsTarget = new StackTraceElement[stackTraceElements.length - 1];
        System.arraycopy(stackTraceElements, 1, stackTraceElementsTarget, 0, stackTraceElementsTarget.length);
        System.out.println(" ----------------------- StackTrace Info ----------------------- ");
        System.out.print(StackTraceHelper.buildStackTrace(stackTraceElementsTarget));
    }

    public static String buildStackTrace(StackTraceElement[] stackTraceElements) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < stackTraceElements.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElements[i];
            builder.append("    at ");
            builder.append(stackTraceElement.getClassName());
            builder.append(".");
            builder.append(stackTraceElement.getMethodName());
            builder.append("(");
            builder.append(stackTraceElement.getFileName());
            builder.append(":");
            builder.append(stackTraceElement.getLineNumber());
            builder.append(")");
            builder.append(StringHelper.line());
        }
        return builder.toString();
    }

    public static StackTraceElement[] getStackTrace() {
        Throwable throwable = new Throwable();
        StackTraceElement[] stackTraceElements = throwable.getStackTrace();
        StackTraceElement[] stackTraceElementsTarget = new StackTraceElement[stackTraceElements.length];
        System.arraycopy(stackTraceElements, 0, stackTraceElementsTarget, 0, stackTraceElementsTarget.length);
        return stackTraceElementsTarget;
    }

    public static Class whoInvoke() {
        Throwable throwable = new Throwable();
        StackTraceElement[] stackTraceElements = throwable.getStackTrace();
        StackTraceElement stackTraceElement = stackTraceElements[2];
        try {
            return Class.forName(stackTraceElement.getClassName());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        StackTraceHelper.printStackTrace();
        StackTraceElement[] stackTraceElements = StackTraceHelper.getStackTrace();
        for (int i = 1; i < stackTraceElements.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElements[i];
            System.out.println("    at " + stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + "(" + stackTraceElement.getFileName() + ":" + stackTraceElement.getLineNumber() + ")");
        }
    }
}

