/*
 * Decompiled with CFR 0.152.
 */
package com.xiongyingqi.util;

import com.xiongyingqi.util.Assert;
import com.xiongyingqi.util.Base64;
import com.xiongyingqi.util.EntityHelper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Key;
import java.util.Date;

public class SerializeHelper {
    public static final String ENCODING = "UTF-8";
    private static byte index;

    public static File writeObjectToFile(File folder, Serializable serializable) throws IOException {
        Assert.notNull(folder, "\u6587\u4ef6\u5939\u4e0d\u80fd\u4e3a\u7a7a");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        Assert.isTrue(folder.isDirectory(), folder + "\u4e0d\u662f\u6587\u4ef6\u5939");
        File file = new File(folder, System.currentTimeMillis() + SerializeHelper.nextIndex() + "");
        ObjectOutputStream outputStream = new ObjectOutputStream(new FileOutputStream(file));
        outputStream.writeObject(serializable);
        outputStream.flush();
        outputStream.close();
        return file;
    }

    public static byte[] readObjectToBytes(Serializable serializable) {
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream outputStream = null;
        try {
            outputStream = new ObjectOutputStream(arrayOutputStream);
            outputStream.writeObject(serializable);
            outputStream.flush();
            outputStream.close();
            arrayOutputStream.flush();
            arrayOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return arrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String nextIndex() {
        String rs = "";
        Class<SerializeHelper> clazz = SerializeHelper.class;
        synchronized (SerializeHelper.class) {
            index = (byte)(index + 1);
            rs = rs + (index < 0 ? -index : index);
            int least = 3 - rs.length();
            for (int i = 0; i < least; ++i) {
                rs = "0" + rs;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return rs;
        }
    }

    public static long getTimeOfTheName(String fileName) throws NumberFormatException {
        String longStr = fileName.substring(0, fileName.length() - 3);
        Long lo = Long.parseLong(longStr);
        return lo;
    }

    public static void main(String[] args) {
        for (int i = 0; i < 1000; ++i) {
            EntityHelper.print(SerializeHelper.nextIndex());
            String fileName = System.currentTimeMillis() + SerializeHelper.nextIndex();
            EntityHelper.print(SerializeHelper.getTimeOfTheName(fileName));
        }
        System.out.println(Base64.decodeToObject(Base64.encodeObject(new Date())));
    }

    public static Key readObjectFromFile(File privateKeyFile) throws IOException, ClassNotFoundException {
        Assert.notNull(privateKeyFile, "\u6587\u4ef6\u5939\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue(privateKeyFile.exists(), "\u79c1\u94a5\u6587\u4ef6\u4e0d\u5b58\u5728");
        FileInputStream inputStream = new FileInputStream(privateKeyFile);
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        Key privateKey = (Key)objectInputStream.readObject();
        return privateKey;
    }
}

