/*
 * Decompiled with CFR 0.152.
 */
package com.xiongyingqi.util;

import com.xiongyingqi.util.EntityHelper;
import com.xiongyingqi.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.Cipher;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class RsaUtils {
    public static final String ALGORITHM = "RSA";
    private static final int KEYSIZE = 1024;
    private static String PUBLIC_KEY_FILE = "PublicKey";
    private static String PRIVATE_KEY_FILE = "PrivateKey";

    private static void generateKeyPair() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(ALGORITHM);
        keyPairGenerator.initialize(1024);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        ObjectOutputStream oos1 = null;
        ObjectOutputStream oos2 = null;
        try {
            oos1 = new ObjectOutputStream(new FileOutputStream(PUBLIC_KEY_FILE));
            oos2 = new ObjectOutputStream(new FileOutputStream(PRIVATE_KEY_FILE));
            oos1.writeObject(publicKey);
            oos2.writeObject(privateKey);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            oos1.close();
            oos2.close();
        }
    }

    private static String encrypt(String source) throws Exception {
        Key publicKey;
        RsaUtils.generateKeyPair();
        try (ObjectInputStream ois = null;){
            ois = new ObjectInputStream(new FileInputStream(PUBLIC_KEY_FILE));
            publicKey = (Key)ois.readObject();
        }
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(1, publicKey);
        byte[] b = source.getBytes();
        byte[] b1 = cipher.doFinal(b);
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(b1);
    }

    private static String decrypt(String cryptograph) throws Exception {
        Key privateKey;
        try (ObjectInputStream ois = null;){
            ois = new ObjectInputStream(new FileInputStream(PRIVATE_KEY_FILE));
            privateKey = (Key)ois.readObject();
        }
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, privateKey);
        BASE64Decoder decoder = new BASE64Decoder();
        byte[] b1 = decoder.decodeBuffer(cryptograph);
        byte[] b = cipher.doFinal(b1);
        return new String(b);
    }

    public KeyPair generatorKeyPair() throws NoSuchAlgorithmException {
        return this.generatorKeyPair(ALGORITHM, 1024);
    }

    public KeyPair generatorKeyPair(String algorithm, int keySize) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(algorithm);
        keyPairGenerator.initialize(keySize);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        return keyPair;
    }

    public String encrypt(String source, Key publicKey) throws Exception {
        return this.encrypt(source, publicKey, ALGORITHM);
    }

    public String encrypt(String source, Key publicKey, String algorithm) throws Exception {
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(1, publicKey);
        byte[] b = source.getBytes();
        byte[] b1 = cipher.doFinal(b);
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(b1);
    }

    public String encrypt(String source, KeyPair keyPair) throws Exception {
        return this.encrypt(source, keyPair.getPublic());
    }

    public String decrypt(String cryptograph, Key privateKey) throws Exception {
        return this.decrypt(cryptograph, privateKey, ALGORITHM);
    }

    public String decrypt(String cryptograph, Key privateKey, String algorithm) throws Exception {
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(2, privateKey);
        BASE64Decoder decoder = new BASE64Decoder();
        byte[] b1 = decoder.decodeBuffer(cryptograph);
        byte[] b = cipher.doFinal(b1);
        return new String(b);
    }

    public String decrypt(String cryptograph, KeyPair keyPair) throws Exception {
        return this.decrypt(cryptograph, keyPair.getPrivate());
    }

    public static void main(String[] args) throws Exception {
        RsaUtils rsaUtils = new RsaUtils();
        KeyPair keyPair = rsaUtils.generatorKeyPair();
        String secret = rsaUtils.encrypt(StringUtil.randomString(117), keyPair);
        String message = rsaUtils.decrypt(secret, keyPair);
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream outputStream = new ObjectOutputStream(arrayOutputStream);
        outputStream.writeObject(keyPair.getPrivate());
        outputStream.flush();
        outputStream.close();
        arrayOutputStream.flush();
        arrayOutputStream.close();
        EntityHelper.print(arrayOutputStream.toString().length());
        System.out.println(message);
        System.out.println(keyPair.getPrivate());
        System.out.println(keyPair.getPublic());
        System.out.println(secret);
    }
}

