/*
 * Decompiled with CFR 0.152.
 */
package com.xiongyingqi.util;

import com.xiongyingqi.util.Assert;
import com.xiongyingqi.util.DateHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PropertiesHelper {
    public static Map<String, String> readProperties(String propertiesFilePath) {
        return PropertiesHelper.readProperties(new File(propertiesFilePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> readProperties(File propertiesFile) {
        if (!propertiesFile.exists()) {
            return null;
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(propertiesFile);
            Map<String, String> map = PropertiesHelper.readProperties(inputStream);
            return map;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> readProperties(InputStream inputStream) {
        LinkedHashMap<String, String> propertiesMap = null;
        try {
            propertiesMap = new LinkedHashMap<String, String>();
            Properties properties = new Properties();
            properties.load(inputStream);
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String value = (String)properties.get(key);
                propertiesMap.put(key, value);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return propertiesMap;
    }

    public static void save(Map<String, String> map, File file) throws IOException {
        Assert.notNull(map, "\u5c5e\u6027\u96c6\u5408\u4e3a\u7a7a\uff01");
        Properties properties = new Properties();
        Set<Map.Entry<String, String>> entries = map.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String key = entry.getKey();
            String value = entry.getValue();
            properties.setProperty(key, value);
        }
        PropertiesHelper.save(properties, file);
    }

    public static void save(Properties properties, File file) throws IOException {
        Assert.notNull(properties, "\u5b58\u50a8\u7684\u5c5e\u6027\u4e3a\u7a7a\uff01");
        FileOutputStream outputStream = new FileOutputStream(file);
        properties.store(outputStream, "saved on " + DateHelper.getStringDate());
        outputStream.flush();
        ((OutputStream)outputStream).close();
    }

    public static void main(String[] args) throws IOException {
        File file = new File("test.properties");
        Map<String, String> map = PropertiesHelper.readProperties(file);
        map.put("a", "\u6d4b\u8bd5");
        PropertiesHelper.save(map, file);
    }
}

